#include <PyQueryOverTimeAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyQueryOverTimeAttributes
//
// Purpose: 
//   Attributes for queries over time.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Apr 2 10:58:34 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a QueryOverTimeAttributes.
//
struct QueryOverTimeAttributesObject
{
    PyObject_HEAD
    QueryOverTimeAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewQueryOverTimeAttributes();

static PyObject *
QueryOverTimeAttributes_Notify(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_SetTimeType(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTimeType(QueryOverTimeAttributes::TimeType(ival));
    else
    {
        fprintf(stderr, "An invalid timeType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cycle, DTime, Timestep.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetTimeType(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeType()));
    return retval;
}

static PyObject *
QueryOverTimeAttributes_SetStartTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startTimeFlag in the object.
    obj->data->SetStartTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetStartTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetStartTimeFlag()?1L:0L);
    return retval;
}

static PyObject *
QueryOverTimeAttributes_SetStartTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startTime in the object.
    obj->data->SetStartTime(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetStartTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStartTime()));
    return retval;
}

static PyObject *
QueryOverTimeAttributes_SetEndTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endTimeFlag in the object.
    obj->data->SetEndTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetEndTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEndTimeFlag()?1L:0L);
    return retval;
}

static PyObject *
QueryOverTimeAttributes_SetEndTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endTime in the object.
    obj->data->SetEndTime(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetEndTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEndTime()));
    return retval;
}

static PyObject *
QueryOverTimeAttributes_SetStride(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetStride(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

static PyObject *
QueryOverTimeAttributes_SetCreateWindow(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createWindow in the object.
    obj->data->SetCreateWindow(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetCreateWindow(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateWindow()?1L:0L);
    return retval;
}

static PyObject *
QueryOverTimeAttributes_SetWindowId(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowId in the object.
    obj->data->SetWindowId(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
QueryOverTimeAttributes_GetWindowId(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowId()));
    return retval;
}



static struct PyMethodDef QueryOverTimeAttributes_methods[] = {
    {"Notify", QueryOverTimeAttributes_Notify, METH_VARARGS},
    {"SetTimeType", QueryOverTimeAttributes_SetTimeType, METH_VARARGS},
    {"GetTimeType", QueryOverTimeAttributes_GetTimeType, METH_VARARGS},
    {"SetStartTimeFlag", QueryOverTimeAttributes_SetStartTimeFlag, METH_VARARGS},
    {"GetStartTimeFlag", QueryOverTimeAttributes_GetStartTimeFlag, METH_VARARGS},
    {"SetStartTime", QueryOverTimeAttributes_SetStartTime, METH_VARARGS},
    {"GetStartTime", QueryOverTimeAttributes_GetStartTime, METH_VARARGS},
    {"SetEndTimeFlag", QueryOverTimeAttributes_SetEndTimeFlag, METH_VARARGS},
    {"GetEndTimeFlag", QueryOverTimeAttributes_GetEndTimeFlag, METH_VARARGS},
    {"SetEndTime", QueryOverTimeAttributes_SetEndTime, METH_VARARGS},
    {"GetEndTime", QueryOverTimeAttributes_GetEndTime, METH_VARARGS},
    {"SetStride", QueryOverTimeAttributes_SetStride, METH_VARARGS},
    {"GetStride", QueryOverTimeAttributes_GetStride, METH_VARARGS},
    {"SetCreateWindow", QueryOverTimeAttributes_SetCreateWindow, METH_VARARGS},
    {"GetCreateWindow", QueryOverTimeAttributes_GetCreateWindow, METH_VARARGS},
    {"SetWindowId", QueryOverTimeAttributes_SetWindowId, METH_VARARGS},
    {"GetWindowId", QueryOverTimeAttributes_GetWindowId, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
QueryOverTimeAttributes_dealloc(PyObject *v)
{
   QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
QueryOverTimeAttributes_compare(PyObject *v, PyObject *w)
{
    QueryOverTimeAttributes *a = ((QueryOverTimeAttributesObject *)v)->data;
    QueryOverTimeAttributes *b = ((QueryOverTimeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
QueryOverTimeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "timeType") == 0)
        return QueryOverTimeAttributes_GetTimeType(self, NULL);
    if(strcmp(name, "Cycle") == 0)
        return PyInt_FromLong(long(QueryOverTimeAttributes::Cycle));
    else if(strcmp(name, "DTime") == 0)
        return PyInt_FromLong(long(QueryOverTimeAttributes::DTime));
    else if(strcmp(name, "Timestep") == 0)
        return PyInt_FromLong(long(QueryOverTimeAttributes::Timestep));

    if(strcmp(name, "startTimeFlag") == 0)
        return QueryOverTimeAttributes_GetStartTimeFlag(self, NULL);
    if(strcmp(name, "startTime") == 0)
        return QueryOverTimeAttributes_GetStartTime(self, NULL);
    if(strcmp(name, "endTimeFlag") == 0)
        return QueryOverTimeAttributes_GetEndTimeFlag(self, NULL);
    if(strcmp(name, "endTime") == 0)
        return QueryOverTimeAttributes_GetEndTime(self, NULL);
    if(strcmp(name, "stride") == 0)
        return QueryOverTimeAttributes_GetStride(self, NULL);
    if(strcmp(name, "createWindow") == 0)
        return QueryOverTimeAttributes_GetCreateWindow(self, NULL);
    if(strcmp(name, "windowId") == 0)
        return QueryOverTimeAttributes_GetWindowId(self, NULL);

    return Py_FindMethod(QueryOverTimeAttributes_methods, self, name);
}

static int
QueryOverTimeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "timeType") == 0)
        retval = (QueryOverTimeAttributes_SetTimeType(self, tuple) != NULL);
    else if(strcmp(name, "startTimeFlag") == 0)
        retval = (QueryOverTimeAttributes_SetStartTimeFlag(self, tuple) != NULL);
    else if(strcmp(name, "startTime") == 0)
        retval = (QueryOverTimeAttributes_SetStartTime(self, tuple) != NULL);
    else if(strcmp(name, "endTimeFlag") == 0)
        retval = (QueryOverTimeAttributes_SetEndTimeFlag(self, tuple) != NULL);
    else if(strcmp(name, "endTime") == 0)
        retval = (QueryOverTimeAttributes_SetEndTime(self, tuple) != NULL);
    else if(strcmp(name, "stride") == 0)
        retval = (QueryOverTimeAttributes_SetStride(self, tuple) != NULL);
    else if(strcmp(name, "createWindow") == 0)
        retval = (QueryOverTimeAttributes_SetCreateWindow(self, tuple) != NULL);
    else if(strcmp(name, "windowId") == 0)
        retval = (QueryOverTimeAttributes_SetWindowId(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
QueryOverTimeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)v;

    const char *timeType_names = "Cycle, DTime, Timestep";
    if(obj->data->GetTimeType() == QueryOverTimeAttributes::Cycle)
        fprintf(fp, "timeType = Cycle  # %s\n", timeType_names);
    else if(obj->data->GetTimeType() == QueryOverTimeAttributes::DTime)
        fprintf(fp, "timeType = DTime  # %s\n", timeType_names);
    else
        fprintf(fp, "timeType = Timestep  # %s\n", timeType_names);

    if(obj->data->GetStartTimeFlag())
        fprintf(fp, "startTimeFlag = 1\n");
    else
        fprintf(fp, "startTimeFlag = 0\n");
    fprintf(fp, "startTime = %d\n", obj->data->GetStartTime());
    if(obj->data->GetEndTimeFlag())
        fprintf(fp, "endTimeFlag = 1\n");
    else
        fprintf(fp, "endTimeFlag = 0\n");
    fprintf(fp, "endTime = %d\n", obj->data->GetEndTime());
    fprintf(fp, "stride = %d\n", obj->data->GetStride());
    if(obj->data->GetCreateWindow())
        fprintf(fp, "createWindow = 1\n");
    else
        fprintf(fp, "createWindow = 0\n");
    fprintf(fp, "windowId = %d\n", obj->data->GetWindowId());

    return 0;
}

#include <snprintf.h>
PyObject *
PyQueryOverTimeAttributes_StringRepresentation(const QueryOverTimeAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *timeType_names = "Cycle, DTime, Timestep";
    if(atts->GetTimeType() == QueryOverTimeAttributes::Cycle)
        {
             SNPRINTF(tmpStr, 10000, "timeType = Cycle  # %s\n", timeType_names);
             str += tmpStr;
        }
    else if(atts->GetTimeType() == QueryOverTimeAttributes::DTime)
        {
             SNPRINTF(tmpStr, 10000, "timeType = DTime  # %s\n", timeType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "timeType = Timestep  # %s\n", timeType_names);
             str += tmpStr;
        }

    if(atts->GetStartTimeFlag())
        SNPRINTF(tmpStr, 1000, "startTimeFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "startTimeFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "startTime = %d\n", atts->GetStartTime());
    str += tmpStr;
    if(atts->GetEndTimeFlag())
        SNPRINTF(tmpStr, 1000, "endTimeFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "endTimeFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "endTime = %d\n", atts->GetEndTime());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "stride = %d\n", atts->GetStride());
    str += tmpStr;
    if(atts->GetCreateWindow())
        SNPRINTF(tmpStr, 1000, "createWindow = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "createWindow = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "windowId = %d\n", atts->GetWindowId());
    str += tmpStr;
    { // new scope
#if 0
         PyObject *s = PyQueryAttributes_StringRepresentation(atts->GetQueryAtts());
         str += "queryAtts = {"
         if(obj != 0) str += PyString_AS_STRING(s);
         str += "}"
#endif

    }
    return PyString_FromString(str.c_str());
}

static PyObject *
QueryOverTimeAttributes_str(PyObject *v)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)v;
    return PyQueryOverTimeAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *QueryOverTimeAttributes_Purpose = "Attributes for queries over time.";

//
// The type description structure
//
static PyTypeObject QueryOverTimeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "QueryOverTimeAttributes",                    // tp_name
    sizeof(QueryOverTimeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)QueryOverTimeAttributes_dealloc,  // tp_dealloc
    (printfunc)QueryOverTimeAttributes_print,     // tp_print
    (getattrfunc)QueryOverTimeAttributes_getattr, // tp_getattr
    (setattrfunc)QueryOverTimeAttributes_setattr, // tp_setattr
    (cmpfunc)QueryOverTimeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)QueryOverTimeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    QueryOverTimeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static QueryOverTimeAttributes *defaultAtts = 0;

static PyObject *
NewQueryOverTimeAttributes()
{
    QueryOverTimeAttributesObject *newObject;
    newObject = PyObject_NEW(QueryOverTimeAttributesObject, &QueryOverTimeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new QueryOverTimeAttributes(*defaultAtts);
    else
        newObject->data = new QueryOverTimeAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapQueryOverTimeAttributes(const QueryOverTimeAttributes *attr)
{
    QueryOverTimeAttributesObject *newObject;
    newObject = PyObject_NEW(QueryOverTimeAttributesObject, &QueryOverTimeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (QueryOverTimeAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
QueryOverTimeAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewQueryOverTimeAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef QueryOverTimeAttributesMethods[] = {
    {"QueryOverTimeAttributes", QueryOverTimeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *QueryOverTimeAttributesObserver = 0;
static bool QueryOverTimeAttributesEnableLogging = true;

static void
PyQueryOverTimeAttributes_WriteLog(Subject *subj, void *data)
{
    QueryOverTimeAttributes *atts = (QueryOverTimeAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!QueryOverTimeAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# QueryOverTimeAttributes_WriteLog()\n");
}

void
PyQueryOverTimeAttributes_StartUp(QueryOverTimeAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyQueryOverTimeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(QueryOverTimeAttributesObserver == 0)
    {
        QueryOverTimeAttributesObserver = new ObserverToCallback(subj,
            PyQueryOverTimeAttributes_WriteLog, (void *)logFile);
    }

    QueryOverTimeAttributesEnableLogging = true;
}

void
PyQueryOverTimeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete QueryOverTimeAttributesObserver;
    QueryOverTimeAttributesObserver = 0;
}

PyMethodDef *
PyQueryOverTimeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return QueryOverTimeAttributesMethods;
}

bool
PyQueryOverTimeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &QueryOverTimeAttributesType);
}

QueryOverTimeAttributes *
PyQueryOverTimeAttributes_FromPyObject(PyObject *obj)
{
    QueryOverTimeAttributesObject *obj2 = (QueryOverTimeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyQueryOverTimeAttributes_NewPyObject()
{
    return NewQueryOverTimeAttributes();
}

PyObject *
PyQueryOverTimeAttributes_WrapPyObject(const QueryOverTimeAttributes *attr)
{
    return WrapQueryOverTimeAttributes(attr);
}

void
PyQueryOverTimeAttributes_SetLogging(bool val)
{
    QueryOverTimeAttributesEnableLogging = val;
}

void
PyQueryOverTimeAttributes_SetDefaults(const QueryOverTimeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new QueryOverTimeAttributes(*atts);
}

