#include <PyPrinterAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyPrinterAttributes
//
// Purpose: 
//   This class contains the attributes used for controlling printers.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue May 7 11:09:39 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a PrinterAttributes.
//
struct PrinterAttributesObject
{
    PyObject_HEAD
    PrinterAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewPrinterAttributes();

static PyObject *
PrinterAttributes_Notify(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_SetPrinterName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the printerName in the object.
    obj->data->SetPrinterName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetPrinterName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPrinterName().c_str());
    return retval;
}

static PyObject *
PrinterAttributes_SetPrintProgram(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the printProgram in the object.
    obj->data->SetPrintProgram(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetPrintProgram(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPrintProgram().c_str());
    return retval;
}

static PyObject *
PrinterAttributes_SetDocumentName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the documentName in the object.
    obj->data->SetDocumentName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetDocumentName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDocumentName().c_str());
    return retval;
}

static PyObject *
PrinterAttributes_SetCreator(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the creator in the object.
    obj->data->SetCreator(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetCreator(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCreator().c_str());
    return retval;
}

static PyObject *
PrinterAttributes_SetNumCopies(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numCopies in the object.
    obj->data->SetNumCopies(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetNumCopies(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumCopies()));
    return retval;
}

static PyObject *
PrinterAttributes_SetPortrait(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the portrait in the object.
    obj->data->SetPortrait(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetPortrait(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPortrait()?1L:0L);
    return retval;
}

static PyObject *
PrinterAttributes_SetPrintColor(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the printColor in the object.
    obj->data->SetPrintColor(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetPrintColor(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPrintColor()?1L:0L);
    return retval;
}

static PyObject *
PrinterAttributes_SetOutputToFile(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputToFile in the object.
    obj->data->SetOutputToFile(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetOutputToFile(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOutputToFile()?1L:0L);
    return retval;
}

static PyObject *
PrinterAttributes_SetOutputToFileName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the outputToFileName in the object.
    obj->data->SetOutputToFileName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetOutputToFileName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOutputToFileName().c_str());
    return retval;
}

static PyObject *
PrinterAttributes_SetPageSize(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pageSize in the object.
    obj->data->SetPageSize(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PrinterAttributes_GetPageSize(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPageSize()));
    return retval;
}



static struct PyMethodDef PrinterAttributes_methods[] = {
    {"Notify", PrinterAttributes_Notify, METH_VARARGS},
    {"SetPrinterName", PrinterAttributes_SetPrinterName, METH_VARARGS},
    {"GetPrinterName", PrinterAttributes_GetPrinterName, METH_VARARGS},
    {"SetPrintProgram", PrinterAttributes_SetPrintProgram, METH_VARARGS},
    {"GetPrintProgram", PrinterAttributes_GetPrintProgram, METH_VARARGS},
    {"SetDocumentName", PrinterAttributes_SetDocumentName, METH_VARARGS},
    {"GetDocumentName", PrinterAttributes_GetDocumentName, METH_VARARGS},
    {"SetCreator", PrinterAttributes_SetCreator, METH_VARARGS},
    {"GetCreator", PrinterAttributes_GetCreator, METH_VARARGS},
    {"SetNumCopies", PrinterAttributes_SetNumCopies, METH_VARARGS},
    {"GetNumCopies", PrinterAttributes_GetNumCopies, METH_VARARGS},
    {"SetPortrait", PrinterAttributes_SetPortrait, METH_VARARGS},
    {"GetPortrait", PrinterAttributes_GetPortrait, METH_VARARGS},
    {"SetPrintColor", PrinterAttributes_SetPrintColor, METH_VARARGS},
    {"GetPrintColor", PrinterAttributes_GetPrintColor, METH_VARARGS},
    {"SetOutputToFile", PrinterAttributes_SetOutputToFile, METH_VARARGS},
    {"GetOutputToFile", PrinterAttributes_GetOutputToFile, METH_VARARGS},
    {"SetOutputToFileName", PrinterAttributes_SetOutputToFileName, METH_VARARGS},
    {"GetOutputToFileName", PrinterAttributes_GetOutputToFileName, METH_VARARGS},
    {"SetPageSize", PrinterAttributes_SetPageSize, METH_VARARGS},
    {"GetPageSize", PrinterAttributes_GetPageSize, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PrinterAttributes_dealloc(PyObject *v)
{
   PrinterAttributesObject *obj = (PrinterAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
PrinterAttributes_compare(PyObject *v, PyObject *w)
{
    PrinterAttributes *a = ((PrinterAttributesObject *)v)->data;
    PrinterAttributes *b = ((PrinterAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
PrinterAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "printerName") == 0)
        return PrinterAttributes_GetPrinterName(self, NULL);
    if(strcmp(name, "printProgram") == 0)
        return PrinterAttributes_GetPrintProgram(self, NULL);
    if(strcmp(name, "documentName") == 0)
        return PrinterAttributes_GetDocumentName(self, NULL);
    if(strcmp(name, "creator") == 0)
        return PrinterAttributes_GetCreator(self, NULL);
    if(strcmp(name, "numCopies") == 0)
        return PrinterAttributes_GetNumCopies(self, NULL);
    if(strcmp(name, "portrait") == 0)
        return PrinterAttributes_GetPortrait(self, NULL);
    if(strcmp(name, "printColor") == 0)
        return PrinterAttributes_GetPrintColor(self, NULL);
    if(strcmp(name, "outputToFile") == 0)
        return PrinterAttributes_GetOutputToFile(self, NULL);
    if(strcmp(name, "outputToFileName") == 0)
        return PrinterAttributes_GetOutputToFileName(self, NULL);
    if(strcmp(name, "pageSize") == 0)
        return PrinterAttributes_GetPageSize(self, NULL);

    return Py_FindMethod(PrinterAttributes_methods, self, name);
}

static int
PrinterAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "printerName") == 0)
        retval = (PrinterAttributes_SetPrinterName(self, tuple) != NULL);
    else if(strcmp(name, "printProgram") == 0)
        retval = (PrinterAttributes_SetPrintProgram(self, tuple) != NULL);
    else if(strcmp(name, "documentName") == 0)
        retval = (PrinterAttributes_SetDocumentName(self, tuple) != NULL);
    else if(strcmp(name, "creator") == 0)
        retval = (PrinterAttributes_SetCreator(self, tuple) != NULL);
    else if(strcmp(name, "numCopies") == 0)
        retval = (PrinterAttributes_SetNumCopies(self, tuple) != NULL);
    else if(strcmp(name, "portrait") == 0)
        retval = (PrinterAttributes_SetPortrait(self, tuple) != NULL);
    else if(strcmp(name, "printColor") == 0)
        retval = (PrinterAttributes_SetPrintColor(self, tuple) != NULL);
    else if(strcmp(name, "outputToFile") == 0)
        retval = (PrinterAttributes_SetOutputToFile(self, tuple) != NULL);
    else if(strcmp(name, "outputToFileName") == 0)
        retval = (PrinterAttributes_SetOutputToFileName(self, tuple) != NULL);
    else if(strcmp(name, "pageSize") == 0)
        retval = (PrinterAttributes_SetPageSize(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
PrinterAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)v;

    fprintf(fp, "printerName = \"%s\"\n", obj->data->GetPrinterName().c_str());
    fprintf(fp, "printProgram = \"%s\"\n", obj->data->GetPrintProgram().c_str());
    fprintf(fp, "documentName = \"%s\"\n", obj->data->GetDocumentName().c_str());
    fprintf(fp, "creator = \"%s\"\n", obj->data->GetCreator().c_str());
    fprintf(fp, "numCopies = %d\n", obj->data->GetNumCopies());
    if(obj->data->GetPortrait())
        fprintf(fp, "portrait = 1\n");
    else
        fprintf(fp, "portrait = 0\n");
    if(obj->data->GetPrintColor())
        fprintf(fp, "printColor = 1\n");
    else
        fprintf(fp, "printColor = 0\n");
    if(obj->data->GetOutputToFile())
        fprintf(fp, "outputToFile = 1\n");
    else
        fprintf(fp, "outputToFile = 0\n");
    fprintf(fp, "outputToFileName = \"%s\"\n", obj->data->GetOutputToFileName().c_str());
    fprintf(fp, "pageSize = %d\n", obj->data->GetPageSize());

    return 0;
}

//
// The doc string for the class.
//
static char *PrinterAttributes_Purpose = "This class contains the attributes used for controlling printers.";

//
// The type description structure
//
static PyTypeObject PrinterAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PrinterAttributes",                    // tp_name
    sizeof(PrinterAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PrinterAttributes_dealloc,  // tp_dealloc
    (printfunc)PrinterAttributes_print,     // tp_print
    (getattrfunc)PrinterAttributes_getattr, // tp_getattr
    (setattrfunc)PrinterAttributes_setattr, // tp_setattr
    (cmpfunc)PrinterAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PrinterAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PrinterAttributes *defaultAtts = 0;

static PyObject *
NewPrinterAttributes()
{
    PrinterAttributesObject *newObject;
    newObject = PyObject_NEW(PrinterAttributesObject, &PrinterAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new PrinterAttributes(*defaultAtts);
    else
        newObject->data = new PrinterAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapPrinterAttributes(const PrinterAttributes *attr)
{
    PrinterAttributesObject *newObject;
    newObject = PyObject_NEW(PrinterAttributesObject, &PrinterAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PrinterAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PrinterAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewPrinterAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PrinterAttributesMethods[] = {
    {"PrinterAttributes", PrinterAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PrinterAttributesObserver = 0;
static bool PrinterAttributesEnableLogging = true;

static void
PyPrinterAttributes_WriteLog(Subject *subj, void *data)
{
    PrinterAttributes *atts = (PrinterAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!PrinterAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# PrinterAttributes_WriteLog()\n");
}

void
PyPrinterAttributes_StartUp(PrinterAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyPrinterAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PrinterAttributesObserver == 0)
    {
        PrinterAttributesObserver = new ObserverToCallback(subj,
            PyPrinterAttributes_WriteLog, (void *)logFile);
    }

    PrinterAttributesEnableLogging = true;
}

void
PyPrinterAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PrinterAttributesObserver;
    PrinterAttributesObserver = 0;
}

PyMethodDef *
PyPrinterAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PrinterAttributesMethods;
}

bool
PyPrinterAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PrinterAttributesType);
}

PrinterAttributes *
PyPrinterAttributes_FromPyObject(PyObject *obj)
{
    PrinterAttributesObject *obj2 = (PrinterAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPrinterAttributes_NewPyObject()
{
    return NewPrinterAttributes();
}

PyObject *
PyPrinterAttributes_WrapPyObject(const PrinterAttributes *attr)
{
    return WrapPrinterAttributes(attr);
}

void
PyPrinterAttributes_SetLogging(bool val)
{
    PrinterAttributesEnableLogging = val;
}

void
PyPrinterAttributes_SetDefaults(const PrinterAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PrinterAttributes(*atts);
}

