#include <PyPickAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyPickAttributes
//
// Purpose: 
//   This class contains attributes used for pick.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Dec 28 12:30:28 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a PickAttributes.
//
struct PickAttributesObject
{
    PyObject_HEAD
    PickAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewPickAttributes();

static PyObject *
PickAttributes_Notify(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_SetVariables(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    stringVector  &vec = obj->data->GetVariables();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the variables in the object as modified.
    obj->data->SelectVariables();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetVariables(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the variables.
    const stringVector &variables = obj->data->GetVariables();
    PyObject *retval = PyTuple_New(variables.size());
    for(int i = 0; i < variables.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(variables[i].c_str()));
    return retval;
}

static PyObject *
PickAttributes_SetDisplayIncidentElements(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayIncidentElements in the object.
    obj->data->SetDisplayIncidentElements(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetDisplayIncidentElements(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplayIncidentElements()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowNodeId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodeId in the object.
    obj->data->SetShowNodeId(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowNodeId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodeId()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowNodeDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodeDomainLogicalCoords in the object.
    obj->data->SetShowNodeDomainLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowNodeDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodeDomainLogicalCoords()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowNodeBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodeBlockLogicalCoords in the object.
    obj->data->SetShowNodeBlockLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowNodeBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodeBlockLogicalCoords()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowNodePhysicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodePhysicalCoords in the object.
    obj->data->SetShowNodePhysicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowNodePhysicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodePhysicalCoords()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowZoneId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showZoneId in the object.
    obj->data->SetShowZoneId(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowZoneId(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowZoneId()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowZoneDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showZoneDomainLogicalCoords in the object.
    obj->data->SetShowZoneDomainLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowZoneDomainLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowZoneDomainLogicalCoords()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowZoneBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showZoneBlockLogicalCoords in the object.
    obj->data->SetShowZoneBlockLogicalCoords(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowZoneBlockLogicalCoords(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowZoneBlockLogicalCoords()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetDoTimeCurve(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doTimeCurve in the object.
    obj->data->SetDoTimeCurve(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetDoTimeCurve(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoTimeCurve()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetConciseOutput(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the conciseOutput in the object.
    obj->data->SetConciseOutput(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetConciseOutput(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetConciseOutput()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowTimeStep(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showTimeStep in the object.
    obj->data->SetShowTimeStep(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowTimeStep(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowTimeStep()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetShowMeshName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showMeshName in the object.
    obj->data->SetShowMeshName(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetShowMeshName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowMeshName()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetBlockPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the blockPieceName in the object.
    obj->data->SetBlockPieceName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetBlockPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetBlockPieceName().c_str());
    return retval;
}

static PyObject *
PickAttributes_SetGroupPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the groupPieceName in the object.
    obj->data->SetGroupPieceName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetGroupPieceName(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetGroupPieceName().c_str());
    return retval;
}

static PyObject *
PickAttributes_SetDisplayGlobalIds(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayGlobalIds in the object.
    obj->data->SetDisplayGlobalIds(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetDisplayGlobalIds(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplayGlobalIds()?1L:0L);
    return retval;
}

static PyObject *
PickAttributes_SetDisplayPickLetter(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayPickLetter in the object.
    obj->data->SetDisplayPickLetter(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PickAttributes_GetDisplayPickLetter(PyObject *self, PyObject *args)
{
    PickAttributesObject *obj = (PickAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplayPickLetter()?1L:0L);
    return retval;
}



static struct PyMethodDef PickAttributes_methods[] = {
    {"Notify", PickAttributes_Notify, METH_VARARGS},
    {"SetVariables", PickAttributes_SetVariables, METH_VARARGS},
    {"GetVariables", PickAttributes_GetVariables, METH_VARARGS},
    {"SetDisplayIncidentElements", PickAttributes_SetDisplayIncidentElements, METH_VARARGS},
    {"GetDisplayIncidentElements", PickAttributes_GetDisplayIncidentElements, METH_VARARGS},
    {"SetShowNodeId", PickAttributes_SetShowNodeId, METH_VARARGS},
    {"GetShowNodeId", PickAttributes_GetShowNodeId, METH_VARARGS},
    {"SetShowNodeDomainLogicalCoords", PickAttributes_SetShowNodeDomainLogicalCoords, METH_VARARGS},
    {"GetShowNodeDomainLogicalCoords", PickAttributes_GetShowNodeDomainLogicalCoords, METH_VARARGS},
    {"SetShowNodeBlockLogicalCoords", PickAttributes_SetShowNodeBlockLogicalCoords, METH_VARARGS},
    {"GetShowNodeBlockLogicalCoords", PickAttributes_GetShowNodeBlockLogicalCoords, METH_VARARGS},
    {"SetShowNodePhysicalCoords", PickAttributes_SetShowNodePhysicalCoords, METH_VARARGS},
    {"GetShowNodePhysicalCoords", PickAttributes_GetShowNodePhysicalCoords, METH_VARARGS},
    {"SetShowZoneId", PickAttributes_SetShowZoneId, METH_VARARGS},
    {"GetShowZoneId", PickAttributes_GetShowZoneId, METH_VARARGS},
    {"SetShowZoneDomainLogicalCoords", PickAttributes_SetShowZoneDomainLogicalCoords, METH_VARARGS},
    {"GetShowZoneDomainLogicalCoords", PickAttributes_GetShowZoneDomainLogicalCoords, METH_VARARGS},
    {"SetShowZoneBlockLogicalCoords", PickAttributes_SetShowZoneBlockLogicalCoords, METH_VARARGS},
    {"GetShowZoneBlockLogicalCoords", PickAttributes_GetShowZoneBlockLogicalCoords, METH_VARARGS},
    {"SetDoTimeCurve", PickAttributes_SetDoTimeCurve, METH_VARARGS},
    {"GetDoTimeCurve", PickAttributes_GetDoTimeCurve, METH_VARARGS},
    {"SetConciseOutput", PickAttributes_SetConciseOutput, METH_VARARGS},
    {"GetConciseOutput", PickAttributes_GetConciseOutput, METH_VARARGS},
    {"SetShowTimeStep", PickAttributes_SetShowTimeStep, METH_VARARGS},
    {"GetShowTimeStep", PickAttributes_GetShowTimeStep, METH_VARARGS},
    {"SetShowMeshName", PickAttributes_SetShowMeshName, METH_VARARGS},
    {"GetShowMeshName", PickAttributes_GetShowMeshName, METH_VARARGS},
    {"SetBlockPieceName", PickAttributes_SetBlockPieceName, METH_VARARGS},
    {"GetBlockPieceName", PickAttributes_GetBlockPieceName, METH_VARARGS},
    {"SetGroupPieceName", PickAttributes_SetGroupPieceName, METH_VARARGS},
    {"GetGroupPieceName", PickAttributes_GetGroupPieceName, METH_VARARGS},
    {"SetDisplayGlobalIds", PickAttributes_SetDisplayGlobalIds, METH_VARARGS},
    {"GetDisplayGlobalIds", PickAttributes_GetDisplayGlobalIds, METH_VARARGS},
    {"SetDisplayPickLetter", PickAttributes_SetDisplayPickLetter, METH_VARARGS},
    {"GetDisplayPickLetter", PickAttributes_GetDisplayPickLetter, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PickAttributes_dealloc(PyObject *v)
{
   PickAttributesObject *obj = (PickAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
PickAttributes_compare(PyObject *v, PyObject *w)
{
    PickAttributes *a = ((PickAttributesObject *)v)->data;
    PickAttributes *b = ((PickAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
PickAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "variables") == 0)
        return PickAttributes_GetVariables(self, NULL);
    if(strcmp(name, "displayIncidentElements") == 0)
        return PickAttributes_GetDisplayIncidentElements(self, NULL);
    if(strcmp(name, "showNodeId") == 0)
        return PickAttributes_GetShowNodeId(self, NULL);
    if(strcmp(name, "showNodeDomainLogicalCoords") == 0)
        return PickAttributes_GetShowNodeDomainLogicalCoords(self, NULL);
    if(strcmp(name, "showNodeBlockLogicalCoords") == 0)
        return PickAttributes_GetShowNodeBlockLogicalCoords(self, NULL);
    if(strcmp(name, "showNodePhysicalCoords") == 0)
        return PickAttributes_GetShowNodePhysicalCoords(self, NULL);
    if(strcmp(name, "showZoneId") == 0)
        return PickAttributes_GetShowZoneId(self, NULL);
    if(strcmp(name, "showZoneDomainLogicalCoords") == 0)
        return PickAttributes_GetShowZoneDomainLogicalCoords(self, NULL);
    if(strcmp(name, "showZoneBlockLogicalCoords") == 0)
        return PickAttributes_GetShowZoneBlockLogicalCoords(self, NULL);
    if(strcmp(name, "doTimeCurve") == 0)
        return PickAttributes_GetDoTimeCurve(self, NULL);
    if(strcmp(name, "conciseOutput") == 0)
        return PickAttributes_GetConciseOutput(self, NULL);
    if(strcmp(name, "showTimeStep") == 0)
        return PickAttributes_GetShowTimeStep(self, NULL);
    if(strcmp(name, "showMeshName") == 0)
        return PickAttributes_GetShowMeshName(self, NULL);
    if(strcmp(name, "blockPieceName") == 0)
        return PickAttributes_GetBlockPieceName(self, NULL);
    if(strcmp(name, "groupPieceName") == 0)
        return PickAttributes_GetGroupPieceName(self, NULL);
    if(strcmp(name, "displayGlobalIds") == 0)
        return PickAttributes_GetDisplayGlobalIds(self, NULL);
    if(strcmp(name, "displayPickLetter") == 0)
        return PickAttributes_GetDisplayPickLetter(self, NULL);

    return Py_FindMethod(PickAttributes_methods, self, name);
}

static int
PickAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "variables") == 0)
        retval = (PickAttributes_SetVariables(self, tuple) != NULL);
    else if(strcmp(name, "displayIncidentElements") == 0)
        retval = (PickAttributes_SetDisplayIncidentElements(self, tuple) != NULL);
    else if(strcmp(name, "showNodeId") == 0)
        retval = (PickAttributes_SetShowNodeId(self, tuple) != NULL);
    else if(strcmp(name, "showNodeDomainLogicalCoords") == 0)
        retval = (PickAttributes_SetShowNodeDomainLogicalCoords(self, tuple) != NULL);
    else if(strcmp(name, "showNodeBlockLogicalCoords") == 0)
        retval = (PickAttributes_SetShowNodeBlockLogicalCoords(self, tuple) != NULL);
    else if(strcmp(name, "showNodePhysicalCoords") == 0)
        retval = (PickAttributes_SetShowNodePhysicalCoords(self, tuple) != NULL);
    else if(strcmp(name, "showZoneId") == 0)
        retval = (PickAttributes_SetShowZoneId(self, tuple) != NULL);
    else if(strcmp(name, "showZoneDomainLogicalCoords") == 0)
        retval = (PickAttributes_SetShowZoneDomainLogicalCoords(self, tuple) != NULL);
    else if(strcmp(name, "showZoneBlockLogicalCoords") == 0)
        retval = (PickAttributes_SetShowZoneBlockLogicalCoords(self, tuple) != NULL);
    else if(strcmp(name, "doTimeCurve") == 0)
        retval = (PickAttributes_SetDoTimeCurve(self, tuple) != NULL);
    else if(strcmp(name, "conciseOutput") == 0)
        retval = (PickAttributes_SetConciseOutput(self, tuple) != NULL);
    else if(strcmp(name, "showTimeStep") == 0)
        retval = (PickAttributes_SetShowTimeStep(self, tuple) != NULL);
    else if(strcmp(name, "showMeshName") == 0)
        retval = (PickAttributes_SetShowMeshName(self, tuple) != NULL);
    else if(strcmp(name, "blockPieceName") == 0)
        retval = (PickAttributes_SetBlockPieceName(self, tuple) != NULL);
    else if(strcmp(name, "groupPieceName") == 0)
        retval = (PickAttributes_SetGroupPieceName(self, tuple) != NULL);
    else if(strcmp(name, "displayGlobalIds") == 0)
        retval = (PickAttributes_SetDisplayGlobalIds(self, tuple) != NULL);
    else if(strcmp(name, "displayPickLetter") == 0)
        retval = (PickAttributes_SetDisplayPickLetter(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
PickAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PickAttributesObject *obj = (PickAttributesObject *)v;

    {   const stringVector &variables = obj->data->GetVariables();
        fprintf(fp, "variables = (");
        for(int i = 0; i < variables.size(); ++i)
        {
            fprintf(fp, "\"%s\"", variables[i].c_str());
            if(i < variables.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetDisplayIncidentElements())
        fprintf(fp, "displayIncidentElements = 1\n");
    else
        fprintf(fp, "displayIncidentElements = 0\n");
    if(obj->data->GetShowNodeId())
        fprintf(fp, "showNodeId = 1\n");
    else
        fprintf(fp, "showNodeId = 0\n");
    if(obj->data->GetShowNodeDomainLogicalCoords())
        fprintf(fp, "showNodeDomainLogicalCoords = 1\n");
    else
        fprintf(fp, "showNodeDomainLogicalCoords = 0\n");
    if(obj->data->GetShowNodeBlockLogicalCoords())
        fprintf(fp, "showNodeBlockLogicalCoords = 1\n");
    else
        fprintf(fp, "showNodeBlockLogicalCoords = 0\n");
    if(obj->data->GetShowNodePhysicalCoords())
        fprintf(fp, "showNodePhysicalCoords = 1\n");
    else
        fprintf(fp, "showNodePhysicalCoords = 0\n");
    if(obj->data->GetShowZoneId())
        fprintf(fp, "showZoneId = 1\n");
    else
        fprintf(fp, "showZoneId = 0\n");
    if(obj->data->GetShowZoneDomainLogicalCoords())
        fprintf(fp, "showZoneDomainLogicalCoords = 1\n");
    else
        fprintf(fp, "showZoneDomainLogicalCoords = 0\n");
    if(obj->data->GetShowZoneBlockLogicalCoords())
        fprintf(fp, "showZoneBlockLogicalCoords = 1\n");
    else
        fprintf(fp, "showZoneBlockLogicalCoords = 0\n");
    if(obj->data->GetDoTimeCurve())
        fprintf(fp, "doTimeCurve = 1\n");
    else
        fprintf(fp, "doTimeCurve = 0\n");
    if(obj->data->GetConciseOutput())
        fprintf(fp, "conciseOutput = 1\n");
    else
        fprintf(fp, "conciseOutput = 0\n");
    if(obj->data->GetShowTimeStep())
        fprintf(fp, "showTimeStep = 1\n");
    else
        fprintf(fp, "showTimeStep = 0\n");
    if(obj->data->GetShowMeshName())
        fprintf(fp, "showMeshName = 1\n");
    else
        fprintf(fp, "showMeshName = 0\n");
    fprintf(fp, "blockPieceName = \"%s\"\n", obj->data->GetBlockPieceName().c_str());
    fprintf(fp, "groupPieceName = \"%s\"\n", obj->data->GetGroupPieceName().c_str());
    if(obj->data->GetDisplayGlobalIds())
        fprintf(fp, "displayGlobalIds = 1\n");
    else
        fprintf(fp, "displayGlobalIds = 0\n");
    if(obj->data->GetDisplayPickLetter())
        fprintf(fp, "displayPickLetter = 1\n");
    else
        fprintf(fp, "displayPickLetter = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyPickAttributes_StringRepresentation(const PickAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    {   const stringVector &variables = atts->GetVariables();
        SNPRINTF(tmpStr, 1000, "variables = (");
        str += tmpStr;
        for(int i = 0; i < variables.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", variables[i].c_str());
            str += tmpStr;
            if(i < variables.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetDisplayIncidentElements())
        SNPRINTF(tmpStr, 1000, "displayIncidentElements = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "displayIncidentElements = 0\n");
    str += tmpStr;
    if(atts->GetShowNodeId())
        SNPRINTF(tmpStr, 1000, "showNodeId = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showNodeId = 0\n");
    str += tmpStr;
    if(atts->GetShowNodeDomainLogicalCoords())
        SNPRINTF(tmpStr, 1000, "showNodeDomainLogicalCoords = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showNodeDomainLogicalCoords = 0\n");
    str += tmpStr;
    if(atts->GetShowNodeBlockLogicalCoords())
        SNPRINTF(tmpStr, 1000, "showNodeBlockLogicalCoords = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showNodeBlockLogicalCoords = 0\n");
    str += tmpStr;
    if(atts->GetShowNodePhysicalCoords())
        SNPRINTF(tmpStr, 1000, "showNodePhysicalCoords = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showNodePhysicalCoords = 0\n");
    str += tmpStr;
    if(atts->GetShowZoneId())
        SNPRINTF(tmpStr, 1000, "showZoneId = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showZoneId = 0\n");
    str += tmpStr;
    if(atts->GetShowZoneDomainLogicalCoords())
        SNPRINTF(tmpStr, 1000, "showZoneDomainLogicalCoords = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showZoneDomainLogicalCoords = 0\n");
    str += tmpStr;
    if(atts->GetShowZoneBlockLogicalCoords())
        SNPRINTF(tmpStr, 1000, "showZoneBlockLogicalCoords = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showZoneBlockLogicalCoords = 0\n");
    str += tmpStr;
    if(atts->GetClearWindow())
        SNPRINTF(tmpStr, 1000, "clearWindow = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "clearWindow = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pickLetter = \"%s\"\n", atts->GetPickLetter().c_str());
    str += tmpStr;
    if(atts->GetFulfilled())
        SNPRINTF(tmpStr, 1000, "fulfilled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "fulfilled = 0\n");
    str += tmpStr;
    const char *pickType_names = "Zone, Node, CurveZone, CurveNode, DomainZone, DomainNode";
    if(atts->GetPickType() == PickAttributes::Zone)
        {
             SNPRINTF(tmpStr, 1000, "pickType = Zone  # %s\n", pickType_names);
             str += tmpStr;
        }
    else if(atts->GetPickType() == PickAttributes::Node)
        {
             SNPRINTF(tmpStr, 1000, "pickType = Node  # %s\n", pickType_names);
             str += tmpStr;
        }
    else if(atts->GetPickType() == PickAttributes::CurveZone)
        {
             SNPRINTF(tmpStr, 1000, "pickType = CurveZone  # %s\n", pickType_names);
             str += tmpStr;
        }
    else if(atts->GetPickType() == PickAttributes::CurveNode)
        {
             SNPRINTF(tmpStr, 1000, "pickType = CurveNode  # %s\n", pickType_names);
             str += tmpStr;
        }
    else if(atts->GetPickType() == PickAttributes::DomainZone)
        {
             SNPRINTF(tmpStr, 1000, "pickType = DomainZone  # %s\n", pickType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "pickType = DomainNode  # %s\n", pickType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "domain = %d\n", atts->GetDomain());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "elementNumber = %d\n", atts->GetElementNumber());
    str += tmpStr;
    {   const intVector &incidentElements = atts->GetIncidentElements();
        SNPRINTF(tmpStr, 1000, "incidentElements = (");
        str += tmpStr;
        for(int i = 0; i < incidentElements.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", incidentElements[i]);
            str += tmpStr;
            if(i < incidentElements.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "timeStep = %d\n", atts->GetTimeStep());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "dimension = %d\n", atts->GetDimension());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "databaseName = \"%s\"\n", atts->GetDatabaseName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "activeVariable = \"%s\"\n", atts->GetActiveVariable().c_str());
    str += tmpStr;
    {   const float *pickPoint = atts->GetPickPoint();
        SNPRINTF(tmpStr, 1000, "pickPoint = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", pickPoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *cellPoint = atts->GetCellPoint();
        SNPRINTF(tmpStr, 1000, "cellPoint = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", cellPoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *nodePoint = atts->GetNodePoint();
        SNPRINTF(tmpStr, 1000, "nodePoint = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", nodePoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *plotBounds = atts->GetPlotBounds();
        SNPRINTF(tmpStr, 1000, "plotBounds = (");
        str += tmpStr;
        for(int i = 0; i < 6; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", plotBounds[i]);
            str += tmpStr;
            if(i < 5)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *rayPoint1 = atts->GetRayPoint1();
        SNPRINTF(tmpStr, 1000, "rayPoint1 = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rayPoint1[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *rayPoint2 = atts->GetRayPoint2();
        SNPRINTF(tmpStr, 1000, "rayPoint2 = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rayPoint2[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "meshInfo = \"%s\"\n", atts->GetMeshInfo().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "realElementNumber = %d\n", atts->GetRealElementNumber());
    str += tmpStr;
    {   const intVector &realIncidentElements = atts->GetRealIncidentElements();
        SNPRINTF(tmpStr, 1000, "realIncidentElements = (");
        str += tmpStr;
        for(int i = 0; i < realIncidentElements.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", realIncidentElements[i]);
            str += tmpStr;
            if(i < realIncidentElements.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &pnodeCoords = atts->GetPnodeCoords();
        SNPRINTF(tmpStr, 1000, "pnodeCoords = (");
        str += tmpStr;
        for(int i = 0; i < pnodeCoords.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", pnodeCoords[i].c_str());
            str += tmpStr;
            if(i < pnodeCoords.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &dnodeCoords = atts->GetDnodeCoords();
        SNPRINTF(tmpStr, 1000, "dnodeCoords = (");
        str += tmpStr;
        for(int i = 0; i < dnodeCoords.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", dnodeCoords[i].c_str());
            str += tmpStr;
            if(i < dnodeCoords.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &bnodeCoords = atts->GetBnodeCoords();
        SNPRINTF(tmpStr, 1000, "bnodeCoords = (");
        str += tmpStr;
        for(int i = 0; i < bnodeCoords.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", bnodeCoords[i].c_str());
            str += tmpStr;
            if(i < bnodeCoords.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &dzoneCoords = atts->GetDzoneCoords();
        SNPRINTF(tmpStr, 1000, "dzoneCoords = (");
        str += tmpStr;
        for(int i = 0; i < dzoneCoords.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", dzoneCoords[i].c_str());
            str += tmpStr;
            if(i < dzoneCoords.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &bzoneCoords = atts->GetBzoneCoords();
        SNPRINTF(tmpStr, 1000, "bzoneCoords = (");
        str += tmpStr;
        for(int i = 0; i < bzoneCoords.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", bzoneCoords[i].c_str());
            str += tmpStr;
            if(i < bzoneCoords.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetNeedTransformMessage())
        SNPRINTF(tmpStr, 1000, "needTransformMessage = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "needTransformMessage = 0\n");
    str += tmpStr;
#if 0
    { // new scope
        // Create string representation of varInfo from atts.
        for(pos = atts->GetVarInfo.begin(); pos != atts->GetVarInfo.end(); ++pos)
        {
            PickVarInfo *currentPickVarInfo = (PickVarInfo *)(*pos);
            PyObject *s = PyPickVarInfo_StringRepresentation(current);
            if(s)
            {
                str += PyString_AS_STRING(s);
                PyDECREF(s);
            }
        }
    }
#endif
    {   const stringVector &invalidVars = atts->GetInvalidVars();
        SNPRINTF(tmpStr, 1000, "invalidVars = (");
        str += tmpStr;
        for(int i = 0; i < invalidVars.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", invalidVars[i].c_str());
            str += tmpStr;
            if(i < invalidVars.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetDoTimeCurve())
        SNPRINTF(tmpStr, 1000, "doTimeCurve = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "doTimeCurve = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "errorMessage = \"%s\"\n", atts->GetErrorMessage().c_str());
    str += tmpStr;
    if(atts->GetError())
        SNPRINTF(tmpStr, 1000, "error = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "error = 0\n");
    str += tmpStr;
    if(atts->GetMatSelected())
        SNPRINTF(tmpStr, 1000, "matSelected = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "matSelected = 0\n");
    str += tmpStr;
    if(atts->GetNeedActualCoords())
        SNPRINTF(tmpStr, 1000, "needActualCoords = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "needActualCoords = 0\n");
    str += tmpStr;
    if(atts->GetConciseOutput())
        SNPRINTF(tmpStr, 1000, "conciseOutput = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "conciseOutput = 0\n");
    str += tmpStr;
    if(atts->GetShowTimeStep())
        SNPRINTF(tmpStr, 1000, "showTimeStep = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showTimeStep = 0\n");
    str += tmpStr;
    if(atts->GetShowMeshName())
        SNPRINTF(tmpStr, 1000, "showMeshName = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showMeshName = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "blockPieceName = \"%s\"\n", atts->GetBlockPieceName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "groupPieceName = \"%s\"\n", atts->GetGroupPieceName().c_str());
    str += tmpStr;
    {   const intVector &ghosts = atts->GetGhosts();
        SNPRINTF(tmpStr, 1000, "ghosts = (");
        str += tmpStr;
        for(int i = 0; i < ghosts.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", ghosts[i]);
            str += tmpStr;
            if(i < ghosts.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetIncludeGhosts())
        SNPRINTF(tmpStr, 1000, "includeGhosts = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "includeGhosts = 0\n");
    str += tmpStr;
    if(atts->GetElementIsGhost())
        SNPRINTF(tmpStr, 1000, "elementIsGhost = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "elementIsGhost = 0\n");
    str += tmpStr;
    if(atts->GetRequiresGlyphPick())
        SNPRINTF(tmpStr, 1000, "requiresGlyphPick = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "requiresGlyphPick = 0\n");
    str += tmpStr;
    if(atts->GetLocationSuccessful())
        SNPRINTF(tmpStr, 1000, "locationSuccessful = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "locationSuccessful = 0\n");
    str += tmpStr;
    if(atts->GetDisplayGlobalIds())
        SNPRINTF(tmpStr, 1000, "displayGlobalIds = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "displayGlobalIds = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "globalElement = %d\n", atts->GetGlobalElement());
    str += tmpStr;
    {   const intVector &globalIncidentElements = atts->GetGlobalIncidentElements();
        SNPRINTF(tmpStr, 1000, "globalIncidentElements = (");
        str += tmpStr;
        for(int i = 0; i < globalIncidentElements.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", globalIncidentElements[i]);
            str += tmpStr;
            if(i < globalIncidentElements.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetElementIsGlobal())
        SNPRINTF(tmpStr, 1000, "elementIsGlobal = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "elementIsGlobal = 0\n");
    str += tmpStr;
    if(atts->GetDisplayPickLetter())
        SNPRINTF(tmpStr, 1000, "displayPickLetter = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "displayPickLetter = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
PickAttributes_str(PyObject *v)
{
    PickAttributesObject *obj = (PickAttributesObject *)v;
    return PyPickAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *PickAttributes_Purpose = "This class contains attributes used for pick.";

//
// The type description structure
//
static PyTypeObject PickAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PickAttributes",                    // tp_name
    sizeof(PickAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PickAttributes_dealloc,  // tp_dealloc
    (printfunc)PickAttributes_print,     // tp_print
    (getattrfunc)PickAttributes_getattr, // tp_getattr
    (setattrfunc)PickAttributes_setattr, // tp_setattr
    (cmpfunc)PickAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PickAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PickAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PickAttributes *defaultAtts = 0;

static PyObject *
NewPickAttributes()
{
    PickAttributesObject *newObject;
    newObject = PyObject_NEW(PickAttributesObject, &PickAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new PickAttributes(*defaultAtts);
    else
        newObject->data = new PickAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapPickAttributes(const PickAttributes *attr)
{
    PickAttributesObject *newObject;
    newObject = PyObject_NEW(PickAttributesObject, &PickAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PickAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PickAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewPickAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PickAttributesMethods[] = {
    {"PickAttributes", PickAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PickAttributesObserver = 0;
static bool PickAttributesEnableLogging = true;

static void
PyPickAttributes_WriteLog(Subject *subj, void *data)
{
    PickAttributes *atts = (PickAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!PickAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# PickAttributes_WriteLog()\n");
}

void
PyPickAttributes_StartUp(PickAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyPickAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PickAttributesObserver == 0)
    {
        PickAttributesObserver = new ObserverToCallback(subj,
            PyPickAttributes_WriteLog, (void *)logFile);
    }

    PickAttributesEnableLogging = true;
}

void
PyPickAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PickAttributesObserver;
    PickAttributesObserver = 0;
}

PyMethodDef *
PyPickAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PickAttributesMethods;
}

bool
PyPickAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PickAttributesType);
}

PickAttributes *
PyPickAttributes_FromPyObject(PyObject *obj)
{
    PickAttributesObject *obj2 = (PickAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPickAttributes_NewPyObject()
{
    return NewPickAttributes();
}

PyObject *
PyPickAttributes_WrapPyObject(const PickAttributes *attr)
{
    return WrapPickAttributes(attr);
}

void
PyPickAttributes_SetLogging(bool val)
{
    PickAttributesEnableLogging = val;
}

void
PyPickAttributes_SetDefaults(const PickAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PickAttributes(*atts);
}

