#include <PyMaterialAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyMaterialAttributes
//
// Purpose: 
//   Attributes to control material interface reconstruction
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Sep 15 16:51:35 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a MaterialAttributes.
//
struct MaterialAttributesObject
{
    PyObject_HEAD
    MaterialAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewMaterialAttributes();

static PyObject *
MaterialAttributes_Notify(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MaterialAttributes_SetSmoothing(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothing in the object.
    obj->data->SetSmoothing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MaterialAttributes_GetSmoothing(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSmoothing()?1L:0L);
    return retval;
}

static PyObject *
MaterialAttributes_SetForceMIR(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceMIR in the object.
    obj->data->SetForceMIR(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MaterialAttributes_GetForceMIR(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceMIR()?1L:0L);
    return retval;
}

static PyObject *
MaterialAttributes_SetCleanZonesOnly(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cleanZonesOnly in the object.
    obj->data->SetCleanZonesOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MaterialAttributes_GetCleanZonesOnly(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCleanZonesOnly()?1L:0L);
    return retval;
}

static PyObject *
MaterialAttributes_SetNeedValidConnectivity(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the needValidConnectivity in the object.
    obj->data->SetNeedValidConnectivity(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MaterialAttributes_GetNeedValidConnectivity(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNeedValidConnectivity()?1L:0L);
    return retval;
}

static PyObject *
MaterialAttributes_SetUseNewMIRAlgorithm(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useNewMIRAlgorithm in the object.
    obj->data->SetUseNewMIRAlgorithm(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MaterialAttributes_GetUseNewMIRAlgorithm(PyObject *self, PyObject *args)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseNewMIRAlgorithm()?1L:0L);
    return retval;
}



static struct PyMethodDef MaterialAttributes_methods[] = {
    {"Notify", MaterialAttributes_Notify, METH_VARARGS},
    {"SetSmoothing", MaterialAttributes_SetSmoothing, METH_VARARGS},
    {"GetSmoothing", MaterialAttributes_GetSmoothing, METH_VARARGS},
    {"SetForceMIR", MaterialAttributes_SetForceMIR, METH_VARARGS},
    {"GetForceMIR", MaterialAttributes_GetForceMIR, METH_VARARGS},
    {"SetCleanZonesOnly", MaterialAttributes_SetCleanZonesOnly, METH_VARARGS},
    {"GetCleanZonesOnly", MaterialAttributes_GetCleanZonesOnly, METH_VARARGS},
    {"SetNeedValidConnectivity", MaterialAttributes_SetNeedValidConnectivity, METH_VARARGS},
    {"GetNeedValidConnectivity", MaterialAttributes_GetNeedValidConnectivity, METH_VARARGS},
    {"SetUseNewMIRAlgorithm", MaterialAttributes_SetUseNewMIRAlgorithm, METH_VARARGS},
    {"GetUseNewMIRAlgorithm", MaterialAttributes_GetUseNewMIRAlgorithm, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MaterialAttributes_dealloc(PyObject *v)
{
   MaterialAttributesObject *obj = (MaterialAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
MaterialAttributes_compare(PyObject *v, PyObject *w)
{
    MaterialAttributes *a = ((MaterialAttributesObject *)v)->data;
    MaterialAttributes *b = ((MaterialAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
MaterialAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "smoothing") == 0)
        return MaterialAttributes_GetSmoothing(self, NULL);
    if(strcmp(name, "forceMIR") == 0)
        return MaterialAttributes_GetForceMIR(self, NULL);
    if(strcmp(name, "cleanZonesOnly") == 0)
        return MaterialAttributes_GetCleanZonesOnly(self, NULL);
    if(strcmp(name, "needValidConnectivity") == 0)
        return MaterialAttributes_GetNeedValidConnectivity(self, NULL);
    if(strcmp(name, "useNewMIRAlgorithm") == 0)
        return MaterialAttributes_GetUseNewMIRAlgorithm(self, NULL);

    return Py_FindMethod(MaterialAttributes_methods, self, name);
}

static int
MaterialAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "smoothing") == 0)
        retval = (MaterialAttributes_SetSmoothing(self, tuple) != NULL);
    else if(strcmp(name, "forceMIR") == 0)
        retval = (MaterialAttributes_SetForceMIR(self, tuple) != NULL);
    else if(strcmp(name, "cleanZonesOnly") == 0)
        retval = (MaterialAttributes_SetCleanZonesOnly(self, tuple) != NULL);
    else if(strcmp(name, "needValidConnectivity") == 0)
        retval = (MaterialAttributes_SetNeedValidConnectivity(self, tuple) != NULL);
    else if(strcmp(name, "useNewMIRAlgorithm") == 0)
        retval = (MaterialAttributes_SetUseNewMIRAlgorithm(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
MaterialAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MaterialAttributesObject *obj = (MaterialAttributesObject *)v;

    if(obj->data->GetSmoothing())
        fprintf(fp, "smoothing = 1\n");
    else
        fprintf(fp, "smoothing = 0\n");
    if(obj->data->GetForceMIR())
        fprintf(fp, "forceMIR = 1\n");
    else
        fprintf(fp, "forceMIR = 0\n");
    if(obj->data->GetCleanZonesOnly())
        fprintf(fp, "cleanZonesOnly = 1\n");
    else
        fprintf(fp, "cleanZonesOnly = 0\n");
    if(obj->data->GetNeedValidConnectivity())
        fprintf(fp, "needValidConnectivity = 1\n");
    else
        fprintf(fp, "needValidConnectivity = 0\n");
    if(obj->data->GetUseNewMIRAlgorithm())
        fprintf(fp, "useNewMIRAlgorithm = 1\n");
    else
        fprintf(fp, "useNewMIRAlgorithm = 0\n");

    return 0;
}

//
// The doc string for the class.
//
static char *MaterialAttributes_Purpose = "Attributes to control material interface reconstruction";

//
// The type description structure
//
static PyTypeObject MaterialAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MaterialAttributes",                    // tp_name
    sizeof(MaterialAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MaterialAttributes_dealloc,  // tp_dealloc
    (printfunc)MaterialAttributes_print,     // tp_print
    (getattrfunc)MaterialAttributes_getattr, // tp_getattr
    (setattrfunc)MaterialAttributes_setattr, // tp_setattr
    (cmpfunc)MaterialAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MaterialAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MaterialAttributes *defaultAtts = 0;

static PyObject *
NewMaterialAttributes()
{
    MaterialAttributesObject *newObject;
    newObject = PyObject_NEW(MaterialAttributesObject, &MaterialAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new MaterialAttributes(*defaultAtts);
    else
        newObject->data = new MaterialAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapMaterialAttributes(const MaterialAttributes *attr)
{
    MaterialAttributesObject *newObject;
    newObject = PyObject_NEW(MaterialAttributesObject, &MaterialAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MaterialAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MaterialAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewMaterialAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MaterialAttributesMethods[] = {
    {"MaterialAttributes", MaterialAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MaterialAttributesObserver = 0;
static bool MaterialAttributesEnableLogging = true;

static void
PyMaterialAttributes_WriteLog(Subject *subj, void *data)
{
    MaterialAttributes *atts = (MaterialAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!MaterialAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# MaterialAttributes_WriteLog()\n");
}

void
PyMaterialAttributes_StartUp(MaterialAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyMaterialAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MaterialAttributesObserver == 0)
    {
        MaterialAttributesObserver = new ObserverToCallback(subj,
            PyMaterialAttributes_WriteLog, (void *)logFile);
    }

    MaterialAttributesEnableLogging = true;
}

void
PyMaterialAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MaterialAttributesObserver;
    MaterialAttributesObserver = 0;
}

PyMethodDef *
PyMaterialAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MaterialAttributesMethods;
}

bool
PyMaterialAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MaterialAttributesType);
}

MaterialAttributes *
PyMaterialAttributes_FromPyObject(PyObject *obj)
{
    MaterialAttributesObject *obj2 = (MaterialAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMaterialAttributes_NewPyObject()
{
    return NewMaterialAttributes();
}

PyObject *
PyMaterialAttributes_WrapPyObject(const MaterialAttributes *attr)
{
    return WrapMaterialAttributes(attr);
}

void
PyMaterialAttributes_SetLogging(bool val)
{
    MaterialAttributesEnableLogging = val;
}

void
PyMaterialAttributes_SetDefaults(const MaterialAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MaterialAttributes(*atts);
}

