#include <PyKeyframeAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyKeyframeAttributes
//
// Purpose: 
//   This class contains the attributes used for keyframing.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Apr 7 14:29:13 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a KeyframeAttributes.
//
struct KeyframeAttributesObject
{
    PyObject_HEAD
    KeyframeAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewKeyframeAttributes();

static PyObject *
KeyframeAttributes_Notify(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KeyframeAttributes_SetEnabled(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enabled in the object.
    obj->data->SetEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KeyframeAttributes_GetEnabled(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEnabled()?1L:0L);
    return retval;
}

static PyObject *
KeyframeAttributes_SetNFrames(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nFrames in the object.
    obj->data->SetNFrames(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KeyframeAttributes_GetNFrames(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNFrames()));
    return retval;
}

static PyObject *
KeyframeAttributes_SetNFramesWasUserSet(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nFramesWasUserSet in the object.
    obj->data->SetNFramesWasUserSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KeyframeAttributes_GetNFramesWasUserSet(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNFramesWasUserSet()?1L:0L);
    return retval;
}



static struct PyMethodDef KeyframeAttributes_methods[] = {
    {"Notify", KeyframeAttributes_Notify, METH_VARARGS},
    {"SetEnabled", KeyframeAttributes_SetEnabled, METH_VARARGS},
    {"GetEnabled", KeyframeAttributes_GetEnabled, METH_VARARGS},
    {"SetNFrames", KeyframeAttributes_SetNFrames, METH_VARARGS},
    {"GetNFrames", KeyframeAttributes_GetNFrames, METH_VARARGS},
    {"SetNFramesWasUserSet", KeyframeAttributes_SetNFramesWasUserSet, METH_VARARGS},
    {"GetNFramesWasUserSet", KeyframeAttributes_GetNFramesWasUserSet, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
KeyframeAttributes_dealloc(PyObject *v)
{
   KeyframeAttributesObject *obj = (KeyframeAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
KeyframeAttributes_compare(PyObject *v, PyObject *w)
{
    KeyframeAttributes *a = ((KeyframeAttributesObject *)v)->data;
    KeyframeAttributes *b = ((KeyframeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
KeyframeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "enabled") == 0)
        return KeyframeAttributes_GetEnabled(self, NULL);
    if(strcmp(name, "nFrames") == 0)
        return KeyframeAttributes_GetNFrames(self, NULL);
    if(strcmp(name, "nFramesWasUserSet") == 0)
        return KeyframeAttributes_GetNFramesWasUserSet(self, NULL);

    return Py_FindMethod(KeyframeAttributes_methods, self, name);
}

static int
KeyframeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "enabled") == 0)
        retval = (KeyframeAttributes_SetEnabled(self, tuple) != NULL);
    else if(strcmp(name, "nFrames") == 0)
        retval = (KeyframeAttributes_SetNFrames(self, tuple) != NULL);
    else if(strcmp(name, "nFramesWasUserSet") == 0)
        retval = (KeyframeAttributes_SetNFramesWasUserSet(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
KeyframeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)v;

    if(obj->data->GetEnabled())
        fprintf(fp, "enabled = 1\n");
    else
        fprintf(fp, "enabled = 0\n");
    fprintf(fp, "nFrames = %d\n", obj->data->GetNFrames());
    if(obj->data->GetNFramesWasUserSet())
        fprintf(fp, "nFramesWasUserSet = 1\n");
    else
        fprintf(fp, "nFramesWasUserSet = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyKeyframeAttributes_StringRepresentation(const KeyframeAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetEnabled())
        SNPRINTF(tmpStr, 1000, "enabled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "enabled = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "nFrames = %d\n", atts->GetNFrames());
    str += tmpStr;
    if(atts->GetNFramesWasUserSet())
        SNPRINTF(tmpStr, 1000, "nFramesWasUserSet = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "nFramesWasUserSet = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
KeyframeAttributes_str(PyObject *v)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)v;
    return PyKeyframeAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *KeyframeAttributes_Purpose = "This class contains the attributes used for keyframing.";

//
// The type description structure
//
static PyTypeObject KeyframeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "KeyframeAttributes",                    // tp_name
    sizeof(KeyframeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)KeyframeAttributes_dealloc,  // tp_dealloc
    (printfunc)KeyframeAttributes_print,     // tp_print
    (getattrfunc)KeyframeAttributes_getattr, // tp_getattr
    (setattrfunc)KeyframeAttributes_setattr, // tp_setattr
    (cmpfunc)KeyframeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)KeyframeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    KeyframeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static KeyframeAttributes *defaultAtts = 0;

static PyObject *
NewKeyframeAttributes()
{
    KeyframeAttributesObject *newObject;
    newObject = PyObject_NEW(KeyframeAttributesObject, &KeyframeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new KeyframeAttributes(*defaultAtts);
    else
        newObject->data = new KeyframeAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapKeyframeAttributes(const KeyframeAttributes *attr)
{
    KeyframeAttributesObject *newObject;
    newObject = PyObject_NEW(KeyframeAttributesObject, &KeyframeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (KeyframeAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
KeyframeAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewKeyframeAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef KeyframeAttributesMethods[] = {
    {"KeyframeAttributes", KeyframeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *KeyframeAttributesObserver = 0;
static bool KeyframeAttributesEnableLogging = true;

static void
PyKeyframeAttributes_WriteLog(Subject *subj, void *data)
{
    KeyframeAttributes *atts = (KeyframeAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!KeyframeAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# KeyframeAttributes_WriteLog()\n");
}

void
PyKeyframeAttributes_StartUp(KeyframeAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyKeyframeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(KeyframeAttributesObserver == 0)
    {
        KeyframeAttributesObserver = new ObserverToCallback(subj,
            PyKeyframeAttributes_WriteLog, (void *)logFile);
    }

    KeyframeAttributesEnableLogging = true;
}

void
PyKeyframeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete KeyframeAttributesObserver;
    KeyframeAttributesObserver = 0;
}

PyMethodDef *
PyKeyframeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return KeyframeAttributesMethods;
}

bool
PyKeyframeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &KeyframeAttributesType);
}

KeyframeAttributes *
PyKeyframeAttributes_FromPyObject(PyObject *obj)
{
    KeyframeAttributesObject *obj2 = (KeyframeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyKeyframeAttributes_NewPyObject()
{
    return NewKeyframeAttributes();
}

PyObject *
PyKeyframeAttributes_WrapPyObject(const KeyframeAttributes *attr)
{
    return WrapKeyframeAttributes(attr);
}

void
PyKeyframeAttributes_SetLogging(bool val)
{
    KeyframeAttributesEnableLogging = val;
}

void
PyKeyframeAttributes_SetDefaults(const KeyframeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new KeyframeAttributes(*atts);
}

