#include <PyInteractorAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyInteractorAttributes
//
// Purpose: 
//   This class contains attributes associated with the main window.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Dec 27 11:37:20 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a InteractorAttributes.
//
struct InteractorAttributesObject
{
    PyObject_HEAD
    InteractorAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewInteractorAttributes();

static PyObject *
InteractorAttributes_Notify(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
InteractorAttributes_SetShowGuidelines(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showGuidelines in the object.
    obj->data->SetShowGuidelines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
InteractorAttributes_GetShowGuidelines(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowGuidelines()?1L:0L);
    return retval;
}

static PyObject *
InteractorAttributes_SetClampSquare(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the clampSquare in the object.
    obj->data->SetClampSquare(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
InteractorAttributes_GetClampSquare(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetClampSquare()?1L:0L);
    return retval;
}

static PyObject *
InteractorAttributes_SetFillViewportOnZoom(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fillViewportOnZoom in the object.
    obj->data->SetFillViewportOnZoom(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
InteractorAttributes_GetFillViewportOnZoom(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFillViewportOnZoom()?1L:0L);
    return retval;
}

static PyObject *
InteractorAttributes_SetNavigationMode(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the navigationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNavigationMode(InteractorAttributes::NavigationMode(ival));
    else
    {
        fprintf(stderr, "An invalid navigationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Trackball, Dolly, Flythrough.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
InteractorAttributes_GetNavigationMode(PyObject *self, PyObject *args)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNavigationMode()));
    return retval;
}



static struct PyMethodDef InteractorAttributes_methods[] = {
    {"Notify", InteractorAttributes_Notify, METH_VARARGS},
    {"SetShowGuidelines", InteractorAttributes_SetShowGuidelines, METH_VARARGS},
    {"GetShowGuidelines", InteractorAttributes_GetShowGuidelines, METH_VARARGS},
    {"SetClampSquare", InteractorAttributes_SetClampSquare, METH_VARARGS},
    {"GetClampSquare", InteractorAttributes_GetClampSquare, METH_VARARGS},
    {"SetFillViewportOnZoom", InteractorAttributes_SetFillViewportOnZoom, METH_VARARGS},
    {"GetFillViewportOnZoom", InteractorAttributes_GetFillViewportOnZoom, METH_VARARGS},
    {"SetNavigationMode", InteractorAttributes_SetNavigationMode, METH_VARARGS},
    {"GetNavigationMode", InteractorAttributes_GetNavigationMode, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
InteractorAttributes_dealloc(PyObject *v)
{
   InteractorAttributesObject *obj = (InteractorAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
InteractorAttributes_compare(PyObject *v, PyObject *w)
{
    InteractorAttributes *a = ((InteractorAttributesObject *)v)->data;
    InteractorAttributes *b = ((InteractorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
InteractorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "showGuidelines") == 0)
        return InteractorAttributes_GetShowGuidelines(self, NULL);
    if(strcmp(name, "clampSquare") == 0)
        return InteractorAttributes_GetClampSquare(self, NULL);
    if(strcmp(name, "fillViewportOnZoom") == 0)
        return InteractorAttributes_GetFillViewportOnZoom(self, NULL);
    if(strcmp(name, "navigationMode") == 0)
        return InteractorAttributes_GetNavigationMode(self, NULL);
    if(strcmp(name, "Trackball") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Trackball));
    else if(strcmp(name, "Dolly") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Dolly));
    else if(strcmp(name, "Flythrough") == 0)
        return PyInt_FromLong(long(InteractorAttributes::Flythrough));


    return Py_FindMethod(InteractorAttributes_methods, self, name);
}

static int
InteractorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "showGuidelines") == 0)
        retval = (InteractorAttributes_SetShowGuidelines(self, tuple) != NULL);
    else if(strcmp(name, "clampSquare") == 0)
        retval = (InteractorAttributes_SetClampSquare(self, tuple) != NULL);
    else if(strcmp(name, "fillViewportOnZoom") == 0)
        retval = (InteractorAttributes_SetFillViewportOnZoom(self, tuple) != NULL);
    else if(strcmp(name, "navigationMode") == 0)
        retval = (InteractorAttributes_SetNavigationMode(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
InteractorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)v;

    if(obj->data->GetShowGuidelines())
        fprintf(fp, "showGuidelines = 1\n");
    else
        fprintf(fp, "showGuidelines = 0\n");
    if(obj->data->GetClampSquare())
        fprintf(fp, "clampSquare = 1\n");
    else
        fprintf(fp, "clampSquare = 0\n");
    if(obj->data->GetFillViewportOnZoom())
        fprintf(fp, "fillViewportOnZoom = 1\n");
    else
        fprintf(fp, "fillViewportOnZoom = 0\n");
    const char *navigationMode_names = "Trackball, Dolly, Flythrough";
    if(obj->data->GetNavigationMode() == InteractorAttributes::Trackball)
        fprintf(fp, "navigationMode = Trackball  # %s\n", navigationMode_names);
    else if(obj->data->GetNavigationMode() == InteractorAttributes::Dolly)
        fprintf(fp, "navigationMode = Dolly  # %s\n", navigationMode_names);
    else
        fprintf(fp, "navigationMode = Flythrough  # %s\n", navigationMode_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PyInteractorAttributes_StringRepresentation(const InteractorAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetShowGuidelines())
        SNPRINTF(tmpStr, 1000, "showGuidelines = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showGuidelines = 0\n");
    str += tmpStr;
    if(atts->GetClampSquare())
        SNPRINTF(tmpStr, 1000, "clampSquare = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "clampSquare = 0\n");
    str += tmpStr;
    if(atts->GetFillViewportOnZoom())
        SNPRINTF(tmpStr, 1000, "fillViewportOnZoom = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "fillViewportOnZoom = 0\n");
    str += tmpStr;
    const char *navigationMode_names = "Trackball, Dolly, Flythrough";
    if(atts->GetNavigationMode() == InteractorAttributes::Trackball)
        {
             SNPRINTF(tmpStr, 1000, "navigationMode = Trackball  # %s\n", navigationMode_names);
             str += tmpStr;
        }
    else if(atts->GetNavigationMode() == InteractorAttributes::Dolly)
        {
             SNPRINTF(tmpStr, 1000, "navigationMode = Dolly  # %s\n", navigationMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "navigationMode = Flythrough  # %s\n", navigationMode_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
InteractorAttributes_str(PyObject *v)
{
    InteractorAttributesObject *obj = (InteractorAttributesObject *)v;
    return PyInteractorAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *InteractorAttributes_Purpose = "This class contains attributes associated with the main window.";

//
// The type description structure
//
static PyTypeObject InteractorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "InteractorAttributes",                    // tp_name
    sizeof(InteractorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)InteractorAttributes_dealloc,  // tp_dealloc
    (printfunc)InteractorAttributes_print,     // tp_print
    (getattrfunc)InteractorAttributes_getattr, // tp_getattr
    (setattrfunc)InteractorAttributes_setattr, // tp_setattr
    (cmpfunc)InteractorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)InteractorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    InteractorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static InteractorAttributes *defaultAtts = 0;

static PyObject *
NewInteractorAttributes()
{
    InteractorAttributesObject *newObject;
    newObject = PyObject_NEW(InteractorAttributesObject, &InteractorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new InteractorAttributes(*defaultAtts);
    else
        newObject->data = new InteractorAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapInteractorAttributes(const InteractorAttributes *attr)
{
    InteractorAttributesObject *newObject;
    newObject = PyObject_NEW(InteractorAttributesObject, &InteractorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (InteractorAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
InteractorAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewInteractorAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef InteractorAttributesMethods[] = {
    {"InteractorAttributes", InteractorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *InteractorAttributesObserver = 0;
static bool InteractorAttributesEnableLogging = true;

static void
PyInteractorAttributes_WriteLog(Subject *subj, void *data)
{
    InteractorAttributes *atts = (InteractorAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!InteractorAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# InteractorAttributes_WriteLog()\n");
}

void
PyInteractorAttributes_StartUp(InteractorAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyInteractorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(InteractorAttributesObserver == 0)
    {
        InteractorAttributesObserver = new ObserverToCallback(subj,
            PyInteractorAttributes_WriteLog, (void *)logFile);
    }

    InteractorAttributesEnableLogging = true;
}

void
PyInteractorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete InteractorAttributesObserver;
    InteractorAttributesObserver = 0;
}

PyMethodDef *
PyInteractorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return InteractorAttributesMethods;
}

bool
PyInteractorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &InteractorAttributesType);
}

InteractorAttributes *
PyInteractorAttributes_FromPyObject(PyObject *obj)
{
    InteractorAttributesObject *obj2 = (InteractorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyInteractorAttributes_NewPyObject()
{
    return NewInteractorAttributes();
}

PyObject *
PyInteractorAttributes_WrapPyObject(const InteractorAttributes *attr)
{
    return WrapInteractorAttributes(attr);
}

void
PyInteractorAttributes_SetLogging(bool val)
{
    InteractorAttributesEnableLogging = val;
}

void
PyInteractorAttributes_SetDefaults(const InteractorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new InteractorAttributes(*atts);
}

