#include <PyHostProfile.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyHostProfile
//
// Purpose: 
//   This class contains information needed to launch a remote,VisIt engine.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Dec 3 13:52:39 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a HostProfile.
//
struct HostProfileObject
{
    PyObject_HEAD
    HostProfile *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewHostProfile();

static PyObject *
HostProfile_Notify(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_SetProfileName(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the profileName in the object.
    obj->data->SetProfileName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetProfileName(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetProfileName().c_str());
    return retval;
}

static PyObject *
HostProfile_SetHost(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the host in the object.
    obj->data->SetHost(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetHost(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHost().c_str());
    return retval;
}

static PyObject *
HostProfile_SetUserName(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the userName in the object.
    obj->data->SetUserName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetUserName(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetUserName().c_str());
    return retval;
}

static PyObject *
HostProfile_SetTimeout(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeout in the object.
    obj->data->SetTimeout(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetTimeout(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeout()));
    return retval;
}

static PyObject *
HostProfile_SetNumProcessors(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numProcessors in the object.
    obj->data->SetNumProcessors(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetNumProcessors(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumProcessors()));
    return retval;
}

static PyObject *
HostProfile_SetNumNodesSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numNodesSet in the object.
    obj->data->SetNumNodesSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetNumNodesSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNumNodesSet()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetNumNodes(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numNodes in the object.
    obj->data->SetNumNodes(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetNumNodes(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumNodes()));
    return retval;
}

static PyObject *
HostProfile_SetPartitionSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the partitionSet in the object.
    obj->data->SetPartitionSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetPartitionSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPartitionSet()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetPartition(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the partition in the object.
    obj->data->SetPartition(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetPartition(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPartition().c_str());
    return retval;
}

static PyObject *
HostProfile_SetBankSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the bankSet in the object.
    obj->data->SetBankSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetBankSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBankSet()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetBank(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the bank in the object.
    obj->data->SetBank(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetBank(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetBank().c_str());
    return retval;
}

static PyObject *
HostProfile_SetTimeLimitSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeLimitSet in the object.
    obj->data->SetTimeLimitSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetTimeLimitSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTimeLimitSet()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetTimeLimit(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the timeLimit in the object.
    obj->data->SetTimeLimit(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetTimeLimit(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTimeLimit().c_str());
    return retval;
}

static PyObject *
HostProfile_SetLaunchMethodSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the launchMethodSet in the object.
    obj->data->SetLaunchMethodSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetLaunchMethodSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLaunchMethodSet()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetLaunchMethod(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the launchMethod in the object.
    obj->data->SetLaunchMethod(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetLaunchMethod(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetLaunchMethod().c_str());
    return retval;
}

static PyObject *
HostProfile_SetForceStatic(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceStatic in the object.
    obj->data->SetForceStatic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetForceStatic(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceStatic()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetForceDynamic(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceDynamic in the object.
    obj->data->SetForceDynamic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetForceDynamic(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceDynamic()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetActive(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetActive(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetArguments(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    stringVector  &vec = obj->data->GetArguments();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the arguments in the object as modified.
    obj->data->SelectArguments();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetArguments(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    // Allocate a tuple the with enough entries to hold the arguments.
    const stringVector &arguments = obj->data->GetArguments();
    PyObject *retval = PyTuple_New(arguments.size());
    for(int i = 0; i < arguments.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(arguments[i].c_str()));
    return retval;
}

static PyObject *
HostProfile_SetParallel(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the parallel in the object.
    obj->data->SetParallel(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetParallel(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetParallel()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetLaunchArgsSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the launchArgsSet in the object.
    obj->data->SetLaunchArgsSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetLaunchArgsSet(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLaunchArgsSet()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetLaunchArgs(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the launchArgs in the object.
    obj->data->SetLaunchArgs(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetLaunchArgs(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetLaunchArgs().c_str());
    return retval;
}

static PyObject *
HostProfile_SetHostAliases(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the hostAliases in the object.
    obj->data->SetHostAliases(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetHostAliases(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHostAliases().c_str());
    return retval;
}

static PyObject *
HostProfile_SetShareOneBatchJob(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the shareOneBatchJob in the object.
    obj->data->SetShareOneBatchJob(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetShareOneBatchJob(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShareOneBatchJob()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetSshPortSpecified(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sshPortSpecified in the object.
    obj->data->SetSshPortSpecified(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetSshPortSpecified(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSshPortSpecified()?1L:0L);
    return retval;
}

static PyObject *
HostProfile_SetSshPort(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sshPort in the object.
    obj->data->SetSshPort(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetSshPort(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSshPort()));
    return retval;
}

static PyObject *
HostProfile_SetClientHostDetermination(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the clientHostDetermination in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetClientHostDetermination(HostProfile::ClientHostDetermination(ival));
    else
    {
        fprintf(stderr, "An invalid clientHostDetermination value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "MachineName, ManuallySpecified, ParsedFromSSHCLIENT.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetClientHostDetermination(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetClientHostDetermination()));
    return retval;
}

static PyObject *
HostProfile_SetManualClientHostName(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the manualClientHostName in the object.
    obj->data->SetManualClientHostName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HostProfile_GetManualClientHostName(PyObject *self, PyObject *args)
{
    HostProfileObject *obj = (HostProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetManualClientHostName().c_str());
    return retval;
}



static struct PyMethodDef HostProfile_methods[] = {
    {"Notify", HostProfile_Notify, METH_VARARGS},
    {"SetProfileName", HostProfile_SetProfileName, METH_VARARGS},
    {"GetProfileName", HostProfile_GetProfileName, METH_VARARGS},
    {"SetHost", HostProfile_SetHost, METH_VARARGS},
    {"GetHost", HostProfile_GetHost, METH_VARARGS},
    {"SetUserName", HostProfile_SetUserName, METH_VARARGS},
    {"GetUserName", HostProfile_GetUserName, METH_VARARGS},
    {"SetTimeout", HostProfile_SetTimeout, METH_VARARGS},
    {"GetTimeout", HostProfile_GetTimeout, METH_VARARGS},
    {"SetNumProcessors", HostProfile_SetNumProcessors, METH_VARARGS},
    {"GetNumProcessors", HostProfile_GetNumProcessors, METH_VARARGS},
    {"SetNumNodesSet", HostProfile_SetNumNodesSet, METH_VARARGS},
    {"GetNumNodesSet", HostProfile_GetNumNodesSet, METH_VARARGS},
    {"SetNumNodes", HostProfile_SetNumNodes, METH_VARARGS},
    {"GetNumNodes", HostProfile_GetNumNodes, METH_VARARGS},
    {"SetPartitionSet", HostProfile_SetPartitionSet, METH_VARARGS},
    {"GetPartitionSet", HostProfile_GetPartitionSet, METH_VARARGS},
    {"SetPartition", HostProfile_SetPartition, METH_VARARGS},
    {"GetPartition", HostProfile_GetPartition, METH_VARARGS},
    {"SetBankSet", HostProfile_SetBankSet, METH_VARARGS},
    {"GetBankSet", HostProfile_GetBankSet, METH_VARARGS},
    {"SetBank", HostProfile_SetBank, METH_VARARGS},
    {"GetBank", HostProfile_GetBank, METH_VARARGS},
    {"SetTimeLimitSet", HostProfile_SetTimeLimitSet, METH_VARARGS},
    {"GetTimeLimitSet", HostProfile_GetTimeLimitSet, METH_VARARGS},
    {"SetTimeLimit", HostProfile_SetTimeLimit, METH_VARARGS},
    {"GetTimeLimit", HostProfile_GetTimeLimit, METH_VARARGS},
    {"SetLaunchMethodSet", HostProfile_SetLaunchMethodSet, METH_VARARGS},
    {"GetLaunchMethodSet", HostProfile_GetLaunchMethodSet, METH_VARARGS},
    {"SetLaunchMethod", HostProfile_SetLaunchMethod, METH_VARARGS},
    {"GetLaunchMethod", HostProfile_GetLaunchMethod, METH_VARARGS},
    {"SetForceStatic", HostProfile_SetForceStatic, METH_VARARGS},
    {"GetForceStatic", HostProfile_GetForceStatic, METH_VARARGS},
    {"SetForceDynamic", HostProfile_SetForceDynamic, METH_VARARGS},
    {"GetForceDynamic", HostProfile_GetForceDynamic, METH_VARARGS},
    {"SetActive", HostProfile_SetActive, METH_VARARGS},
    {"GetActive", HostProfile_GetActive, METH_VARARGS},
    {"SetArguments", HostProfile_SetArguments, METH_VARARGS},
    {"GetArguments", HostProfile_GetArguments, METH_VARARGS},
    {"SetParallel", HostProfile_SetParallel, METH_VARARGS},
    {"GetParallel", HostProfile_GetParallel, METH_VARARGS},
    {"SetLaunchArgsSet", HostProfile_SetLaunchArgsSet, METH_VARARGS},
    {"GetLaunchArgsSet", HostProfile_GetLaunchArgsSet, METH_VARARGS},
    {"SetLaunchArgs", HostProfile_SetLaunchArgs, METH_VARARGS},
    {"GetLaunchArgs", HostProfile_GetLaunchArgs, METH_VARARGS},
    {"SetHostAliases", HostProfile_SetHostAliases, METH_VARARGS},
    {"GetHostAliases", HostProfile_GetHostAliases, METH_VARARGS},
    {"SetShareOneBatchJob", HostProfile_SetShareOneBatchJob, METH_VARARGS},
    {"GetShareOneBatchJob", HostProfile_GetShareOneBatchJob, METH_VARARGS},
    {"SetSshPortSpecified", HostProfile_SetSshPortSpecified, METH_VARARGS},
    {"GetSshPortSpecified", HostProfile_GetSshPortSpecified, METH_VARARGS},
    {"SetSshPort", HostProfile_SetSshPort, METH_VARARGS},
    {"GetSshPort", HostProfile_GetSshPort, METH_VARARGS},
    {"SetClientHostDetermination", HostProfile_SetClientHostDetermination, METH_VARARGS},
    {"GetClientHostDetermination", HostProfile_GetClientHostDetermination, METH_VARARGS},
    {"SetManualClientHostName", HostProfile_SetManualClientHostName, METH_VARARGS},
    {"GetManualClientHostName", HostProfile_GetManualClientHostName, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
HostProfile_dealloc(PyObject *v)
{
   HostProfileObject *obj = (HostProfileObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
HostProfile_compare(PyObject *v, PyObject *w)
{
    HostProfile *a = ((HostProfileObject *)v)->data;
    HostProfile *b = ((HostProfileObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
HostProfile_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "profileName") == 0)
        return HostProfile_GetProfileName(self, NULL);
    if(strcmp(name, "host") == 0)
        return HostProfile_GetHost(self, NULL);
    if(strcmp(name, "userName") == 0)
        return HostProfile_GetUserName(self, NULL);
    if(strcmp(name, "timeout") == 0)
        return HostProfile_GetTimeout(self, NULL);
    if(strcmp(name, "numProcessors") == 0)
        return HostProfile_GetNumProcessors(self, NULL);
    if(strcmp(name, "numNodesSet") == 0)
        return HostProfile_GetNumNodesSet(self, NULL);
    if(strcmp(name, "numNodes") == 0)
        return HostProfile_GetNumNodes(self, NULL);
    if(strcmp(name, "partitionSet") == 0)
        return HostProfile_GetPartitionSet(self, NULL);
    if(strcmp(name, "partition") == 0)
        return HostProfile_GetPartition(self, NULL);
    if(strcmp(name, "bankSet") == 0)
        return HostProfile_GetBankSet(self, NULL);
    if(strcmp(name, "bank") == 0)
        return HostProfile_GetBank(self, NULL);
    if(strcmp(name, "timeLimitSet") == 0)
        return HostProfile_GetTimeLimitSet(self, NULL);
    if(strcmp(name, "timeLimit") == 0)
        return HostProfile_GetTimeLimit(self, NULL);
    if(strcmp(name, "launchMethodSet") == 0)
        return HostProfile_GetLaunchMethodSet(self, NULL);
    if(strcmp(name, "launchMethod") == 0)
        return HostProfile_GetLaunchMethod(self, NULL);
    if(strcmp(name, "forceStatic") == 0)
        return HostProfile_GetForceStatic(self, NULL);
    if(strcmp(name, "forceDynamic") == 0)
        return HostProfile_GetForceDynamic(self, NULL);
    if(strcmp(name, "active") == 0)
        return HostProfile_GetActive(self, NULL);
    if(strcmp(name, "arguments") == 0)
        return HostProfile_GetArguments(self, NULL);
    if(strcmp(name, "parallel") == 0)
        return HostProfile_GetParallel(self, NULL);
    if(strcmp(name, "launchArgsSet") == 0)
        return HostProfile_GetLaunchArgsSet(self, NULL);
    if(strcmp(name, "launchArgs") == 0)
        return HostProfile_GetLaunchArgs(self, NULL);
    if(strcmp(name, "hostAliases") == 0)
        return HostProfile_GetHostAliases(self, NULL);
    if(strcmp(name, "shareOneBatchJob") == 0)
        return HostProfile_GetShareOneBatchJob(self, NULL);
    if(strcmp(name, "sshPortSpecified") == 0)
        return HostProfile_GetSshPortSpecified(self, NULL);
    if(strcmp(name, "sshPort") == 0)
        return HostProfile_GetSshPort(self, NULL);
    if(strcmp(name, "clientHostDetermination") == 0)
        return HostProfile_GetClientHostDetermination(self, NULL);
    if(strcmp(name, "MachineName") == 0)
        return PyInt_FromLong(long(HostProfile::MachineName));
    else if(strcmp(name, "ManuallySpecified") == 0)
        return PyInt_FromLong(long(HostProfile::ManuallySpecified));
    else if(strcmp(name, "ParsedFromSSHCLIENT") == 0)
        return PyInt_FromLong(long(HostProfile::ParsedFromSSHCLIENT));

    if(strcmp(name, "manualClientHostName") == 0)
        return HostProfile_GetManualClientHostName(self, NULL);

    return Py_FindMethod(HostProfile_methods, self, name);
}

static int
HostProfile_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "profileName") == 0)
        retval = (HostProfile_SetProfileName(self, tuple) != NULL);
    else if(strcmp(name, "host") == 0)
        retval = (HostProfile_SetHost(self, tuple) != NULL);
    else if(strcmp(name, "userName") == 0)
        retval = (HostProfile_SetUserName(self, tuple) != NULL);
    else if(strcmp(name, "timeout") == 0)
        retval = (HostProfile_SetTimeout(self, tuple) != NULL);
    else if(strcmp(name, "numProcessors") == 0)
        retval = (HostProfile_SetNumProcessors(self, tuple) != NULL);
    else if(strcmp(name, "numNodesSet") == 0)
        retval = (HostProfile_SetNumNodesSet(self, tuple) != NULL);
    else if(strcmp(name, "numNodes") == 0)
        retval = (HostProfile_SetNumNodes(self, tuple) != NULL);
    else if(strcmp(name, "partitionSet") == 0)
        retval = (HostProfile_SetPartitionSet(self, tuple) != NULL);
    else if(strcmp(name, "partition") == 0)
        retval = (HostProfile_SetPartition(self, tuple) != NULL);
    else if(strcmp(name, "bankSet") == 0)
        retval = (HostProfile_SetBankSet(self, tuple) != NULL);
    else if(strcmp(name, "bank") == 0)
        retval = (HostProfile_SetBank(self, tuple) != NULL);
    else if(strcmp(name, "timeLimitSet") == 0)
        retval = (HostProfile_SetTimeLimitSet(self, tuple) != NULL);
    else if(strcmp(name, "timeLimit") == 0)
        retval = (HostProfile_SetTimeLimit(self, tuple) != NULL);
    else if(strcmp(name, "launchMethodSet") == 0)
        retval = (HostProfile_SetLaunchMethodSet(self, tuple) != NULL);
    else if(strcmp(name, "launchMethod") == 0)
        retval = (HostProfile_SetLaunchMethod(self, tuple) != NULL);
    else if(strcmp(name, "forceStatic") == 0)
        retval = (HostProfile_SetForceStatic(self, tuple) != NULL);
    else if(strcmp(name, "forceDynamic") == 0)
        retval = (HostProfile_SetForceDynamic(self, tuple) != NULL);
    else if(strcmp(name, "active") == 0)
        retval = (HostProfile_SetActive(self, tuple) != NULL);
    else if(strcmp(name, "arguments") == 0)
        retval = (HostProfile_SetArguments(self, tuple) != NULL);
    else if(strcmp(name, "parallel") == 0)
        retval = (HostProfile_SetParallel(self, tuple) != NULL);
    else if(strcmp(name, "launchArgsSet") == 0)
        retval = (HostProfile_SetLaunchArgsSet(self, tuple) != NULL);
    else if(strcmp(name, "launchArgs") == 0)
        retval = (HostProfile_SetLaunchArgs(self, tuple) != NULL);
    else if(strcmp(name, "hostAliases") == 0)
        retval = (HostProfile_SetHostAliases(self, tuple) != NULL);
    else if(strcmp(name, "shareOneBatchJob") == 0)
        retval = (HostProfile_SetShareOneBatchJob(self, tuple) != NULL);
    else if(strcmp(name, "sshPortSpecified") == 0)
        retval = (HostProfile_SetSshPortSpecified(self, tuple) != NULL);
    else if(strcmp(name, "sshPort") == 0)
        retval = (HostProfile_SetSshPort(self, tuple) != NULL);
    else if(strcmp(name, "clientHostDetermination") == 0)
        retval = (HostProfile_SetClientHostDetermination(self, tuple) != NULL);
    else if(strcmp(name, "manualClientHostName") == 0)
        retval = (HostProfile_SetManualClientHostName(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
HostProfile_print(PyObject *v, FILE *fp, int flags)
{
    HostProfileObject *obj = (HostProfileObject *)v;

    fprintf(fp, "profileName = \"%s\"\n", obj->data->GetProfileName().c_str());
    fprintf(fp, "host = \"%s\"\n", obj->data->GetHost().c_str());
    fprintf(fp, "userName = \"%s\"\n", obj->data->GetUserName().c_str());
    fprintf(fp, "timeout = %d\n", obj->data->GetTimeout());
    fprintf(fp, "numProcessors = %d\n", obj->data->GetNumProcessors());
    if(obj->data->GetNumNodesSet())
        fprintf(fp, "numNodesSet = 1\n");
    else
        fprintf(fp, "numNodesSet = 0\n");
    fprintf(fp, "numNodes = %d\n", obj->data->GetNumNodes());
    if(obj->data->GetPartitionSet())
        fprintf(fp, "partitionSet = 1\n");
    else
        fprintf(fp, "partitionSet = 0\n");
    fprintf(fp, "partition = \"%s\"\n", obj->data->GetPartition().c_str());
    if(obj->data->GetBankSet())
        fprintf(fp, "bankSet = 1\n");
    else
        fprintf(fp, "bankSet = 0\n");
    fprintf(fp, "bank = \"%s\"\n", obj->data->GetBank().c_str());
    if(obj->data->GetTimeLimitSet())
        fprintf(fp, "timeLimitSet = 1\n");
    else
        fprintf(fp, "timeLimitSet = 0\n");
    fprintf(fp, "timeLimit = \"%s\"\n", obj->data->GetTimeLimit().c_str());
    if(obj->data->GetLaunchMethodSet())
        fprintf(fp, "launchMethodSet = 1\n");
    else
        fprintf(fp, "launchMethodSet = 0\n");
    fprintf(fp, "launchMethod = \"%s\"\n", obj->data->GetLaunchMethod().c_str());
    if(obj->data->GetForceStatic())
        fprintf(fp, "forceStatic = 1\n");
    else
        fprintf(fp, "forceStatic = 0\n");
    if(obj->data->GetForceDynamic())
        fprintf(fp, "forceDynamic = 1\n");
    else
        fprintf(fp, "forceDynamic = 0\n");
    if(obj->data->GetActive())
        fprintf(fp, "active = 1\n");
    else
        fprintf(fp, "active = 0\n");
    {   const stringVector &arguments = obj->data->GetArguments();
        fprintf(fp, "arguments = (");
        for(int i = 0; i < arguments.size(); ++i)
        {
            fprintf(fp, "\"%s\"", arguments[i].c_str());
            if(i < arguments.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    if(obj->data->GetParallel())
        fprintf(fp, "parallel = 1\n");
    else
        fprintf(fp, "parallel = 0\n");
    if(obj->data->GetLaunchArgsSet())
        fprintf(fp, "launchArgsSet = 1\n");
    else
        fprintf(fp, "launchArgsSet = 0\n");
    fprintf(fp, "launchArgs = \"%s\"\n", obj->data->GetLaunchArgs().c_str());
    fprintf(fp, "hostAliases = \"%s\"\n", obj->data->GetHostAliases().c_str());
    if(obj->data->GetShareOneBatchJob())
        fprintf(fp, "shareOneBatchJob = 1\n");
    else
        fprintf(fp, "shareOneBatchJob = 0\n");
    if(obj->data->GetSshPortSpecified())
        fprintf(fp, "sshPortSpecified = 1\n");
    else
        fprintf(fp, "sshPortSpecified = 0\n");
    fprintf(fp, "sshPort = %d\n", obj->data->GetSshPort());
    const char *clientHostDetermination_names = "MachineName, ManuallySpecified, ParsedFromSSHCLIENT";
    if(obj->data->GetClientHostDetermination() == HostProfile::MachineName)
        fprintf(fp, "clientHostDetermination = MachineName  # %s\n", clientHostDetermination_names);
    else if(obj->data->GetClientHostDetermination() == HostProfile::ManuallySpecified)
        fprintf(fp, "clientHostDetermination = ManuallySpecified  # %s\n", clientHostDetermination_names);
    else
        fprintf(fp, "clientHostDetermination = ParsedFromSSHCLIENT  # %s\n", clientHostDetermination_names);

    fprintf(fp, "manualClientHostName = \"%s\"\n", obj->data->GetManualClientHostName().c_str());

    return 0;
}

//
// The doc string for the class.
//
static char *HostProfile_Purpose = "This class contains information needed to launch a remote,VisIt engine.";

//
// The type description structure
//
static PyTypeObject HostProfileType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "HostProfile",                    // tp_name
    sizeof(HostProfileObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)HostProfile_dealloc,  // tp_dealloc
    (printfunc)HostProfile_print,     // tp_print
    (getattrfunc)HostProfile_getattr, // tp_getattr
    (setattrfunc)HostProfile_setattr, // tp_setattr
    (cmpfunc)HostProfile_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    HostProfile_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static HostProfile *defaultAtts = 0;

static PyObject *
NewHostProfile()
{
    HostProfileObject *newObject;
    newObject = PyObject_NEW(HostProfileObject, &HostProfileType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new HostProfile(*defaultAtts);
    else
        newObject->data = new HostProfile;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapHostProfile(const HostProfile *attr)
{
    HostProfileObject *newObject;
    newObject = PyObject_NEW(HostProfileObject, &HostProfileType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (HostProfile *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
HostProfile_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewHostProfile();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef HostProfileMethods[] = {
    {"HostProfile", HostProfile_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *HostProfileObserver = 0;
static bool HostProfileEnableLogging = true;

static void
PyHostProfile_WriteLog(Subject *subj, void *data)
{
    HostProfile *atts = (HostProfile *)subj;
    FILE *logFile = (FILE *)data;

    if(!HostProfileEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# HostProfile_WriteLog()\n");
}

void
PyHostProfile_StartUp(HostProfile *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyHostProfile_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(HostProfileObserver == 0)
    {
        HostProfileObserver = new ObserverToCallback(subj,
            PyHostProfile_WriteLog, (void *)logFile);
    }

    HostProfileEnableLogging = true;
}

void
PyHostProfile_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete HostProfileObserver;
    HostProfileObserver = 0;
}

PyMethodDef *
PyHostProfile_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return HostProfileMethods;
}

bool
PyHostProfile_Check(PyObject *obj)
{
    return (obj->ob_type == &HostProfileType);
}

HostProfile *
PyHostProfile_FromPyObject(PyObject *obj)
{
    HostProfileObject *obj2 = (HostProfileObject *)obj;
    return obj2->data;
}

PyObject *
PyHostProfile_NewPyObject()
{
    return NewHostProfile();
}

PyObject *
PyHostProfile_WrapPyObject(const HostProfile *attr)
{
    return WrapHostProfile(attr);
}

void
PyHostProfile_SetLogging(bool val)
{
    HostProfileEnableLogging = val;
}

void
PyHostProfile_SetDefaults(const HostProfile *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new HostProfile(*atts);
}

