#include <PyGlobalLineoutAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyGlobalLineoutAttributes
//
// Purpose: 
//   This file contains global attributes controlling Lineouts.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Feb 3 15:56:56 PST 2005
//
// ****************************************************************************

//
// This struct contains the Python type information and a GlobalLineoutAttributes.
//
struct GlobalLineoutAttributesObject
{
    PyObject_HEAD
    GlobalLineoutAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewGlobalLineoutAttributes();

static PyObject *
GlobalLineoutAttributes_Notify(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_SetDynamic(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the Dynamic in the object.
    obj->data->SetDynamic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetDynamic(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDynamic()?1L:0L);
    return retval;
}

static PyObject *
GlobalLineoutAttributes_SetCreateWindow(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createWindow in the object.
    obj->data->SetCreateWindow(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetCreateWindow(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateWindow()?1L:0L);
    return retval;
}

static PyObject *
GlobalLineoutAttributes_SetWindowId(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowId in the object.
    obj->data->SetWindowId(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetWindowId(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowId()));
    return retval;
}

static PyObject *
GlobalLineoutAttributes_SetSamplingOn(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplingOn in the object.
    obj->data->SetSamplingOn(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetSamplingOn(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSamplingOn()?1L:0L);
    return retval;
}

static PyObject *
GlobalLineoutAttributes_SetNumSamples(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numSamples in the object.
    obj->data->SetNumSamples(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetNumSamples(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumSamples()));
    return retval;
}

static PyObject *
GlobalLineoutAttributes_SetCreateReflineLabels(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createReflineLabels in the object.
    obj->data->SetCreateReflineLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetCreateReflineLabels(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateReflineLabels()?1L:0L);
    return retval;
}

static PyObject *
GlobalLineoutAttributes_SetCurveOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the curveOption in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCurveOption(GlobalLineoutAttributes::CurveOptions(ival));
    else
    {
        fprintf(stderr, "An invalid curveOption value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "UpdateCurve, CreateCurve.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetCurveOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCurveOption()));
    return retval;
}

static PyObject *
GlobalLineoutAttributes_SetColorOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorOption in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetColorOption(GlobalLineoutAttributes::ColorOptions(ival));
    else
    {
        fprintf(stderr, "An invalid colorOption value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "RepeatColor, CreateColor.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalLineoutAttributes_GetColorOption(PyObject *self, PyObject *args)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorOption()));
    return retval;
}



static struct PyMethodDef GlobalLineoutAttributes_methods[] = {
    {"Notify", GlobalLineoutAttributes_Notify, METH_VARARGS},
    {"SetDynamic", GlobalLineoutAttributes_SetDynamic, METH_VARARGS},
    {"GetDynamic", GlobalLineoutAttributes_GetDynamic, METH_VARARGS},
    {"SetCreateWindow", GlobalLineoutAttributes_SetCreateWindow, METH_VARARGS},
    {"GetCreateWindow", GlobalLineoutAttributes_GetCreateWindow, METH_VARARGS},
    {"SetWindowId", GlobalLineoutAttributes_SetWindowId, METH_VARARGS},
    {"GetWindowId", GlobalLineoutAttributes_GetWindowId, METH_VARARGS},
    {"SetSamplingOn", GlobalLineoutAttributes_SetSamplingOn, METH_VARARGS},
    {"GetSamplingOn", GlobalLineoutAttributes_GetSamplingOn, METH_VARARGS},
    {"SetNumSamples", GlobalLineoutAttributes_SetNumSamples, METH_VARARGS},
    {"GetNumSamples", GlobalLineoutAttributes_GetNumSamples, METH_VARARGS},
    {"SetCreateReflineLabels", GlobalLineoutAttributes_SetCreateReflineLabels, METH_VARARGS},
    {"GetCreateReflineLabels", GlobalLineoutAttributes_GetCreateReflineLabels, METH_VARARGS},
    {"SetCurveOption", GlobalLineoutAttributes_SetCurveOption, METH_VARARGS},
    {"GetCurveOption", GlobalLineoutAttributes_GetCurveOption, METH_VARARGS},
    {"SetColorOption", GlobalLineoutAttributes_SetColorOption, METH_VARARGS},
    {"GetColorOption", GlobalLineoutAttributes_GetColorOption, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
GlobalLineoutAttributes_dealloc(PyObject *v)
{
   GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
GlobalLineoutAttributes_compare(PyObject *v, PyObject *w)
{
    GlobalLineoutAttributes *a = ((GlobalLineoutAttributesObject *)v)->data;
    GlobalLineoutAttributes *b = ((GlobalLineoutAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
GlobalLineoutAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "Dynamic") == 0)
        return GlobalLineoutAttributes_GetDynamic(self, NULL);
    if(strcmp(name, "createWindow") == 0)
        return GlobalLineoutAttributes_GetCreateWindow(self, NULL);
    if(strcmp(name, "windowId") == 0)
        return GlobalLineoutAttributes_GetWindowId(self, NULL);
    if(strcmp(name, "samplingOn") == 0)
        return GlobalLineoutAttributes_GetSamplingOn(self, NULL);
    if(strcmp(name, "numSamples") == 0)
        return GlobalLineoutAttributes_GetNumSamples(self, NULL);
    if(strcmp(name, "createReflineLabels") == 0)
        return GlobalLineoutAttributes_GetCreateReflineLabels(self, NULL);
    if(strcmp(name, "curveOption") == 0)
        return GlobalLineoutAttributes_GetCurveOption(self, NULL);
    if(strcmp(name, "UpdateCurve") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::UpdateCurve));
    else if(strcmp(name, "CreateCurve") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::CreateCurve));

    if(strcmp(name, "colorOption") == 0)
        return GlobalLineoutAttributes_GetColorOption(self, NULL);
    if(strcmp(name, "RepeatColor") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::RepeatColor));
    else if(strcmp(name, "CreateColor") == 0)
        return PyInt_FromLong(long(GlobalLineoutAttributes::CreateColor));


    return Py_FindMethod(GlobalLineoutAttributes_methods, self, name);
}

static int
GlobalLineoutAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "Dynamic") == 0)
        retval = (GlobalLineoutAttributes_SetDynamic(self, tuple) != NULL);
    else if(strcmp(name, "createWindow") == 0)
        retval = (GlobalLineoutAttributes_SetCreateWindow(self, tuple) != NULL);
    else if(strcmp(name, "windowId") == 0)
        retval = (GlobalLineoutAttributes_SetWindowId(self, tuple) != NULL);
    else if(strcmp(name, "samplingOn") == 0)
        retval = (GlobalLineoutAttributes_SetSamplingOn(self, tuple) != NULL);
    else if(strcmp(name, "numSamples") == 0)
        retval = (GlobalLineoutAttributes_SetNumSamples(self, tuple) != NULL);
    else if(strcmp(name, "createReflineLabels") == 0)
        retval = (GlobalLineoutAttributes_SetCreateReflineLabels(self, tuple) != NULL);
    else if(strcmp(name, "curveOption") == 0)
        retval = (GlobalLineoutAttributes_SetCurveOption(self, tuple) != NULL);
    else if(strcmp(name, "colorOption") == 0)
        retval = (GlobalLineoutAttributes_SetColorOption(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
GlobalLineoutAttributes_print(PyObject *v, FILE *fp, int flags)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)v;

    if(obj->data->GetDynamic())
        fprintf(fp, "Dynamic = 1\n");
    else
        fprintf(fp, "Dynamic = 0\n");
    if(obj->data->GetCreateWindow())
        fprintf(fp, "createWindow = 1\n");
    else
        fprintf(fp, "createWindow = 0\n");
    fprintf(fp, "windowId = %d\n", obj->data->GetWindowId());
    if(obj->data->GetSamplingOn())
        fprintf(fp, "samplingOn = 1\n");
    else
        fprintf(fp, "samplingOn = 0\n");
    fprintf(fp, "numSamples = %d\n", obj->data->GetNumSamples());
    if(obj->data->GetCreateReflineLabels())
        fprintf(fp, "createReflineLabels = 1\n");
    else
        fprintf(fp, "createReflineLabels = 0\n");
    const char *curveOption_names = "UpdateCurve, CreateCurve";
    if(obj->data->GetCurveOption() == GlobalLineoutAttributes::UpdateCurve)
        fprintf(fp, "curveOption = UpdateCurve  # %s\n", curveOption_names);
    else
        fprintf(fp, "curveOption = CreateCurve  # %s\n", curveOption_names);

    const char *colorOption_names = "RepeatColor, CreateColor";
    if(obj->data->GetColorOption() == GlobalLineoutAttributes::RepeatColor)
        fprintf(fp, "colorOption = RepeatColor  # %s\n", colorOption_names);
    else
        fprintf(fp, "colorOption = CreateColor  # %s\n", colorOption_names);


    return 0;
}

#include <snprintf.h>
PyObject *
PyGlobalLineoutAttributes_StringRepresentation(const GlobalLineoutAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetDynamic())
        SNPRINTF(tmpStr, 1000, "Dynamic = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "Dynamic = 0\n");
    str += tmpStr;
    if(atts->GetCreateWindow())
        SNPRINTF(tmpStr, 1000, "createWindow = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "createWindow = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "windowId = %d\n", atts->GetWindowId());
    str += tmpStr;
    if(atts->GetSamplingOn())
        SNPRINTF(tmpStr, 1000, "samplingOn = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "samplingOn = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "numSamples = %d\n", atts->GetNumSamples());
    str += tmpStr;
    if(atts->GetCreateReflineLabels())
        SNPRINTF(tmpStr, 1000, "createReflineLabels = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "createReflineLabels = 0\n");
    str += tmpStr;
    const char *curveOption_names = "UpdateCurve, CreateCurve";
    if(atts->GetCurveOption() == GlobalLineoutAttributes::UpdateCurve)
        {
             SNPRINTF(tmpStr, 1000, "curveOption = UpdateCurve  # %s\n", curveOption_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "curveOption = CreateCurve  # %s\n", curveOption_names);
             str += tmpStr;
        }

    const char *colorOption_names = "RepeatColor, CreateColor";
    if(atts->GetColorOption() == GlobalLineoutAttributes::RepeatColor)
        {
             SNPRINTF(tmpStr, 1000, "colorOption = RepeatColor  # %s\n", colorOption_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "colorOption = CreateColor  # %s\n", colorOption_names);
             str += tmpStr;
        }

    return PyString_FromString(str.c_str());
}

static PyObject *
GlobalLineoutAttributes_str(PyObject *v)
{
    GlobalLineoutAttributesObject *obj = (GlobalLineoutAttributesObject *)v;
    return PyGlobalLineoutAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *GlobalLineoutAttributes_Purpose = "This file contains global attributes controlling Lineouts.";

//
// The type description structure
//
static PyTypeObject GlobalLineoutAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "GlobalLineoutAttributes",                    // tp_name
    sizeof(GlobalLineoutAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)GlobalLineoutAttributes_dealloc,  // tp_dealloc
    (printfunc)GlobalLineoutAttributes_print,     // tp_print
    (getattrfunc)GlobalLineoutAttributes_getattr, // tp_getattr
    (setattrfunc)GlobalLineoutAttributes_setattr, // tp_setattr
    (cmpfunc)GlobalLineoutAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)GlobalLineoutAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    GlobalLineoutAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static GlobalLineoutAttributes *defaultAtts = 0;

static PyObject *
NewGlobalLineoutAttributes()
{
    GlobalLineoutAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalLineoutAttributesObject, &GlobalLineoutAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new GlobalLineoutAttributes(*defaultAtts);
    else
        newObject->data = new GlobalLineoutAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapGlobalLineoutAttributes(const GlobalLineoutAttributes *attr)
{
    GlobalLineoutAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalLineoutAttributesObject, &GlobalLineoutAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (GlobalLineoutAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
GlobalLineoutAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewGlobalLineoutAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef GlobalLineoutAttributesMethods[] = {
    {"GlobalLineoutAttributes", GlobalLineoutAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *GlobalLineoutAttributesObserver = 0;
static bool GlobalLineoutAttributesEnableLogging = true;

static void
PyGlobalLineoutAttributes_WriteLog(Subject *subj, void *data)
{
    GlobalLineoutAttributes *atts = (GlobalLineoutAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!GlobalLineoutAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# GlobalLineoutAttributes_WriteLog()\n");
}

void
PyGlobalLineoutAttributes_StartUp(GlobalLineoutAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyGlobalLineoutAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(GlobalLineoutAttributesObserver == 0)
    {
        GlobalLineoutAttributesObserver = new ObserverToCallback(subj,
            PyGlobalLineoutAttributes_WriteLog, (void *)logFile);
    }

    GlobalLineoutAttributesEnableLogging = true;
}

void
PyGlobalLineoutAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete GlobalLineoutAttributesObserver;
    GlobalLineoutAttributesObserver = 0;
}

PyMethodDef *
PyGlobalLineoutAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return GlobalLineoutAttributesMethods;
}

bool
PyGlobalLineoutAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &GlobalLineoutAttributesType);
}

GlobalLineoutAttributes *
PyGlobalLineoutAttributes_FromPyObject(PyObject *obj)
{
    GlobalLineoutAttributesObject *obj2 = (GlobalLineoutAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyGlobalLineoutAttributes_NewPyObject()
{
    return NewGlobalLineoutAttributes();
}

PyObject *
PyGlobalLineoutAttributes_WrapPyObject(const GlobalLineoutAttributes *attr)
{
    return WrapGlobalLineoutAttributes(attr);
}

void
PyGlobalLineoutAttributes_SetLogging(bool val)
{
    GlobalLineoutAttributesEnableLogging = val;
}

void
PyGlobalLineoutAttributes_SetDefaults(const GlobalLineoutAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new GlobalLineoutAttributes(*atts);
}

