#include <PyGlobalAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyGlobalAttributes
//
// Purpose: 
//   This class contains attributes associated with the main window.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Aug 5 16:52:31 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a GlobalAttributes.
//
struct GlobalAttributesObject
{
    PyObject_HEAD
    GlobalAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewGlobalAttributes();

static PyObject *
GlobalAttributes_Notify(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_SetSources(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    stringVector  &vec = obj->data->GetSources();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the sources in the object as modified.
    obj->data->SelectSources();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetSources(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the sources.
    const stringVector &sources = obj->data->GetSources();
    PyObject *retval = PyTuple_New(sources.size());
    for(int i = 0; i < sources.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(sources[i].c_str()));
    return retval;
}

static PyObject *
GlobalAttributes_SetWindows(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    intVector  &vec = obj->data->GetWindows();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the windows in the object as modified.
    obj->data->SelectWindows();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetWindows(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the windows.
    const intVector &windows = obj->data->GetWindows();
    PyObject *retval = PyTuple_New(windows.size());
    for(int i = 0; i < windows.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(windows[i])));
    return retval;
}

static PyObject *
GlobalAttributes_SetActiveWindow(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the activeWindow in the object.
    obj->data->SetActiveWindow(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetActiveWindow(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetActiveWindow()));
    return retval;
}

static PyObject *
GlobalAttributes_SetIconifiedFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the iconifiedFlag in the object.
    obj->data->SetIconifiedFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetIconifiedFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIconifiedFlag()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetAutoUpdateFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoUpdateFlag in the object.
    obj->data->SetAutoUpdateFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetAutoUpdateFlag(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoUpdateFlag()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetReplacePlots(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the replacePlots in the object.
    obj->data->SetReplacePlots(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetReplacePlots(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetReplacePlots()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetApplyOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the applyOperator in the object.
    obj->data->SetApplyOperator(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetApplyOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetApplyOperator()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetExecuting(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the executing in the object.
    obj->data->SetExecuting(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetExecuting(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetExecuting()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetWindowLayout(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowLayout in the object.
    obj->data->SetWindowLayout(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetWindowLayout(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowLayout()));
    return retval;
}

static PyObject *
GlobalAttributes_SetMakeDefaultConfirm(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the makeDefaultConfirm in the object.
    obj->data->SetMakeDefaultConfirm(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetMakeDefaultConfirm(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMakeDefaultConfirm()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetCloneWindowOnFirstRef(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cloneWindowOnFirstRef in the object.
    obj->data->SetCloneWindowOnFirstRef(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetCloneWindowOnFirstRef(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCloneWindowOnFirstRef()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetMaintainView(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maintainView in the object.
    obj->data->SetMaintainView(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetMaintainView(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaintainView()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetMaintainData(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maintainData in the object.
    obj->data->SetMaintainData(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetMaintainData(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaintainData()?1L:0L);
    return retval;
}

static PyObject *
GlobalAttributes_SetAutomaticallyAddOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the automaticallyAddOperator in the object.
    obj->data->SetAutomaticallyAddOperator(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GlobalAttributes_GetAutomaticallyAddOperator(PyObject *self, PyObject *args)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutomaticallyAddOperator()?1L:0L);
    return retval;
}



static struct PyMethodDef GlobalAttributes_methods[] = {
    {"Notify", GlobalAttributes_Notify, METH_VARARGS},
    {"SetSources", GlobalAttributes_SetSources, METH_VARARGS},
    {"GetSources", GlobalAttributes_GetSources, METH_VARARGS},
    {"SetWindows", GlobalAttributes_SetWindows, METH_VARARGS},
    {"GetWindows", GlobalAttributes_GetWindows, METH_VARARGS},
    {"SetActiveWindow", GlobalAttributes_SetActiveWindow, METH_VARARGS},
    {"GetActiveWindow", GlobalAttributes_GetActiveWindow, METH_VARARGS},
    {"SetIconifiedFlag", GlobalAttributes_SetIconifiedFlag, METH_VARARGS},
    {"GetIconifiedFlag", GlobalAttributes_GetIconifiedFlag, METH_VARARGS},
    {"SetAutoUpdateFlag", GlobalAttributes_SetAutoUpdateFlag, METH_VARARGS},
    {"GetAutoUpdateFlag", GlobalAttributes_GetAutoUpdateFlag, METH_VARARGS},
    {"SetReplacePlots", GlobalAttributes_SetReplacePlots, METH_VARARGS},
    {"GetReplacePlots", GlobalAttributes_GetReplacePlots, METH_VARARGS},
    {"SetApplyOperator", GlobalAttributes_SetApplyOperator, METH_VARARGS},
    {"GetApplyOperator", GlobalAttributes_GetApplyOperator, METH_VARARGS},
    {"SetExecuting", GlobalAttributes_SetExecuting, METH_VARARGS},
    {"GetExecuting", GlobalAttributes_GetExecuting, METH_VARARGS},
    {"SetWindowLayout", GlobalAttributes_SetWindowLayout, METH_VARARGS},
    {"GetWindowLayout", GlobalAttributes_GetWindowLayout, METH_VARARGS},
    {"SetMakeDefaultConfirm", GlobalAttributes_SetMakeDefaultConfirm, METH_VARARGS},
    {"GetMakeDefaultConfirm", GlobalAttributes_GetMakeDefaultConfirm, METH_VARARGS},
    {"SetCloneWindowOnFirstRef", GlobalAttributes_SetCloneWindowOnFirstRef, METH_VARARGS},
    {"GetCloneWindowOnFirstRef", GlobalAttributes_GetCloneWindowOnFirstRef, METH_VARARGS},
    {"SetMaintainView", GlobalAttributes_SetMaintainView, METH_VARARGS},
    {"GetMaintainView", GlobalAttributes_GetMaintainView, METH_VARARGS},
    {"SetMaintainData", GlobalAttributes_SetMaintainData, METH_VARARGS},
    {"GetMaintainData", GlobalAttributes_GetMaintainData, METH_VARARGS},
    {"SetAutomaticallyAddOperator", GlobalAttributes_SetAutomaticallyAddOperator, METH_VARARGS},
    {"GetAutomaticallyAddOperator", GlobalAttributes_GetAutomaticallyAddOperator, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
GlobalAttributes_dealloc(PyObject *v)
{
   GlobalAttributesObject *obj = (GlobalAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
GlobalAttributes_compare(PyObject *v, PyObject *w)
{
    GlobalAttributes *a = ((GlobalAttributesObject *)v)->data;
    GlobalAttributes *b = ((GlobalAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
GlobalAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sources") == 0)
        return GlobalAttributes_GetSources(self, NULL);
    if(strcmp(name, "windows") == 0)
        return GlobalAttributes_GetWindows(self, NULL);
    if(strcmp(name, "activeWindow") == 0)
        return GlobalAttributes_GetActiveWindow(self, NULL);
    if(strcmp(name, "iconifiedFlag") == 0)
        return GlobalAttributes_GetIconifiedFlag(self, NULL);
    if(strcmp(name, "autoUpdateFlag") == 0)
        return GlobalAttributes_GetAutoUpdateFlag(self, NULL);
    if(strcmp(name, "replacePlots") == 0)
        return GlobalAttributes_GetReplacePlots(self, NULL);
    if(strcmp(name, "applyOperator") == 0)
        return GlobalAttributes_GetApplyOperator(self, NULL);
    if(strcmp(name, "executing") == 0)
        return GlobalAttributes_GetExecuting(self, NULL);
    if(strcmp(name, "windowLayout") == 0)
        return GlobalAttributes_GetWindowLayout(self, NULL);
    if(strcmp(name, "makeDefaultConfirm") == 0)
        return GlobalAttributes_GetMakeDefaultConfirm(self, NULL);
    if(strcmp(name, "cloneWindowOnFirstRef") == 0)
        return GlobalAttributes_GetCloneWindowOnFirstRef(self, NULL);
    if(strcmp(name, "maintainView") == 0)
        return GlobalAttributes_GetMaintainView(self, NULL);
    if(strcmp(name, "maintainData") == 0)
        return GlobalAttributes_GetMaintainData(self, NULL);
    if(strcmp(name, "automaticallyAddOperator") == 0)
        return GlobalAttributes_GetAutomaticallyAddOperator(self, NULL);

    return Py_FindMethod(GlobalAttributes_methods, self, name);
}

static int
GlobalAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "sources") == 0)
        retval = (GlobalAttributes_SetSources(self, tuple) != NULL);
    else if(strcmp(name, "windows") == 0)
        retval = (GlobalAttributes_SetWindows(self, tuple) != NULL);
    else if(strcmp(name, "activeWindow") == 0)
        retval = (GlobalAttributes_SetActiveWindow(self, tuple) != NULL);
    else if(strcmp(name, "iconifiedFlag") == 0)
        retval = (GlobalAttributes_SetIconifiedFlag(self, tuple) != NULL);
    else if(strcmp(name, "autoUpdateFlag") == 0)
        retval = (GlobalAttributes_SetAutoUpdateFlag(self, tuple) != NULL);
    else if(strcmp(name, "replacePlots") == 0)
        retval = (GlobalAttributes_SetReplacePlots(self, tuple) != NULL);
    else if(strcmp(name, "applyOperator") == 0)
        retval = (GlobalAttributes_SetApplyOperator(self, tuple) != NULL);
    else if(strcmp(name, "executing") == 0)
        retval = (GlobalAttributes_SetExecuting(self, tuple) != NULL);
    else if(strcmp(name, "windowLayout") == 0)
        retval = (GlobalAttributes_SetWindowLayout(self, tuple) != NULL);
    else if(strcmp(name, "makeDefaultConfirm") == 0)
        retval = (GlobalAttributes_SetMakeDefaultConfirm(self, tuple) != NULL);
    else if(strcmp(name, "cloneWindowOnFirstRef") == 0)
        retval = (GlobalAttributes_SetCloneWindowOnFirstRef(self, tuple) != NULL);
    else if(strcmp(name, "maintainView") == 0)
        retval = (GlobalAttributes_SetMaintainView(self, tuple) != NULL);
    else if(strcmp(name, "maintainData") == 0)
        retval = (GlobalAttributes_SetMaintainData(self, tuple) != NULL);
    else if(strcmp(name, "automaticallyAddOperator") == 0)
        retval = (GlobalAttributes_SetAutomaticallyAddOperator(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
GlobalAttributes_print(PyObject *v, FILE *fp, int flags)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)v;

    {   const stringVector &sources = obj->data->GetSources();
        fprintf(fp, "sources = (");
        for(int i = 0; i < sources.size(); ++i)
        {
            fprintf(fp, "\"%s\"", sources[i].c_str());
            if(i < sources.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const intVector &windows = obj->data->GetWindows();
        fprintf(fp, "windows = (");
        for(int i = 0; i < windows.size(); ++i)
        {
            fprintf(fp, "%d", windows[i]);
            if(i < windows.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "activeWindow = %d\n", obj->data->GetActiveWindow());
    if(obj->data->GetIconifiedFlag())
        fprintf(fp, "iconifiedFlag = 1\n");
    else
        fprintf(fp, "iconifiedFlag = 0\n");
    if(obj->data->GetAutoUpdateFlag())
        fprintf(fp, "autoUpdateFlag = 1\n");
    else
        fprintf(fp, "autoUpdateFlag = 0\n");
    if(obj->data->GetReplacePlots())
        fprintf(fp, "replacePlots = 1\n");
    else
        fprintf(fp, "replacePlots = 0\n");
    if(obj->data->GetApplyOperator())
        fprintf(fp, "applyOperator = 1\n");
    else
        fprintf(fp, "applyOperator = 0\n");
    if(obj->data->GetExecuting())
        fprintf(fp, "executing = 1\n");
    else
        fprintf(fp, "executing = 0\n");
    fprintf(fp, "windowLayout = %d\n", obj->data->GetWindowLayout());
    if(obj->data->GetMakeDefaultConfirm())
        fprintf(fp, "makeDefaultConfirm = 1\n");
    else
        fprintf(fp, "makeDefaultConfirm = 0\n");
    if(obj->data->GetCloneWindowOnFirstRef())
        fprintf(fp, "cloneWindowOnFirstRef = 1\n");
    else
        fprintf(fp, "cloneWindowOnFirstRef = 0\n");
    if(obj->data->GetMaintainView())
        fprintf(fp, "maintainView = 1\n");
    else
        fprintf(fp, "maintainView = 0\n");
    if(obj->data->GetMaintainData())
        fprintf(fp, "maintainData = 1\n");
    else
        fprintf(fp, "maintainData = 0\n");
    if(obj->data->GetAutomaticallyAddOperator())
        fprintf(fp, "automaticallyAddOperator = 1\n");
    else
        fprintf(fp, "automaticallyAddOperator = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyGlobalAttributes_StringRepresentation(const GlobalAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    {   const stringVector &sources = atts->GetSources();
        SNPRINTF(tmpStr, 1000, "sources = (");
        str += tmpStr;
        for(int i = 0; i < sources.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", sources[i].c_str());
            str += tmpStr;
            if(i < sources.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &windows = atts->GetWindows();
        SNPRINTF(tmpStr, 1000, "windows = (");
        str += tmpStr;
        for(int i = 0; i < windows.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", windows[i]);
            str += tmpStr;
            if(i < windows.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "activeWindow = %d\n", atts->GetActiveWindow());
    str += tmpStr;
    if(atts->GetIconifiedFlag())
        SNPRINTF(tmpStr, 1000, "iconifiedFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "iconifiedFlag = 0\n");
    str += tmpStr;
    if(atts->GetAutoUpdateFlag())
        SNPRINTF(tmpStr, 1000, "autoUpdateFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "autoUpdateFlag = 0\n");
    str += tmpStr;
    if(atts->GetReplacePlots())
        SNPRINTF(tmpStr, 1000, "replacePlots = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "replacePlots = 0\n");
    str += tmpStr;
    if(atts->GetApplyOperator())
        SNPRINTF(tmpStr, 1000, "applyOperator = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "applyOperator = 0\n");
    str += tmpStr;
    if(atts->GetExecuting())
        SNPRINTF(tmpStr, 1000, "executing = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "executing = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "windowLayout = %d\n", atts->GetWindowLayout());
    str += tmpStr;
    if(atts->GetMakeDefaultConfirm())
        SNPRINTF(tmpStr, 1000, "makeDefaultConfirm = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "makeDefaultConfirm = 0\n");
    str += tmpStr;
    if(atts->GetCloneWindowOnFirstRef())
        SNPRINTF(tmpStr, 1000, "cloneWindowOnFirstRef = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "cloneWindowOnFirstRef = 0\n");
    str += tmpStr;
    if(atts->GetMaintainView())
        SNPRINTF(tmpStr, 1000, "maintainView = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maintainView = 0\n");
    str += tmpStr;
    if(atts->GetMaintainData())
        SNPRINTF(tmpStr, 1000, "maintainData = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maintainData = 0\n");
    str += tmpStr;
    if(atts->GetAutomaticallyAddOperator())
        SNPRINTF(tmpStr, 1000, "automaticallyAddOperator = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "automaticallyAddOperator = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
GlobalAttributes_str(PyObject *v)
{
    GlobalAttributesObject *obj = (GlobalAttributesObject *)v;
    return PyGlobalAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *GlobalAttributes_Purpose = "This class contains attributes associated with the main window.";

//
// The type description structure
//
static PyTypeObject GlobalAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "GlobalAttributes",                    // tp_name
    sizeof(GlobalAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)GlobalAttributes_dealloc,  // tp_dealloc
    (printfunc)GlobalAttributes_print,     // tp_print
    (getattrfunc)GlobalAttributes_getattr, // tp_getattr
    (setattrfunc)GlobalAttributes_setattr, // tp_setattr
    (cmpfunc)GlobalAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)GlobalAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    GlobalAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static GlobalAttributes *defaultAtts = 0;

static PyObject *
NewGlobalAttributes()
{
    GlobalAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalAttributesObject, &GlobalAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new GlobalAttributes(*defaultAtts);
    else
        newObject->data = new GlobalAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapGlobalAttributes(const GlobalAttributes *attr)
{
    GlobalAttributesObject *newObject;
    newObject = PyObject_NEW(GlobalAttributesObject, &GlobalAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (GlobalAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
GlobalAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewGlobalAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef GlobalAttributesMethods[] = {
    {"GlobalAttributes", GlobalAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *GlobalAttributesObserver = 0;
static bool GlobalAttributesEnableLogging = true;

static void
PyGlobalAttributes_WriteLog(Subject *subj, void *data)
{
    GlobalAttributes *atts = (GlobalAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!GlobalAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# GlobalAttributes_WriteLog()\n");
}

void
PyGlobalAttributes_StartUp(GlobalAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyGlobalAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(GlobalAttributesObserver == 0)
    {
        GlobalAttributesObserver = new ObserverToCallback(subj,
            PyGlobalAttributes_WriteLog, (void *)logFile);
    }

    GlobalAttributesEnableLogging = true;
}

void
PyGlobalAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete GlobalAttributesObserver;
    GlobalAttributesObserver = 0;
}

PyMethodDef *
PyGlobalAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return GlobalAttributesMethods;
}

bool
PyGlobalAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &GlobalAttributesType);
}

GlobalAttributes *
PyGlobalAttributes_FromPyObject(PyObject *obj)
{
    GlobalAttributesObject *obj2 = (GlobalAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyGlobalAttributes_NewPyObject()
{
    return NewGlobalAttributes();
}

PyObject *
PyGlobalAttributes_WrapPyObject(const GlobalAttributes *attr)
{
    return WrapGlobalAttributes(attr);
}

void
PyGlobalAttributes_SetLogging(bool val)
{
    GlobalAttributesEnableLogging = val;
}

void
PyGlobalAttributes_SetDefaults(const GlobalAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new GlobalAttributes(*atts);
}

