#include <PyAnnotationAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyAnnotationAttributes
//
// Purpose: 
//   This class contains the attributes controlling annotations.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu May 27 11:03:11 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a AnnotationAttributes.
//
struct AnnotationAttributesObject
{
    PyObject_HEAD
    AnnotationAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewAnnotationAttributes();

static PyObject *
AnnotationAttributes_Notify(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_SetAxesFlag2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesFlag2D in the object.
    obj->data->SetAxesFlag2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesFlag2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAxesFlag2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesAutoSetTicks2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesAutoSetTicks2D in the object.
    obj->data->SetAxesAutoSetTicks2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesAutoSetTicks2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAxesAutoSetTicks2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetLabelAutoSetScaling2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the labelAutoSetScaling2D in the object.
    obj->data->SetLabelAutoSetScaling2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetLabelAutoSetScaling2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLabelAutoSetScaling2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXAxisLabels2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xAxisLabels2D in the object.
    obj->data->SetXAxisLabels2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXAxisLabels2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXAxisLabels2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetYAxisLabels2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yAxisLabels2D in the object.
    obj->data->SetYAxisLabels2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYAxisLabels2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYAxisLabels2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXAxisTitle2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xAxisTitle2D in the object.
    obj->data->SetXAxisTitle2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXAxisTitle2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXAxisTitle2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetYAxisTitle2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yAxisTitle2D in the object.
    obj->data->SetYAxisTitle2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYAxisTitle2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYAxisTitle2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXGridLines2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xGridLines2D in the object.
    obj->data->SetXGridLines2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXGridLines2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXGridLines2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetYGridLines2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yGridLines2D in the object.
    obj->data->SetYGridLines2D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYGridLines2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYGridLines2D()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMajorTickMinimum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMajorTickMinimum2D in the object.
    obj->data->SetXMajorTickMinimum2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMajorTickMinimum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMajorTickMinimum2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMajorTickMinimum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMajorTickMinimum2D in the object.
    obj->data->SetYMajorTickMinimum2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMajorTickMinimum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMajorTickMinimum2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMajorTickMaximum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMajorTickMaximum2D in the object.
    obj->data->SetXMajorTickMaximum2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMajorTickMaximum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMajorTickMaximum2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMajorTickMaximum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMajorTickMaximum2D in the object.
    obj->data->SetYMajorTickMaximum2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMajorTickMaximum2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMajorTickMaximum2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMajorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMajorTickSpacing2D in the object.
    obj->data->SetXMajorTickSpacing2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMajorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMajorTickSpacing2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMajorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMajorTickSpacing2D in the object.
    obj->data->SetYMajorTickSpacing2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMajorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMajorTickSpacing2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMinorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMinorTickSpacing2D in the object.
    obj->data->SetXMinorTickSpacing2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMinorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMinorTickSpacing2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMinorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMinorTickSpacing2D in the object.
    obj->data->SetYMinorTickSpacing2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMinorTickSpacing2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMinorTickSpacing2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXLabelFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xLabelFontHeight2D in the object.
    obj->data->SetXLabelFontHeight2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXLabelFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXLabelFontHeight2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYLabelFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yLabelFontHeight2D in the object.
    obj->data->SetYLabelFontHeight2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYLabelFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYLabelFontHeight2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXTitleFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xTitleFontHeight2D in the object.
    obj->data->SetXTitleFontHeight2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXTitleFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXTitleFontHeight2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYTitleFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yTitleFontHeight2D in the object.
    obj->data->SetYTitleFontHeight2D(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYTitleFontHeight2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYTitleFontHeight2D());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXLabelScaling2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xLabelScaling2D in the object.
    obj->data->SetXLabelScaling2D(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXLabelScaling2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXLabelScaling2D()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetYLabelScaling2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yLabelScaling2D in the object.
    obj->data->SetYLabelScaling2D(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYLabelScaling2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYLabelScaling2D()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesLineWidth2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesLineWidth2D in the object.
    obj->data->SetAxesLineWidth2D(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesLineWidth2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAxesLineWidth2D()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesTickLocation2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesTickLocation2D in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetAxesTickLocation2D(AnnotationAttributes::Location(ival));
    else
    {
        fprintf(stderr, "An invalid axesTickLocation2D value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Inside, Outside, Both.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesTickLocation2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAxesTickLocation2D()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesTicks2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesTicks2D in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetAxesTicks2D(AnnotationAttributes::Ticks(ival));
    else
    {
        fprintf(stderr, "An invalid axesTicks2D value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Off, Bottom, Left, BottomLeft, All.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesTicks2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAxesTicks2D()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesFlag in the object.
    obj->data->SetAxesFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAxesFlag()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesAutoSetTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesAutoSetTicks in the object.
    obj->data->SetAxesAutoSetTicks(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesAutoSetTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAxesAutoSetTicks()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetLabelAutoSetScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the labelAutoSetScaling in the object.
    obj->data->SetLabelAutoSetScaling(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetLabelAutoSetScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLabelAutoSetScaling()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXAxisLabels(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xAxisLabels in the object.
    obj->data->SetXAxisLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXAxisLabels(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXAxisLabels()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetYAxisLabels(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yAxisLabels in the object.
    obj->data->SetYAxisLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYAxisLabels(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYAxisLabels()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetZAxisLabels(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zAxisLabels in the object.
    obj->data->SetZAxisLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZAxisLabels(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetZAxisLabels()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXAxisTitle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xAxisTitle in the object.
    obj->data->SetXAxisTitle(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXAxisTitle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXAxisTitle()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetYAxisTitle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yAxisTitle in the object.
    obj->data->SetYAxisTitle(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYAxisTitle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYAxisTitle()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetZAxisTitle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zAxisTitle in the object.
    obj->data->SetZAxisTitle(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZAxisTitle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetZAxisTitle()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXGridLines(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xGridLines in the object.
    obj->data->SetXGridLines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXGridLines(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXGridLines()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetYGridLines(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yGridLines in the object.
    obj->data->SetYGridLines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYGridLines(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYGridLines()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetZGridLines(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zGridLines in the object.
    obj->data->SetZGridLines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZGridLines(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetZGridLines()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXAxisTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xAxisTicks in the object.
    obj->data->SetXAxisTicks(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXAxisTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetXAxisTicks()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetYAxisTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yAxisTicks in the object.
    obj->data->SetYAxisTicks(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYAxisTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetYAxisTicks()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetZAxisTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zAxisTicks in the object.
    obj->data->SetZAxisTicks(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZAxisTicks(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetZAxisTicks()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMajorTickMinimum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMajorTickMinimum in the object.
    obj->data->SetXMajorTickMinimum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMajorTickMinimum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMajorTickMinimum());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMajorTickMinimum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMajorTickMinimum in the object.
    obj->data->SetYMajorTickMinimum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMajorTickMinimum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMajorTickMinimum());
    return retval;
}

static PyObject *
AnnotationAttributes_SetZMajorTickMinimum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zMajorTickMinimum in the object.
    obj->data->SetZMajorTickMinimum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZMajorTickMinimum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZMajorTickMinimum());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMajorTickMaximum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMajorTickMaximum in the object.
    obj->data->SetXMajorTickMaximum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMajorTickMaximum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMajorTickMaximum());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMajorTickMaximum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMajorTickMaximum in the object.
    obj->data->SetYMajorTickMaximum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMajorTickMaximum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMajorTickMaximum());
    return retval;
}

static PyObject *
AnnotationAttributes_SetZMajorTickMaximum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zMajorTickMaximum in the object.
    obj->data->SetZMajorTickMaximum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZMajorTickMaximum(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZMajorTickMaximum());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMajorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMajorTickSpacing in the object.
    obj->data->SetXMajorTickSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMajorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMajorTickSpacing());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMajorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMajorTickSpacing in the object.
    obj->data->SetYMajorTickSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMajorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMajorTickSpacing());
    return retval;
}

static PyObject *
AnnotationAttributes_SetZMajorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zMajorTickSpacing in the object.
    obj->data->SetZMajorTickSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZMajorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZMajorTickSpacing());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXMinorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xMinorTickSpacing in the object.
    obj->data->SetXMinorTickSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXMinorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXMinorTickSpacing());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYMinorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yMinorTickSpacing in the object.
    obj->data->SetYMinorTickSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYMinorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYMinorTickSpacing());
    return retval;
}

static PyObject *
AnnotationAttributes_SetZMinorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zMinorTickSpacing in the object.
    obj->data->SetZMinorTickSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZMinorTickSpacing(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZMinorTickSpacing());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXLabelFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xLabelFontHeight in the object.
    obj->data->SetXLabelFontHeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXLabelFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXLabelFontHeight());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYLabelFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yLabelFontHeight in the object.
    obj->data->SetYLabelFontHeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYLabelFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYLabelFontHeight());
    return retval;
}

static PyObject *
AnnotationAttributes_SetZLabelFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zLabelFontHeight in the object.
    obj->data->SetZLabelFontHeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZLabelFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZLabelFontHeight());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXTitleFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the xTitleFontHeight in the object.
    obj->data->SetXTitleFontHeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXTitleFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetXTitleFontHeight());
    return retval;
}

static PyObject *
AnnotationAttributes_SetYTitleFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yTitleFontHeight in the object.
    obj->data->SetYTitleFontHeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYTitleFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYTitleFontHeight());
    return retval;
}

static PyObject *
AnnotationAttributes_SetZTitleFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the zTitleFontHeight in the object.
    obj->data->SetZTitleFontHeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZTitleFontHeight(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetZTitleFontHeight());
    return retval;
}

static PyObject *
AnnotationAttributes_SetXLabelScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xLabelScaling in the object.
    obj->data->SetXLabelScaling(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetXLabelScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXLabelScaling()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetYLabelScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yLabelScaling in the object.
    obj->data->SetYLabelScaling(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetYLabelScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYLabelScaling()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetZLabelScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zLabelScaling in the object.
    obj->data->SetZLabelScaling(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetZLabelScaling(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZLabelScaling()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesTickLocation(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesTickLocation in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetAxesTickLocation(AnnotationAttributes::Location(ival));
    else
    {
        fprintf(stderr, "An invalid axesTickLocation value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Inside, Outside, Both.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesTickLocation(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAxesTickLocation()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetAxesType(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axesType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetAxesType(AnnotationAttributes::Axes(ival));
    else
    {
        fprintf(stderr, "An invalid axesType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "ClosestTriad, FurthestTriad, OutsideEdges, StaticTriad, StaticEdges.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetAxesType(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAxesType()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetTriadFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the triadFlag in the object.
    obj->data->SetTriadFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetTriadFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTriadFlag()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetBboxFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the bboxFlag in the object.
    obj->data->SetBboxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetBboxFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBboxFlag()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetBackgroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the backgroundColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetBackgroundColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetBackgroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the backgroundColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *backgroundColor = obj->data->GetBackgroundColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(backgroundColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(backgroundColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(backgroundColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(backgroundColor[3])));
    return retval;
}

static PyObject *
AnnotationAttributes_SetForegroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the foregroundColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetForegroundColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetForegroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the foregroundColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *foregroundColor = obj->data->GetForegroundColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(foregroundColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(foregroundColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(foregroundColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(foregroundColor[3])));
    return retval;
}

static PyObject *
AnnotationAttributes_SetGradientBackgroundStyle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the gradientBackgroundStyle in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetGradientBackgroundStyle(AnnotationAttributes::GradientStyle(ival));
    else
    {
        fprintf(stderr, "An invalid gradientBackgroundStyle value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "TopToBottom, BottomToTop, LeftToRight, RightToLeft, Radial.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetGradientBackgroundStyle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGradientBackgroundStyle()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetGradientColor1(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the gradientColor1 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetGradientColor1(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetGradientColor1(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the gradientColor1.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *gradientColor1 = obj->data->GetGradientColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(gradientColor1[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(gradientColor1[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(gradientColor1[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(gradientColor1[3])));
    return retval;
}

static PyObject *
AnnotationAttributes_SetGradientColor2(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the gradientColor2 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetGradientColor2(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetGradientColor2(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the gradientColor2.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *gradientColor2 = obj->data->GetGradientColor2().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(gradientColor2[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(gradientColor2[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(gradientColor2[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(gradientColor2[3])));
    return retval;
}

static PyObject *
AnnotationAttributes_SetBackgroundMode(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the backgroundMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetBackgroundMode(AnnotationAttributes::BackgroundMode(ival));
    else
    {
        fprintf(stderr, "An invalid backgroundMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Solid, Gradient.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetBackgroundMode(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBackgroundMode()));
    return retval;
}

static PyObject *
AnnotationAttributes_SetUserInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the userInfoFlag in the object.
    obj->data->SetUserInfoFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetUserInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUserInfoFlag()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetDatabaseInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the databaseInfoFlag in the object.
    obj->data->SetDatabaseInfoFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetDatabaseInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDatabaseInfoFlag()?1L:0L);
    return retval;
}

static PyObject *
AnnotationAttributes_SetLegendInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendInfoFlag in the object.
    obj->data->SetLegendInfoFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
AnnotationAttributes_GetLegendInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendInfoFlag()?1L:0L);
    return retval;
}



static struct PyMethodDef AnnotationAttributes_methods[] = {
    {"Notify", AnnotationAttributes_Notify, METH_VARARGS},
    {"SetAxesFlag2D", AnnotationAttributes_SetAxesFlag2D, METH_VARARGS},
    {"GetAxesFlag2D", AnnotationAttributes_GetAxesFlag2D, METH_VARARGS},
    {"SetAxesAutoSetTicks2D", AnnotationAttributes_SetAxesAutoSetTicks2D, METH_VARARGS},
    {"GetAxesAutoSetTicks2D", AnnotationAttributes_GetAxesAutoSetTicks2D, METH_VARARGS},
    {"SetLabelAutoSetScaling2D", AnnotationAttributes_SetLabelAutoSetScaling2D, METH_VARARGS},
    {"GetLabelAutoSetScaling2D", AnnotationAttributes_GetLabelAutoSetScaling2D, METH_VARARGS},
    {"SetXAxisLabels2D", AnnotationAttributes_SetXAxisLabels2D, METH_VARARGS},
    {"GetXAxisLabels2D", AnnotationAttributes_GetXAxisLabels2D, METH_VARARGS},
    {"SetYAxisLabels2D", AnnotationAttributes_SetYAxisLabels2D, METH_VARARGS},
    {"GetYAxisLabels2D", AnnotationAttributes_GetYAxisLabels2D, METH_VARARGS},
    {"SetXAxisTitle2D", AnnotationAttributes_SetXAxisTitle2D, METH_VARARGS},
    {"GetXAxisTitle2D", AnnotationAttributes_GetXAxisTitle2D, METH_VARARGS},
    {"SetYAxisTitle2D", AnnotationAttributes_SetYAxisTitle2D, METH_VARARGS},
    {"GetYAxisTitle2D", AnnotationAttributes_GetYAxisTitle2D, METH_VARARGS},
    {"SetXGridLines2D", AnnotationAttributes_SetXGridLines2D, METH_VARARGS},
    {"GetXGridLines2D", AnnotationAttributes_GetXGridLines2D, METH_VARARGS},
    {"SetYGridLines2D", AnnotationAttributes_SetYGridLines2D, METH_VARARGS},
    {"GetYGridLines2D", AnnotationAttributes_GetYGridLines2D, METH_VARARGS},
    {"SetXMajorTickMinimum2D", AnnotationAttributes_SetXMajorTickMinimum2D, METH_VARARGS},
    {"GetXMajorTickMinimum2D", AnnotationAttributes_GetXMajorTickMinimum2D, METH_VARARGS},
    {"SetYMajorTickMinimum2D", AnnotationAttributes_SetYMajorTickMinimum2D, METH_VARARGS},
    {"GetYMajorTickMinimum2D", AnnotationAttributes_GetYMajorTickMinimum2D, METH_VARARGS},
    {"SetXMajorTickMaximum2D", AnnotationAttributes_SetXMajorTickMaximum2D, METH_VARARGS},
    {"GetXMajorTickMaximum2D", AnnotationAttributes_GetXMajorTickMaximum2D, METH_VARARGS},
    {"SetYMajorTickMaximum2D", AnnotationAttributes_SetYMajorTickMaximum2D, METH_VARARGS},
    {"GetYMajorTickMaximum2D", AnnotationAttributes_GetYMajorTickMaximum2D, METH_VARARGS},
    {"SetXMajorTickSpacing2D", AnnotationAttributes_SetXMajorTickSpacing2D, METH_VARARGS},
    {"GetXMajorTickSpacing2D", AnnotationAttributes_GetXMajorTickSpacing2D, METH_VARARGS},
    {"SetYMajorTickSpacing2D", AnnotationAttributes_SetYMajorTickSpacing2D, METH_VARARGS},
    {"GetYMajorTickSpacing2D", AnnotationAttributes_GetYMajorTickSpacing2D, METH_VARARGS},
    {"SetXMinorTickSpacing2D", AnnotationAttributes_SetXMinorTickSpacing2D, METH_VARARGS},
    {"GetXMinorTickSpacing2D", AnnotationAttributes_GetXMinorTickSpacing2D, METH_VARARGS},
    {"SetYMinorTickSpacing2D", AnnotationAttributes_SetYMinorTickSpacing2D, METH_VARARGS},
    {"GetYMinorTickSpacing2D", AnnotationAttributes_GetYMinorTickSpacing2D, METH_VARARGS},
    {"SetXLabelFontHeight2D", AnnotationAttributes_SetXLabelFontHeight2D, METH_VARARGS},
    {"GetXLabelFontHeight2D", AnnotationAttributes_GetXLabelFontHeight2D, METH_VARARGS},
    {"SetYLabelFontHeight2D", AnnotationAttributes_SetYLabelFontHeight2D, METH_VARARGS},
    {"GetYLabelFontHeight2D", AnnotationAttributes_GetYLabelFontHeight2D, METH_VARARGS},
    {"SetXTitleFontHeight2D", AnnotationAttributes_SetXTitleFontHeight2D, METH_VARARGS},
    {"GetXTitleFontHeight2D", AnnotationAttributes_GetXTitleFontHeight2D, METH_VARARGS},
    {"SetYTitleFontHeight2D", AnnotationAttributes_SetYTitleFontHeight2D, METH_VARARGS},
    {"GetYTitleFontHeight2D", AnnotationAttributes_GetYTitleFontHeight2D, METH_VARARGS},
    {"SetXLabelScaling2D", AnnotationAttributes_SetXLabelScaling2D, METH_VARARGS},
    {"GetXLabelScaling2D", AnnotationAttributes_GetXLabelScaling2D, METH_VARARGS},
    {"SetYLabelScaling2D", AnnotationAttributes_SetYLabelScaling2D, METH_VARARGS},
    {"GetYLabelScaling2D", AnnotationAttributes_GetYLabelScaling2D, METH_VARARGS},
    {"SetAxesLineWidth2D", AnnotationAttributes_SetAxesLineWidth2D, METH_VARARGS},
    {"GetAxesLineWidth2D", AnnotationAttributes_GetAxesLineWidth2D, METH_VARARGS},
    {"SetAxesTickLocation2D", AnnotationAttributes_SetAxesTickLocation2D, METH_VARARGS},
    {"GetAxesTickLocation2D", AnnotationAttributes_GetAxesTickLocation2D, METH_VARARGS},
    {"SetAxesTicks2D", AnnotationAttributes_SetAxesTicks2D, METH_VARARGS},
    {"GetAxesTicks2D", AnnotationAttributes_GetAxesTicks2D, METH_VARARGS},
    {"SetAxesFlag", AnnotationAttributes_SetAxesFlag, METH_VARARGS},
    {"GetAxesFlag", AnnotationAttributes_GetAxesFlag, METH_VARARGS},
    {"SetAxesAutoSetTicks", AnnotationAttributes_SetAxesAutoSetTicks, METH_VARARGS},
    {"GetAxesAutoSetTicks", AnnotationAttributes_GetAxesAutoSetTicks, METH_VARARGS},
    {"SetLabelAutoSetScaling", AnnotationAttributes_SetLabelAutoSetScaling, METH_VARARGS},
    {"GetLabelAutoSetScaling", AnnotationAttributes_GetLabelAutoSetScaling, METH_VARARGS},
    {"SetXAxisLabels", AnnotationAttributes_SetXAxisLabels, METH_VARARGS},
    {"GetXAxisLabels", AnnotationAttributes_GetXAxisLabels, METH_VARARGS},
    {"SetYAxisLabels", AnnotationAttributes_SetYAxisLabels, METH_VARARGS},
    {"GetYAxisLabels", AnnotationAttributes_GetYAxisLabels, METH_VARARGS},
    {"SetZAxisLabels", AnnotationAttributes_SetZAxisLabels, METH_VARARGS},
    {"GetZAxisLabels", AnnotationAttributes_GetZAxisLabels, METH_VARARGS},
    {"SetXAxisTitle", AnnotationAttributes_SetXAxisTitle, METH_VARARGS},
    {"GetXAxisTitle", AnnotationAttributes_GetXAxisTitle, METH_VARARGS},
    {"SetYAxisTitle", AnnotationAttributes_SetYAxisTitle, METH_VARARGS},
    {"GetYAxisTitle", AnnotationAttributes_GetYAxisTitle, METH_VARARGS},
    {"SetZAxisTitle", AnnotationAttributes_SetZAxisTitle, METH_VARARGS},
    {"GetZAxisTitle", AnnotationAttributes_GetZAxisTitle, METH_VARARGS},
    {"SetXGridLines", AnnotationAttributes_SetXGridLines, METH_VARARGS},
    {"GetXGridLines", AnnotationAttributes_GetXGridLines, METH_VARARGS},
    {"SetYGridLines", AnnotationAttributes_SetYGridLines, METH_VARARGS},
    {"GetYGridLines", AnnotationAttributes_GetYGridLines, METH_VARARGS},
    {"SetZGridLines", AnnotationAttributes_SetZGridLines, METH_VARARGS},
    {"GetZGridLines", AnnotationAttributes_GetZGridLines, METH_VARARGS},
    {"SetXAxisTicks", AnnotationAttributes_SetXAxisTicks, METH_VARARGS},
    {"GetXAxisTicks", AnnotationAttributes_GetXAxisTicks, METH_VARARGS},
    {"SetYAxisTicks", AnnotationAttributes_SetYAxisTicks, METH_VARARGS},
    {"GetYAxisTicks", AnnotationAttributes_GetYAxisTicks, METH_VARARGS},
    {"SetZAxisTicks", AnnotationAttributes_SetZAxisTicks, METH_VARARGS},
    {"GetZAxisTicks", AnnotationAttributes_GetZAxisTicks, METH_VARARGS},
    {"SetXMajorTickMinimum", AnnotationAttributes_SetXMajorTickMinimum, METH_VARARGS},
    {"GetXMajorTickMinimum", AnnotationAttributes_GetXMajorTickMinimum, METH_VARARGS},
    {"SetYMajorTickMinimum", AnnotationAttributes_SetYMajorTickMinimum, METH_VARARGS},
    {"GetYMajorTickMinimum", AnnotationAttributes_GetYMajorTickMinimum, METH_VARARGS},
    {"SetZMajorTickMinimum", AnnotationAttributes_SetZMajorTickMinimum, METH_VARARGS},
    {"GetZMajorTickMinimum", AnnotationAttributes_GetZMajorTickMinimum, METH_VARARGS},
    {"SetXMajorTickMaximum", AnnotationAttributes_SetXMajorTickMaximum, METH_VARARGS},
    {"GetXMajorTickMaximum", AnnotationAttributes_GetXMajorTickMaximum, METH_VARARGS},
    {"SetYMajorTickMaximum", AnnotationAttributes_SetYMajorTickMaximum, METH_VARARGS},
    {"GetYMajorTickMaximum", AnnotationAttributes_GetYMajorTickMaximum, METH_VARARGS},
    {"SetZMajorTickMaximum", AnnotationAttributes_SetZMajorTickMaximum, METH_VARARGS},
    {"GetZMajorTickMaximum", AnnotationAttributes_GetZMajorTickMaximum, METH_VARARGS},
    {"SetXMajorTickSpacing", AnnotationAttributes_SetXMajorTickSpacing, METH_VARARGS},
    {"GetXMajorTickSpacing", AnnotationAttributes_GetXMajorTickSpacing, METH_VARARGS},
    {"SetYMajorTickSpacing", AnnotationAttributes_SetYMajorTickSpacing, METH_VARARGS},
    {"GetYMajorTickSpacing", AnnotationAttributes_GetYMajorTickSpacing, METH_VARARGS},
    {"SetZMajorTickSpacing", AnnotationAttributes_SetZMajorTickSpacing, METH_VARARGS},
    {"GetZMajorTickSpacing", AnnotationAttributes_GetZMajorTickSpacing, METH_VARARGS},
    {"SetXMinorTickSpacing", AnnotationAttributes_SetXMinorTickSpacing, METH_VARARGS},
    {"GetXMinorTickSpacing", AnnotationAttributes_GetXMinorTickSpacing, METH_VARARGS},
    {"SetYMinorTickSpacing", AnnotationAttributes_SetYMinorTickSpacing, METH_VARARGS},
    {"GetYMinorTickSpacing", AnnotationAttributes_GetYMinorTickSpacing, METH_VARARGS},
    {"SetZMinorTickSpacing", AnnotationAttributes_SetZMinorTickSpacing, METH_VARARGS},
    {"GetZMinorTickSpacing", AnnotationAttributes_GetZMinorTickSpacing, METH_VARARGS},
    {"SetXLabelFontHeight", AnnotationAttributes_SetXLabelFontHeight, METH_VARARGS},
    {"GetXLabelFontHeight", AnnotationAttributes_GetXLabelFontHeight, METH_VARARGS},
    {"SetYLabelFontHeight", AnnotationAttributes_SetYLabelFontHeight, METH_VARARGS},
    {"GetYLabelFontHeight", AnnotationAttributes_GetYLabelFontHeight, METH_VARARGS},
    {"SetZLabelFontHeight", AnnotationAttributes_SetZLabelFontHeight, METH_VARARGS},
    {"GetZLabelFontHeight", AnnotationAttributes_GetZLabelFontHeight, METH_VARARGS},
    {"SetXTitleFontHeight", AnnotationAttributes_SetXTitleFontHeight, METH_VARARGS},
    {"GetXTitleFontHeight", AnnotationAttributes_GetXTitleFontHeight, METH_VARARGS},
    {"SetYTitleFontHeight", AnnotationAttributes_SetYTitleFontHeight, METH_VARARGS},
    {"GetYTitleFontHeight", AnnotationAttributes_GetYTitleFontHeight, METH_VARARGS},
    {"SetZTitleFontHeight", AnnotationAttributes_SetZTitleFontHeight, METH_VARARGS},
    {"GetZTitleFontHeight", AnnotationAttributes_GetZTitleFontHeight, METH_VARARGS},
    {"SetXLabelScaling", AnnotationAttributes_SetXLabelScaling, METH_VARARGS},
    {"GetXLabelScaling", AnnotationAttributes_GetXLabelScaling, METH_VARARGS},
    {"SetYLabelScaling", AnnotationAttributes_SetYLabelScaling, METH_VARARGS},
    {"GetYLabelScaling", AnnotationAttributes_GetYLabelScaling, METH_VARARGS},
    {"SetZLabelScaling", AnnotationAttributes_SetZLabelScaling, METH_VARARGS},
    {"GetZLabelScaling", AnnotationAttributes_GetZLabelScaling, METH_VARARGS},
    {"SetAxesTickLocation", AnnotationAttributes_SetAxesTickLocation, METH_VARARGS},
    {"GetAxesTickLocation", AnnotationAttributes_GetAxesTickLocation, METH_VARARGS},
    {"SetAxesType", AnnotationAttributes_SetAxesType, METH_VARARGS},
    {"GetAxesType", AnnotationAttributes_GetAxesType, METH_VARARGS},
    {"SetTriadFlag", AnnotationAttributes_SetTriadFlag, METH_VARARGS},
    {"GetTriadFlag", AnnotationAttributes_GetTriadFlag, METH_VARARGS},
    {"SetBboxFlag", AnnotationAttributes_SetBboxFlag, METH_VARARGS},
    {"GetBboxFlag", AnnotationAttributes_GetBboxFlag, METH_VARARGS},
    {"SetBackgroundColor", AnnotationAttributes_SetBackgroundColor, METH_VARARGS},
    {"GetBackgroundColor", AnnotationAttributes_GetBackgroundColor, METH_VARARGS},
    {"SetForegroundColor", AnnotationAttributes_SetForegroundColor, METH_VARARGS},
    {"GetForegroundColor", AnnotationAttributes_GetForegroundColor, METH_VARARGS},
    {"SetGradientBackgroundStyle", AnnotationAttributes_SetGradientBackgroundStyle, METH_VARARGS},
    {"GetGradientBackgroundStyle", AnnotationAttributes_GetGradientBackgroundStyle, METH_VARARGS},
    {"SetGradientColor1", AnnotationAttributes_SetGradientColor1, METH_VARARGS},
    {"GetGradientColor1", AnnotationAttributes_GetGradientColor1, METH_VARARGS},
    {"SetGradientColor2", AnnotationAttributes_SetGradientColor2, METH_VARARGS},
    {"GetGradientColor2", AnnotationAttributes_GetGradientColor2, METH_VARARGS},
    {"SetBackgroundMode", AnnotationAttributes_SetBackgroundMode, METH_VARARGS},
    {"GetBackgroundMode", AnnotationAttributes_GetBackgroundMode, METH_VARARGS},
    {"SetUserInfoFlag", AnnotationAttributes_SetUserInfoFlag, METH_VARARGS},
    {"GetUserInfoFlag", AnnotationAttributes_GetUserInfoFlag, METH_VARARGS},
    {"SetDatabaseInfoFlag", AnnotationAttributes_SetDatabaseInfoFlag, METH_VARARGS},
    {"GetDatabaseInfoFlag", AnnotationAttributes_GetDatabaseInfoFlag, METH_VARARGS},
    {"SetLegendInfoFlag", AnnotationAttributes_SetLegendInfoFlag, METH_VARARGS},
    {"GetLegendInfoFlag", AnnotationAttributes_GetLegendInfoFlag, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AnnotationAttributes_dealloc(PyObject *v)
{
   AnnotationAttributesObject *obj = (AnnotationAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
AnnotationAttributes_compare(PyObject *v, PyObject *w)
{
    AnnotationAttributes *a = ((AnnotationAttributesObject *)v)->data;
    AnnotationAttributes *b = ((AnnotationAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
AnnotationAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "axesFlag2D") == 0)
        return AnnotationAttributes_GetAxesFlag2D(self, NULL);
    if(strcmp(name, "axesAutoSetTicks2D") == 0)
        return AnnotationAttributes_GetAxesAutoSetTicks2D(self, NULL);
    if(strcmp(name, "labelAutoSetScaling2D") == 0)
        return AnnotationAttributes_GetLabelAutoSetScaling2D(self, NULL);
    if(strcmp(name, "xAxisLabels2D") == 0)
        return AnnotationAttributes_GetXAxisLabels2D(self, NULL);
    if(strcmp(name, "yAxisLabels2D") == 0)
        return AnnotationAttributes_GetYAxisLabels2D(self, NULL);
    if(strcmp(name, "xAxisTitle2D") == 0)
        return AnnotationAttributes_GetXAxisTitle2D(self, NULL);
    if(strcmp(name, "yAxisTitle2D") == 0)
        return AnnotationAttributes_GetYAxisTitle2D(self, NULL);
    if(strcmp(name, "xGridLines2D") == 0)
        return AnnotationAttributes_GetXGridLines2D(self, NULL);
    if(strcmp(name, "yGridLines2D") == 0)
        return AnnotationAttributes_GetYGridLines2D(self, NULL);
    if(strcmp(name, "xMajorTickMinimum2D") == 0)
        return AnnotationAttributes_GetXMajorTickMinimum2D(self, NULL);
    if(strcmp(name, "yMajorTickMinimum2D") == 0)
        return AnnotationAttributes_GetYMajorTickMinimum2D(self, NULL);
    if(strcmp(name, "xMajorTickMaximum2D") == 0)
        return AnnotationAttributes_GetXMajorTickMaximum2D(self, NULL);
    if(strcmp(name, "yMajorTickMaximum2D") == 0)
        return AnnotationAttributes_GetYMajorTickMaximum2D(self, NULL);
    if(strcmp(name, "xMajorTickSpacing2D") == 0)
        return AnnotationAttributes_GetXMajorTickSpacing2D(self, NULL);
    if(strcmp(name, "yMajorTickSpacing2D") == 0)
        return AnnotationAttributes_GetYMajorTickSpacing2D(self, NULL);
    if(strcmp(name, "xMinorTickSpacing2D") == 0)
        return AnnotationAttributes_GetXMinorTickSpacing2D(self, NULL);
    if(strcmp(name, "yMinorTickSpacing2D") == 0)
        return AnnotationAttributes_GetYMinorTickSpacing2D(self, NULL);
    if(strcmp(name, "xLabelFontHeight2D") == 0)
        return AnnotationAttributes_GetXLabelFontHeight2D(self, NULL);
    if(strcmp(name, "yLabelFontHeight2D") == 0)
        return AnnotationAttributes_GetYLabelFontHeight2D(self, NULL);
    if(strcmp(name, "xTitleFontHeight2D") == 0)
        return AnnotationAttributes_GetXTitleFontHeight2D(self, NULL);
    if(strcmp(name, "yTitleFontHeight2D") == 0)
        return AnnotationAttributes_GetYTitleFontHeight2D(self, NULL);
    if(strcmp(name, "xLabelScaling2D") == 0)
        return AnnotationAttributes_GetXLabelScaling2D(self, NULL);
    if(strcmp(name, "yLabelScaling2D") == 0)
        return AnnotationAttributes_GetYLabelScaling2D(self, NULL);
    if(strcmp(name, "axesLineWidth2D") == 0)
        return AnnotationAttributes_GetAxesLineWidth2D(self, NULL);
    if(strcmp(name, "axesTickLocation2D") == 0)
        return AnnotationAttributes_GetAxesTickLocation2D(self, NULL);
    if(strcmp(name, "Inside") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Inside));
    else if(strcmp(name, "Outside") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Outside));
    else if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Both));

    if(strcmp(name, "axesTicks2D") == 0)
        return AnnotationAttributes_GetAxesTicks2D(self, NULL);
    if(strcmp(name, "Off") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Off));
    else if(strcmp(name, "Bottom") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Bottom));
    else if(strcmp(name, "Left") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Left));
    else if(strcmp(name, "BottomLeft") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::BottomLeft));
    else if(strcmp(name, "All") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::All));

    if(strcmp(name, "axesFlag") == 0)
        return AnnotationAttributes_GetAxesFlag(self, NULL);
    if(strcmp(name, "axesAutoSetTicks") == 0)
        return AnnotationAttributes_GetAxesAutoSetTicks(self, NULL);
    if(strcmp(name, "labelAutoSetScaling") == 0)
        return AnnotationAttributes_GetLabelAutoSetScaling(self, NULL);
    if(strcmp(name, "xAxisLabels") == 0)
        return AnnotationAttributes_GetXAxisLabels(self, NULL);
    if(strcmp(name, "yAxisLabels") == 0)
        return AnnotationAttributes_GetYAxisLabels(self, NULL);
    if(strcmp(name, "zAxisLabels") == 0)
        return AnnotationAttributes_GetZAxisLabels(self, NULL);
    if(strcmp(name, "xAxisTitle") == 0)
        return AnnotationAttributes_GetXAxisTitle(self, NULL);
    if(strcmp(name, "yAxisTitle") == 0)
        return AnnotationAttributes_GetYAxisTitle(self, NULL);
    if(strcmp(name, "zAxisTitle") == 0)
        return AnnotationAttributes_GetZAxisTitle(self, NULL);
    if(strcmp(name, "xGridLines") == 0)
        return AnnotationAttributes_GetXGridLines(self, NULL);
    if(strcmp(name, "yGridLines") == 0)
        return AnnotationAttributes_GetYGridLines(self, NULL);
    if(strcmp(name, "zGridLines") == 0)
        return AnnotationAttributes_GetZGridLines(self, NULL);
    if(strcmp(name, "xAxisTicks") == 0)
        return AnnotationAttributes_GetXAxisTicks(self, NULL);
    if(strcmp(name, "yAxisTicks") == 0)
        return AnnotationAttributes_GetYAxisTicks(self, NULL);
    if(strcmp(name, "zAxisTicks") == 0)
        return AnnotationAttributes_GetZAxisTicks(self, NULL);
    if(strcmp(name, "xMajorTickMinimum") == 0)
        return AnnotationAttributes_GetXMajorTickMinimum(self, NULL);
    if(strcmp(name, "yMajorTickMinimum") == 0)
        return AnnotationAttributes_GetYMajorTickMinimum(self, NULL);
    if(strcmp(name, "zMajorTickMinimum") == 0)
        return AnnotationAttributes_GetZMajorTickMinimum(self, NULL);
    if(strcmp(name, "xMajorTickMaximum") == 0)
        return AnnotationAttributes_GetXMajorTickMaximum(self, NULL);
    if(strcmp(name, "yMajorTickMaximum") == 0)
        return AnnotationAttributes_GetYMajorTickMaximum(self, NULL);
    if(strcmp(name, "zMajorTickMaximum") == 0)
        return AnnotationAttributes_GetZMajorTickMaximum(self, NULL);
    if(strcmp(name, "xMajorTickSpacing") == 0)
        return AnnotationAttributes_GetXMajorTickSpacing(self, NULL);
    if(strcmp(name, "yMajorTickSpacing") == 0)
        return AnnotationAttributes_GetYMajorTickSpacing(self, NULL);
    if(strcmp(name, "zMajorTickSpacing") == 0)
        return AnnotationAttributes_GetZMajorTickSpacing(self, NULL);
    if(strcmp(name, "xMinorTickSpacing") == 0)
        return AnnotationAttributes_GetXMinorTickSpacing(self, NULL);
    if(strcmp(name, "yMinorTickSpacing") == 0)
        return AnnotationAttributes_GetYMinorTickSpacing(self, NULL);
    if(strcmp(name, "zMinorTickSpacing") == 0)
        return AnnotationAttributes_GetZMinorTickSpacing(self, NULL);
    if(strcmp(name, "xLabelFontHeight") == 0)
        return AnnotationAttributes_GetXLabelFontHeight(self, NULL);
    if(strcmp(name, "yLabelFontHeight") == 0)
        return AnnotationAttributes_GetYLabelFontHeight(self, NULL);
    if(strcmp(name, "zLabelFontHeight") == 0)
        return AnnotationAttributes_GetZLabelFontHeight(self, NULL);
    if(strcmp(name, "xTitleFontHeight") == 0)
        return AnnotationAttributes_GetXTitleFontHeight(self, NULL);
    if(strcmp(name, "yTitleFontHeight") == 0)
        return AnnotationAttributes_GetYTitleFontHeight(self, NULL);
    if(strcmp(name, "zTitleFontHeight") == 0)
        return AnnotationAttributes_GetZTitleFontHeight(self, NULL);
    if(strcmp(name, "xLabelScaling") == 0)
        return AnnotationAttributes_GetXLabelScaling(self, NULL);
    if(strcmp(name, "yLabelScaling") == 0)
        return AnnotationAttributes_GetYLabelScaling(self, NULL);
    if(strcmp(name, "zLabelScaling") == 0)
        return AnnotationAttributes_GetZLabelScaling(self, NULL);
    if(strcmp(name, "axesTickLocation") == 0)
        return AnnotationAttributes_GetAxesTickLocation(self, NULL);
    if(strcmp(name, "Inside") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Inside));
    else if(strcmp(name, "Outside") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Outside));
    else if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Both));

    if(strcmp(name, "axesType") == 0)
        return AnnotationAttributes_GetAxesType(self, NULL);
    if(strcmp(name, "ClosestTriad") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::ClosestTriad));
    else if(strcmp(name, "FurthestTriad") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::FurthestTriad));
    else if(strcmp(name, "OutsideEdges") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::OutsideEdges));
    else if(strcmp(name, "StaticTriad") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::StaticTriad));
    else if(strcmp(name, "StaticEdges") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::StaticEdges));

    if(strcmp(name, "triadFlag") == 0)
        return AnnotationAttributes_GetTriadFlag(self, NULL);
    if(strcmp(name, "bboxFlag") == 0)
        return AnnotationAttributes_GetBboxFlag(self, NULL);
    if(strcmp(name, "backgroundColor") == 0)
        return AnnotationAttributes_GetBackgroundColor(self, NULL);
    if(strcmp(name, "foregroundColor") == 0)
        return AnnotationAttributes_GetForegroundColor(self, NULL);
    if(strcmp(name, "gradientBackgroundStyle") == 0)
        return AnnotationAttributes_GetGradientBackgroundStyle(self, NULL);
    if(strcmp(name, "TopToBottom") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::TopToBottom));
    else if(strcmp(name, "BottomToTop") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::BottomToTop));
    else if(strcmp(name, "LeftToRight") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::LeftToRight));
    else if(strcmp(name, "RightToLeft") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::RightToLeft));
    else if(strcmp(name, "Radial") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Radial));

    if(strcmp(name, "gradientColor1") == 0)
        return AnnotationAttributes_GetGradientColor1(self, NULL);
    if(strcmp(name, "gradientColor2") == 0)
        return AnnotationAttributes_GetGradientColor2(self, NULL);
    if(strcmp(name, "backgroundMode") == 0)
        return AnnotationAttributes_GetBackgroundMode(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Solid));
    else if(strcmp(name, "Gradient") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Gradient));

    if(strcmp(name, "userInfoFlag") == 0)
        return AnnotationAttributes_GetUserInfoFlag(self, NULL);
    if(strcmp(name, "databaseInfoFlag") == 0)
        return AnnotationAttributes_GetDatabaseInfoFlag(self, NULL);
    if(strcmp(name, "legendInfoFlag") == 0)
        return AnnotationAttributes_GetLegendInfoFlag(self, NULL);

    return Py_FindMethod(AnnotationAttributes_methods, self, name);
}

static int
AnnotationAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "axesFlag2D") == 0)
        retval = (AnnotationAttributes_SetAxesFlag2D(self, tuple) != NULL);
    else if(strcmp(name, "axesAutoSetTicks2D") == 0)
        retval = (AnnotationAttributes_SetAxesAutoSetTicks2D(self, tuple) != NULL);
    else if(strcmp(name, "labelAutoSetScaling2D") == 0)
        retval = (AnnotationAttributes_SetLabelAutoSetScaling2D(self, tuple) != NULL);
    else if(strcmp(name, "xAxisLabels2D") == 0)
        retval = (AnnotationAttributes_SetXAxisLabels2D(self, tuple) != NULL);
    else if(strcmp(name, "yAxisLabels2D") == 0)
        retval = (AnnotationAttributes_SetYAxisLabels2D(self, tuple) != NULL);
    else if(strcmp(name, "xAxisTitle2D") == 0)
        retval = (AnnotationAttributes_SetXAxisTitle2D(self, tuple) != NULL);
    else if(strcmp(name, "yAxisTitle2D") == 0)
        retval = (AnnotationAttributes_SetYAxisTitle2D(self, tuple) != NULL);
    else if(strcmp(name, "xGridLines2D") == 0)
        retval = (AnnotationAttributes_SetXGridLines2D(self, tuple) != NULL);
    else if(strcmp(name, "yGridLines2D") == 0)
        retval = (AnnotationAttributes_SetYGridLines2D(self, tuple) != NULL);
    else if(strcmp(name, "xMajorTickMinimum2D") == 0)
        retval = (AnnotationAttributes_SetXMajorTickMinimum2D(self, tuple) != NULL);
    else if(strcmp(name, "yMajorTickMinimum2D") == 0)
        retval = (AnnotationAttributes_SetYMajorTickMinimum2D(self, tuple) != NULL);
    else if(strcmp(name, "xMajorTickMaximum2D") == 0)
        retval = (AnnotationAttributes_SetXMajorTickMaximum2D(self, tuple) != NULL);
    else if(strcmp(name, "yMajorTickMaximum2D") == 0)
        retval = (AnnotationAttributes_SetYMajorTickMaximum2D(self, tuple) != NULL);
    else if(strcmp(name, "xMajorTickSpacing2D") == 0)
        retval = (AnnotationAttributes_SetXMajorTickSpacing2D(self, tuple) != NULL);
    else if(strcmp(name, "yMajorTickSpacing2D") == 0)
        retval = (AnnotationAttributes_SetYMajorTickSpacing2D(self, tuple) != NULL);
    else if(strcmp(name, "xMinorTickSpacing2D") == 0)
        retval = (AnnotationAttributes_SetXMinorTickSpacing2D(self, tuple) != NULL);
    else if(strcmp(name, "yMinorTickSpacing2D") == 0)
        retval = (AnnotationAttributes_SetYMinorTickSpacing2D(self, tuple) != NULL);
    else if(strcmp(name, "xLabelFontHeight2D") == 0)
        retval = (AnnotationAttributes_SetXLabelFontHeight2D(self, tuple) != NULL);
    else if(strcmp(name, "yLabelFontHeight2D") == 0)
        retval = (AnnotationAttributes_SetYLabelFontHeight2D(self, tuple) != NULL);
    else if(strcmp(name, "xTitleFontHeight2D") == 0)
        retval = (AnnotationAttributes_SetXTitleFontHeight2D(self, tuple) != NULL);
    else if(strcmp(name, "yTitleFontHeight2D") == 0)
        retval = (AnnotationAttributes_SetYTitleFontHeight2D(self, tuple) != NULL);
    else if(strcmp(name, "xLabelScaling2D") == 0)
        retval = (AnnotationAttributes_SetXLabelScaling2D(self, tuple) != NULL);
    else if(strcmp(name, "yLabelScaling2D") == 0)
        retval = (AnnotationAttributes_SetYLabelScaling2D(self, tuple) != NULL);
    else if(strcmp(name, "axesLineWidth2D") == 0)
        retval = (AnnotationAttributes_SetAxesLineWidth2D(self, tuple) != NULL);
    else if(strcmp(name, "axesTickLocation2D") == 0)
        retval = (AnnotationAttributes_SetAxesTickLocation2D(self, tuple) != NULL);
    else if(strcmp(name, "axesTicks2D") == 0)
        retval = (AnnotationAttributes_SetAxesTicks2D(self, tuple) != NULL);
    else if(strcmp(name, "axesFlag") == 0)
        retval = (AnnotationAttributes_SetAxesFlag(self, tuple) != NULL);
    else if(strcmp(name, "axesAutoSetTicks") == 0)
        retval = (AnnotationAttributes_SetAxesAutoSetTicks(self, tuple) != NULL);
    else if(strcmp(name, "labelAutoSetScaling") == 0)
        retval = (AnnotationAttributes_SetLabelAutoSetScaling(self, tuple) != NULL);
    else if(strcmp(name, "xAxisLabels") == 0)
        retval = (AnnotationAttributes_SetXAxisLabels(self, tuple) != NULL);
    else if(strcmp(name, "yAxisLabels") == 0)
        retval = (AnnotationAttributes_SetYAxisLabels(self, tuple) != NULL);
    else if(strcmp(name, "zAxisLabels") == 0)
        retval = (AnnotationAttributes_SetZAxisLabels(self, tuple) != NULL);
    else if(strcmp(name, "xAxisTitle") == 0)
        retval = (AnnotationAttributes_SetXAxisTitle(self, tuple) != NULL);
    else if(strcmp(name, "yAxisTitle") == 0)
        retval = (AnnotationAttributes_SetYAxisTitle(self, tuple) != NULL);
    else if(strcmp(name, "zAxisTitle") == 0)
        retval = (AnnotationAttributes_SetZAxisTitle(self, tuple) != NULL);
    else if(strcmp(name, "xGridLines") == 0)
        retval = (AnnotationAttributes_SetXGridLines(self, tuple) != NULL);
    else if(strcmp(name, "yGridLines") == 0)
        retval = (AnnotationAttributes_SetYGridLines(self, tuple) != NULL);
    else if(strcmp(name, "zGridLines") == 0)
        retval = (AnnotationAttributes_SetZGridLines(self, tuple) != NULL);
    else if(strcmp(name, "xAxisTicks") == 0)
        retval = (AnnotationAttributes_SetXAxisTicks(self, tuple) != NULL);
    else if(strcmp(name, "yAxisTicks") == 0)
        retval = (AnnotationAttributes_SetYAxisTicks(self, tuple) != NULL);
    else if(strcmp(name, "zAxisTicks") == 0)
        retval = (AnnotationAttributes_SetZAxisTicks(self, tuple) != NULL);
    else if(strcmp(name, "xMajorTickMinimum") == 0)
        retval = (AnnotationAttributes_SetXMajorTickMinimum(self, tuple) != NULL);
    else if(strcmp(name, "yMajorTickMinimum") == 0)
        retval = (AnnotationAttributes_SetYMajorTickMinimum(self, tuple) != NULL);
    else if(strcmp(name, "zMajorTickMinimum") == 0)
        retval = (AnnotationAttributes_SetZMajorTickMinimum(self, tuple) != NULL);
    else if(strcmp(name, "xMajorTickMaximum") == 0)
        retval = (AnnotationAttributes_SetXMajorTickMaximum(self, tuple) != NULL);
    else if(strcmp(name, "yMajorTickMaximum") == 0)
        retval = (AnnotationAttributes_SetYMajorTickMaximum(self, tuple) != NULL);
    else if(strcmp(name, "zMajorTickMaximum") == 0)
        retval = (AnnotationAttributes_SetZMajorTickMaximum(self, tuple) != NULL);
    else if(strcmp(name, "xMajorTickSpacing") == 0)
        retval = (AnnotationAttributes_SetXMajorTickSpacing(self, tuple) != NULL);
    else if(strcmp(name, "yMajorTickSpacing") == 0)
        retval = (AnnotationAttributes_SetYMajorTickSpacing(self, tuple) != NULL);
    else if(strcmp(name, "zMajorTickSpacing") == 0)
        retval = (AnnotationAttributes_SetZMajorTickSpacing(self, tuple) != NULL);
    else if(strcmp(name, "xMinorTickSpacing") == 0)
        retval = (AnnotationAttributes_SetXMinorTickSpacing(self, tuple) != NULL);
    else if(strcmp(name, "yMinorTickSpacing") == 0)
        retval = (AnnotationAttributes_SetYMinorTickSpacing(self, tuple) != NULL);
    else if(strcmp(name, "zMinorTickSpacing") == 0)
        retval = (AnnotationAttributes_SetZMinorTickSpacing(self, tuple) != NULL);
    else if(strcmp(name, "xLabelFontHeight") == 0)
        retval = (AnnotationAttributes_SetXLabelFontHeight(self, tuple) != NULL);
    else if(strcmp(name, "yLabelFontHeight") == 0)
        retval = (AnnotationAttributes_SetYLabelFontHeight(self, tuple) != NULL);
    else if(strcmp(name, "zLabelFontHeight") == 0)
        retval = (AnnotationAttributes_SetZLabelFontHeight(self, tuple) != NULL);
    else if(strcmp(name, "xTitleFontHeight") == 0)
        retval = (AnnotationAttributes_SetXTitleFontHeight(self, tuple) != NULL);
    else if(strcmp(name, "yTitleFontHeight") == 0)
        retval = (AnnotationAttributes_SetYTitleFontHeight(self, tuple) != NULL);
    else if(strcmp(name, "zTitleFontHeight") == 0)
        retval = (AnnotationAttributes_SetZTitleFontHeight(self, tuple) != NULL);
    else if(strcmp(name, "xLabelScaling") == 0)
        retval = (AnnotationAttributes_SetXLabelScaling(self, tuple) != NULL);
    else if(strcmp(name, "yLabelScaling") == 0)
        retval = (AnnotationAttributes_SetYLabelScaling(self, tuple) != NULL);
    else if(strcmp(name, "zLabelScaling") == 0)
        retval = (AnnotationAttributes_SetZLabelScaling(self, tuple) != NULL);
    else if(strcmp(name, "axesTickLocation") == 0)
        retval = (AnnotationAttributes_SetAxesTickLocation(self, tuple) != NULL);
    else if(strcmp(name, "axesType") == 0)
        retval = (AnnotationAttributes_SetAxesType(self, tuple) != NULL);
    else if(strcmp(name, "triadFlag") == 0)
        retval = (AnnotationAttributes_SetTriadFlag(self, tuple) != NULL);
    else if(strcmp(name, "bboxFlag") == 0)
        retval = (AnnotationAttributes_SetBboxFlag(self, tuple) != NULL);
    else if(strcmp(name, "backgroundColor") == 0)
        retval = (AnnotationAttributes_SetBackgroundColor(self, tuple) != NULL);
    else if(strcmp(name, "foregroundColor") == 0)
        retval = (AnnotationAttributes_SetForegroundColor(self, tuple) != NULL);
    else if(strcmp(name, "gradientBackgroundStyle") == 0)
        retval = (AnnotationAttributes_SetGradientBackgroundStyle(self, tuple) != NULL);
    else if(strcmp(name, "gradientColor1") == 0)
        retval = (AnnotationAttributes_SetGradientColor1(self, tuple) != NULL);
    else if(strcmp(name, "gradientColor2") == 0)
        retval = (AnnotationAttributes_SetGradientColor2(self, tuple) != NULL);
    else if(strcmp(name, "backgroundMode") == 0)
        retval = (AnnotationAttributes_SetBackgroundMode(self, tuple) != NULL);
    else if(strcmp(name, "userInfoFlag") == 0)
        retval = (AnnotationAttributes_SetUserInfoFlag(self, tuple) != NULL);
    else if(strcmp(name, "databaseInfoFlag") == 0)
        retval = (AnnotationAttributes_SetDatabaseInfoFlag(self, tuple) != NULL);
    else if(strcmp(name, "legendInfoFlag") == 0)
        retval = (AnnotationAttributes_SetLegendInfoFlag(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
AnnotationAttributes_print(PyObject *v, FILE *fp, int flags)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)v;

    if(obj->data->GetAxesFlag2D())
        fprintf(fp, "axesFlag2D = 1\n");
    else
        fprintf(fp, "axesFlag2D = 0\n");
    if(obj->data->GetAxesAutoSetTicks2D())
        fprintf(fp, "axesAutoSetTicks2D = 1\n");
    else
        fprintf(fp, "axesAutoSetTicks2D = 0\n");
    if(obj->data->GetLabelAutoSetScaling2D())
        fprintf(fp, "labelAutoSetScaling2D = 1\n");
    else
        fprintf(fp, "labelAutoSetScaling2D = 0\n");
    if(obj->data->GetXAxisLabels2D())
        fprintf(fp, "xAxisLabels2D = 1\n");
    else
        fprintf(fp, "xAxisLabels2D = 0\n");
    if(obj->data->GetYAxisLabels2D())
        fprintf(fp, "yAxisLabels2D = 1\n");
    else
        fprintf(fp, "yAxisLabels2D = 0\n");
    if(obj->data->GetXAxisTitle2D())
        fprintf(fp, "xAxisTitle2D = 1\n");
    else
        fprintf(fp, "xAxisTitle2D = 0\n");
    if(obj->data->GetYAxisTitle2D())
        fprintf(fp, "yAxisTitle2D = 1\n");
    else
        fprintf(fp, "yAxisTitle2D = 0\n");
    if(obj->data->GetXGridLines2D())
        fprintf(fp, "xGridLines2D = 1\n");
    else
        fprintf(fp, "xGridLines2D = 0\n");
    if(obj->data->GetYGridLines2D())
        fprintf(fp, "yGridLines2D = 1\n");
    else
        fprintf(fp, "yGridLines2D = 0\n");
    fprintf(fp, "xMajorTickMinimum2D = %g\n", obj->data->GetXMajorTickMinimum2D());
    fprintf(fp, "yMajorTickMinimum2D = %g\n", obj->data->GetYMajorTickMinimum2D());
    fprintf(fp, "xMajorTickMaximum2D = %g\n", obj->data->GetXMajorTickMaximum2D());
    fprintf(fp, "yMajorTickMaximum2D = %g\n", obj->data->GetYMajorTickMaximum2D());
    fprintf(fp, "xMajorTickSpacing2D = %g\n", obj->data->GetXMajorTickSpacing2D());
    fprintf(fp, "yMajorTickSpacing2D = %g\n", obj->data->GetYMajorTickSpacing2D());
    fprintf(fp, "xMinorTickSpacing2D = %g\n", obj->data->GetXMinorTickSpacing2D());
    fprintf(fp, "yMinorTickSpacing2D = %g\n", obj->data->GetYMinorTickSpacing2D());
    fprintf(fp, "xLabelFontHeight2D = %g\n", obj->data->GetXLabelFontHeight2D());
    fprintf(fp, "yLabelFontHeight2D = %g\n", obj->data->GetYLabelFontHeight2D());
    fprintf(fp, "xTitleFontHeight2D = %g\n", obj->data->GetXTitleFontHeight2D());
    fprintf(fp, "yTitleFontHeight2D = %g\n", obj->data->GetYTitleFontHeight2D());
    fprintf(fp, "xLabelScaling2D = %d\n", obj->data->GetXLabelScaling2D());
    fprintf(fp, "yLabelScaling2D = %d\n", obj->data->GetYLabelScaling2D());
    fprintf(fp, "axesLineWidth2D = %d\n", obj->data->GetAxesLineWidth2D());
    const char *axesTickLocation2D_names = "Inside, Outside, Both";
    if(obj->data->GetAxesTickLocation2D() == AnnotationAttributes::Inside)
        fprintf(fp, "axesTickLocation2D = Inside  # %s\n", axesTickLocation2D_names);
    else if(obj->data->GetAxesTickLocation2D() == AnnotationAttributes::Outside)
        fprintf(fp, "axesTickLocation2D = Outside  # %s\n", axesTickLocation2D_names);
    else
        fprintf(fp, "axesTickLocation2D = Both  # %s\n", axesTickLocation2D_names);

    const char *axesTicks2D_names = "Off, Bottom, Left, BottomLeft, All";
    if(obj->data->GetAxesTicks2D() == AnnotationAttributes::Off)
        fprintf(fp, "axesTicks2D = Off  # %s\n", axesTicks2D_names);
    else if(obj->data->GetAxesTicks2D() == AnnotationAttributes::Bottom)
        fprintf(fp, "axesTicks2D = Bottom  # %s\n", axesTicks2D_names);
    else if(obj->data->GetAxesTicks2D() == AnnotationAttributes::Left)
        fprintf(fp, "axesTicks2D = Left  # %s\n", axesTicks2D_names);
    else if(obj->data->GetAxesTicks2D() == AnnotationAttributes::BottomLeft)
        fprintf(fp, "axesTicks2D = BottomLeft  # %s\n", axesTicks2D_names);
    else
        fprintf(fp, "axesTicks2D = All  # %s\n", axesTicks2D_names);

    if(obj->data->GetAxesFlag())
        fprintf(fp, "axesFlag = 1\n");
    else
        fprintf(fp, "axesFlag = 0\n");
    if(obj->data->GetAxesAutoSetTicks())
        fprintf(fp, "axesAutoSetTicks = 1\n");
    else
        fprintf(fp, "axesAutoSetTicks = 0\n");
    if(obj->data->GetLabelAutoSetScaling())
        fprintf(fp, "labelAutoSetScaling = 1\n");
    else
        fprintf(fp, "labelAutoSetScaling = 0\n");
    if(obj->data->GetXAxisLabels())
        fprintf(fp, "xAxisLabels = 1\n");
    else
        fprintf(fp, "xAxisLabels = 0\n");
    if(obj->data->GetYAxisLabels())
        fprintf(fp, "yAxisLabels = 1\n");
    else
        fprintf(fp, "yAxisLabels = 0\n");
    if(obj->data->GetZAxisLabels())
        fprintf(fp, "zAxisLabels = 1\n");
    else
        fprintf(fp, "zAxisLabels = 0\n");
    if(obj->data->GetXAxisTitle())
        fprintf(fp, "xAxisTitle = 1\n");
    else
        fprintf(fp, "xAxisTitle = 0\n");
    if(obj->data->GetYAxisTitle())
        fprintf(fp, "yAxisTitle = 1\n");
    else
        fprintf(fp, "yAxisTitle = 0\n");
    if(obj->data->GetZAxisTitle())
        fprintf(fp, "zAxisTitle = 1\n");
    else
        fprintf(fp, "zAxisTitle = 0\n");
    if(obj->data->GetXGridLines())
        fprintf(fp, "xGridLines = 1\n");
    else
        fprintf(fp, "xGridLines = 0\n");
    if(obj->data->GetYGridLines())
        fprintf(fp, "yGridLines = 1\n");
    else
        fprintf(fp, "yGridLines = 0\n");
    if(obj->data->GetZGridLines())
        fprintf(fp, "zGridLines = 1\n");
    else
        fprintf(fp, "zGridLines = 0\n");
    if(obj->data->GetXAxisTicks())
        fprintf(fp, "xAxisTicks = 1\n");
    else
        fprintf(fp, "xAxisTicks = 0\n");
    if(obj->data->GetYAxisTicks())
        fprintf(fp, "yAxisTicks = 1\n");
    else
        fprintf(fp, "yAxisTicks = 0\n");
    if(obj->data->GetZAxisTicks())
        fprintf(fp, "zAxisTicks = 1\n");
    else
        fprintf(fp, "zAxisTicks = 0\n");
    fprintf(fp, "xMajorTickMinimum = %g\n", obj->data->GetXMajorTickMinimum());
    fprintf(fp, "yMajorTickMinimum = %g\n", obj->data->GetYMajorTickMinimum());
    fprintf(fp, "zMajorTickMinimum = %g\n", obj->data->GetZMajorTickMinimum());
    fprintf(fp, "xMajorTickMaximum = %g\n", obj->data->GetXMajorTickMaximum());
    fprintf(fp, "yMajorTickMaximum = %g\n", obj->data->GetYMajorTickMaximum());
    fprintf(fp, "zMajorTickMaximum = %g\n", obj->data->GetZMajorTickMaximum());
    fprintf(fp, "xMajorTickSpacing = %g\n", obj->data->GetXMajorTickSpacing());
    fprintf(fp, "yMajorTickSpacing = %g\n", obj->data->GetYMajorTickSpacing());
    fprintf(fp, "zMajorTickSpacing = %g\n", obj->data->GetZMajorTickSpacing());
    fprintf(fp, "xMinorTickSpacing = %g\n", obj->data->GetXMinorTickSpacing());
    fprintf(fp, "yMinorTickSpacing = %g\n", obj->data->GetYMinorTickSpacing());
    fprintf(fp, "zMinorTickSpacing = %g\n", obj->data->GetZMinorTickSpacing());
    fprintf(fp, "xLabelFontHeight = %g\n", obj->data->GetXLabelFontHeight());
    fprintf(fp, "yLabelFontHeight = %g\n", obj->data->GetYLabelFontHeight());
    fprintf(fp, "zLabelFontHeight = %g\n", obj->data->GetZLabelFontHeight());
    fprintf(fp, "xTitleFontHeight = %g\n", obj->data->GetXTitleFontHeight());
    fprintf(fp, "yTitleFontHeight = %g\n", obj->data->GetYTitleFontHeight());
    fprintf(fp, "zTitleFontHeight = %g\n", obj->data->GetZTitleFontHeight());
    fprintf(fp, "xLabelScaling = %d\n", obj->data->GetXLabelScaling());
    fprintf(fp, "yLabelScaling = %d\n", obj->data->GetYLabelScaling());
    fprintf(fp, "zLabelScaling = %d\n", obj->data->GetZLabelScaling());
    const char *axesTickLocation_names = "Inside, Outside, Both";
    if(obj->data->GetAxesTickLocation() == AnnotationAttributes::Inside)
        fprintf(fp, "axesTickLocation = Inside  # %s\n", axesTickLocation_names);
    else if(obj->data->GetAxesTickLocation() == AnnotationAttributes::Outside)
        fprintf(fp, "axesTickLocation = Outside  # %s\n", axesTickLocation_names);
    else
        fprintf(fp, "axesTickLocation = Both  # %s\n", axesTickLocation_names);

    const char *axesType_names = "ClosestTriad, FurthestTriad, OutsideEdges, StaticTriad, StaticEdges";
    if(obj->data->GetAxesType() == AnnotationAttributes::ClosestTriad)
        fprintf(fp, "axesType = ClosestTriad  # %s\n", axesType_names);
    else if(obj->data->GetAxesType() == AnnotationAttributes::FurthestTriad)
        fprintf(fp, "axesType = FurthestTriad  # %s\n", axesType_names);
    else if(obj->data->GetAxesType() == AnnotationAttributes::OutsideEdges)
        fprintf(fp, "axesType = OutsideEdges  # %s\n", axesType_names);
    else if(obj->data->GetAxesType() == AnnotationAttributes::StaticTriad)
        fprintf(fp, "axesType = StaticTriad  # %s\n", axesType_names);
    else
        fprintf(fp, "axesType = StaticEdges  # %s\n", axesType_names);

    if(obj->data->GetTriadFlag())
        fprintf(fp, "triadFlag = 1\n");
    else
        fprintf(fp, "triadFlag = 0\n");
    if(obj->data->GetBboxFlag())
        fprintf(fp, "bboxFlag = 1\n");
    else
        fprintf(fp, "bboxFlag = 0\n");
    const unsigned char *backgroundColor = obj->data->GetBackgroundColor().GetColor();
    fprintf(fp, "backgroundColor = (%d, %d, %d, %d)\n", int(backgroundColor[0]), int(backgroundColor[1]), int(backgroundColor[2]), int(backgroundColor[3]));
    const unsigned char *foregroundColor = obj->data->GetForegroundColor().GetColor();
    fprintf(fp, "foregroundColor = (%d, %d, %d, %d)\n", int(foregroundColor[0]), int(foregroundColor[1]), int(foregroundColor[2]), int(foregroundColor[3]));
    const char *gradientBackgroundStyle_names = "TopToBottom, BottomToTop, LeftToRight, RightToLeft, Radial";
    if(obj->data->GetGradientBackgroundStyle() == AnnotationAttributes::TopToBottom)
        fprintf(fp, "gradientBackgroundStyle = TopToBottom  # %s\n", gradientBackgroundStyle_names);
    else if(obj->data->GetGradientBackgroundStyle() == AnnotationAttributes::BottomToTop)
        fprintf(fp, "gradientBackgroundStyle = BottomToTop  # %s\n", gradientBackgroundStyle_names);
    else if(obj->data->GetGradientBackgroundStyle() == AnnotationAttributes::LeftToRight)
        fprintf(fp, "gradientBackgroundStyle = LeftToRight  # %s\n", gradientBackgroundStyle_names);
    else if(obj->data->GetGradientBackgroundStyle() == AnnotationAttributes::RightToLeft)
        fprintf(fp, "gradientBackgroundStyle = RightToLeft  # %s\n", gradientBackgroundStyle_names);
    else
        fprintf(fp, "gradientBackgroundStyle = Radial  # %s\n", gradientBackgroundStyle_names);

    const unsigned char *gradientColor1 = obj->data->GetGradientColor1().GetColor();
    fprintf(fp, "gradientColor1 = (%d, %d, %d, %d)\n", int(gradientColor1[0]), int(gradientColor1[1]), int(gradientColor1[2]), int(gradientColor1[3]));
    const unsigned char *gradientColor2 = obj->data->GetGradientColor2().GetColor();
    fprintf(fp, "gradientColor2 = (%d, %d, %d, %d)\n", int(gradientColor2[0]), int(gradientColor2[1]), int(gradientColor2[2]), int(gradientColor2[3]));
    const char *backgroundMode_names = "Solid, Gradient";
    if(obj->data->GetBackgroundMode() == AnnotationAttributes::Solid)
        fprintf(fp, "backgroundMode = Solid  # %s\n", backgroundMode_names);
    else
        fprintf(fp, "backgroundMode = Gradient  # %s\n", backgroundMode_names);

    if(obj->data->GetUserInfoFlag())
        fprintf(fp, "userInfoFlag = 1\n");
    else
        fprintf(fp, "userInfoFlag = 0\n");
    if(obj->data->GetDatabaseInfoFlag())
        fprintf(fp, "databaseInfoFlag = 1\n");
    else
        fprintf(fp, "databaseInfoFlag = 0\n");
    if(obj->data->GetLegendInfoFlag())
        fprintf(fp, "legendInfoFlag = 1\n");
    else
        fprintf(fp, "legendInfoFlag = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyAnnotationAttributes_StringRepresentation(const AnnotationAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetAxesFlag2D())
        SNPRINTF(tmpStr, 1000, "axesFlag2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "axesFlag2D = 0\n");
    str += tmpStr;
    if(atts->GetAxesAutoSetTicks2D())
        SNPRINTF(tmpStr, 1000, "axesAutoSetTicks2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "axesAutoSetTicks2D = 0\n");
    str += tmpStr;
    if(atts->GetLabelAutoSetScaling2D())
        SNPRINTF(tmpStr, 1000, "labelAutoSetScaling2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "labelAutoSetScaling2D = 0\n");
    str += tmpStr;
    if(atts->GetXAxisLabels2D())
        SNPRINTF(tmpStr, 1000, "xAxisLabels2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "xAxisLabels2D = 0\n");
    str += tmpStr;
    if(atts->GetYAxisLabels2D())
        SNPRINTF(tmpStr, 1000, "yAxisLabels2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "yAxisLabels2D = 0\n");
    str += tmpStr;
    if(atts->GetXAxisTitle2D())
        SNPRINTF(tmpStr, 1000, "xAxisTitle2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "xAxisTitle2D = 0\n");
    str += tmpStr;
    if(atts->GetYAxisTitle2D())
        SNPRINTF(tmpStr, 1000, "yAxisTitle2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "yAxisTitle2D = 0\n");
    str += tmpStr;
    if(atts->GetXGridLines2D())
        SNPRINTF(tmpStr, 1000, "xGridLines2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "xGridLines2D = 0\n");
    str += tmpStr;
    if(atts->GetYGridLines2D())
        SNPRINTF(tmpStr, 1000, "yGridLines2D = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "yGridLines2D = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMajorTickMinimum2D = %g\n", atts->GetXMajorTickMinimum2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMajorTickMinimum2D = %g\n", atts->GetYMajorTickMinimum2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMajorTickMaximum2D = %g\n", atts->GetXMajorTickMaximum2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMajorTickMaximum2D = %g\n", atts->GetYMajorTickMaximum2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMajorTickSpacing2D = %g\n", atts->GetXMajorTickSpacing2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMajorTickSpacing2D = %g\n", atts->GetYMajorTickSpacing2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMinorTickSpacing2D = %g\n", atts->GetXMinorTickSpacing2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMinorTickSpacing2D = %g\n", atts->GetYMinorTickSpacing2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xLabelFontHeight2D = %g\n", atts->GetXLabelFontHeight2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yLabelFontHeight2D = %g\n", atts->GetYLabelFontHeight2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xTitleFontHeight2D = %g\n", atts->GetXTitleFontHeight2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yTitleFontHeight2D = %g\n", atts->GetYTitleFontHeight2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xLabelScaling2D = %d\n", atts->GetXLabelScaling2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yLabelScaling2D = %d\n", atts->GetYLabelScaling2D());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "axesLineWidth2D = %d\n", atts->GetAxesLineWidth2D());
    str += tmpStr;
    const char *axesTickLocation2D_names = "Inside, Outside, Both";
    if(atts->GetAxesTickLocation2D() == AnnotationAttributes::Inside)
        {
             SNPRINTF(tmpStr, 10000, "axesTickLocation2D = Inside  # %s\n", axesTickLocation2D_names);
             str += tmpStr;
        }
    else if(atts->GetAxesTickLocation2D() == AnnotationAttributes::Outside)
        {
             SNPRINTF(tmpStr, 10000, "axesTickLocation2D = Outside  # %s\n", axesTickLocation2D_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "axesTickLocation2D = Both  # %s\n", axesTickLocation2D_names);
             str += tmpStr;
        }

    const char *axesTicks2D_names = "Off, Bottom, Left, BottomLeft, All";
    if(atts->GetAxesTicks2D() == AnnotationAttributes::Off)
        {
             SNPRINTF(tmpStr, 10000, "axesTicks2D = Off  # %s\n", axesTicks2D_names);
             str += tmpStr;
        }
    else if(atts->GetAxesTicks2D() == AnnotationAttributes::Bottom)
        {
             SNPRINTF(tmpStr, 10000, "axesTicks2D = Bottom  # %s\n", axesTicks2D_names);
             str += tmpStr;
        }
    else if(atts->GetAxesTicks2D() == AnnotationAttributes::Left)
        {
             SNPRINTF(tmpStr, 10000, "axesTicks2D = Left  # %s\n", axesTicks2D_names);
             str += tmpStr;
        }
    else if(atts->GetAxesTicks2D() == AnnotationAttributes::BottomLeft)
        {
             SNPRINTF(tmpStr, 10000, "axesTicks2D = BottomLeft  # %s\n", axesTicks2D_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "axesTicks2D = All  # %s\n", axesTicks2D_names);
             str += tmpStr;
        }

    if(atts->GetAxesFlag())
        SNPRINTF(tmpStr, 1000, "axesFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "axesFlag = 0\n");
    str += tmpStr;
    if(atts->GetAxesAutoSetTicks())
        SNPRINTF(tmpStr, 1000, "axesAutoSetTicks = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "axesAutoSetTicks = 0\n");
    str += tmpStr;
    if(atts->GetLabelAutoSetScaling())
        SNPRINTF(tmpStr, 1000, "labelAutoSetScaling = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "labelAutoSetScaling = 0\n");
    str += tmpStr;
    if(atts->GetXAxisLabels())
        SNPRINTF(tmpStr, 1000, "xAxisLabels = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "xAxisLabels = 0\n");
    str += tmpStr;
    if(atts->GetYAxisLabels())
        SNPRINTF(tmpStr, 1000, "yAxisLabels = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "yAxisLabels = 0\n");
    str += tmpStr;
    if(atts->GetZAxisLabels())
        SNPRINTF(tmpStr, 1000, "zAxisLabels = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "zAxisLabels = 0\n");
    str += tmpStr;
    if(atts->GetXAxisTitle())
        SNPRINTF(tmpStr, 1000, "xAxisTitle = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "xAxisTitle = 0\n");
    str += tmpStr;
    if(atts->GetYAxisTitle())
        SNPRINTF(tmpStr, 1000, "yAxisTitle = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "yAxisTitle = 0\n");
    str += tmpStr;
    if(atts->GetZAxisTitle())
        SNPRINTF(tmpStr, 1000, "zAxisTitle = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "zAxisTitle = 0\n");
    str += tmpStr;
    if(atts->GetXGridLines())
        SNPRINTF(tmpStr, 1000, "xGridLines = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "xGridLines = 0\n");
    str += tmpStr;
    if(atts->GetYGridLines())
        SNPRINTF(tmpStr, 1000, "yGridLines = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "yGridLines = 0\n");
    str += tmpStr;
    if(atts->GetZGridLines())
        SNPRINTF(tmpStr, 1000, "zGridLines = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "zGridLines = 0\n");
    str += tmpStr;
    if(atts->GetXAxisTicks())
        SNPRINTF(tmpStr, 1000, "xAxisTicks = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "xAxisTicks = 0\n");
    str += tmpStr;
    if(atts->GetYAxisTicks())
        SNPRINTF(tmpStr, 1000, "yAxisTicks = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "yAxisTicks = 0\n");
    str += tmpStr;
    if(atts->GetZAxisTicks())
        SNPRINTF(tmpStr, 1000, "zAxisTicks = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "zAxisTicks = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMajorTickMinimum = %g\n", atts->GetXMajorTickMinimum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMajorTickMinimum = %g\n", atts->GetYMajorTickMinimum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "zMajorTickMinimum = %g\n", atts->GetZMajorTickMinimum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMajorTickMaximum = %g\n", atts->GetXMajorTickMaximum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMajorTickMaximum = %g\n", atts->GetYMajorTickMaximum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "zMajorTickMaximum = %g\n", atts->GetZMajorTickMaximum());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMajorTickSpacing = %g\n", atts->GetXMajorTickSpacing());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMajorTickSpacing = %g\n", atts->GetYMajorTickSpacing());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "zMajorTickSpacing = %g\n", atts->GetZMajorTickSpacing());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xMinorTickSpacing = %g\n", atts->GetXMinorTickSpacing());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yMinorTickSpacing = %g\n", atts->GetYMinorTickSpacing());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "zMinorTickSpacing = %g\n", atts->GetZMinorTickSpacing());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xLabelFontHeight = %g\n", atts->GetXLabelFontHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yLabelFontHeight = %g\n", atts->GetYLabelFontHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "zLabelFontHeight = %g\n", atts->GetZLabelFontHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xTitleFontHeight = %g\n", atts->GetXTitleFontHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yTitleFontHeight = %g\n", atts->GetYTitleFontHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "zTitleFontHeight = %g\n", atts->GetZTitleFontHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "xLabelScaling = %d\n", atts->GetXLabelScaling());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "yLabelScaling = %d\n", atts->GetYLabelScaling());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "zLabelScaling = %d\n", atts->GetZLabelScaling());
    str += tmpStr;
    const char *axesTickLocation_names = "Inside, Outside, Both";
    if(atts->GetAxesTickLocation() == AnnotationAttributes::Inside)
        {
             SNPRINTF(tmpStr, 10000, "axesTickLocation = Inside  # %s\n", axesTickLocation_names);
             str += tmpStr;
        }
    else if(atts->GetAxesTickLocation() == AnnotationAttributes::Outside)
        {
             SNPRINTF(tmpStr, 10000, "axesTickLocation = Outside  # %s\n", axesTickLocation_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "axesTickLocation = Both  # %s\n", axesTickLocation_names);
             str += tmpStr;
        }

    const char *axesType_names = "ClosestTriad, FurthestTriad, OutsideEdges, StaticTriad, StaticEdges";
    if(atts->GetAxesType() == AnnotationAttributes::ClosestTriad)
        {
             SNPRINTF(tmpStr, 10000, "axesType = ClosestTriad  # %s\n", axesType_names);
             str += tmpStr;
        }
    else if(atts->GetAxesType() == AnnotationAttributes::FurthestTriad)
        {
             SNPRINTF(tmpStr, 10000, "axesType = FurthestTriad  # %s\n", axesType_names);
             str += tmpStr;
        }
    else if(atts->GetAxesType() == AnnotationAttributes::OutsideEdges)
        {
             SNPRINTF(tmpStr, 10000, "axesType = OutsideEdges  # %s\n", axesType_names);
             str += tmpStr;
        }
    else if(atts->GetAxesType() == AnnotationAttributes::StaticTriad)
        {
             SNPRINTF(tmpStr, 10000, "axesType = StaticTriad  # %s\n", axesType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "axesType = StaticEdges  # %s\n", axesType_names);
             str += tmpStr;
        }

    if(atts->GetTriadFlag())
        SNPRINTF(tmpStr, 1000, "triadFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "triadFlag = 0\n");
    str += tmpStr;
    if(atts->GetBboxFlag())
        SNPRINTF(tmpStr, 1000, "bboxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "bboxFlag = 0\n");
    str += tmpStr;
    const unsigned char *backgroundColor = atts->GetBackgroundColor().GetColor();
    SNPRINTF(tmpStr, 1000, "backgroundColor = (%d, %d, %d, %d)\n", int(backgroundColor[0]), int(backgroundColor[1]), int(backgroundColor[2]), int(backgroundColor[3]));
    str += tmpStr;
    const unsigned char *foregroundColor = atts->GetForegroundColor().GetColor();
    SNPRINTF(tmpStr, 1000, "foregroundColor = (%d, %d, %d, %d)\n", int(foregroundColor[0]), int(foregroundColor[1]), int(foregroundColor[2]), int(foregroundColor[3]));
    str += tmpStr;
    const char *gradientBackgroundStyle_names = "TopToBottom, BottomToTop, LeftToRight, RightToLeft, Radial";
    if(atts->GetGradientBackgroundStyle() == AnnotationAttributes::TopToBottom)
        {
             SNPRINTF(tmpStr, 10000, "gradientBackgroundStyle = TopToBottom  # %s\n", gradientBackgroundStyle_names);
             str += tmpStr;
        }
    else if(atts->GetGradientBackgroundStyle() == AnnotationAttributes::BottomToTop)
        {
             SNPRINTF(tmpStr, 10000, "gradientBackgroundStyle = BottomToTop  # %s\n", gradientBackgroundStyle_names);
             str += tmpStr;
        }
    else if(atts->GetGradientBackgroundStyle() == AnnotationAttributes::LeftToRight)
        {
             SNPRINTF(tmpStr, 10000, "gradientBackgroundStyle = LeftToRight  # %s\n", gradientBackgroundStyle_names);
             str += tmpStr;
        }
    else if(atts->GetGradientBackgroundStyle() == AnnotationAttributes::RightToLeft)
        {
             SNPRINTF(tmpStr, 10000, "gradientBackgroundStyle = RightToLeft  # %s\n", gradientBackgroundStyle_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "gradientBackgroundStyle = Radial  # %s\n", gradientBackgroundStyle_names);
             str += tmpStr;
        }

    const unsigned char *gradientColor1 = atts->GetGradientColor1().GetColor();
    SNPRINTF(tmpStr, 1000, "gradientColor1 = (%d, %d, %d, %d)\n", int(gradientColor1[0]), int(gradientColor1[1]), int(gradientColor1[2]), int(gradientColor1[3]));
    str += tmpStr;
    const unsigned char *gradientColor2 = atts->GetGradientColor2().GetColor();
    SNPRINTF(tmpStr, 1000, "gradientColor2 = (%d, %d, %d, %d)\n", int(gradientColor2[0]), int(gradientColor2[1]), int(gradientColor2[2]), int(gradientColor2[3]));
    str += tmpStr;
    const char *backgroundMode_names = "Solid, Gradient";
    if(atts->GetBackgroundMode() == AnnotationAttributes::Solid)
        {
             SNPRINTF(tmpStr, 10000, "backgroundMode = Solid  # %s\n", backgroundMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "backgroundMode = Gradient  # %s\n", backgroundMode_names);
             str += tmpStr;
        }

    if(atts->GetUserInfoFlag())
        SNPRINTF(tmpStr, 1000, "userInfoFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "userInfoFlag = 0\n");
    str += tmpStr;
    if(atts->GetDatabaseInfoFlag())
        SNPRINTF(tmpStr, 1000, "databaseInfoFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "databaseInfoFlag = 0\n");
    str += tmpStr;
    if(atts->GetLegendInfoFlag())
        SNPRINTF(tmpStr, 1000, "legendInfoFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendInfoFlag = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
AnnotationAttributes_str(PyObject *v)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)v;
    return PyAnnotationAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *AnnotationAttributes_Purpose = "This class contains the attributes controlling annotations.";

//
// The type description structure
//
static PyTypeObject AnnotationAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AnnotationAttributes",                    // tp_name
    sizeof(AnnotationAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AnnotationAttributes_dealloc,  // tp_dealloc
    (printfunc)AnnotationAttributes_print,     // tp_print
    (getattrfunc)AnnotationAttributes_getattr, // tp_getattr
    (setattrfunc)AnnotationAttributes_setattr, // tp_setattr
    (cmpfunc)AnnotationAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AnnotationAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AnnotationAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AnnotationAttributes *defaultAtts = 0;

static PyObject *
NewAnnotationAttributes()
{
    AnnotationAttributesObject *newObject;
    newObject = PyObject_NEW(AnnotationAttributesObject, &AnnotationAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new AnnotationAttributes(*defaultAtts);
    else
        newObject->data = new AnnotationAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapAnnotationAttributes(const AnnotationAttributes *attr)
{
    AnnotationAttributesObject *newObject;
    newObject = PyObject_NEW(AnnotationAttributesObject, &AnnotationAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AnnotationAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AnnotationAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewAnnotationAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AnnotationAttributesMethods[] = {
    {"AnnotationAttributes", AnnotationAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AnnotationAttributesObserver = 0;
static bool AnnotationAttributesEnableLogging = true;

static void
PyAnnotationAttributes_WriteLog(Subject *subj, void *data)
{
    AnnotationAttributes *atts = (AnnotationAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!AnnotationAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# AnnotationAttributes_WriteLog()\n");
}

void
PyAnnotationAttributes_StartUp(AnnotationAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyAnnotationAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AnnotationAttributesObserver == 0)
    {
        AnnotationAttributesObserver = new ObserverToCallback(subj,
            PyAnnotationAttributes_WriteLog, (void *)logFile);
    }

    AnnotationAttributesEnableLogging = true;
}

void
PyAnnotationAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AnnotationAttributesObserver;
    AnnotationAttributesObserver = 0;
}

PyMethodDef *
PyAnnotationAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AnnotationAttributesMethods;
}

bool
PyAnnotationAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &AnnotationAttributesType);
}

AnnotationAttributes *
PyAnnotationAttributes_FromPyObject(PyObject *obj)
{
    AnnotationAttributesObject *obj2 = (AnnotationAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyAnnotationAttributes_NewPyObject()
{
    return NewAnnotationAttributes();
}

PyObject *
PyAnnotationAttributes_WrapPyObject(const AnnotationAttributes *attr)
{
    return WrapAnnotationAttributes(attr);
}

void
PyAnnotationAttributes_SetLogging(bool val)
{
    AnnotationAttributesEnableLogging = val;
}

void
PyAnnotationAttributes_SetDefaults(const AnnotationAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AnnotationAttributes(*atts);
}

