#include <ViewerWindowManagerAttributes.h>
#include <DataNode.h>
#include <ActionGroupDescription.h>

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::ViewerWindowManagerAttributes
//
// Purpose: 
//   Constructor for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ViewerWindowManagerAttributes::ViewerWindowManagerAttributes() : AttributeSubject("a*bb")
{
    // Initialize the action groups.
    DataNode *parentNode = new DataNode("parent");
    parentNode->AddNode(new DataNode("ViewerWindowManagerAttributes"));
    ProcessOldVersions(parentNode, 0);
    SetFromNode(parentNode);
    delete parentNode;
    toolbarsVisible = true;
    largeIcons = false;
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::ViewerWindowManagerAttributes
//
// Purpose: 
//   Copy constructor for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ViewerWindowManagerAttributes::ViewerWindowManagerAttributes(const ViewerWindowManagerAttributes &obj) : AttributeSubject("a*bb")
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the actionConfigurations field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = actionConfigurations.begin(); pos != actionConfigurations.end(); ++pos)
        delete *pos;
    actionConfigurations.clear();
    if(obj.actionConfigurations.size() > 0)
        actionConfigurations.reserve(obj.actionConfigurations.size());
    // Duplicate the actionConfigurations from obj.
    for(pos = obj.actionConfigurations.begin(); pos != obj.actionConfigurations.end(); ++pos)
    {
        ActionGroupDescription *oldActionGroupDescription = (ActionGroupDescription *)(*pos);
        ActionGroupDescription *newActionGroupDescription = new ActionGroupDescription(*oldActionGroupDescription);
        actionConfigurations.push_back(newActionGroupDescription);
    }

    toolbarsVisible = obj.toolbarsVisible;
    largeIcons = obj.largeIcons;

    SelectAll();
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::~ViewerWindowManagerAttributes
//
// Purpose: 
//   Destructor for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ViewerWindowManagerAttributes::~ViewerWindowManagerAttributes()
{
    AttributeGroupVector::iterator pos;

    // Destroy the actionConfigurations field.
    for(pos = actionConfigurations.begin(); pos != actionConfigurations.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::operator = (const ViewerWindowManagerAttributes &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the actionConfigurations field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = actionConfigurations.begin(); pos != actionConfigurations.end(); ++pos)
        delete *pos;
    actionConfigurations.clear();
    if(obj.actionConfigurations.size() > 0)
        actionConfigurations.reserve(obj.actionConfigurations.size());
    // Duplicate the actionConfigurations from obj.
    for(pos = obj.actionConfigurations.begin(); pos != obj.actionConfigurations.end(); ++pos)
    {
        ActionGroupDescription *oldActionGroupDescription = (ActionGroupDescription *)(*pos);
        ActionGroupDescription *newActionGroupDescription = new ActionGroupDescription(*oldActionGroupDescription);
        actionConfigurations.push_back(newActionGroupDescription);
    }

    toolbarsVisible = obj.toolbarsVisible;
    largeIcons = obj.largeIcons;

    SelectAll();
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerWindowManagerAttributes::operator == (const ViewerWindowManagerAttributes &obj) const
{
    int i;

    bool actionConfigurations_equal = (obj.actionConfigurations.size() == actionConfigurations.size());
    for(i = 0; (i < actionConfigurations.size()) && actionConfigurations_equal; ++i)
    {
        // Make references to ActionGroupDescription from AttributeGroup *.
        const ActionGroupDescription &actionConfigurations1 = *((const ActionGroupDescription *)(actionConfigurations[i]));
        const ActionGroupDescription &actionConfigurations2 = *((const ActionGroupDescription *)(obj.actionConfigurations[i]));
        actionConfigurations_equal = (actionConfigurations1 == actionConfigurations2);
    }

    // Create the return value
    return (actionConfigurations_equal &&
            (toolbarsVisible == obj.toolbarsVisible) &&
            (largeIcons == obj.largeIcons));
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerWindowManagerAttributes::operator != (const ViewerWindowManagerAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::TypeName
//
// Purpose: 
//   Type name method for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
ViewerWindowManagerAttributes::TypeName() const
{
    return "ViewerWindowManagerAttributes";
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerWindowManagerAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewerWindowManagerAttributes *tmp = (const ViewerWindowManagerAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerWindowManagerAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewerWindowManagerAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ViewerWindowManagerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerWindowManagerAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewerWindowManagerAttributes(*this);
    else
        retval = new ViewerWindowManagerAttributes;

    return retval;
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::SelectAll()
{
    Select(0, (void *)&actionConfigurations);
    Select(1, (void *)&toolbarsVisible);
    Select(2, (void *)&largeIcons);
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::CreateSubAttributeGroup
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
ViewerWindowManagerAttributes::CreateSubAttributeGroup(int)
{
    return new ActionGroupDescription;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 5 12:27:55 PDT 2003
//
// Modifications:
//   Brad Whitlock, Wed Jul 23 14:00:55 PST 2003
//   Removed window size, location coding.
//
//   Brad Whitlock, Tue Feb 24 13:38:09 PST 2004
//   Added code to save the toolbarsVisible flag.
//
//   Brad Whitlock, Tue Mar 16 11:06:19 PDT 2004
//   Added code to save the large icons flag.
//
// ****************************************************************************

bool
ViewerWindowManagerAttributes::CreateNode(DataNode *parentNode, bool, bool)
{
    if(parentNode == 0)
        return false;

    // Create a node for ViewerWindowManagerAttributes.
    DataNode *node = new DataNode("ViewerWindowManagerAttributes");
    DataNode *attNode = new DataNode("ActionConfigurations");
    for(int i = 0; i < actionConfigurations.size(); ++i)
        actionConfigurations[i]->CreateNode(attNode, true, true);
    node->AddNode(attNode);

    // Add the toolbars saved flag.
    node->AddNode(new DataNode("toolbarsVisible", toolbarsVisible));

    // Add the large icons flag.
    node->AddNode(new DataNode("largeIcons", largeIcons));

    // Add the node to the parent node.
    parentNode->AddNode(node);

    return true;
}
// ****************************************************************************
// Method: ViewerWindowManagerAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Feb 5 12:27:55 PDT 2003
//
// Modifications:
//   Brad Whitlock, Wed Jul 23 14:00:55 PST 2003
//   Removed window size, location coding.
//
//   Brad Whitlock, Tue Feb 24 13:38:40 PST 2004
//   Added code to read the toolbarsVisible flag.
//
//   Brad Whitlock, Tue Mar 16 12:01:25 PDT 2004
//   Added code to read the largeIcons flag.
//
// ****************************************************************************

void
ViewerWindowManagerAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewerWindowManagerAttributes");
    if(searchNode == 0)
        return;

    // Look for the action configuration.
    DataNode *attNode = searchNode->GetNode("ActionConfigurations");
    if(attNode)
    {
        // Clear all the ActionGroupDescriptions.
        ClearActionGroupDescriptions();

        // Go through all of the children and construct a new
        // ActionGroupDescription for each one of them.
        DataNode **children = attNode->GetChildren();
        for(int i = 0; i < attNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == "ActionGroupDescription")
            {
                ActionGroupDescription temp;
                temp.SetFromNode(children[i]);
                AddActionGroupDescription(temp);
            }
        }
    }

    //
    // Read the toolbarsVisible flag.
    //
    DataNode *node;
    if((node = searchNode->GetNode("toolbarsVisible")) != 0)
        SetToolbarsVisible(node->AsBool());

    //
    // Read the largeIcons flag.
    //
    if((node = searchNode->GetNode("largeIcons")) != 0)
        SetLargeIcons(node->AsBool());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerWindowManagerAttributes::SetToolbarsVisible(bool toolbarsVisible_)
{
    toolbarsVisible = toolbarsVisible_;
    Select(1, (void *)&toolbarsVisible);
}

void
ViewerWindowManagerAttributes::SetLargeIcons(bool largeIcons_)
{
    largeIcons = largeIcons_;
    Select(2, (void *)&largeIcons);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
ViewerWindowManagerAttributes::GetActionConfigurations() const
{
    return actionConfigurations;
}

AttributeGroupVector &
ViewerWindowManagerAttributes::GetActionConfigurations()
{
    return actionConfigurations;
}

bool
ViewerWindowManagerAttributes::GetToolbarsVisible() const
{
    return toolbarsVisible;
}

bool
ViewerWindowManagerAttributes::GetLargeIcons() const
{
    return largeIcons;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerWindowManagerAttributes::SelectActionConfigurations()
{
    Select(0, (void *)&actionConfigurations);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::AddActionGroupDescription
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::AddActionGroupDescription(const ActionGroupDescription &obj)
{
    ActionGroupDescription *newActionGroupDescription = new ActionGroupDescription(obj);
    actionConfigurations.push_back(newActionGroupDescription);

    // Indicate that things have changed by selecting it.
    Select(0, (void *)&actionConfigurations);
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::ClearActionGroupDescriptions
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::ClearActionGroupDescriptions()
{
    AttributeGroupVector::iterator pos;

    for(pos = actionConfigurations.begin(); pos != actionConfigurations.end(); ++pos)
        delete *pos;
    actionConfigurations.clear();

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&actionConfigurations);
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::RemoveActionGroupDescription
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::RemoveActionGroupDescription(int index)
{
    AttributeGroupVector::iterator pos = actionConfigurations.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != actionConfigurations.end())
    {
        delete *pos;
        actionConfigurations.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(0, (void *)&actionConfigurations);
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::GetNumActionGroupDescriptions
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
ViewerWindowManagerAttributes::GetNumActionGroupDescriptions() const
{
    return actionConfigurations.size();
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::GetActionGroupDescription
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription &
ViewerWindowManagerAttributes::GetActionGroupDescription(int i)
{
    return *((ActionGroupDescription *)actionConfigurations[i]);
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::GetActionGroupDescription
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const ActionGroupDescription &
ViewerWindowManagerAttributes::GetActionGroupDescription(int i) const
{
    return *((ActionGroupDescription *)actionConfigurations[i]);
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::operator []
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ActionGroupDescription &
ViewerWindowManagerAttributes::operator [] (int i)
{
    return *((ActionGroupDescription *)actionConfigurations[i]);
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::operator []
//
// Purpose: 
//   This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const ActionGroupDescription &
ViewerWindowManagerAttributes::operator [] (int i) const
{
    return *((ActionGroupDescription *)actionConfigurations[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewerWindowManagerAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "actionConfigurations";
        case 1:  return "Toolbars visible";
        case 2:  return "Large icons";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ViewerWindowManagerAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_attVector;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewerWindowManagerAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "attVector";
        case 1:  return "bool";
        case 2:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 16 16:46:50 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerWindowManagerAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const ViewerWindowManagerAttributes &obj = *((const ViewerWindowManagerAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        bool actionConfigurations_equal = (obj.actionConfigurations.size() == actionConfigurations.size());
        for(i = 0; (i < actionConfigurations.size()) && actionConfigurations_equal; ++i)
        {
            // Make references to ActionGroupDescription from AttributeGroup *.
            const ActionGroupDescription &actionConfigurations1 = *((const ActionGroupDescription *)(actionConfigurations[i]));
            const ActionGroupDescription &actionConfigurations2 = *((const ActionGroupDescription *)(obj.actionConfigurations[i]));
            actionConfigurations_equal = (actionConfigurations1 == actionConfigurations2);
        }

        retval = actionConfigurations_equal;
        }
        break;
    case 1:
        {  // new scope
        retval = (toolbarsVisible == obj.toolbarsVisible);
        }
        break;
    case 2:
        {  // new scope
        retval = (largeIcons == obj.largeIcons);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewerWindowManagerAttributes::ProcessOldVersions
//
// Purpose: 
//   This method creates modifies a DataNode representation of the object
//   so it conforms to the newest representation of the object, which can
//   can be read back in.
//
// Programmer: Brad Whitlock
// Creation:   Fri Mar 21 10:37:49 PDT 2003
//
// Modifications:
//   Kathleen Bonnell, Thu May 15 13:13:52 PDT 2003 
//   Added ToggleFullFrameRPC to the viewGroup for 1.1.5.
//
//   Brad Whitlock, Mon Jun 23 16:39:49 PST 2003
//   I added the Clear action group for 1.1.6.
//
//   Brad Whitlock, Mon Dec 29 15:00:03 PST 2003
//   I added new actions.
//
//   Brad Whitlock, Sun Jan 25 19:48:23 PST 2004
//   I renamed some actions.
//
// ****************************************************************************

void
ViewerWindowManagerAttributes::ProcessOldVersions(DataNode *parentNode,
    const char *configVersion)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewerWindowManagerAttributes");
    if(searchNode == 0)
        return;

    // Try and find the ActionConfigurations node. If there is no such
    // node, create one.
    DataNode *actionNode = searchNode->GetNode("ActionConfigurations");
    if(actionNode == 0)
    {
        actionNode = new DataNode("ActionConfigurations");
        searchNode->AddNode(actionNode);
    }

    //
    // Add actions that are new in 1.1
    //
    if(VersionLessThan(configVersion, "1.1"))
    {
        // Create an action group for the mode.
        ActionGroupDescription modeGroup("Mode");
        AddActionGroup(actionNode, modeGroup);

        // Create an action group for the tools.
        ActionGroupDescription toolGroup("Tools");
        AddActionGroup(actionNode, toolGroup);

        // Create an action group that contains window actions.
        ActionGroupDescription windowGroup("Window");
        windowGroup.AddAction(ViewerRPC::SetActiveWindowRPC);
        windowGroup.AddAction(ViewerRPC::AddWindowRPC);
        windowGroup.AddAction(ViewerRPC::CloneWindowRPC);
        windowGroup.AddAction(ViewerRPC::DeleteWindowRPC);
        windowGroup.AddAction(ViewerRPC::SetWindowLayoutRPC);
        windowGroup.AddAction(ViewerRPC::ToggleSpinModeRPC);
        windowGroup.AddAction(ViewerRPC::ToggleBoundingBoxModeRPC);
        windowGroup.AddAction(ViewerRPC::InvertBackgroundRPC);
        AddActionGroup(actionNode, windowGroup);

        // Create an action group that contains the view actions.
        ActionGroupDescription viewGroup("View");
        viewGroup.AddAction(ViewerRPC::TogglePerspectiveViewRPC);
        viewGroup.AddAction(ViewerRPC::ToggleLockViewModeRPC);
        viewGroup.AddAction(ViewerRPC::ResetViewRPC);
        viewGroup.AddAction(ViewerRPC::RecenterViewRPC);
        viewGroup.AddAction(ViewerRPC::UndoViewRPC);
        AddActionGroup(actionNode, viewGroup);

        // Create an action group that contains the animation options.
        ActionGroupDescription animationGroup("Animation");
        animationGroup.AddAction(ViewerRPC::TimeSliderPreviousStateRPC);
        animationGroup.AddAction(ViewerRPC::AnimationReversePlayRPC);
        animationGroup.AddAction(ViewerRPC::AnimationStopRPC);
        animationGroup.AddAction(ViewerRPC::AnimationPlayRPC);
        animationGroup.AddAction(ViewerRPC::TimeSliderNextStateRPC);
        AddActionGroup(actionNode, animationGroup);
    }

    //
    // Add actions that are new in 1.1.1
    //
    if(VersionLessThan(configVersion, "1.1.1"))
    {
        AddAction(actionNode, "View", ViewerRPC::SaveViewRPC);
    }

    //
    // Add actions that are new in 1.1.2
    //
    if(VersionLessThan(configVersion, "1.1.2"))
    {
        // Create an action group that contains the operator actions.
        ActionGroupDescription operatorGroup("Operators");
        operatorGroup.SetVisible(false);
        operatorGroup.AddAction(ViewerRPC::AddOperatorRPC);
        operatorGroup.AddAction(ViewerRPC::RemoveLastOperatorRPC);
        operatorGroup.AddAction(ViewerRPC::RemoveAllOperatorsRPC);
        AddActionGroup(actionNode, operatorGroup);

        // Create an action group that contains the operator actions.
        ActionGroupDescription plotGroup("Plots");
        plotGroup.SetVisible(false);
        plotGroup.AddAction(ViewerRPC::AddPlotRPC);
        plotGroup.AddAction(ViewerRPC::DrawPlotsRPC);
        plotGroup.AddAction(ViewerRPC::HideActivePlotsRPC);
        plotGroup.AddAction(ViewerRPC::DeleteActivePlotsRPC);
        AddActionGroup(actionNode, plotGroup);
    }

    //
    // Add actions that are new in 1.1.5
    //
    if(VersionLessThan(configVersion, "1.1.5"))
    {
        AddAction(actionNode, "View", ViewerRPC::ToggleFullFrameRPC);
    }

    //
    // Add actions that are new in 1.1.6
    //
    if(VersionLessThan(configVersion, "1.1.6"))
    {
        ActionGroupDescription clearGroup("Clear");
        clearGroup.SetVisible(true);
        clearGroup.AddAction(ViewerRPC::ClearWindowRPC);
        clearGroup.AddAction(ViewerRPC::ClearAllWindowsRPC);
        clearGroup.AddAction(ViewerRPC::ClearPickPointsRPC);
        clearGroup.AddAction(ViewerRPC::ClearRefLinesRPC);
        AddActionGroup(actionNode, clearGroup);

        // Remove ClearWindowRPC from the Window action group.
        RemoveActionFromNode(actionNode, "Window",
                             ViewerRPC::ClearWindowRPC);
    }

    //
    // Add actions that are new in 1.3
    //
    if(VersionLessThan(configVersion, "1.3"))
    {
        AddAction(actionNode, "View", ViewerRPC::ChooseCenterOfRotationRPC);

        // Remove all of the animation actions and then re-add them with
        // the new names in the right order.
        RemoveActionFromNode(actionNode, "Animation", "AnimationPreviousFrameRPC");
        RemoveActionFromNode(actionNode, "Animation", "AnimationNextFrameRPC");
        RemoveActionFromNode(actionNode, "Animation", "AnimationStopRPC");
        RemoveActionFromNode(actionNode, "Animation", "AnimationReversePlayRPC");
        RemoveActionFromNode(actionNode, "Animation", "AnimationPlayRPC");
        AddAction(actionNode, "Animation", ViewerRPC::TimeSliderPreviousStateRPC);
        AddAction(actionNode, "Animation", ViewerRPC::AnimationReversePlayRPC);
        AddAction(actionNode, "Animation", ViewerRPC::AnimationStopRPC);
        AddAction(actionNode, "Animation", ViewerRPC::AnimationPlayRPC);
        AddAction(actionNode, "Animation", ViewerRPC::TimeSliderNextStateRPC);
    }
}


// ****************************************************************************
// Method: ViewerWindowManagerAttributes::RemoveActionFromNode
//
// Purpose: 
//   Removes an action from an action group in a DataNode.
//
// Arguments:
//   node            : The node that contains the action groups.
//   actionGroupName : The name of the action group from which we're removing
//                     the action.
//   action          : The action to be removed.
//
// Programmer: Brad Whitlock
// Creation:   Tue Jun 24 11:33:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::RemoveActionFromNode(DataNode *node,
    const char *actionGroupName, ViewerRPC::ViewerRPCType action)
{
    std::string actionName(ViewerRPC::ViewerRPCType_ToString(action));
    RemoveActionFromNode(node, actionGroupName, actionName.c_str());
}


// ****************************************************************************
// Method: ViewerWindowManagerAttributes::RemoveActionFromNode
//
// Purpose: 
//   Removes an action from an action group in a DataNode.
//
// Arguments:
//   node            : The node that contains the action groups.
//   actionGroupName : The name of the action group from which we're removing
//                     the action.
//   action          : The action to be removed.
//
// Programmer: Brad Whitlock
// Creation:   Tue Jun 24 11:33:38 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::RemoveActionFromNode(DataNode *node,
    const char *actionGroupName, const char *aName)
{
    // See if the ClearWindow action is in the Window action group.
    // If it is, remove it.
    std::string AGName(actionGroupName);
    std::string actionName(aName);

    DataNode **actionNodes = node->GetChildren();
    for(int i = 0; i < node->GetNumChildren(); ++i)
    {
        DataNode *nameNode = actionNodes[i]->GetNode("name");
        DataNode *aNode = actionNodes[i]->GetNode("actions");
        if(nameNode != 0 && aNode != 0 &&
           nameNode->AsString() == AGName)
        {
            stringVector newActions;
            const stringVector &oldActions = aNode->AsStringVector();
            for(int j = 0; j < oldActions.size(); ++j)
            {
                if(oldActions[j] != actionName)
                    newActions.push_back(oldActions[j]);
            }

            aNode->SetStringVector(newActions);
            break;
        }
    }
}


// ****************************************************************************
// Method: ViewerWindowManagerAttributes::AddAction
//
// Purpose: 
//   Adds an action to an existing action group in the DataNode.
//
// Arguments:
//   node            : The node that contains the action groups.
//   actionGroupName : The name of the action group to which we'll add the
//                     new action.
//   action          : The action to be added.
//
// Programmer: Brad Whitlock
// Creation:   Fri Mar 21 13:22:11 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::AddAction(DataNode *node,
    const char *actionGroupName, ViewerRPC::ViewerRPCType action)
{
    // Look to see if the action group is already in the node.
    DataNode *actionNode = 0;
    DataNode **groups = node->GetChildren();
    std::string AGName(actionGroupName);
    for(int i = 0; i < node->GetNumChildren(); ++i)
    {
        DataNode *nameNode = groups[i]->GetNode("name");
        // If the action group is already in the node, add the new group's
        // actions to it if they are not in it already.
        if(nameNode && nameNode->AsString() == AGName)
        {
            actionNode = groups[i]->GetNode("actions");
            if(actionNode)
                break;
        }
    }

    if(actionNode == 0)
    {
        // No action group with the specified name was found. Make one
        // and insert it into the node.
        ActionGroupDescription newGroup(actionGroupName);
        newGroup.AddAction(action);
        newGroup.CreateNode(node, true, false);
    }
    else
    {
        // If we're adding an action to an existing action group,
        // replace the group's action vector.
        stringVector existingActions(actionNode->AsStringVector());
        existingActions.push_back(ViewerRPC::ViewerRPCType_ToString(action));
        actionNode->SetStringVector(existingActions);
    }
}


// ****************************************************************************
// Method: ViewerWindowManagerAttributes::AddActionGroup
//
// Purpose: 
//   Adds a new action group to the list of action groups in the DataNode
//   that we know about.
//
// Arguments:
//   node : The node to which the action group will be added.
//   ag   : The action group description containing the list of actions that
//          make up the group.
//
// Programmer: Brad Whitlock
// Creation:   Fri Mar 21 13:20:17 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
ViewerWindowManagerAttributes::AddActionGroup(DataNode *node,
    ActionGroupDescription &ag)
{
    // Look to see if the action group is already in the node.
    DataNode **groups = node->GetChildren();
    for(int i = 0; i < node->GetNumChildren(); ++i)
    {
        DataNode *nameNode = groups[i]->GetNode("name");

        // If the action group is already in the node, add the new group's
        // actions to it if they are not in it already.
        if(nameNode && nameNode->AsString() == ag.GetName())
        {
            DataNode *actionNode = groups[i]->GetNode("actions");
            if(actionNode)
            {
                stringVector existingActions(actionNode->AsStringVector());
                const stringVector &newActions = ag.GetActions();
                bool modifiedActions = false;

                // Add any actions in newActions to existingActions that
                // are not already in existingActions.
                for(int j = 0; j < newActions.size(); ++j)
                {
                    bool actionFound = false;
                    for(int k = 0; k < existingActions.size(); ++k)
                    {
                        if(existingActions[k] == newActions[j])
                        {
                            actionFound = true;
                            break;
                        }
                    }

                    if(!actionFound)
                    {
                        existingActions.push_back(newActions[j]);
                        modifiedActions = true;
                    }
                }

                // If we added an action, replace the action vector.
                if(modifiedActions)
                    actionNode->SetStringVector(existingActions);

                return;
            }
        }
    }

    // The action group was not in the node. Add it.
    ag.CreateNode(node, true, false);
}

