#ifndef ACTIONGROUPDESCRIPTION_H
#define ACTIONGROUPDESCRIPTION_H
#include <string>
#include <AttributeSubject.h>
#include <ViewerRPC.h>

// ****************************************************************************
// Class: ActionGroupDescription
//
// Purpose:
//    This class contains the attributes that describe an action group.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:42:29 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class ActionGroupDescription : public AttributeSubject
{
public:
    ActionGroupDescription();
    ActionGroupDescription(const ActionGroupDescription &obj);
    virtual ~ActionGroupDescription();

    virtual void operator = (const ActionGroupDescription &obj);
    virtual bool operator == (const ActionGroupDescription &obj) const;
    virtual bool operator != (const ActionGroupDescription &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectName();
    void SelectActions();

    // Property setting methods
    void SetName(const std::string &name_);
    void SetActions(const stringVector &actions_);
    void SetVisible(bool visible_);

    // Property getting methods
    const std::string  &GetName() const;
          std::string  &GetName();
    const stringVector &GetActions() const;
          stringVector &GetActions();
    bool               GetVisible() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    ActionGroupDescription(const std::string &n);
    void AddAction(ViewerRPC::ViewerRPCType t);
    ViewerRPC::ViewerRPCType GetAction(int index) const;
private:
    std::string  name;
    stringVector actions;
    bool         visible;
};

#endif
