#include <SimDBPluginInfo.h>
#include <avtSimDBFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  SimDBCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a SimDB database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Mon Jan 12 14:24:06 PST 2004
//
// ****************************************************************************
DatabaseType
SimDBCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  SimDBCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a SimDB database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Mon Jan 12 14:24:06 PST 2004
//
// ****************************************************************************
std::vector<std::string>
SimDBCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("sim");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: SimDBCommonPluginInfo::GetWriter
//
//  Purpose:
//      Sets up a SimDB writer.
//
//  Returns:    A SimDB writer.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jan 12 14:24:06 PST 2004
//
// ****************************************************************************
avtDatabaseWriter *
SimDBCommonPluginInfo::GetWriter(void)
{
    return NULL;
}

// ****************************************************************************
//  Method: SimDBCommonPluginInfo::SetUpSimDBDatabase
//
//  Purpose:
//      Sets up a SimDB database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A SimDB database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jan 12 14:24:06 PST 2004
//
// ****************************************************************************
avtDatabase *
SimDBCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtSimDBFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
