// ************************************************************************* //
//  File: VolumeViewerPluginInfo.C
// ************************************************************************* //

#include <VolumePluginInfo.h>
#include <avtVolumePlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Volume_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Volume plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    VolumeViewerPluginInfo::InitializeGlobalObjects();
    return new VolumeViewerPluginInfo;
}

//
// Storage for static data elements.
//
VolumeAttributes *VolumeViewerPluginInfo::clientAtts = NULL;
VolumeAttributes *VolumeViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  VolumeViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************
void
VolumeViewerPluginInfo::InitializeGlobalObjects()
{
    VolumeViewerPluginInfo::clientAtts  = new VolumeAttributes;
    VolumeViewerPluginInfo::defaultAtts = new VolumeAttributes;
}

// ****************************************************************************
//  Method: VolumeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************

AttributeSubject *
VolumeViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: VolumeViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************

AttributeSubject *
VolumeViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: VolumeViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************

void
VolumeViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(VolumeAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: VolumeViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************

void
VolumeViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(VolumeAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: VolumeViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************

avtPlot *
VolumeViewerPluginInfo::AllocAvtPlot()
{
    return new avtVolumePlot;
}

// ****************************************************************************
//  Method: VolumeViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************

void
VolumeViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(VolumeAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: VolumeViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
VolumeViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}


// ****************************************************************************
//  Method: VolumeViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:05 PST 2004
//
// ****************************************************************************

#include <Volume.xpm>
const char **
VolumeViewerPluginInfo::XPMIconData() const
{
    return Volume_xpm;
}
