// ************************************************************************* //
//                        VolumeScriptingPluginInfo.C
// ************************************************************************* //
#include <VolumePluginInfo.h>
#include <PyVolumeAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Volume_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Volume plot.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Tue Jan 21 10:54:04 PDT 2003
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new VolumeScriptingPluginInfo;
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Tue Jan 21 10:54:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
VolumeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyVolumeAttributes_StartUp((VolumeAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Tue Jan 21 10:54:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void *
VolumeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyVolumeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Volume plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Tue Jan 21 10:54:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
VolumeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyVolumeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Tue Jan 21 10:54:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
VolumeScriptingPluginInfo::SetLogging(bool val)
{
    PyVolumeAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Tue Jan 21 10:54:04 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
VolumeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyVolumeAttributes_SetDefaults((const VolumeAttributes *)atts);
}
