// ************************************************************************* //
//  File: VolumeGUIPluginInfo.C
// ************************************************************************* //

#include <VolumePluginInfo.h>
#include <VolumeAttributes.h>
#include <QvisVolumePlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Volume_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Volume plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:43:55 PST 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new VolumeGUIPluginInfo;
}

// ****************************************************************************
//  Method: VolumeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:43:55 PST 2003
//
// ****************************************************************************

const char *
VolumeGUIPluginInfo::GetMenuName() const
{
    return "Volume";
}


// ****************************************************************************
// Method: VolumeGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:43:55 PST 2003
//
// Modifications:
//   
// ****************************************************************************

int
VolumeGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}

// ****************************************************************************
//  Method: VolumeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:43:55 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
VolumeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisVolumePlotWindow(type, (VolumeAttributes *)attr,
        "Volume plot attributes", "Volume plot", notepad);
}

// ****************************************************************************
//  Method: VolumeGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:43:55 PST 2003
//
// ****************************************************************************

#include <Volume.xpm>
const char **
VolumeGUIPluginInfo::XPMIconData() const
{
    return Volume_xpm;
}
