#include <PyVolumeAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyVolumeAttributes
//
// Purpose: 
//   This class contains the plot attributes for the volume plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Dec 15 09:18:37 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a VolumeAttributes.
//
struct VolumeAttributesObject
{
    PyObject_HEAD
    VolumeAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewVolumeAttributes();

static PyObject *
VolumeAttributes_Notify(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetColorControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=colorControlPoints, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetColorControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=colorControlPoints, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
VolumeAttributes_SetOpacityAttenuation(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityAttenuation in the object.
    obj->data->SetOpacityAttenuation(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetOpacityAttenuation(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityAttenuation()));
    return retval;
}

static PyObject *
VolumeAttributes_SetFreeformFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the freeformFlag in the object.
    obj->data->SetFreeformFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetFreeformFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFreeformFlag()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetOpacityControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=opacityControlPoints, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetOpacityControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=opacityControlPoints, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
VolumeAttributes_SetResampleTarget(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the resampleTarget in the object.
    obj->data->SetResampleTarget(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetResampleTarget(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetResampleTarget()));
    return retval;
}

static PyObject *
VolumeAttributes_SetOpacityVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the opacityVariable in the object.
    obj->data->SetOpacityVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetOpacityVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOpacityVariable().c_str());
    return retval;
}

static PyObject *
VolumeAttributes_SetFreeformOpacity(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    unsigned char *cvals = obj->data->GetFreeformOpacity();
    if(!PyArg_ParseTuple(args, "cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc", &cvals[0], &cvals[1], &cvals[2], &cvals[3], &cvals[4], &cvals[5], &cvals[6], &cvals[7], &cvals[8], &cvals[9], &cvals[10], &cvals[11], &cvals[12], &cvals[13], &cvals[14], &cvals[15], &cvals[16], &cvals[17], &cvals[18], &cvals[19], &cvals[20], &cvals[21], &cvals[22], &cvals[23], &cvals[24], &cvals[25], &cvals[26], &cvals[27], &cvals[28], &cvals[29], &cvals[30], &cvals[31], &cvals[32], &cvals[33], &cvals[34], &cvals[35], &cvals[36], &cvals[37], &cvals[38], &cvals[39], &cvals[40], &cvals[41], &cvals[42], &cvals[43], &cvals[44], &cvals[45], &cvals[46], &cvals[47], &cvals[48], &cvals[49], &cvals[50], &cvals[51], &cvals[52], &cvals[53], &cvals[54], &cvals[55], &cvals[56], &cvals[57], &cvals[58], &cvals[59], &cvals[60], &cvals[61], &cvals[62], &cvals[63], &cvals[64], &cvals[65], &cvals[66], &cvals[67], &cvals[68], &cvals[69], &cvals[70], &cvals[71], &cvals[72], &cvals[73], &cvals[74], &cvals[75], &cvals[76], &cvals[77], &cvals[78], &cvals[79], &cvals[80], &cvals[81], &cvals[82], &cvals[83], &cvals[84], &cvals[85], &cvals[86], &cvals[87], &cvals[88], &cvals[89], &cvals[90], &cvals[91], &cvals[92], &cvals[93], &cvals[94], &cvals[95], &cvals[96], &cvals[97], &cvals[98], &cvals[99], &cvals[100], &cvals[101], &cvals[102], &cvals[103], &cvals[104], &cvals[105], &cvals[106], &cvals[107], &cvals[108], &cvals[109], &cvals[110], &cvals[111], &cvals[112], &cvals[113], &cvals[114], &cvals[115], &cvals[116], &cvals[117], &cvals[118], &cvals[119], &cvals[120], &cvals[121], &cvals[122], &cvals[123], &cvals[124], &cvals[125], &cvals[126], &cvals[127], &cvals[128], &cvals[129], &cvals[130], &cvals[131], &cvals[132], &cvals[133], &cvals[134], &cvals[135], &cvals[136], &cvals[137], &cvals[138], &cvals[139], &cvals[140], &cvals[141], &cvals[142], &cvals[143], &cvals[144], &cvals[145], &cvals[146], &cvals[147], &cvals[148], &cvals[149], &cvals[150], &cvals[151], &cvals[152], &cvals[153], &cvals[154], &cvals[155], &cvals[156], &cvals[157], &cvals[158], &cvals[159], &cvals[160], &cvals[161], &cvals[162], &cvals[163], &cvals[164], &cvals[165], &cvals[166], &cvals[167], &cvals[168], &cvals[169], &cvals[170], &cvals[171], &cvals[172], &cvals[173], &cvals[174], &cvals[175], &cvals[176], &cvals[177], &cvals[178], &cvals[179], &cvals[180], &cvals[181], &cvals[182], &cvals[183], &cvals[184], &cvals[185], &cvals[186], &cvals[187], &cvals[188], &cvals[189], &cvals[190], &cvals[191], &cvals[192], &cvals[193], &cvals[194], &cvals[195], &cvals[196], &cvals[197], &cvals[198], &cvals[199], &cvals[200], &cvals[201], &cvals[202], &cvals[203], &cvals[204], &cvals[205], &cvals[206], &cvals[207], &cvals[208], &cvals[209], &cvals[210], &cvals[211], &cvals[212], &cvals[213], &cvals[214], &cvals[215], &cvals[216], &cvals[217], &cvals[218], &cvals[219], &cvals[220], &cvals[221], &cvals[222], &cvals[223], &cvals[224], &cvals[225], &cvals[226], &cvals[227], &cvals[228], &cvals[229], &cvals[230], &cvals[231], &cvals[232], &cvals[233], &cvals[234], &cvals[235], &cvals[236], &cvals[237], &cvals[238], &cvals[239], &cvals[240], &cvals[241], &cvals[242], &cvals[243], &cvals[244], &cvals[245], &cvals[246], &cvals[247], &cvals[248], &cvals[249], &cvals[250], &cvals[251], &cvals[252], &cvals[253], &cvals[254], &cvals[255]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 256)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                int c;
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    c = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    c = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    c = int(PyLong_AsDouble(item));
                else
                    c = 0;

                if(c < 0) c = 0;
                if(c > 255) c = 255;
                cvals[i] = (unsigned char)(c);
            }
        }
        else
            return NULL;
    }

    // Mark the freeformOpacity in the object as modified.
    obj->data->SelectFreeformOpacity();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetFreeformOpacity(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the freeformOpacity.
    PyObject *retval = PyTuple_New(256);
    const unsigned char *freeformOpacity = obj->data->GetFreeformOpacity();
    for(int i = 0; i < 256; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(freeformOpacity[i])));
    return retval;
}

static PyObject *
VolumeAttributes_SetUseColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useColorVarMin in the object.
    obj->data->SetUseColorVarMin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetUseColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseColorVarMin()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the colorVarMin in the object.
    obj->data->SetColorVarMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetColorVarMin()));
    return retval;
}

static PyObject *
VolumeAttributes_SetUseColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useColorVarMax in the object.
    obj->data->SetUseColorVarMax(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetUseColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseColorVarMax()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the colorVarMax in the object.
    obj->data->SetColorVarMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetColorVarMax()));
    return retval;
}

static PyObject *
VolumeAttributes_SetUseOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useOpacityVarMin in the object.
    obj->data->SetUseOpacityVarMin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetUseOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseOpacityVarMin()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityVarMin in the object.
    obj->data->SetOpacityVarMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityVarMin()));
    return retval;
}

static PyObject *
VolumeAttributes_SetUseOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useOpacityVarMax in the object.
    obj->data->SetUseOpacityVarMax(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetUseOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseOpacityVarMax()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityVarMax in the object.
    obj->data->SetOpacityVarMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityVarMax()));
    return retval;
}

static PyObject *
VolumeAttributes_SetSmoothData(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothData in the object.
    obj->data->SetSmoothData(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetSmoothData(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSmoothData()?1L:0L);
    return retval;
}

static PyObject *
VolumeAttributes_SetSamplesPerRay(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesPerRay in the object.
    obj->data->SetSamplesPerRay(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetSamplesPerRay(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesPerRay()));
    return retval;
}

static PyObject *
VolumeAttributes_SetRendererType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rendererType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetRendererType(VolumeAttributes::Renderer(ival));
    else
    {
        fprintf(stderr, "An invalid rendererType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Splatting, Texture3D, RayCasting.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetRendererType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRendererType()));
    return retval;
}

static PyObject *
VolumeAttributes_SetGradientType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the gradientType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetGradientType(VolumeAttributes::GradientType(ival));
    else
    {
        fprintf(stderr, "An invalid gradientType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CenteredDifferences, SobelOperator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetGradientType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGradientType()));
    return retval;
}

static PyObject *
VolumeAttributes_SetNum3DSlices(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the num3DSlices in the object.
    obj->data->SetNum3DSlices(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_GetNum3DSlices(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNum3DSlices()));
    return retval;
}



static struct PyMethodDef VolumeAttributes_methods[] = {
    {"Notify", VolumeAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", VolumeAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", VolumeAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", VolumeAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", VolumeAttributes_GetLightingFlag, METH_VARARGS},
    {"SetColorControlPoints", VolumeAttributes_SetColorControlPoints, METH_VARARGS},
    {"GetColorControlPoints", VolumeAttributes_GetColorControlPoints, METH_VARARGS},
    {"SetOpacityAttenuation", VolumeAttributes_SetOpacityAttenuation, METH_VARARGS},
    {"GetOpacityAttenuation", VolumeAttributes_GetOpacityAttenuation, METH_VARARGS},
    {"SetFreeformFlag", VolumeAttributes_SetFreeformFlag, METH_VARARGS},
    {"GetFreeformFlag", VolumeAttributes_GetFreeformFlag, METH_VARARGS},
    {"SetOpacityControlPoints", VolumeAttributes_SetOpacityControlPoints, METH_VARARGS},
    {"GetOpacityControlPoints", VolumeAttributes_GetOpacityControlPoints, METH_VARARGS},
    {"SetResampleTarget", VolumeAttributes_SetResampleTarget, METH_VARARGS},
    {"GetResampleTarget", VolumeAttributes_GetResampleTarget, METH_VARARGS},
    {"SetOpacityVariable", VolumeAttributes_SetOpacityVariable, METH_VARARGS},
    {"GetOpacityVariable", VolumeAttributes_GetOpacityVariable, METH_VARARGS},
    {"SetFreeformOpacity", VolumeAttributes_SetFreeformOpacity, METH_VARARGS},
    {"GetFreeformOpacity", VolumeAttributes_GetFreeformOpacity, METH_VARARGS},
    {"SetUseColorVarMin", VolumeAttributes_SetUseColorVarMin, METH_VARARGS},
    {"GetUseColorVarMin", VolumeAttributes_GetUseColorVarMin, METH_VARARGS},
    {"SetColorVarMin", VolumeAttributes_SetColorVarMin, METH_VARARGS},
    {"GetColorVarMin", VolumeAttributes_GetColorVarMin, METH_VARARGS},
    {"SetUseColorVarMax", VolumeAttributes_SetUseColorVarMax, METH_VARARGS},
    {"GetUseColorVarMax", VolumeAttributes_GetUseColorVarMax, METH_VARARGS},
    {"SetColorVarMax", VolumeAttributes_SetColorVarMax, METH_VARARGS},
    {"GetColorVarMax", VolumeAttributes_GetColorVarMax, METH_VARARGS},
    {"SetUseOpacityVarMin", VolumeAttributes_SetUseOpacityVarMin, METH_VARARGS},
    {"GetUseOpacityVarMin", VolumeAttributes_GetUseOpacityVarMin, METH_VARARGS},
    {"SetOpacityVarMin", VolumeAttributes_SetOpacityVarMin, METH_VARARGS},
    {"GetOpacityVarMin", VolumeAttributes_GetOpacityVarMin, METH_VARARGS},
    {"SetUseOpacityVarMax", VolumeAttributes_SetUseOpacityVarMax, METH_VARARGS},
    {"GetUseOpacityVarMax", VolumeAttributes_GetUseOpacityVarMax, METH_VARARGS},
    {"SetOpacityVarMax", VolumeAttributes_SetOpacityVarMax, METH_VARARGS},
    {"GetOpacityVarMax", VolumeAttributes_GetOpacityVarMax, METH_VARARGS},
    {"SetSmoothData", VolumeAttributes_SetSmoothData, METH_VARARGS},
    {"GetSmoothData", VolumeAttributes_GetSmoothData, METH_VARARGS},
    {"SetSamplesPerRay", VolumeAttributes_SetSamplesPerRay, METH_VARARGS},
    {"GetSamplesPerRay", VolumeAttributes_GetSamplesPerRay, METH_VARARGS},
    {"SetRendererType", VolumeAttributes_SetRendererType, METH_VARARGS},
    {"GetRendererType", VolumeAttributes_GetRendererType, METH_VARARGS},
    {"SetGradientType", VolumeAttributes_SetGradientType, METH_VARARGS},
    {"GetGradientType", VolumeAttributes_GetGradientType, METH_VARARGS},
    {"SetNum3DSlices", VolumeAttributes_SetNum3DSlices, METH_VARARGS},
    {"GetNum3DSlices", VolumeAttributes_GetNum3DSlices, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
VolumeAttributes_dealloc(PyObject *v)
{
   VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
VolumeAttributes_compare(PyObject *v, PyObject *w)
{
    VolumeAttributes *a = ((VolumeAttributesObject *)v)->data;
    VolumeAttributes *b = ((VolumeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
VolumeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return VolumeAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return VolumeAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "opacityAttenuation") == 0)
        return VolumeAttributes_GetOpacityAttenuation(self, NULL);
    if(strcmp(name, "freeformFlag") == 0)
        return VolumeAttributes_GetFreeformFlag(self, NULL);
    if(strcmp(name, "resampleTarget") == 0)
        return VolumeAttributes_GetResampleTarget(self, NULL);
    if(strcmp(name, "opacityVariable") == 0)
        return VolumeAttributes_GetOpacityVariable(self, NULL);
    if(strcmp(name, "freeformOpacity") == 0)
        return VolumeAttributes_GetFreeformOpacity(self, NULL);
    if(strcmp(name, "useColorVarMin") == 0)
        return VolumeAttributes_GetUseColorVarMin(self, NULL);
    if(strcmp(name, "colorVarMin") == 0)
        return VolumeAttributes_GetColorVarMin(self, NULL);
    if(strcmp(name, "useColorVarMax") == 0)
        return VolumeAttributes_GetUseColorVarMax(self, NULL);
    if(strcmp(name, "colorVarMax") == 0)
        return VolumeAttributes_GetColorVarMax(self, NULL);
    if(strcmp(name, "useOpacityVarMin") == 0)
        return VolumeAttributes_GetUseOpacityVarMin(self, NULL);
    if(strcmp(name, "opacityVarMin") == 0)
        return VolumeAttributes_GetOpacityVarMin(self, NULL);
    if(strcmp(name, "useOpacityVarMax") == 0)
        return VolumeAttributes_GetUseOpacityVarMax(self, NULL);
    if(strcmp(name, "opacityVarMax") == 0)
        return VolumeAttributes_GetOpacityVarMax(self, NULL);
    if(strcmp(name, "smoothData") == 0)
        return VolumeAttributes_GetSmoothData(self, NULL);
    if(strcmp(name, "samplesPerRay") == 0)
        return VolumeAttributes_GetSamplesPerRay(self, NULL);
    if(strcmp(name, "rendererType") == 0)
        return VolumeAttributes_GetRendererType(self, NULL);
    if(strcmp(name, "Splatting") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Splatting));
    else if(strcmp(name, "Texture3D") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Texture3D));
    else if(strcmp(name, "RayCasting") == 0)
        return PyInt_FromLong(long(VolumeAttributes::RayCasting));

    if(strcmp(name, "gradientType") == 0)
        return VolumeAttributes_GetGradientType(self, NULL);
    if(strcmp(name, "CenteredDifferences") == 0)
        return PyInt_FromLong(long(VolumeAttributes::CenteredDifferences));
    else if(strcmp(name, "SobelOperator") == 0)
        return PyInt_FromLong(long(VolumeAttributes::SobelOperator));

    if(strcmp(name, "num3DSlices") == 0)
        return VolumeAttributes_GetNum3DSlices(self, NULL);

    return Py_FindMethod(VolumeAttributes_methods, self, name);
}

static int
VolumeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "legendFlag") == 0)
        retval = (VolumeAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lightingFlag") == 0)
        retval = (VolumeAttributes_SetLightingFlag(self, tuple) != NULL);
    else if(strcmp(name, "opacityAttenuation") == 0)
        retval = (VolumeAttributes_SetOpacityAttenuation(self, tuple) != NULL);
    else if(strcmp(name, "freeformFlag") == 0)
        retval = (VolumeAttributes_SetFreeformFlag(self, tuple) != NULL);
    else if(strcmp(name, "resampleTarget") == 0)
        retval = (VolumeAttributes_SetResampleTarget(self, tuple) != NULL);
    else if(strcmp(name, "opacityVariable") == 0)
        retval = (VolumeAttributes_SetOpacityVariable(self, tuple) != NULL);
    else if(strcmp(name, "freeformOpacity") == 0)
        retval = (VolumeAttributes_SetFreeformOpacity(self, tuple) != NULL);
    else if(strcmp(name, "useColorVarMin") == 0)
        retval = (VolumeAttributes_SetUseColorVarMin(self, tuple) != NULL);
    else if(strcmp(name, "colorVarMin") == 0)
        retval = (VolumeAttributes_SetColorVarMin(self, tuple) != NULL);
    else if(strcmp(name, "useColorVarMax") == 0)
        retval = (VolumeAttributes_SetUseColorVarMax(self, tuple) != NULL);
    else if(strcmp(name, "colorVarMax") == 0)
        retval = (VolumeAttributes_SetColorVarMax(self, tuple) != NULL);
    else if(strcmp(name, "useOpacityVarMin") == 0)
        retval = (VolumeAttributes_SetUseOpacityVarMin(self, tuple) != NULL);
    else if(strcmp(name, "opacityVarMin") == 0)
        retval = (VolumeAttributes_SetOpacityVarMin(self, tuple) != NULL);
    else if(strcmp(name, "useOpacityVarMax") == 0)
        retval = (VolumeAttributes_SetUseOpacityVarMax(self, tuple) != NULL);
    else if(strcmp(name, "opacityVarMax") == 0)
        retval = (VolumeAttributes_SetOpacityVarMax(self, tuple) != NULL);
    else if(strcmp(name, "smoothData") == 0)
        retval = (VolumeAttributes_SetSmoothData(self, tuple) != NULL);
    else if(strcmp(name, "samplesPerRay") == 0)
        retval = (VolumeAttributes_SetSamplesPerRay(self, tuple) != NULL);
    else if(strcmp(name, "rendererType") == 0)
        retval = (VolumeAttributes_SetRendererType(self, tuple) != NULL);
    else if(strcmp(name, "gradientType") == 0)
        retval = (VolumeAttributes_SetGradientType(self, tuple) != NULL);
    else if(strcmp(name, "num3DSlices") == 0)
        retval = (VolumeAttributes_SetNum3DSlices(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
VolumeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)v;

    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    if(obj->data->GetLightingFlag())
        fprintf(fp, "lightingFlag = 1\n");
    else
        fprintf(fp, "lightingFlag = 0\n");
    //colorControlPoints
    fprintf(fp, "opacityAttenuation = %g\n", obj->data->GetOpacityAttenuation());
    if(obj->data->GetFreeformFlag())
        fprintf(fp, "freeformFlag = 1\n");
    else
        fprintf(fp, "freeformFlag = 0\n");
    //opacityControlPoints
    fprintf(fp, "resampleTarget = %d\n", obj->data->GetResampleTarget());
    fprintf(fp, "opacityVariable = \"%s\"\n", obj->data->GetOpacityVariable().c_str());
    {   const unsigned char *freeformOpacity = obj->data->GetFreeformOpacity();
        fprintf(fp, "freeformOpacity = (");
        for(int i = 0; i < 256; ++i)
        {
            fprintf(fp, "%d", int(freeformOpacity[i]));
            if(i < 255)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }

    if(obj->data->GetUseColorVarMin())
        fprintf(fp, "useColorVarMin = 1\n");
    else
        fprintf(fp, "useColorVarMin = 0\n");
    fprintf(fp, "colorVarMin = %g\n", obj->data->GetColorVarMin());
    if(obj->data->GetUseColorVarMax())
        fprintf(fp, "useColorVarMax = 1\n");
    else
        fprintf(fp, "useColorVarMax = 0\n");
    fprintf(fp, "colorVarMax = %g\n", obj->data->GetColorVarMax());
    if(obj->data->GetUseOpacityVarMin())
        fprintf(fp, "useOpacityVarMin = 1\n");
    else
        fprintf(fp, "useOpacityVarMin = 0\n");
    fprintf(fp, "opacityVarMin = %g\n", obj->data->GetOpacityVarMin());
    if(obj->data->GetUseOpacityVarMax())
        fprintf(fp, "useOpacityVarMax = 1\n");
    else
        fprintf(fp, "useOpacityVarMax = 0\n");
    fprintf(fp, "opacityVarMax = %g\n", obj->data->GetOpacityVarMax());
    if(obj->data->GetSmoothData())
        fprintf(fp, "smoothData = 1\n");
    else
        fprintf(fp, "smoothData = 0\n");
    fprintf(fp, "samplesPerRay = %d\n", obj->data->GetSamplesPerRay());
    const char *rendererType_names = "Splatting, Texture3D, RayCasting";
    if(obj->data->GetRendererType() == VolumeAttributes::Splatting)
        fprintf(fp, "rendererType = Splatting  # %s\n", rendererType_names);
    else if(obj->data->GetRendererType() == VolumeAttributes::Texture3D)
        fprintf(fp, "rendererType = Texture3D  # %s\n", rendererType_names);
    else
        fprintf(fp, "rendererType = RayCasting  # %s\n", rendererType_names);

    const char *gradientType_names = "CenteredDifferences, SobelOperator";
    if(obj->data->GetGradientType() == VolumeAttributes::CenteredDifferences)
        fprintf(fp, "gradientType = CenteredDifferences  # %s\n", gradientType_names);
    else
        fprintf(fp, "gradientType = SobelOperator  # %s\n", gradientType_names);

    fprintf(fp, "num3DSlices = %d\n", obj->data->GetNum3DSlices());

    return 0;
}

#include <snprintf.h>
PyObject *
PyVolumeAttributes_StringRepresentation(const VolumeAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "lightingFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "lightingFlag = 0\n");
    str += tmpStr;
#if 0
    { // new scope
         PyObject *obj = PyColorControlPointList_StringRepresentation(atts->GetColorControlPoints());
         str += "colorControlPoints = {";
         if(obj != 0) str += PyString_AS_STRING(obj);
         str += "}\n";

    }
#endif
    SNPRINTF(tmpStr, 1000, "opacityAttenuation = %g\n", atts->GetOpacityAttenuation());
    str += tmpStr;
    if(atts->GetFreeformFlag())
        SNPRINTF(tmpStr, 1000, "freeformFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "freeformFlag = 0\n");
    str += tmpStr;
#if 0
    { // new scope
         PyObject *obj = PyGaussianControlPointList_StringRepresentation(atts->GetOpacityControlPoints());
         str += "opacityControlPoints = {";
         if(obj != 0) str += PyString_AS_STRING(obj);
         str += "}\n";

    }
#endif
    SNPRINTF(tmpStr, 1000, "resampleTarget = %d\n", atts->GetResampleTarget());
    str += tmpStr;
   SNPRINTF(tmpStr, 1000, "opacityVariable = \"%s\"\n", atts->GetOpacityVariable().c_str());
   str += tmpStr;
    {   const unsigned char *freeformOpacity = atts->GetFreeformOpacity();
        SNPRINTF(tmpStr, 1000, "freeformOpacity = (");
        str += tmpStr;
        for(int i = 0; i < 256; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(freeformOpacity[i]));
            str += tmpStr;
            if(i < 255)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetUseColorVarMin())
        SNPRINTF(tmpStr, 1000, "useColorVarMin = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useColorVarMin = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "colorVarMin = %g\n", atts->GetColorVarMin());
    str += tmpStr;
    if(atts->GetUseColorVarMax())
        SNPRINTF(tmpStr, 1000, "useColorVarMax = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useColorVarMax = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "colorVarMax = %g\n", atts->GetColorVarMax());
    str += tmpStr;
    if(atts->GetUseOpacityVarMin())
        SNPRINTF(tmpStr, 1000, "useOpacityVarMin = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useOpacityVarMin = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "opacityVarMin = %g\n", atts->GetOpacityVarMin());
    str += tmpStr;
    if(atts->GetUseOpacityVarMax())
        SNPRINTF(tmpStr, 1000, "useOpacityVarMax = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useOpacityVarMax = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "opacityVarMax = %g\n", atts->GetOpacityVarMax());
    str += tmpStr;
    if(atts->GetSmoothData())
        SNPRINTF(tmpStr, 1000, "smoothData = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "smoothData = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "samplesPerRay = %d\n", atts->GetSamplesPerRay());
    str += tmpStr;
    const char *rendererType_names = "Splatting, Texture3D, RayCasting";
    if(atts->GetRendererType() == VolumeAttributes::Splatting)
        {
             SNPRINTF(tmpStr, 1000, "rendererType = Splatting  # %s\n", rendererType_names);
             str += tmpStr;
        }
    else if(atts->GetRendererType() == VolumeAttributes::Texture3D)
        {
             SNPRINTF(tmpStr, 1000, "rendererType = Texture3D  # %s\n", rendererType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "rendererType = RayCasting  # %s\n", rendererType_names);
             str += tmpStr;
        }

    const char *gradientType_names = "CenteredDifferences, SobelOperator";
    if(atts->GetGradientType() == VolumeAttributes::CenteredDifferences)
        {
             SNPRINTF(tmpStr, 1000, "gradientType = CenteredDifferences  # %s\n", gradientType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "gradientType = SobelOperator  # %s\n", gradientType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "num3DSlices = %d\n", atts->GetNum3DSlices());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
VolumeAttributes_str(PyObject *v)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
    return PyVolumeAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *VolumeAttributes_Purpose = "This class contains the plot attributes for the volume plot.";

//
// The type description structure
//
static PyTypeObject VolumeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "VolumeAttributes",                    // tp_name
    sizeof(VolumeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)VolumeAttributes_dealloc,  // tp_dealloc
    (printfunc)VolumeAttributes_print,     // tp_print
    (getattrfunc)VolumeAttributes_getattr, // tp_getattr
    (setattrfunc)VolumeAttributes_setattr, // tp_setattr
    (cmpfunc)VolumeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)VolumeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    VolumeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static VolumeAttributes *defaultAtts = 0;

static PyObject *
NewVolumeAttributes()
{
    VolumeAttributesObject *newObject;
    newObject = PyObject_NEW(VolumeAttributesObject, &VolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new VolumeAttributes(*defaultAtts);
    else
        newObject->data = new VolumeAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapVolumeAttributes(const VolumeAttributes *attr)
{
    VolumeAttributesObject *newObject;
    newObject = PyObject_NEW(VolumeAttributesObject, &VolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (VolumeAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
VolumeAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewVolumeAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef VolumeAttributesMethods[] = {
    {"VolumeAttributes", VolumeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *VolumeAttributesObserver = 0;
static bool VolumeAttributesEnableLogging = true;

static void
PyVolumeAttributes_WriteLog(Subject *subj, void *data)
{
    VolumeAttributes *atts = (VolumeAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!VolumeAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# VolumeAttributes_WriteLog()\n");
}

void
PyVolumeAttributes_StartUp(VolumeAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyVolumeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(VolumeAttributesObserver == 0)
    {
        VolumeAttributesObserver = new ObserverToCallback(subj,
            PyVolumeAttributes_WriteLog, (void *)logFile);
    }

    VolumeAttributesEnableLogging = true;
}

void
PyVolumeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete VolumeAttributesObserver;
    VolumeAttributesObserver = 0;
}

PyMethodDef *
PyVolumeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return VolumeAttributesMethods;
}

bool
PyVolumeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &VolumeAttributesType);
}

VolumeAttributes *
PyVolumeAttributes_FromPyObject(PyObject *obj)
{
    VolumeAttributesObject *obj2 = (VolumeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyVolumeAttributes_NewPyObject()
{
    return NewVolumeAttributes();
}

PyObject *
PyVolumeAttributes_WrapPyObject(const VolumeAttributes *attr)
{
    return WrapVolumeAttributes(attr);
}

void
PyVolumeAttributes_SetLogging(bool val)
{
    VolumeAttributesEnableLogging = val;
}

void
PyVolumeAttributes_SetDefaults(const VolumeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new VolumeAttributes(*atts);
}

