// ************************************************************************* //
//  File: VectorViewerPluginInfo.C
// ************************************************************************* //

#include <VectorPluginInfo.h>
#include <avtVectorPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Vector_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Vector plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    VectorViewerPluginInfo::InitializeGlobalObjects();
    return new VectorViewerPluginInfo;
}

//
// Storage for static data elements.
//
VectorAttributes *VectorViewerPluginInfo::clientAtts = NULL;
VectorAttributes *VectorViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  VectorViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************
void
VectorViewerPluginInfo::InitializeGlobalObjects()
{
    VectorViewerPluginInfo::clientAtts  = new VectorAttributes;
    VectorViewerPluginInfo::defaultAtts = new VectorAttributes;
}

// ****************************************************************************
//  Method: VectorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************

AttributeSubject *
VectorViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: VectorViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************

AttributeSubject *
VectorViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: VectorViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************

void
VectorViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(VectorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: VectorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************

void
VectorViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(VectorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: VectorViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************

avtPlot *
VectorViewerPluginInfo::AllocAvtPlot()
{
    return new avtVectorPlot;
}

// ****************************************************************************
//  Method: VectorViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************

void
VectorViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(VectorAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: VectorViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
VectorViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}


// ****************************************************************************
//  Method: VectorViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:10:02 PST 2004
//
// ****************************************************************************

#include <Vector.xpm>
const char **
VectorViewerPluginInfo::XPMIconData() const
{
    return Vector_xpm;
}
