// ************************************************************************* //
//                        VectorScriptingPluginInfo.C
// ************************************************************************* //
#include <VectorPluginInfo.h>
#include <PyVectorAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Vector_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Vector plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:34:12 PST 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new VectorScriptingPluginInfo;
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:34:12 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
VectorScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyVectorAttributes_StartUp((VectorAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:34:12 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
VectorScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyVectorAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Vector plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:34:12 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
VectorScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyVectorAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:34:12 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
VectorScriptingPluginInfo::SetLogging(bool val)
{
    PyVectorAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:34:12 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
VectorScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyVectorAttributes_SetDefaults((const VectorAttributes *)atts);
}
