// ************************************************************************* //
//  File: VectorGUIPluginInfo.C
// ************************************************************************* //

#include <VectorPluginInfo.h>
#include <VectorAttributes.h>
#include <QvisVectorPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Vector_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Vector plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 08:06:57 PDT 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new VectorGUIPluginInfo;
}

// ****************************************************************************
//  Method: VectorGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 08:06:57 PDT 2003
//
// ****************************************************************************

const char *
VectorGUIPluginInfo::GetMenuName() const
{
    return "Vector";
}


// ****************************************************************************
// Method: VectorGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 08:06:57 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
VectorGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}

// ****************************************************************************
//  Method: VectorGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 08:06:57 PDT 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
VectorGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisVectorPlotWindow(type, (VectorAttributes *)attr,
        "Vector plot attributes", "Vector plot", notepad);
}

// ****************************************************************************
//  Method: VectorGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 08:06:57 PDT 2003
//
// ****************************************************************************

#include <Vector.xpm>
const char **
VectorGUIPluginInfo::XPMIconData() const
{
    return Vector_xpm;
}
