#include <VectorAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for VectorAttributes::OriginType
//

static const char *OriginType_strings[] = {
"Head", "Middle", "Tail"
};

std::string
VectorAttributes::OriginType_ToString(VectorAttributes::OriginType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return OriginType_strings[index];
}

std::string
VectorAttributes::OriginType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return OriginType_strings[index];
}

bool
VectorAttributes::OriginType_FromString(const std::string &s, VectorAttributes::OriginType &val)
{
    val = VectorAttributes::Head;
    for(int i = 0; i < 3; ++i)
    {
        if(s == OriginType_strings[i])
        {
            val = (OriginType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for VectorAttributes::LimitsMode
//

static const char *LimitsMode_strings[] = {
"OriginalData", "CurrentPlot"};

std::string
VectorAttributes::LimitsMode_ToString(VectorAttributes::LimitsMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LimitsMode_strings[index];
}

std::string
VectorAttributes::LimitsMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LimitsMode_strings[index];
}

bool
VectorAttributes::LimitsMode_FromString(const std::string &s, VectorAttributes::LimitsMode &val)
{
    val = VectorAttributes::OriginalData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LimitsMode_strings[i])
        {
            val = (LimitsMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose: 
//   Constructor for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

VectorAttributes::VectorAttributes() : AttributeSubject("biiiidbbdbbbasibbidd"),
    vectorColor(0, 0, 0), colorTableName("Default")
{
    useStride = false;
    stride = 1;
    nVectors = 400;
    lineStyle = 0;
    lineWidth = 0;
    scale = 0.25;
    scaleByMagnitude = true;
    autoScale = true;
    headSize = 0.25;
    headOn = true;
    colorByMag = true;
    useLegend = true;
    vectorOrigin = Tail;
    minFlag = false;
    maxFlag = false;
    limitsMode = OriginalData;
    min = 0;
    max = 1;
}

// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose: 
//   Copy constructor for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

VectorAttributes::VectorAttributes(const VectorAttributes &obj) : AttributeSubject("biiiidbbdbbbasibbidd")
{
    useStride = obj.useStride;
    stride = obj.stride;
    nVectors = obj.nVectors;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    scale = obj.scale;
    scaleByMagnitude = obj.scaleByMagnitude;
    autoScale = obj.autoScale;
    headSize = obj.headSize;
    headOn = obj.headOn;
    colorByMag = obj.colorByMag;
    useLegend = obj.useLegend;
    vectorColor = obj.vectorColor;
    colorTableName = obj.colorTableName;
    vectorOrigin = obj.vectorOrigin;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    limitsMode = obj.limitsMode;
    min = obj.min;
    max = obj.max;

    SelectAll();
}

// ****************************************************************************
// Method: VectorAttributes::~VectorAttributes
//
// Purpose: 
//   Destructor for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

VectorAttributes::~VectorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: VectorAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

VectorAttributes& 
VectorAttributes::operator = (const VectorAttributes &obj)
{
    if (this == &obj) return *this;
    useStride = obj.useStride;
    stride = obj.stride;
    nVectors = obj.nVectors;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    scale = obj.scale;
    scaleByMagnitude = obj.scaleByMagnitude;
    autoScale = obj.autoScale;
    headSize = obj.headSize;
    headOn = obj.headOn;
    colorByMag = obj.colorByMag;
    useLegend = obj.useLegend;
    vectorColor = obj.vectorColor;
    colorTableName = obj.colorTableName;
    vectorOrigin = obj.vectorOrigin;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    limitsMode = obj.limitsMode;
    min = obj.min;
    max = obj.max;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: VectorAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VectorAttributes::operator == (const VectorAttributes &obj) const
{
    // Create the return value
    return ((useStride == obj.useStride) &&
            (stride == obj.stride) &&
            (nVectors == obj.nVectors) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (scale == obj.scale) &&
            (scaleByMagnitude == obj.scaleByMagnitude) &&
            (autoScale == obj.autoScale) &&
            (headSize == obj.headSize) &&
            (headOn == obj.headOn) &&
            (colorByMag == obj.colorByMag) &&
            (useLegend == obj.useLegend) &&
            (vectorColor == obj.vectorColor) &&
            (colorTableName == obj.colorTableName) &&
            (vectorOrigin == obj.vectorOrigin) &&
            (minFlag == obj.minFlag) &&
            (maxFlag == obj.maxFlag) &&
            (limitsMode == obj.limitsMode) &&
            (min == obj.min) &&
            (max == obj.max));
}

// ****************************************************************************
// Method: VectorAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VectorAttributes::operator != (const VectorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: VectorAttributes::TypeName
//
// Purpose: 
//   Type name method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
VectorAttributes::TypeName() const
{
    return "VectorAttributes";
}

// ****************************************************************************
// Method: VectorAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VectorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const VectorAttributes *tmp = (const VectorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: VectorAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
VectorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new VectorAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: VectorAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
VectorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new VectorAttributes(*this);
    else
        retval = new VectorAttributes;

    return retval;
}

// ****************************************************************************
// Method: VectorAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
VectorAttributes::SelectAll()
{
    Select(0, (void *)&useStride);
    Select(1, (void *)&stride);
    Select(2, (void *)&nVectors);
    Select(3, (void *)&lineStyle);
    Select(4, (void *)&lineWidth);
    Select(5, (void *)&scale);
    Select(6, (void *)&scaleByMagnitude);
    Select(7, (void *)&autoScale);
    Select(8, (void *)&headSize);
    Select(9, (void *)&headOn);
    Select(10, (void *)&colorByMag);
    Select(11, (void *)&useLegend);
    Select(12, (void *)&vectorColor);
    Select(13, (void *)&colorTableName);
    Select(14, (void *)&vectorOrigin);
    Select(15, (void *)&minFlag);
    Select(16, (void *)&maxFlag);
    Select(17, (void *)&limitsMode);
    Select(18, (void *)&min);
    Select(19, (void *)&max);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VectorAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VectorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    VectorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for VectorAttributes.
    DataNode *node = new DataNode("VectorAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useStride", useStride));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nVectors", nVectors));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scale", scale));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleByMagnitude", scaleByMagnitude));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoScale", autoScale));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("headSize", headSize));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("headOn", headOn));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorByMag", colorByMag));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useLegend", useLegend));
    }

        DataNode *vectorColorNode = new DataNode("vectorColor");
        if(vectorColor.CreateNode(vectorColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(vectorColorNode);
        }
        else
            delete vectorColorNode;
    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("vectorOrigin", OriginType_ToString(vectorOrigin)));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("limitsMode", LimitsMode_ToString(limitsMode)));
    }

    if(completeSave || !FieldsEqual(18, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(19, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: VectorAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
VectorAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("VectorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useStride")) != 0)
        SetUseStride(node->AsBool());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("nVectors")) != 0)
        SetNVectors(node->AsInt());
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("scale")) != 0)
        SetScale(node->AsDouble());
    if((node = searchNode->GetNode("scaleByMagnitude")) != 0)
        SetScaleByMagnitude(node->AsBool());
    if((node = searchNode->GetNode("autoScale")) != 0)
        SetAutoScale(node->AsBool());
    if((node = searchNode->GetNode("headSize")) != 0)
        SetHeadSize(node->AsDouble());
    if((node = searchNode->GetNode("headOn")) != 0)
        SetHeadOn(node->AsBool());
    if((node = searchNode->GetNode("colorByMag")) != 0)
        SetColorByMag(node->AsBool());
    if((node = searchNode->GetNode("useLegend")) != 0)
        SetUseLegend(node->AsBool());
    if((node = searchNode->GetNode("vectorColor")) != 0)
        vectorColor.SetFromNode(node);
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
    if((node = searchNode->GetNode("vectorOrigin")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVectorOrigin(OriginType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            OriginType value;
            if(OriginType_FromString(node->AsString(), value))
                SetVectorOrigin(value);
        }
    }
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("limitsMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLimitsMode(LimitsMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LimitsMode value;
            if(LimitsMode_FromString(node->AsString(), value))
                SetLimitsMode(value);
        }
    }
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
VectorAttributes::SetUseStride(bool useStride_)
{
    useStride = useStride_;
    Select(0, (void *)&useStride);
}

void
VectorAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(1, (void *)&stride);
}

void
VectorAttributes::SetNVectors(int nVectors_)
{
    nVectors = nVectors_;
    Select(2, (void *)&nVectors);
}

void
VectorAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(3, (void *)&lineStyle);
}

void
VectorAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(4, (void *)&lineWidth);
}

void
VectorAttributes::SetScale(double scale_)
{
    scale = scale_;
    Select(5, (void *)&scale);
}

void
VectorAttributes::SetScaleByMagnitude(bool scaleByMagnitude_)
{
    scaleByMagnitude = scaleByMagnitude_;
    Select(6, (void *)&scaleByMagnitude);
}

void
VectorAttributes::SetAutoScale(bool autoScale_)
{
    autoScale = autoScale_;
    Select(7, (void *)&autoScale);
}

void
VectorAttributes::SetHeadSize(double headSize_)
{
    headSize = headSize_;
    Select(8, (void *)&headSize);
}

void
VectorAttributes::SetHeadOn(bool headOn_)
{
    headOn = headOn_;
    Select(9, (void *)&headOn);
}

void
VectorAttributes::SetColorByMag(bool colorByMag_)
{
    colorByMag = colorByMag_;
    Select(10, (void *)&colorByMag);
}

void
VectorAttributes::SetUseLegend(bool useLegend_)
{
    useLegend = useLegend_;
    Select(11, (void *)&useLegend);
}

void
VectorAttributes::SetVectorColor(const ColorAttribute &vectorColor_)
{
    vectorColor = vectorColor_;
    Select(12, (void *)&vectorColor);
}

void
VectorAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(13, (void *)&colorTableName);
}

void
VectorAttributes::SetVectorOrigin(VectorAttributes::OriginType vectorOrigin_)
{
    vectorOrigin = vectorOrigin_;
    Select(14, (void *)&vectorOrigin);
}

void
VectorAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(15, (void *)&minFlag);
}

void
VectorAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(16, (void *)&maxFlag);
}

void
VectorAttributes::SetLimitsMode(VectorAttributes::LimitsMode limitsMode_)
{
    limitsMode = limitsMode_;
    Select(17, (void *)&limitsMode);
}

void
VectorAttributes::SetMin(double min_)
{
    min = min_;
    Select(18, (void *)&min);
}

void
VectorAttributes::SetMax(double max_)
{
    max = max_;
    Select(19, (void *)&max);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
VectorAttributes::GetUseStride() const
{
    return useStride;
}

int
VectorAttributes::GetStride() const
{
    return stride;
}

int
VectorAttributes::GetNVectors() const
{
    return nVectors;
}

int
VectorAttributes::GetLineStyle() const
{
    return lineStyle;
}

int
VectorAttributes::GetLineWidth() const
{
    return lineWidth;
}

double
VectorAttributes::GetScale() const
{
    return scale;
}

bool
VectorAttributes::GetScaleByMagnitude() const
{
    return scaleByMagnitude;
}

bool
VectorAttributes::GetAutoScale() const
{
    return autoScale;
}

double
VectorAttributes::GetHeadSize() const
{
    return headSize;
}

bool
VectorAttributes::GetHeadOn() const
{
    return headOn;
}

bool
VectorAttributes::GetColorByMag() const
{
    return colorByMag;
}

bool
VectorAttributes::GetUseLegend() const
{
    return useLegend;
}

const ColorAttribute &
VectorAttributes::GetVectorColor() const
{
    return vectorColor;
}

ColorAttribute &
VectorAttributes::GetVectorColor()
{
    return vectorColor;
}

const std::string &
VectorAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
VectorAttributes::GetColorTableName()
{
    return colorTableName;
}

VectorAttributes::OriginType
VectorAttributes::GetVectorOrigin() const
{
    return OriginType(vectorOrigin);
}

bool
VectorAttributes::GetMinFlag() const
{
    return minFlag;
}

bool
VectorAttributes::GetMaxFlag() const
{
    return maxFlag;
}

VectorAttributes::LimitsMode
VectorAttributes::GetLimitsMode() const
{
    return LimitsMode(limitsMode);
}

double
VectorAttributes::GetMin() const
{
    return min;
}

double
VectorAttributes::GetMax() const
{
    return max;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
VectorAttributes::SelectVectorColor()
{
    Select(12, (void *)&vectorColor);
}

void
VectorAttributes::SelectColorTableName()
{
    Select(13, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VectorAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
VectorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Use stride";
        case 1:  return "Stride";
        case 2:  return "Num vectors";
        case 3:  return "Line Style";
        case 4:  return "Line Width";
        case 5:  return "Scale";
        case 6:  return "Scale by magnitude";
        case 7:  return "Auto scale";
        case 8:  return "Head size";
        case 9:  return "Draw head";
        case 10:  return "color by magnitude";
        case 11:  return "Legend";
        case 12:  return "color";
        case 13:  return "Color table";
        case 14:  return "Vector Origin";
        case 15:  return "Use min";
        case 16:  return "Use max";
        case 17:  return "Limits Mode";
        case 18:  return "Min";
        case 19:  return "Max";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VectorAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
VectorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_int;
        case 2:  return FieldType_int;
        case 3:  return FieldType_linestyle;
        case 4:  return FieldType_linewidth;
        case 5:  return FieldType_double;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_double;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_color;
        case 13:  return FieldType_colortable;
        case 14:  return FieldType_enum;
        case 15:  return FieldType_bool;
        case 16:  return FieldType_bool;
        case 17:  return FieldType_enum;
        case 18:  return FieldType_double;
        case 19:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: VectorAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
VectorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "int";
        case 2:  return "int";
        case 3:  return "linestyle";
        case 4:  return "linewidth";
        case 5:  return "double";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "double";
        case 9:  return "bool";
        case 10:  return "bool";
        case 11:  return "bool";
        case 12:  return "color";
        case 13:  return "colortable";
        case 14:  return "enum";
        case 15:  return "bool";
        case 16:  return "bool";
        case 17:  return "enum";
        case 18:  return "double";
        case 19:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VectorAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Mon Dec 27 10:47:02 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
VectorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const VectorAttributes &obj = *((const VectorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (useStride == obj.useStride);
        }
        break;
    case 1:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case 2:
        {  // new scope
        retval = (nVectors == obj.nVectors);
        }
        break;
    case 3:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 4:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 5:
        {  // new scope
        retval = (scale == obj.scale);
        }
        break;
    case 6:
        {  // new scope
        retval = (scaleByMagnitude == obj.scaleByMagnitude);
        }
        break;
    case 7:
        {  // new scope
        retval = (autoScale == obj.autoScale);
        }
        break;
    case 8:
        {  // new scope
        retval = (headSize == obj.headSize);
        }
        break;
    case 9:
        {  // new scope
        retval = (headOn == obj.headOn);
        }
        break;
    case 10:
        {  // new scope
        retval = (colorByMag == obj.colorByMag);
        }
        break;
    case 11:
        {  // new scope
        retval = (useLegend == obj.useLegend);
        }
        break;
    case 12:
        {  // new scope
        retval = (vectorColor == obj.vectorColor);
        }
        break;
    case 13:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    case 14:
        {  // new scope
        retval = (vectorOrigin == obj.vectorOrigin);
        }
        break;
    case 15:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case 16:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case 17:
        {  // new scope
        retval = (limitsMode == obj.limitsMode);
        }
        break;
    case 18:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case 19:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
VectorAttributes::ChangesRequireRecalculation(const VectorAttributes &obj)
{
    return ((useStride != obj.useStride) ||
            (stride != obj.stride) ||
            (nVectors != obj.nVectors));
}

