#include <PyVectorAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyVectorAttributes
//
// Purpose: 
//   Attributes for the vector plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Dec 27 10:47:31 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a VectorAttributes.
//
struct VectorAttributesObject
{
    PyObject_HEAD
    VectorAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewVectorAttributes();

static PyObject *
VectorAttributes_Notify(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_SetUseStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useStride in the object.
    obj->data->SetUseStride(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetUseStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseStride()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetStride(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

static PyObject *
VectorAttributes_SetNVectors(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nVectors in the object.
    obj->data->SetNVectors(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetNVectors(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNVectors()));
    return retval;
}

static PyObject *
VectorAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
VectorAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
VectorAttributes_SetScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scale in the object.
    obj->data->SetScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScale());
    return retval;
}

static PyObject *
VectorAttributes_SetScaleByMagnitude(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleByMagnitude in the object.
    obj->data->SetScaleByMagnitude(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetScaleByMagnitude(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleByMagnitude()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetAutoScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoScale in the object.
    obj->data->SetAutoScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetAutoScale(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoScale()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetHeadSize(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the headSize in the object.
    obj->data->SetHeadSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetHeadSize(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHeadSize());
    return retval;
}

static PyObject *
VectorAttributes_SetHeadOn(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the headOn in the object.
    obj->data->SetHeadOn(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetHeadOn(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHeadOn()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetColorByMag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorByMag in the object.
    obj->data->SetColorByMag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetColorByMag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetColorByMag()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetUseLegend(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useLegend in the object.
    obj->data->SetUseLegend(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetUseLegend(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseLegend()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetVectorColor(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the vectorColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetVectorColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetVectorColor(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the vectorColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *vectorColor = obj->data->GetVectorColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(vectorColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(vectorColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(vectorColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(vectorColor[3])));
    return retval;
}

static PyObject *
VectorAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
VectorAttributes_SetVectorOrigin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the vectorOrigin in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVectorOrigin(VectorAttributes::OriginType(ival));
    else
    {
        fprintf(stderr, "An invalid vectorOrigin value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Head, Middle, Tail.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetVectorOrigin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVectorOrigin()));
    return retval;
}

static PyObject *
VectorAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

static PyObject *
VectorAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(VectorAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

static PyObject *
VectorAttributes_SetMin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetMin(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

static PyObject *
VectorAttributes_SetMax(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VectorAttributes_GetMax(PyObject *self, PyObject *args)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}



static struct PyMethodDef VectorAttributes_methods[] = {
    {"Notify", VectorAttributes_Notify, METH_VARARGS},
    {"SetUseStride", VectorAttributes_SetUseStride, METH_VARARGS},
    {"GetUseStride", VectorAttributes_GetUseStride, METH_VARARGS},
    {"SetStride", VectorAttributes_SetStride, METH_VARARGS},
    {"GetStride", VectorAttributes_GetStride, METH_VARARGS},
    {"SetNVectors", VectorAttributes_SetNVectors, METH_VARARGS},
    {"GetNVectors", VectorAttributes_GetNVectors, METH_VARARGS},
    {"SetLineStyle", VectorAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", VectorAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", VectorAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", VectorAttributes_GetLineWidth, METH_VARARGS},
    {"SetScale", VectorAttributes_SetScale, METH_VARARGS},
    {"GetScale", VectorAttributes_GetScale, METH_VARARGS},
    {"SetScaleByMagnitude", VectorAttributes_SetScaleByMagnitude, METH_VARARGS},
    {"GetScaleByMagnitude", VectorAttributes_GetScaleByMagnitude, METH_VARARGS},
    {"SetAutoScale", VectorAttributes_SetAutoScale, METH_VARARGS},
    {"GetAutoScale", VectorAttributes_GetAutoScale, METH_VARARGS},
    {"SetHeadSize", VectorAttributes_SetHeadSize, METH_VARARGS},
    {"GetHeadSize", VectorAttributes_GetHeadSize, METH_VARARGS},
    {"SetHeadOn", VectorAttributes_SetHeadOn, METH_VARARGS},
    {"GetHeadOn", VectorAttributes_GetHeadOn, METH_VARARGS},
    {"SetColorByMag", VectorAttributes_SetColorByMag, METH_VARARGS},
    {"GetColorByMag", VectorAttributes_GetColorByMag, METH_VARARGS},
    {"SetUseLegend", VectorAttributes_SetUseLegend, METH_VARARGS},
    {"GetUseLegend", VectorAttributes_GetUseLegend, METH_VARARGS},
    {"SetVectorColor", VectorAttributes_SetVectorColor, METH_VARARGS},
    {"GetVectorColor", VectorAttributes_GetVectorColor, METH_VARARGS},
    {"SetColorTableName", VectorAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", VectorAttributes_GetColorTableName, METH_VARARGS},
    {"SetVectorOrigin", VectorAttributes_SetVectorOrigin, METH_VARARGS},
    {"GetVectorOrigin", VectorAttributes_GetVectorOrigin, METH_VARARGS},
    {"SetMinFlag", VectorAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", VectorAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", VectorAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", VectorAttributes_GetMaxFlag, METH_VARARGS},
    {"SetLimitsMode", VectorAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", VectorAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMin", VectorAttributes_SetMin, METH_VARARGS},
    {"GetMin", VectorAttributes_GetMin, METH_VARARGS},
    {"SetMax", VectorAttributes_SetMax, METH_VARARGS},
    {"GetMax", VectorAttributes_GetMax, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
VectorAttributes_dealloc(PyObject *v)
{
   VectorAttributesObject *obj = (VectorAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
VectorAttributes_compare(PyObject *v, PyObject *w)
{
    VectorAttributes *a = ((VectorAttributesObject *)v)->data;
    VectorAttributes *b = ((VectorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
VectorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "useStride") == 0)
        return VectorAttributes_GetUseStride(self, NULL);
    if(strcmp(name, "stride") == 0)
        return VectorAttributes_GetStride(self, NULL);
    if(strcmp(name, "nVectors") == 0)
        return VectorAttributes_GetNVectors(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return VectorAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return VectorAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "scale") == 0)
        return VectorAttributes_GetScale(self, NULL);
    if(strcmp(name, "scaleByMagnitude") == 0)
        return VectorAttributes_GetScaleByMagnitude(self, NULL);
    if(strcmp(name, "autoScale") == 0)
        return VectorAttributes_GetAutoScale(self, NULL);
    if(strcmp(name, "headSize") == 0)
        return VectorAttributes_GetHeadSize(self, NULL);
    if(strcmp(name, "headOn") == 0)
        return VectorAttributes_GetHeadOn(self, NULL);
    if(strcmp(name, "colorByMag") == 0)
        return VectorAttributes_GetColorByMag(self, NULL);
    if(strcmp(name, "useLegend") == 0)
        return VectorAttributes_GetUseLegend(self, NULL);
    if(strcmp(name, "vectorColor") == 0)
        return VectorAttributes_GetVectorColor(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return VectorAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "vectorOrigin") == 0)
        return VectorAttributes_GetVectorOrigin(self, NULL);
    if(strcmp(name, "Head") == 0)
        return PyInt_FromLong(long(VectorAttributes::Head));
    else if(strcmp(name, "Middle") == 0)
        return PyInt_FromLong(long(VectorAttributes::Middle));
    else if(strcmp(name, "Tail") == 0)
        return PyInt_FromLong(long(VectorAttributes::Tail));

    if(strcmp(name, "minFlag") == 0)
        return VectorAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return VectorAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return VectorAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(VectorAttributes::OriginalData));
    else if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(VectorAttributes::CurrentPlot));

    if(strcmp(name, "min") == 0)
        return VectorAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return VectorAttributes_GetMax(self, NULL);

    return Py_FindMethod(VectorAttributes_methods, self, name);
}

static int
VectorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "useStride") == 0)
        retval = (VectorAttributes_SetUseStride(self, tuple) != NULL);
    else if(strcmp(name, "stride") == 0)
        retval = (VectorAttributes_SetStride(self, tuple) != NULL);
    else if(strcmp(name, "nVectors") == 0)
        retval = (VectorAttributes_SetNVectors(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (VectorAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (VectorAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "scale") == 0)
        retval = (VectorAttributes_SetScale(self, tuple) != NULL);
    else if(strcmp(name, "scaleByMagnitude") == 0)
        retval = (VectorAttributes_SetScaleByMagnitude(self, tuple) != NULL);
    else if(strcmp(name, "autoScale") == 0)
        retval = (VectorAttributes_SetAutoScale(self, tuple) != NULL);
    else if(strcmp(name, "headSize") == 0)
        retval = (VectorAttributes_SetHeadSize(self, tuple) != NULL);
    else if(strcmp(name, "headOn") == 0)
        retval = (VectorAttributes_SetHeadOn(self, tuple) != NULL);
    else if(strcmp(name, "colorByMag") == 0)
        retval = (VectorAttributes_SetColorByMag(self, tuple) != NULL);
    else if(strcmp(name, "useLegend") == 0)
        retval = (VectorAttributes_SetUseLegend(self, tuple) != NULL);
    else if(strcmp(name, "vectorColor") == 0)
        retval = (VectorAttributes_SetVectorColor(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (VectorAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "vectorOrigin") == 0)
        retval = (VectorAttributes_SetVectorOrigin(self, tuple) != NULL);
    else if(strcmp(name, "minFlag") == 0)
        retval = (VectorAttributes_SetMinFlag(self, tuple) != NULL);
    else if(strcmp(name, "maxFlag") == 0)
        retval = (VectorAttributes_SetMaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "limitsMode") == 0)
        retval = (VectorAttributes_SetLimitsMode(self, tuple) != NULL);
    else if(strcmp(name, "min") == 0)
        retval = (VectorAttributes_SetMin(self, tuple) != NULL);
    else if(strcmp(name, "max") == 0)
        retval = (VectorAttributes_SetMax(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
VectorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)v;

    if(obj->data->GetUseStride())
        fprintf(fp, "useStride = 1\n");
    else
        fprintf(fp, "useStride = 0\n");
    fprintf(fp, "stride = %d\n", obj->data->GetStride());
    fprintf(fp, "nVectors = %d\n", obj->data->GetNVectors());
    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    fprintf(fp, "scale = %g\n", obj->data->GetScale());
    if(obj->data->GetScaleByMagnitude())
        fprintf(fp, "scaleByMagnitude = 1\n");
    else
        fprintf(fp, "scaleByMagnitude = 0\n");
    if(obj->data->GetAutoScale())
        fprintf(fp, "autoScale = 1\n");
    else
        fprintf(fp, "autoScale = 0\n");
    fprintf(fp, "headSize = %g\n", obj->data->GetHeadSize());
    if(obj->data->GetHeadOn())
        fprintf(fp, "headOn = 1\n");
    else
        fprintf(fp, "headOn = 0\n");
    if(obj->data->GetColorByMag())
        fprintf(fp, "colorByMag = 1\n");
    else
        fprintf(fp, "colorByMag = 0\n");
    if(obj->data->GetUseLegend())
        fprintf(fp, "useLegend = 1\n");
    else
        fprintf(fp, "useLegend = 0\n");
    const unsigned char *vectorColor = obj->data->GetVectorColor().GetColor();
    fprintf(fp, "vectorColor = (%d, %d, %d, %d)\n", int(vectorColor[0]), int(vectorColor[1]), int(vectorColor[2]), int(vectorColor[3]));
    fprintf(fp, "colorTableName = \"%s\"\n", obj->data->GetColorTableName().c_str());
    const char *vectorOrigin_names = "Head, Middle, Tail";
    if(obj->data->GetVectorOrigin() == VectorAttributes::Head)
        fprintf(fp, "vectorOrigin = Head  # %s\n", vectorOrigin_names);
    else if(obj->data->GetVectorOrigin() == VectorAttributes::Middle)
        fprintf(fp, "vectorOrigin = Middle  # %s\n", vectorOrigin_names);
    else
        fprintf(fp, "vectorOrigin = Tail  # %s\n", vectorOrigin_names);

    if(obj->data->GetMinFlag())
        fprintf(fp, "minFlag = 1\n");
    else
        fprintf(fp, "minFlag = 0\n");
    if(obj->data->GetMaxFlag())
        fprintf(fp, "maxFlag = 1\n");
    else
        fprintf(fp, "maxFlag = 0\n");
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    if(obj->data->GetLimitsMode() == VectorAttributes::OriginalData)
        fprintf(fp, "limitsMode = OriginalData  # %s\n", limitsMode_names);
    else
        fprintf(fp, "limitsMode = CurrentPlot  # %s\n", limitsMode_names);

    fprintf(fp, "min = %g\n", obj->data->GetMin());
    fprintf(fp, "max = %g\n", obj->data->GetMax());

    return 0;
}

#include <snprintf.h>
PyObject *
PyVectorAttributes_StringRepresentation(const VectorAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetUseStride())
        SNPRINTF(tmpStr, 1000, "useStride = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useStride = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "stride = %d\n", atts->GetStride());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "nVectors = %d\n", atts->GetNVectors());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineStyle = %d\n", atts->GetLineStyle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "scale = %g\n", atts->GetScale());
    str += tmpStr;
    if(atts->GetScaleByMagnitude())
        SNPRINTF(tmpStr, 1000, "scaleByMagnitude = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "scaleByMagnitude = 0\n");
    str += tmpStr;
    if(atts->GetAutoScale())
        SNPRINTF(tmpStr, 1000, "autoScale = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "autoScale = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "headSize = %g\n", atts->GetHeadSize());
    str += tmpStr;
    if(atts->GetHeadOn())
        SNPRINTF(tmpStr, 1000, "headOn = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "headOn = 0\n");
    str += tmpStr;
    if(atts->GetColorByMag())
        SNPRINTF(tmpStr, 1000, "colorByMag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "colorByMag = 0\n");
    str += tmpStr;
    if(atts->GetUseLegend())
        SNPRINTF(tmpStr, 1000, "useLegend = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useLegend = 0\n");
    str += tmpStr;
    const unsigned char *vectorColor = atts->GetVectorColor().GetColor();
    SNPRINTF(tmpStr, 1000, "vectorColor = (%d, %d, %d, %d)\n", int(vectorColor[0]), int(vectorColor[1]), int(vectorColor[2]), int(vectorColor[3]));
    str += tmpStr;
   SNPRINTF(tmpStr, 1000, "colorTableName = \"%s\"\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    const char *vectorOrigin_names = "Head, Middle, Tail";
    if(atts->GetVectorOrigin() == VectorAttributes::Head)
        {
             SNPRINTF(tmpStr, 1000, "vectorOrigin = Head  # %s\n", vectorOrigin_names);
             str += tmpStr;
        }
    else if(atts->GetVectorOrigin() == VectorAttributes::Middle)
        {
             SNPRINTF(tmpStr, 1000, "vectorOrigin = Middle  # %s\n", vectorOrigin_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "vectorOrigin = Tail  # %s\n", vectorOrigin_names);
             str += tmpStr;
        }

    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "minFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "minFlag = 0\n");
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "maxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maxFlag = 0\n");
    str += tmpStr;
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    if(atts->GetLimitsMode() == VectorAttributes::OriginalData)
        {
             SNPRINTF(tmpStr, 1000, "limitsMode = OriginalData  # %s\n", limitsMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "limitsMode = CurrentPlot  # %s\n", limitsMode_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "min = %g\n", atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "max = %g\n", atts->GetMax());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
VectorAttributes_str(PyObject *v)
{
    VectorAttributesObject *obj = (VectorAttributesObject *)v;
    return PyVectorAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *VectorAttributes_Purpose = "Attributes for the vector plot";

//
// The type description structure
//
static PyTypeObject VectorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "VectorAttributes",                    // tp_name
    sizeof(VectorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)VectorAttributes_dealloc,  // tp_dealloc
    (printfunc)VectorAttributes_print,     // tp_print
    (getattrfunc)VectorAttributes_getattr, // tp_getattr
    (setattrfunc)VectorAttributes_setattr, // tp_setattr
    (cmpfunc)VectorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)VectorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    VectorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static VectorAttributes *defaultAtts = 0;

static PyObject *
NewVectorAttributes()
{
    VectorAttributesObject *newObject;
    newObject = PyObject_NEW(VectorAttributesObject, &VectorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new VectorAttributes(*defaultAtts);
    else
        newObject->data = new VectorAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapVectorAttributes(const VectorAttributes *attr)
{
    VectorAttributesObject *newObject;
    newObject = PyObject_NEW(VectorAttributesObject, &VectorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (VectorAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
VectorAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewVectorAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef VectorAttributesMethods[] = {
    {"VectorAttributes", VectorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *VectorAttributesObserver = 0;
static bool VectorAttributesEnableLogging = true;

static void
PyVectorAttributes_WriteLog(Subject *subj, void *data)
{
    VectorAttributes *atts = (VectorAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!VectorAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# VectorAttributes_WriteLog()\n");
}

void
PyVectorAttributes_StartUp(VectorAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyVectorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(VectorAttributesObserver == 0)
    {
        VectorAttributesObserver = new ObserverToCallback(subj,
            PyVectorAttributes_WriteLog, (void *)logFile);
    }

    VectorAttributesEnableLogging = true;
}

void
PyVectorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete VectorAttributesObserver;
    VectorAttributesObserver = 0;
}

PyMethodDef *
PyVectorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return VectorAttributesMethods;
}

bool
PyVectorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &VectorAttributesType);
}

VectorAttributes *
PyVectorAttributes_FromPyObject(PyObject *obj)
{
    VectorAttributesObject *obj2 = (VectorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyVectorAttributes_NewPyObject()
{
    return NewVectorAttributes();
}

PyObject *
PyVectorAttributes_WrapPyObject(const VectorAttributes *attr)
{
    return WrapVectorAttributes(attr);
}

void
PyVectorAttributes_SetLogging(bool val)
{
    VectorAttributesEnableLogging = val;
}

void
PyVectorAttributes_SetDefaults(const VectorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new VectorAttributes(*atts);
}

