// ************************************************************************* //
//  File: TruecolorViewerPluginInfo.C
// ************************************************************************* //

#include <TruecolorPluginInfo.h>
#include <avtTruecolorPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Truecolor_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Truecolor plot.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    TruecolorViewerPluginInfo::InitializeGlobalObjects();
    return new TruecolorViewerPluginInfo;
}

//
// Storage for static data elements.
//
TruecolorAttributes *TruecolorViewerPluginInfo::clientAtts = NULL;
TruecolorAttributes *TruecolorViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TruecolorViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************
void
TruecolorViewerPluginInfo::InitializeGlobalObjects()
{
    TruecolorViewerPluginInfo::clientAtts  = new TruecolorAttributes;
    TruecolorViewerPluginInfo::defaultAtts = new TruecolorAttributes;
}

// ****************************************************************************
//  Method: TruecolorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

AttributeSubject *
TruecolorViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TruecolorViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

AttributeSubject *
TruecolorViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TruecolorViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

void
TruecolorViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TruecolorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TruecolorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

void
TruecolorViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TruecolorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TruecolorViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

avtPlot *
TruecolorViewerPluginInfo::AllocAvtPlot()
{
    return new avtTruecolorPlot;
}

// ****************************************************************************
//  Method: TruecolorViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

void
TruecolorViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(TruecolorAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: TruecolorViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

int
TruecolorViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}

