// ************************************************************************* //
//                        TruecolorScriptingPluginInfo.C
// ************************************************************************* //
#include <TruecolorPluginInfo.h>
#include <PyTruecolorAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Truecolor_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Truecolor plot.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new TruecolorScriptingPluginInfo;
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
TruecolorScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyTruecolorAttributes_StartUp((TruecolorAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void *
TruecolorScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTruecolorAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Truecolor plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
TruecolorScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTruecolorAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
TruecolorScriptingPluginInfo::SetLogging(bool val)
{
    PyTruecolorAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
TruecolorScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTruecolorAttributes_SetDefaults((const TruecolorAttributes *)atts);
}
