// ************************************************************************* //
//                               TruecolorPluginInfo.h                            //
// ************************************************************************* //

#ifndef TRUECOLOR_PLUGIN_INFO_H
#define TRUECOLOR_PLUGIN_INFO_H
#include <PlotPluginInfo.h>
#include <plot_plugin_exports.h>

class TruecolorAttributes;

// ****************************************************************************
//  Class: TruecolorPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about a Truecolor
//    plot plugin.  The information is broken up into five classes since
//    portions of it are only relevant to particular components within
//    visit.  There is the general information which all the components
//    are interested in, the gui information which the gui is interested in,
//    the viewer information which the viewer is interested in, the
//    engine information which the engine is interested in, and finally a.
//    scripting portion that enables the Python VisIt extension to use the
//    plugin.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

class TruecolorGeneralPluginInfo: public virtual GeneralPlotPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
};

class TruecolorCommonPluginInfo : public virtual CommonPlotPluginInfo, public virtual TruecolorGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class TruecolorGUIPluginInfo: public virtual GUIPlotPluginInfo, public virtual TruecolorCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual int GetVariableTypes() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
};

class TruecolorViewerPluginInfo: public virtual ViewerPlotPluginInfo, public virtual TruecolorCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual avtPlot *AllocAvtPlot();

    virtual void InitializePlotAtts(AttributeSubject *atts,
        const avtDatabaseMetaData *md,
        const char *variableName);
    virtual int GetVariableTypes() const;

    static void InitializeGlobalObjects();
  private:
    static TruecolorAttributes *defaultAtts;
    static TruecolorAttributes *clientAtts;
};

class TruecolorEnginePluginInfo: public virtual EnginePlotPluginInfo, public virtual TruecolorCommonPluginInfo
{
  public:
    virtual avtPlot *AllocAvtPlot();
};

class TruecolorScriptingPluginInfo : public virtual ScriptingPlotPluginInfo, public virtual TruecolorCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
