// ************************************************************************* //
//  File: TruecolorPluginInfo.C
// ************************************************************************* //

#include <TruecolorPluginInfo.h>
#include <TruecolorAttributes.h>

#if defined(__APPLE__)
#define GetGeneralInfo Truecolor_GetGeneralInfo
#endif

// ****************************************************************************
//  Function:  GetGeneralInfo
//
//  Purpose:
//    Return a new GeneralPluginInfo for the Truecolor plot.
//
//  Programmer:  wojtan2 -- generated by xml2info
//  Creation:    Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************
extern "C" GeneralPlotPluginInfo* GetGeneralInfo()
{
    return new TruecolorGeneralPluginInfo;
}

// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

char *
TruecolorGeneralPluginInfo::GetName() const
{
    return "Truecolor";
}

// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

char *
TruecolorGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

char *
TruecolorGeneralPluginInfo::GetID() const
{
    return "Truecolor_1.0";
}
// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

bool
TruecolorGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
