// ************************************************************************* //
//  File: TruecolorGUIPluginInfo.C
// ************************************************************************* //

#include <TruecolorPluginInfo.h>
#include <TruecolorAttributes.h>
#include <QvisTruecolorPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Truecolor_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Truecolor plot.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new TruecolorGUIPluginInfo;
}

// ****************************************************************************
//  Method: TruecolorGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

const char *
TruecolorGUIPluginInfo::GetMenuName() const
{
    return "Truecolor";
}


// ****************************************************************************
// Method: TruecolorGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

int
TruecolorGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}

// ****************************************************************************
//  Method: TruecolorGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: wojtan2 -- generated by xml2info
//  Creation:   Tue Jun 15 11:11:13 PDT 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
TruecolorGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisTruecolorPlotWindow(type, (TruecolorAttributes *)attr,
        "Truecolor plot attributes", "Truecolor plot", notepad);
}
