#include <PyTruecolorAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyTruecolorAttributes
//
// Purpose: 
//   Truecolor plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Jun 15 11:11:05 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a TruecolorAttributes.
//
struct TruecolorAttributesObject
{
    PyObject_HEAD
    TruecolorAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewTruecolorAttributes();

static PyObject *
TruecolorAttributes_Notify(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TruecolorAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TruecolorAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}



static struct PyMethodDef TruecolorAttributes_methods[] = {
    {"Notify", TruecolorAttributes_Notify, METH_VARARGS},
    {"SetOpacity", TruecolorAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", TruecolorAttributes_GetOpacity, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TruecolorAttributes_dealloc(PyObject *v)
{
   TruecolorAttributesObject *obj = (TruecolorAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
TruecolorAttributes_compare(PyObject *v, PyObject *w)
{
    TruecolorAttributes *a = ((TruecolorAttributesObject *)v)->data;
    TruecolorAttributes *b = ((TruecolorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
TruecolorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "opacity") == 0)
        return TruecolorAttributes_GetOpacity(self, NULL);

    return Py_FindMethod(TruecolorAttributes_methods, self, name);
}

static int
TruecolorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "opacity") == 0)
        retval = (TruecolorAttributes_SetOpacity(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
TruecolorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)v;

    fprintf(fp, "opacity = %g\n", obj->data->GetOpacity());

    return 0;
}

#include <snprintf.h>
PyObject *
PyTruecolorAttributes_StringRepresentation(const TruecolorAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "opacity = %g\n", atts->GetOpacity());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
TruecolorAttributes_str(PyObject *v)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)v;
    return PyTruecolorAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *TruecolorAttributes_Purpose = "Truecolor plot";

//
// The type description structure
//
static PyTypeObject TruecolorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TruecolorAttributes",                    // tp_name
    sizeof(TruecolorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TruecolorAttributes_dealloc,  // tp_dealloc
    (printfunc)TruecolorAttributes_print,     // tp_print
    (getattrfunc)TruecolorAttributes_getattr, // tp_getattr
    (setattrfunc)TruecolorAttributes_setattr, // tp_setattr
    (cmpfunc)TruecolorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TruecolorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TruecolorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TruecolorAttributes *defaultAtts = 0;

static PyObject *
NewTruecolorAttributes()
{
    TruecolorAttributesObject *newObject;
    newObject = PyObject_NEW(TruecolorAttributesObject, &TruecolorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new TruecolorAttributes(*defaultAtts);
    else
        newObject->data = new TruecolorAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapTruecolorAttributes(const TruecolorAttributes *attr)
{
    TruecolorAttributesObject *newObject;
    newObject = PyObject_NEW(TruecolorAttributesObject, &TruecolorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TruecolorAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TruecolorAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewTruecolorAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TruecolorAttributesMethods[] = {
    {"TruecolorAttributes", TruecolorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TruecolorAttributesObserver = 0;
static bool TruecolorAttributesEnableLogging = true;

static void
PyTruecolorAttributes_WriteLog(Subject *subj, void *data)
{
    TruecolorAttributes *atts = (TruecolorAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!TruecolorAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# TruecolorAttributes_WriteLog()\n");
}

void
PyTruecolorAttributes_StartUp(TruecolorAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyTruecolorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TruecolorAttributesObserver == 0)
    {
        TruecolorAttributesObserver = new ObserverToCallback(subj,
            PyTruecolorAttributes_WriteLog, (void *)logFile);
    }

    TruecolorAttributesEnableLogging = true;
}

void
PyTruecolorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TruecolorAttributesObserver;
    TruecolorAttributesObserver = 0;
}

PyMethodDef *
PyTruecolorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TruecolorAttributesMethods;
}

bool
PyTruecolorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TruecolorAttributesType);
}

TruecolorAttributes *
PyTruecolorAttributes_FromPyObject(PyObject *obj)
{
    TruecolorAttributesObject *obj2 = (TruecolorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTruecolorAttributes_NewPyObject()
{
    return NewTruecolorAttributes();
}

PyObject *
PyTruecolorAttributes_WrapPyObject(const TruecolorAttributes *attr)
{
    return WrapTruecolorAttributes(attr);
}

void
PyTruecolorAttributes_SetLogging(bool val)
{
    TruecolorAttributesEnableLogging = val;
}

void
PyTruecolorAttributes_SetDefaults(const TruecolorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TruecolorAttributes(*atts);
}

