// ************************************************************************* //
//                              avtTopologyFilter.h                          //
// ************************************************************************* //

#ifndef AVT_Topology_FILTER_H
#define AVT_Topology_FILTER_H

#include <avtDataTreeStreamer.h>

class vtkCell;
class vtkContourFilter;
class vtkDataArray;
class vtkIdList;

// ****************************************************************************
//  Class: avtTopologyFilter
//
//  Purpose:
//      This operator is the implied operator associated with an Topology plot.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Thu Jun 26 15:59:09 PST 2003
//
// ****************************************************************************

class avtTopologyFilter : public avtDataTreeStreamer
{
  public:
    static const string labelNames[4];
      
                              avtTopologyFilter();
    virtual                  ~avtTopologyFilter();

    virtual const char       *GetType(void)   { return "avtTopologyFilter"; };
    virtual const char       *GetDescription(void)
                                  { return "Finding Topology"; };

    void              SetTolerance(double t)   { tolerance  =  t; }
    void              SetHitpercent(double hp) { hitpercent = hp; }

    virtual void              ReleaseData();

  protected:
    double tolerance;
    double hitpercent;
    
    vtkContourFilter *cf;
    
    virtual avtDataTree_p     ExecuteDataTree(vtkDataSet *, int, std::string);
    virtual void              RefashionDataObjectInfo(void);
    
    vtkDataArray             *GetGradient(vtkDataSet *, vtkDataArray *);

    float                     EvaluateComponent(float, float, float, float,
                                                float, float, float, 
                                                vtkDataSet *, vtkDataArray *,
                                                vtkIdList *);    
    
    float                     EvaluateValue(float, float, float, vtkDataSet *,
                                            vtkDataArray *,vtkIdList *,bool &);

    bool                      GetLocalGradient(int, vtkDataSet *,
                                               vtkDataArray *, float[3], int);
};


#endif
