// ************************************************************************* //
//  File: TopologyViewerPluginInfo.C
// ************************************************************************* //

#include <TopologyPluginInfo.h>
#include <avtTopologyPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Topology_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Topology plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    TopologyViewerPluginInfo::InitializeGlobalObjects();
    return new TopologyViewerPluginInfo;
}

//
// Storage for static data elements.
//
TopologyAttributes *TopologyViewerPluginInfo::clientAtts = NULL;
TopologyAttributes *TopologyViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TopologyViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************
void
TopologyViewerPluginInfo::InitializeGlobalObjects()
{
    TopologyViewerPluginInfo::clientAtts  = new TopologyAttributes;
    TopologyViewerPluginInfo::defaultAtts = new TopologyAttributes;
}

// ****************************************************************************
//  Method: TopologyViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************

AttributeSubject *
TopologyViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TopologyViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************

AttributeSubject *
TopologyViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TopologyViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************

void
TopologyViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TopologyAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TopologyViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************

void
TopologyViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TopologyAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TopologyViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************

avtPlot *
TopologyViewerPluginInfo::AllocAvtPlot()
{
    return new avtTopologyPlot;
}

// ****************************************************************************
//  Method: TopologyViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************

void
TopologyViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(TopologyAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: TopologyViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
TopologyViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}


// ****************************************************************************
//  Method: TopologyViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:59 PST 2004
//
// ****************************************************************************

#include <Topology.xpm>
const char **
TopologyViewerPluginInfo::XPMIconData() const
{
    return Topology_xpm;
}
