// ************************************************************************* //
//                        TopologyScriptingPluginInfo.C
// ************************************************************************* //
#include <TopologyPluginInfo.h>
#include <PyTopologyAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Makefile_GetScriptingInfo
#endif

#if defined(__APPLE__)
#define GetScriptingInfo Topology_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Topology plot.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new TopologyScriptingPluginInfo;
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
TopologyScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyTopologyAttributes_StartUp((TopologyAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void *
TopologyScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTopologyAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Topology plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TopologyScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTopologyAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
TopologyScriptingPluginInfo::SetLogging(bool val)
{
    PyTopologyAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
TopologyScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTopologyAttributes_SetDefaults((const TopologyAttributes *)atts);
}
