// ************************************************************************* //
//  File: TopologyGUIPluginInfo.C
// ************************************************************************* //

#include <TopologyPluginInfo.h>
#include <TopologyAttributes.h>
#include <QvisTopologyPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Makefile_GetGUIInfo
#endif

#if defined(__APPLE__)
#define GetGUIInfo Topology_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Topology plot.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new TopologyGUIPluginInfo;
}

// ****************************************************************************
//  Method: TopologyGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// ****************************************************************************

const char *
TopologyGUIPluginInfo::GetMenuName() const
{
    return "Topology";
}


// ****************************************************************************
// Method: TopologyGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
TopologyGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}

// ****************************************************************************
//  Method: TopologyGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
TopologyGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisTopologyPlotWindow(type, (TopologyAttributes *)attr,
        "Topology plot attributes", "Topology plot", notepad);
}

// ****************************************************************************
//  Method: TopologyGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// ****************************************************************************

#include <Topology.xpm>
const char **
TopologyGUIPluginInfo::XPMIconData() const
{
    return Topology_xpm;
}
