package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttributeList;

// ****************************************************************************
// Class: TopologyAttributes
//
// Purpose:
//    This class contains the plot attributes for the topology plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:08:05 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class TopologyAttributes extends AttributeSubject implements Plugin
{
    public TopologyAttributes()
    {
        super(9);

        lineWidth = 2;
        lineStyle = 0;
        multiColor = new ColorAttributeList();
        minOpacity = 1;
        minPlateauOpacity = 1;
        maxPlateauOpacity = 1;
        maxOpacity = 1;
        tolerance = 1e-06;
        hitpercent = 0;
    }

    public TopologyAttributes(TopologyAttributes obj)
    {
        super(9);

        lineWidth = obj.lineWidth;
        lineStyle = obj.lineStyle;
        multiColor = new ColorAttributeList(obj.multiColor);
        minOpacity = obj.minOpacity;
        minPlateauOpacity = obj.minPlateauOpacity;
        maxPlateauOpacity = obj.maxPlateauOpacity;
        maxOpacity = obj.maxOpacity;
        tolerance = obj.tolerance;
        hitpercent = obj.hitpercent;

        SelectAll();
    }

    public boolean equals(TopologyAttributes obj)
    {
        // Create the return value
        return ((lineWidth == obj.lineWidth) &&
                (lineStyle == obj.lineStyle) &&
                (multiColor == obj.multiColor) &&
                (minOpacity == obj.minOpacity) &&
                (minPlateauOpacity == obj.minPlateauOpacity) &&
                (maxPlateauOpacity == obj.maxPlateauOpacity) &&
                (maxOpacity == obj.maxOpacity) &&
                (tolerance == obj.tolerance) &&
                (hitpercent == obj.hitpercent));
    }

    public String GetName() { return "Topology"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(0);
    }

    public void SetLineStyle(int lineStyle_)
    {
        lineStyle = lineStyle_;
        Select(1);
    }

    public void SetMultiColor(ColorAttributeList multiColor_)
    {
        multiColor = multiColor_;
        Select(2);
    }

    public void SetMinOpacity(double minOpacity_)
    {
        minOpacity = minOpacity_;
        Select(3);
    }

    public void SetMinPlateauOpacity(double minPlateauOpacity_)
    {
        minPlateauOpacity = minPlateauOpacity_;
        Select(4);
    }

    public void SetMaxPlateauOpacity(double maxPlateauOpacity_)
    {
        maxPlateauOpacity = maxPlateauOpacity_;
        Select(5);
    }

    public void SetMaxOpacity(double maxOpacity_)
    {
        maxOpacity = maxOpacity_;
        Select(6);
    }

    public void SetTolerance(double tolerance_)
    {
        tolerance = tolerance_;
        Select(7);
    }

    public void SetHitpercent(double hitpercent_)
    {
        hitpercent = hitpercent_;
        Select(8);
    }

    // Property getting methods
    public int                GetLineWidth() { return lineWidth; }
    public int                GetLineStyle() { return lineStyle; }
    public ColorAttributeList GetMultiColor() { return multiColor; }
    public double             GetMinOpacity() { return minOpacity; }
    public double             GetMinPlateauOpacity() { return minPlateauOpacity; }
    public double             GetMaxPlateauOpacity() { return maxPlateauOpacity; }
    public double             GetMaxOpacity() { return maxOpacity; }
    public double             GetTolerance() { return tolerance; }
    public double             GetHitpercent() { return hitpercent; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(1, buf))
            buf.WriteInt(lineStyle);
        if(WriteSelect(2, buf))
            multiColor.Write(buf);
        if(WriteSelect(3, buf))
            buf.WriteDouble(minOpacity);
        if(WriteSelect(4, buf))
            buf.WriteDouble(minPlateauOpacity);
        if(WriteSelect(5, buf))
            buf.WriteDouble(maxPlateauOpacity);
        if(WriteSelect(6, buf))
            buf.WriteDouble(maxOpacity);
        if(WriteSelect(7, buf))
            buf.WriteDouble(tolerance);
        if(WriteSelect(8, buf))
            buf.WriteDouble(hitpercent);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetLineWidth(buf.ReadInt());
                break;
            case 1:
                SetLineStyle(buf.ReadInt());
                break;
            case 2:
                multiColor.Read(buf);
                Select(2);
                break;
            case 3:
                SetMinOpacity(buf.ReadDouble());
                break;
            case 4:
                SetMinPlateauOpacity(buf.ReadDouble());
                break;
            case 5:
                SetMaxPlateauOpacity(buf.ReadDouble());
                break;
            case 6:
                SetMaxOpacity(buf.ReadDouble());
                break;
            case 7:
                SetTolerance(buf.ReadDouble());
                break;
            case 8:
                SetHitpercent(buf.ReadDouble());
                break;
            }
        }
    }


    // Attributes
    private int                lineWidth;
    private int                lineStyle;
    private ColorAttributeList multiColor;
    private double             minOpacity;
    private double             minPlateauOpacity;
    private double             maxPlateauOpacity;
    private double             maxOpacity;
    private double             tolerance;
    private double             hitpercent;
}

