#ifndef TOPOLOGYATTRIBUTES_H
#define TOPOLOGYATTRIBUTES_H
#include <AttributeSubject.h>
#include <ColorAttributeList.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Class: TopologyAttributes
//
// Purpose:
//    This class contains the plot attributes for the topology plot
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class TopologyAttributes : public AttributeSubject
{
public:
    TopologyAttributes();
    TopologyAttributes(const TopologyAttributes &obj);
    virtual ~TopologyAttributes();

    virtual void operator = (const TopologyAttributes &obj);
    virtual bool operator == (const TopologyAttributes &obj) const;
    virtual bool operator != (const TopologyAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectMultiColor();

    // Property setting methods
    void SetLineWidth(int lineWidth_);
    void SetLineStyle(int lineStyle_);
    void SetMultiColor(const ColorAttributeList &multiColor_);
    void SetMinOpacity(double minOpacity_);
    void SetMinPlateauOpacity(double minPlateauOpacity_);
    void SetMaxPlateauOpacity(double maxPlateauOpacity_);
    void SetMaxOpacity(double maxOpacity_);
    void SetTolerance(double tolerance_);
    void SetHitpercent(double hitpercent_);

    // Property getting methods
    int                      GetLineWidth() const;
    int                      GetLineStyle() const;
    const ColorAttributeList &GetMultiColor() const;
          ColorAttributeList &GetMultiColor();
    double                   GetMinOpacity() const;
    double                   GetMinPlateauOpacity() const;
    double                   GetMaxPlateauOpacity() const;
    double                   GetMaxOpacity() const;
    double                   GetTolerance() const;
    double                   GetHitpercent() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    bool ChangesRequireRecalculation(const TopologyAttributes &obj);
private:
    int                lineWidth;
    int                lineStyle;
    ColorAttributeList multiColor;
    double             minOpacity;
    double             minPlateauOpacity;
    double             maxPlateauOpacity;
    double             maxOpacity;
    double             tolerance;
    double             hitpercent;
};

#endif
