#include <TopologyAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: TopologyAttributes::TopologyAttributes
//
// Purpose: 
//   Constructor for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

TopologyAttributes::TopologyAttributes() : AttributeSubject("iiadddddd")
{
    lineWidth = 2;
    lineStyle = 0;
    multiColor.AddColorAttribute(ColorAttribute(255,0,0));
    multiColor.AddColorAttribute(ColorAttribute(0,255,0));
    multiColor.AddColorAttribute(ColorAttribute(0,0,255));
    multiColor.AddColorAttribute(ColorAttribute(0,255,255));
    minOpacity = 1;
    minPlateauOpacity = 1;
    maxPlateauOpacity = 1;
    maxOpacity = 1;
    tolerance = 1e-06;
    hitpercent = 0;
}

// ****************************************************************************
// Method: TopologyAttributes::TopologyAttributes
//
// Purpose: 
//   Copy constructor for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

TopologyAttributes::TopologyAttributes(const TopologyAttributes &obj) : AttributeSubject("iiadddddd")
{
    lineWidth = obj.lineWidth;
    lineStyle = obj.lineStyle;
    multiColor = obj.multiColor;
    minOpacity = obj.minOpacity;
    minPlateauOpacity = obj.minPlateauOpacity;
    maxPlateauOpacity = obj.maxPlateauOpacity;
    maxOpacity = obj.maxOpacity;
    tolerance = obj.tolerance;
    hitpercent = obj.hitpercent;

    SelectAll();
}

// ****************************************************************************
// Method: TopologyAttributes::~TopologyAttributes
//
// Purpose: 
//   Destructor for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

TopologyAttributes::~TopologyAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: TopologyAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
TopologyAttributes::operator = (const TopologyAttributes &obj)
{
    lineWidth = obj.lineWidth;
    lineStyle = obj.lineStyle;
    multiColor = obj.multiColor;
    minOpacity = obj.minOpacity;
    minPlateauOpacity = obj.minPlateauOpacity;
    maxPlateauOpacity = obj.maxPlateauOpacity;
    maxOpacity = obj.maxOpacity;
    tolerance = obj.tolerance;
    hitpercent = obj.hitpercent;

    SelectAll();
}

// ****************************************************************************
// Method: TopologyAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TopologyAttributes::operator == (const TopologyAttributes &obj) const
{
    // Create the return value
    return ((lineWidth == obj.lineWidth) &&
            (lineStyle == obj.lineStyle) &&
            (multiColor == obj.multiColor) &&
            (minOpacity == obj.minOpacity) &&
            (minPlateauOpacity == obj.minPlateauOpacity) &&
            (maxPlateauOpacity == obj.maxPlateauOpacity) &&
            (maxOpacity == obj.maxOpacity) &&
            (tolerance == obj.tolerance) &&
            (hitpercent == obj.hitpercent));
}

// ****************************************************************************
// Method: TopologyAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TopologyAttributes::operator != (const TopologyAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TopologyAttributes::TypeName
//
// Purpose: 
//   Type name method for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
TopologyAttributes::TypeName() const
{
    return "TopologyAttributes";
}

// ****************************************************************************
// Method: TopologyAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TopologyAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TopologyAttributes *tmp = (const TopologyAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TopologyAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TopologyAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TopologyAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TopologyAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the TopologyAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TopologyAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TopologyAttributes(*this);
    else
        retval = new TopologyAttributes;

    return retval;
}

// ****************************************************************************
// Method: TopologyAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
TopologyAttributes::SelectAll()
{
    Select(0, (void *)&lineWidth);
    Select(1, (void *)&lineStyle);
    Select(2, (void *)&multiColor);
    Select(3, (void *)&minOpacity);
    Select(4, (void *)&minPlateauOpacity);
    Select(5, (void *)&maxPlateauOpacity);
    Select(6, (void *)&maxOpacity);
    Select(7, (void *)&tolerance);
    Select(8, (void *)&hitpercent);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TopologyAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TopologyAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TopologyAttributes defaultObject;
    bool addToParent = false;
    // Create a node for TopologyAttributes.
    DataNode *node = new DataNode("TopologyAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        DataNode *multiColorNode = new DataNode("multiColor");
        if(multiColor.CreateNode(multiColorNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(multiColorNode);
        }
        else
            delete multiColorNode;
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minOpacity", minOpacity));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minPlateauOpacity", minPlateauOpacity));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxPlateauOpacity", maxPlateauOpacity));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxOpacity", maxOpacity));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tolerance", tolerance));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hitpercent", hitpercent));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TopologyAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
TopologyAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TopologyAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("multiColor")) != 0)
        multiColor.SetFromNode(node);
    if((node = searchNode->GetNode("minOpacity")) != 0)
        SetMinOpacity(node->AsDouble());
    if((node = searchNode->GetNode("minPlateauOpacity")) != 0)
        SetMinPlateauOpacity(node->AsDouble());
    if((node = searchNode->GetNode("maxPlateauOpacity")) != 0)
        SetMaxPlateauOpacity(node->AsDouble());
    if((node = searchNode->GetNode("maxOpacity")) != 0)
        SetMaxOpacity(node->AsDouble());
    if((node = searchNode->GetNode("tolerance")) != 0)
        SetTolerance(node->AsDouble());
    if((node = searchNode->GetNode("hitpercent")) != 0)
        SetHitpercent(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TopologyAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(0, (void *)&lineWidth);
}

void
TopologyAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(1, (void *)&lineStyle);
}

void
TopologyAttributes::SetMultiColor(const ColorAttributeList &multiColor_)
{
    multiColor = multiColor_;
    Select(2, (void *)&multiColor);
}

void
TopologyAttributes::SetMinOpacity(double minOpacity_)
{
    minOpacity = minOpacity_;
    Select(3, (void *)&minOpacity);
}

void
TopologyAttributes::SetMinPlateauOpacity(double minPlateauOpacity_)
{
    minPlateauOpacity = minPlateauOpacity_;
    Select(4, (void *)&minPlateauOpacity);
}

void
TopologyAttributes::SetMaxPlateauOpacity(double maxPlateauOpacity_)
{
    maxPlateauOpacity = maxPlateauOpacity_;
    Select(5, (void *)&maxPlateauOpacity);
}

void
TopologyAttributes::SetMaxOpacity(double maxOpacity_)
{
    maxOpacity = maxOpacity_;
    Select(6, (void *)&maxOpacity);
}

void
TopologyAttributes::SetTolerance(double tolerance_)
{
    tolerance = tolerance_;
    Select(7, (void *)&tolerance);
}

void
TopologyAttributes::SetHitpercent(double hitpercent_)
{
    hitpercent = hitpercent_;
    Select(8, (void *)&hitpercent);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
TopologyAttributes::GetLineWidth() const
{
    return lineWidth;
}

int
TopologyAttributes::GetLineStyle() const
{
    return lineStyle;
}

const ColorAttributeList &
TopologyAttributes::GetMultiColor() const
{
    return multiColor;
}

ColorAttributeList &
TopologyAttributes::GetMultiColor()
{
    return multiColor;
}

double
TopologyAttributes::GetMinOpacity() const
{
    return minOpacity;
}

double
TopologyAttributes::GetMinPlateauOpacity() const
{
    return minPlateauOpacity;
}

double
TopologyAttributes::GetMaxPlateauOpacity() const
{
    return maxPlateauOpacity;
}

double
TopologyAttributes::GetMaxOpacity() const
{
    return maxOpacity;
}

double
TopologyAttributes::GetTolerance() const
{
    return tolerance;
}

double
TopologyAttributes::GetHitpercent() const
{
    return hitpercent;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
TopologyAttributes::SelectMultiColor()
{
    Select(2, (void *)&multiColor);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TopologyAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
TopologyAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Line width";
        case 1:  return "Line style";
        case 2:  return "multiColor";
        case 3:  return "Opacity";
        case 4:  return "Opacity";
        case 5:  return "Opacity";
        case 6:  return "Opacity";
        case 7:  return "tolerance";
        case 8:  return "hitpercent";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TopologyAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TopologyAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_linewidth;
        case 1:  return FieldType_linestyle;
        case 2:  return FieldType_att;
        case 3:  return FieldType_opacity;
        case 4:  return FieldType_opacity;
        case 5:  return FieldType_opacity;
        case 6:  return FieldType_opacity;
        case 7:  return FieldType_double;
        case 8:  return FieldType_double;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TopologyAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
TopologyAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "linewidth";
        case 1:  return "linestyle";
        case 2:  return "att";
        case 3:  return "opacity";
        case 4:  return "opacity";
        case 5:  return "opacity";
        case 6:  return "opacity";
        case 7:  return "double";
        case 8:  return "double";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TopologyAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:27 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TopologyAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TopologyAttributes &obj = *((const TopologyAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 1:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 2:
        {  // new scope
        retval = (multiColor == obj.multiColor);
        }
        break;
    case 3:
        {  // new scope
        retval = (minOpacity == obj.minOpacity);
        }
        break;
    case 4:
        {  // new scope
        retval = (minPlateauOpacity == obj.minPlateauOpacity);
        }
        break;
    case 5:
        {  // new scope
        retval = (maxPlateauOpacity == obj.maxPlateauOpacity);
        }
        break;
    case 6:
        {  // new scope
        retval = (maxOpacity == obj.maxOpacity);
        }
        break;
    case 7:
        {  // new scope
        retval = (tolerance == obj.tolerance);
        }
        break;
    case 8:
        {  // new scope
        retval = (hitpercent == obj.hitpercent);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
TopologyAttributes::ChangesRequireRecalculation(const TopologyAttributes &obj)
{
    return ((tolerance != obj.tolerance) ||
            (hitpercent != obj.hitpercent));
}

