#include <PyTopologyAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyTopologyAttributes
//
// Purpose: 
//   This class contains the plot attributes for the topology plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Jul 1 08:44:44 PDT 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a TopologyAttributes.
//
struct TopologyAttributesObject
{
    PyObject_HEAD
    TopologyAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewTopologyAttributes();

static PyObject *
TopologyAttributes_Notify(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_SetTolerance(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tolerance in the object.
    obj->data->SetTolerance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetTolerance(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTolerance());
    return retval;
}

static PyObject *
TopologyAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
TopologyAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
TopologyAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
TopologyAttributes_SetHitpercent(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hitpercent in the object.
    obj->data->SetHitpercent(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetHitpercent(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHitpercent());
    return retval;
}

static PyObject *
TopologyAttributes_SetMinOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minOpacity in the object.
    obj->data->SetMinOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetMinOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinOpacity());
    return retval;
}

static PyObject *
TopologyAttributes_SetMinPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minPlateauOpacity in the object.
    obj->data->SetMinPlateauOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetMinPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinPlateauOpacity());
    return retval;
}

static PyObject *
TopologyAttributes_SetMaxPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxPlateauOpacity in the object.
    obj->data->SetMaxPlateauOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetMaxPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxPlateauOpacity());
    return retval;
}

static PyObject *
TopologyAttributes_SetMaxOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxOpacity in the object.
    obj->data->SetMaxOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TopologyAttributes_GetMaxOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxOpacity());
    return retval;
}



static struct PyMethodDef TopologyAttributes_methods[] = {
    {"Notify", TopologyAttributes_Notify, METH_VARARGS},
    {"SetTolerance", TopologyAttributes_SetTolerance, METH_VARARGS},
    {"GetTolerance", TopologyAttributes_GetTolerance, METH_VARARGS},
    {"SetMultiColor", TopologyAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", TopologyAttributes_GetMultiColor, METH_VARARGS},
    {"SetLineWidth", TopologyAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", TopologyAttributes_GetLineWidth, METH_VARARGS},
    {"SetLineStyle", TopologyAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", TopologyAttributes_GetLineStyle, METH_VARARGS},
    {"SetHitpercent", TopologyAttributes_SetHitpercent, METH_VARARGS},
    {"GetHitpercent", TopologyAttributes_GetHitpercent, METH_VARARGS},
    {"SetMinOpacity", TopologyAttributes_SetMinOpacity, METH_VARARGS},
    {"GetMinOpacity", TopologyAttributes_GetMinOpacity, METH_VARARGS},
    {"SetMinPlateauOpacity", TopologyAttributes_SetMinPlateauOpacity, METH_VARARGS},
    {"GetMinPlateauOpacity", TopologyAttributes_GetMinPlateauOpacity, METH_VARARGS},
    {"SetMaxPlateauOpacity", TopologyAttributes_SetMaxPlateauOpacity, METH_VARARGS},
    {"GetMaxPlateauOpacity", TopologyAttributes_GetMaxPlateauOpacity, METH_VARARGS},
    {"SetMaxOpacity", TopologyAttributes_SetMaxOpacity, METH_VARARGS},
    {"GetMaxOpacity", TopologyAttributes_GetMaxOpacity, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TopologyAttributes_dealloc(PyObject *v)
{
   TopologyAttributesObject *obj = (TopologyAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
TopologyAttributes_compare(PyObject *v, PyObject *w)
{
    TopologyAttributes *a = ((TopologyAttributesObject *)v)->data;
    TopologyAttributes *b = ((TopologyAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
TopologyAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "tolerance") == 0)
        return TopologyAttributes_GetTolerance(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return TopologyAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return TopologyAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "hitpercent") == 0)
        return TopologyAttributes_GetHitpercent(self, NULL);
    if(strcmp(name, "minOpacity") == 0)
        return TopologyAttributes_GetMinOpacity(self, NULL);
    if(strcmp(name, "minPlateauOpacity") == 0)
        return TopologyAttributes_GetMinPlateauOpacity(self, NULL);
    if(strcmp(name, "maxPlateauOpacity") == 0)
        return TopologyAttributes_GetMaxPlateauOpacity(self, NULL);
    if(strcmp(name, "maxOpacity") == 0)
        return TopologyAttributes_GetMaxOpacity(self, NULL);

    return Py_FindMethod(TopologyAttributes_methods, self, name);
}

static int
TopologyAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "tolerance") == 0)
        retval = (TopologyAttributes_SetTolerance(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (TopologyAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (TopologyAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "hitpercent") == 0)
        retval = (TopologyAttributes_SetHitpercent(self, tuple) != NULL);
    else if(strcmp(name, "minOpacity") == 0)
        retval = (TopologyAttributes_SetMinOpacity(self, tuple) != NULL);
    else if(strcmp(name, "minPlateauOpacity") == 0)
        retval = (TopologyAttributes_SetMinPlateauOpacity(self, tuple) != NULL);
    else if(strcmp(name, "maxPlateauOpacity") == 0)
        retval = (TopologyAttributes_SetMaxPlateauOpacity(self, tuple) != NULL);
    else if(strcmp(name, "maxOpacity") == 0)
        retval = (TopologyAttributes_SetMaxOpacity(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
TopologyAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)v;

    fprintf(fp, "tolerance = %g\n", obj->data->GetTolerance());
    //multiColor
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "hitpercent = %g\n", obj->data->GetHitpercent());
    fprintf(fp, "minOpacity = %g\n", obj->data->GetMinOpacity());
    fprintf(fp, "minPlateauOpacity = %g\n", obj->data->GetMinPlateauOpacity());
    fprintf(fp, "maxPlateauOpacity = %g\n", obj->data->GetMaxPlateauOpacity());
    fprintf(fp, "maxOpacity = %g\n", obj->data->GetMaxOpacity());

    return 0;
}

//
// The doc string for the class.
//
static char *TopologyAttributes_Purpose = "This class contains the plot attributes for the topology plot";

//
// The type description structure
//
static PyTypeObject TopologyAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TopologyAttributes",                    // tp_name
    sizeof(TopologyAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TopologyAttributes_dealloc,  // tp_dealloc
    (printfunc)TopologyAttributes_print,     // tp_print
    (getattrfunc)TopologyAttributes_getattr, // tp_getattr
    (setattrfunc)TopologyAttributes_setattr, // tp_setattr
    (cmpfunc)TopologyAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TopologyAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TopologyAttributes *defaultAtts = 0;

static PyObject *
NewTopologyAttributes()
{
    TopologyAttributesObject *newObject;
    newObject = PyObject_NEW(TopologyAttributesObject, &TopologyAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new TopologyAttributes(*defaultAtts);
    else
        newObject->data = new TopologyAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapTopologyAttributes(const TopologyAttributes *attr)
{
    TopologyAttributesObject *newObject;
    newObject = PyObject_NEW(TopologyAttributesObject, &TopologyAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TopologyAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TopologyAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewTopologyAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TopologyAttributesMethods[] = {
    {"TopologyAttributes", TopologyAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TopologyAttributesObserver = 0;
static bool TopologyAttributesEnableLogging = true;

static void
PyTopologyAttributes_WriteLog(Subject *subj, void *data)
{
    TopologyAttributes *atts = (TopologyAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!TopologyAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# TopologyAttributes_WriteLog()\n");
}

void
PyTopologyAttributes_StartUp(TopologyAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyTopologyAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TopologyAttributesObserver == 0)
    {
        TopologyAttributesObserver = new ObserverToCallback(subj,
            PyTopologyAttributes_WriteLog, (void *)logFile);
    }

    TopologyAttributesEnableLogging = true;
}

void
PyTopologyAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TopologyAttributesObserver;
    TopologyAttributesObserver = 0;
}

PyMethodDef *
PyTopologyAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TopologyAttributesMethods;
}

bool
PyTopologyAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TopologyAttributesType);
}

TopologyAttributes *
PyTopologyAttributes_FromPyObject(PyObject *obj)
{
    TopologyAttributesObject *obj2 = (TopologyAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTopologyAttributes_NewPyObject()
{
    return NewTopologyAttributes();
}

PyObject *
PyTopologyAttributes_WrapPyObject(const TopologyAttributes *attr)
{
    return WrapTopologyAttributes(attr);
}

void
PyTopologyAttributes_SetLogging(bool val)
{
    TopologyAttributesEnableLogging = val;
}

void
PyTopologyAttributes_SetDefaults(const TopologyAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TopologyAttributes(*atts);
}

