// ************************************************************************* //
//                             avtTensorPlot.C                               //
// ************************************************************************* //

#include <avtTensorPlot.h>

#include <vtkPolyData.h>
#include <vtkSphereSource.h>

#include <avtGhostZoneFilter.h>
#include <avtTensorGlyphMapper.h>
#include <avtLookupTable.h>
#include <avtTensorFilter.h>
#include <avtVariableLegend.h>


// ****************************************************************************
//  Method: avtTensorPlot constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
// ****************************************************************************

avtTensorPlot::avtTensorPlot()
{
    colorsInitialized = false;
    TensorFilter = new avtTensorFilter(true, 10);
    ghostFilter  = new avtGhostZoneFilter();
    avtLUT       = new avtLookupTable();

    //
    // The tensor glyph mapper does funny things with normals.  Its best
    // just to remove the normals from the sphere source altogether.
    //
    vtkSphereSource *src = vtkSphereSource::New();
    vtkPolyData *pd = vtkPolyData::New();
    src->Update();
    pd->CopyStructure(src->GetOutput());
    tensorMapper  = new avtTensorGlyphMapper(pd);
    src->Delete();
    pd->Delete();

    varLegend = new avtVariableLegend;
    varLegend->SetTitle("Tensor");

    //
    // This is to allow the legend to be reference counted so the behavior can
    // still access it after the plot is deleted.  The legend cannot be
    // reference counted all of the time since we need to know that it is a
    // VariableLegend.
    //
    varLegendRefPtr = varLegend;
}


// ****************************************************************************
//  Method: avtTensorPlot destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
// ****************************************************************************

avtTensorPlot::~avtTensorPlot()
{
    if (tensorMapper != NULL)
    {
        delete tensorMapper;
        tensorMapper = NULL;
    }
    if (TensorFilter != NULL)
    {
        delete TensorFilter;
        TensorFilter = NULL;
    }
    if (ghostFilter != NULL)
    {
        delete ghostFilter;
        ghostFilter = NULL;
    }
    if (avtLUT != NULL)
    {
        delete avtLUT;
        avtLUT = NULL;
    }
}


// ****************************************************************************
//  Method:  avtTensorPlot::Create
//
//  Purpose:
//    Call the constructor.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
// ****************************************************************************

avtPlot*
avtTensorPlot::Create()
{
    return new avtTensorPlot;
}


// ****************************************************************************
//  Method: avtTensorPlot::GetMapper
//
//  Purpose:
//      Gets a mapper for this plot, it is actually a variable mapper.
//
//  Returns:    The variable mapper typed as its base class mapper.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
// ****************************************************************************

avtMapper *
avtTensorPlot::GetMapper(void)
{
    return tensorMapper;
}


// ****************************************************************************
//  Method: avtTensorPlot::ApplyOperators
//
//  Purpose:
//      Applies the operators associated with a Tensor plot.  
//      The output from this method is a query-able object.
//
//  Arguments:
//      input   The input data object.
//
//  Returns:    The data object after the Tensor plot has been applied.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
// ****************************************************************************

avtDataObject_p
avtTensorPlot::ApplyOperators(avtDataObject_p input)
{
    ghostFilter->SetInput(input);
    TensorFilter->SetInput(ghostFilter->GetOutput());
    return TensorFilter->GetOutput();
}


// ****************************************************************************
//  Method: avtTensorPlot::ApplyRenderingTransformation
//
//  Purpose:
//      Applies the rendering transformation associated with a Tensor plot.  
//
//  Arguments:
//      input   The input data object.
//
//  Returns:    The data object after the Tensor plot has been applied.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
// ****************************************************************************

avtDataObject_p
avtTensorPlot::ApplyRenderingTransformation(avtDataObject_p input)
{
    return input;
}


// ****************************************************************************
//  Method: avtTensorPlot::CustomizeBehavior
//
//  Purpose:
//      Customizes the behavior as appropriate for a Tensor plot.  This includes
//      behavior like shifting towards or away from the screen.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
// ****************************************************************************

void
avtTensorPlot::CustomizeBehavior(void)
{
    behavior->SetLegend(varLegendRefPtr);
}


// ****************************************************************************
//  Method: avtTensorPlot::CustomizeMapper
//
//  Purpose:
//      A hook from the base class that allows the plot to change its mapper
//      based on the dataset input. 
//
//  Arguments:
//      doi     The data object information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
//  Modifications:
//    Kathleen Bonnell, Mon Sep 29 12:31:18 PDT 2003
//    Set antialiased render order.
// ****************************************************************************

void
avtTensorPlot::CustomizeMapper(avtDataObjectInformation &doi)
{
    behavior->SetRenderOrder(DOES_NOT_MATTER);
    behavior->SetAntialiasedRenderOrder(DOES_NOT_MATTER);

    //
    // Set the legend ranges.
    //
    SetLegendRanges();
}


// ****************************************************************************
//  Method: avtTensorPlot::SetAtts
//
//  Purpose:
//      Sets the atts for the Tensor plot.
//
//  Arguments:
//      atts    The attributes for this Tensor plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
//  Modifications:
//    Eric Brugger, Wed Nov 24 13:17:56 PST 2004
//    I added scaleByMagnitude and autoScale.
//
// ****************************************************************************

void
avtTensorPlot::SetAtts(const AttributeGroup *a)
{
    const TensorAttributes *newAtts = (const TensorAttributes *)a;

    // See if the colors will need to be updated.
    bool updateColors = (!colorsInitialized) ||
       (atts.GetColorTableName() != newAtts->GetColorTableName());

    // See if any attributes that require the plot to be regenerated were
    // changed and copy the state object.
    needsRecalculation = atts.ChangesRequireRecalculation(*newAtts);
    atts = *newAtts;

    // Set internal plot state using the information in the atts state object.
    bool useStride = atts.GetUseStride();
    if (useStride)
    {
        TensorFilter->SetStride(atts.GetStride());
    }
    else
    {
        TensorFilter->SetNTensors(atts.GetNTensors());
    }

    tensorMapper->SetScaleByMagnitude(atts.GetScaleByMagnitude());
    tensorMapper->SetAutoScale(atts.GetAutoScale());
    tensorMapper->SetScale(atts.GetScale());

    if (atts.GetColorByEigenvalues())
    {
        tensorMapper->ColorByMagOn();
    }
    else
    {
        const unsigned char *col = atts.GetTensorColor().GetColor();
        tensorMapper->ColorByMagOff(col);
    }

    // Update the plot's colors if needed.
    if (atts.GetColorByEigenvalues() &&
       (updateColors || atts.GetColorTableName() == "Default"))
    {
        colorsInitialized = true;
        SetColorTable(atts.GetColorTableName().c_str());
    }

    //
    // Update the legend.
    //
    SetLegend(atts.GetUseLegend());
}


// ****************************************************************************
//  Method: avtTensorPlot::SetColorTable
//
//  Purpose:
//      Sets the plot's color table if the color table is the same as that of
//      the plot or we are using the default color table for the plot.
//
//  Arguments:
//      ctName : The name of the color table to use.
//
//  Returns:    Returns true if the color table is updated.
//
//  Programmer: Hank Childs
//  Creation:   September 23, 2003
//
// ****************************************************************************

bool
avtTensorPlot::SetColorTable(const char *ctName)
{
    bool retval = false;
    if (atts.GetColorByEigenvalues())
    {
        bool namesMatch = (atts.GetColorTableName() == std::string(ctName));
        if (atts.GetColorTableName() == "Default")
        {
            retval =  avtLUT->SetColorTable(NULL, namesMatch);
        }
        else
        {
            retval =  avtLUT->SetColorTable(ctName, namesMatch);
        }

        if (retval)
        {
            tensorMapper->SetLookupTable(avtLUT->GetLookupTable());
        }
    }
    else
    {
        avtLUT->SetLUTColors(atts.GetTensorColor().GetColor(), 1);
    }

    return retval;
}


// ****************************************************************************
//  Method: avtTensorPlot::SetLegend
//
//  Purpose:
//    Turns the legend on or off.
//
//  Arguments:
//    legendOn  : true if the legend should be turned on, false otherwise.
//
//  Programmer: Hank Childs
//  Creation:   September 23, 2003
//
// ****************************************************************************

void
avtTensorPlot::SetLegend(bool legendOn)
{
    if (legendOn)
    {
        // Set scaling.
        varLegend->LegendOn();
        varLegend->SetLookupTable(avtLUT->GetLookupTable());
        varLegend->SetScaling();
    }
    else
    {
        varLegend->LegendOff();
    }
}


// ****************************************************************************
//  Method: avtTensorPlot::SetLegendRanges
//
//  Purpose:
//      Sets the range to use for the legend.
//
//  Programmer: Hank Childs
//  Date:       September 23, 2003
//
// ****************************************************************************

void
avtTensorPlot::SetLegendRanges()
{
    float min = 0., max = 1.;
    tensorMapper->GetRange(min, max);

    //
    // Set the range for the legend's text and colors.
    //
    varLegend->SetVarRange(min, max);
    varLegend->SetRange(min, max);
}


// ****************************************************************************
//  Method: avtTensorPlot::ReleaseData
//
//  Purpose:
//      Release the problem sized data associated with this plot.
//
//  Programmer: Hank Childs
//  Creation:   September 12, 2002
//
// ****************************************************************************

void
avtTensorPlot::ReleaseData(void)
{
    avtPointDataPlot::ReleaseData();

    if (TensorFilter != NULL)
    {
        TensorFilter->ReleaseData();
    }
    if (ghostFilter != NULL)
    {
        ghostFilter->ReleaseData();
    }
}


