// ************************************************************************* //
//  File: TensorViewerPluginInfo.C
// ************************************************************************* //

#include <TensorPluginInfo.h>
#include <avtTensorPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Tensor_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Tensor plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    TensorViewerPluginInfo::InitializeGlobalObjects();
    return new TensorViewerPluginInfo;
}

//
// Storage for static data elements.
//
TensorAttributes *TensorViewerPluginInfo::clientAtts = NULL;
TensorAttributes *TensorViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TensorViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************
void
TensorViewerPluginInfo::InitializeGlobalObjects()
{
    TensorViewerPluginInfo::clientAtts  = new TensorAttributes;
    TensorViewerPluginInfo::defaultAtts = new TensorAttributes;
}

// ****************************************************************************
//  Method: TensorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************

AttributeSubject *
TensorViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TensorViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************

AttributeSubject *
TensorViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TensorViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************

void
TensorViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TensorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TensorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************

void
TensorViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TensorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TensorViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************

avtPlot *
TensorViewerPluginInfo::AllocAvtPlot()
{
    return new avtTensorPlot;
}

// ****************************************************************************
//  Method: TensorViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************

void
TensorViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(TensorAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: TensorViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
TensorViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_TENSOR | VAR_CATEGORY_SYMMETRIC_TENSOR;
}


// ****************************************************************************
//  Method: TensorViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:56 PST 2004
//
// ****************************************************************************

#include <Tensor.xpm>
const char **
TensorViewerPluginInfo::XPMIconData() const
{
    return Tensor_xpm;
}
