// ************************************************************************* //
//                        TensorScriptingPluginInfo.C
// ************************************************************************* //
#include <TensorPluginInfo.h>
#include <PyTensorAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Tensor_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Tensor plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new TensorScriptingPluginInfo;
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
TensorScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyTensorAttributes_StartUp((TensorAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void *
TensorScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTensorAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Tensor plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
TensorScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTensorAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
TensorScriptingPluginInfo::SetLogging(bool val)
{
    PyTensorAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// Modifications:
//   
// ****************************************************************************

void
TensorScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTensorAttributes_SetDefaults((const TensorAttributes *)atts);
}
