// ************************************************************************* //
//  File: TensorGUIPluginInfo.C
// ************************************************************************* //

#include <TensorPluginInfo.h>
#include <TensorAttributes.h>
#include <QvisTensorPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Tensor_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Tensor plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new TensorGUIPluginInfo;
}

// ****************************************************************************
//  Method: TensorGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// ****************************************************************************

const char *
TensorGUIPluginInfo::GetMenuName() const
{
    return "Tensor";
}


// ****************************************************************************
// Method: TensorGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// Modifications:
//   
// ****************************************************************************

int
TensorGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_TENSOR | VAR_CATEGORY_SYMMETRIC_TENSOR;
}

// ****************************************************************************
//  Method: TensorGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
TensorGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisTensorPlotWindow(type, (TensorAttributes *)attr,
        "Tensor plot attributes", "Tensor plot", notepad);
}

// ****************************************************************************
//  Method: TensorGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// ****************************************************************************

#include <Tensor.xpm>
const char **
TensorGUIPluginInfo::XPMIconData() const
{
    return Tensor_xpm;
}
