// ************************************************************************* //
//  File: TensorCommonPluginInfo.C
// ************************************************************************* //

#include <TensorPluginInfo.h>
#include <TensorAttributes.h>

// ****************************************************************************
//  Method: TensorCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// ****************************************************************************

AttributeSubject *
TensorCommonPluginInfo::AllocAttributes()
{
    return new TensorAttributes;
}

// ****************************************************************************
//  Method: TensorCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Tensor attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:02 PST 2003
//
// ****************************************************************************

void 
TensorCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((TensorAttributes *) to) = *((TensorAttributes *) from);
}
