#include <TensorAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Constructor for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::TensorAttributes() : AttributeSubject("biidbbbbas"),
    tensorColor(0, 0, 0), colorTableName("Default")
{
    useStride = false;
    stride = 1;
    nTensors = 400;
    scale = 0.25;
    scaleByMagnitude = true;
    autoScale = true;
    colorByEigenvalues = true;
    useLegend = true;
}

// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Copy constructor for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::TensorAttributes(const TensorAttributes &obj) : AttributeSubject("biidbbbbas")
{
    useStride = obj.useStride;
    stride = obj.stride;
    nTensors = obj.nTensors;
    scale = obj.scale;
    scaleByMagnitude = obj.scaleByMagnitude;
    autoScale = obj.autoScale;
    colorByEigenvalues = obj.colorByEigenvalues;
    useLegend = obj.useLegend;
    tensorColor = obj.tensorColor;
    colorTableName = obj.colorTableName;

    SelectAll();
}

// ****************************************************************************
// Method: TensorAttributes::~TensorAttributes
//
// Purpose: 
//   Destructor for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::~TensorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: TensorAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes& 
TensorAttributes::operator = (const TensorAttributes &obj)
{
    if (this == &obj) return *this;
    useStride = obj.useStride;
    stride = obj.stride;
    nTensors = obj.nTensors;
    scale = obj.scale;
    scaleByMagnitude = obj.scaleByMagnitude;
    autoScale = obj.autoScale;
    colorByEigenvalues = obj.colorByEigenvalues;
    useLegend = obj.useLegend;
    tensorColor = obj.tensorColor;
    colorTableName = obj.colorTableName;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: TensorAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::operator == (const TensorAttributes &obj) const
{
    // Create the return value
    return ((useStride == obj.useStride) &&
            (stride == obj.stride) &&
            (nTensors == obj.nTensors) &&
            (scale == obj.scale) &&
            (scaleByMagnitude == obj.scaleByMagnitude) &&
            (autoScale == obj.autoScale) &&
            (colorByEigenvalues == obj.colorByEigenvalues) &&
            (useLegend == obj.useLegend) &&
            (tensorColor == obj.tensorColor) &&
            (colorTableName == obj.colorTableName));
}

// ****************************************************************************
// Method: TensorAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::operator != (const TensorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TensorAttributes::TypeName
//
// Purpose: 
//   Type name method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
TensorAttributes::TypeName() const
{
    return "TensorAttributes";
}

// ****************************************************************************
// Method: TensorAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TensorAttributes *tmp = (const TensorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TensorAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TensorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TensorAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TensorAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TensorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TensorAttributes(*this);
    else
        retval = new TensorAttributes;

    return retval;
}

// ****************************************************************************
// Method: TensorAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
TensorAttributes::SelectAll()
{
    Select(0, (void *)&useStride);
    Select(1, (void *)&stride);
    Select(2, (void *)&nTensors);
    Select(3, (void *)&scale);
    Select(4, (void *)&scaleByMagnitude);
    Select(5, (void *)&autoScale);
    Select(6, (void *)&colorByEigenvalues);
    Select(7, (void *)&useLegend);
    Select(8, (void *)&tensorColor);
    Select(9, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TensorAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TensorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for TensorAttributes.
    DataNode *node = new DataNode("TensorAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useStride", useStride));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nTensors", nTensors));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scale", scale));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleByMagnitude", scaleByMagnitude));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoScale", autoScale));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorByEigenvalues", colorByEigenvalues));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useLegend", useLegend));
    }

        DataNode *tensorColorNode = new DataNode("tensorColor");
        if(tensorColor.CreateNode(tensorColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(tensorColorNode);
        }
        else
            delete tensorColorNode;
    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TensorAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
TensorAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TensorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useStride")) != 0)
        SetUseStride(node->AsBool());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("nTensors")) != 0)
        SetNTensors(node->AsInt());
    if((node = searchNode->GetNode("scale")) != 0)
        SetScale(node->AsDouble());
    if((node = searchNode->GetNode("scaleByMagnitude")) != 0)
        SetScaleByMagnitude(node->AsBool());
    if((node = searchNode->GetNode("autoScale")) != 0)
        SetAutoScale(node->AsBool());
    if((node = searchNode->GetNode("colorByEigenvalues")) != 0)
        SetColorByEigenvalues(node->AsBool());
    if((node = searchNode->GetNode("useLegend")) != 0)
        SetUseLegend(node->AsBool());
    if((node = searchNode->GetNode("tensorColor")) != 0)
        tensorColor.SetFromNode(node);
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TensorAttributes::SetUseStride(bool useStride_)
{
    useStride = useStride_;
    Select(0, (void *)&useStride);
}

void
TensorAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(1, (void *)&stride);
}

void
TensorAttributes::SetNTensors(int nTensors_)
{
    nTensors = nTensors_;
    Select(2, (void *)&nTensors);
}

void
TensorAttributes::SetScale(double scale_)
{
    scale = scale_;
    Select(3, (void *)&scale);
}

void
TensorAttributes::SetScaleByMagnitude(bool scaleByMagnitude_)
{
    scaleByMagnitude = scaleByMagnitude_;
    Select(4, (void *)&scaleByMagnitude);
}

void
TensorAttributes::SetAutoScale(bool autoScale_)
{
    autoScale = autoScale_;
    Select(5, (void *)&autoScale);
}

void
TensorAttributes::SetColorByEigenvalues(bool colorByEigenvalues_)
{
    colorByEigenvalues = colorByEigenvalues_;
    Select(6, (void *)&colorByEigenvalues);
}

void
TensorAttributes::SetUseLegend(bool useLegend_)
{
    useLegend = useLegend_;
    Select(7, (void *)&useLegend);
}

void
TensorAttributes::SetTensorColor(const ColorAttribute &tensorColor_)
{
    tensorColor = tensorColor_;
    Select(8, (void *)&tensorColor);
}

void
TensorAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(9, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
TensorAttributes::GetUseStride() const
{
    return useStride;
}

int
TensorAttributes::GetStride() const
{
    return stride;
}

int
TensorAttributes::GetNTensors() const
{
    return nTensors;
}

double
TensorAttributes::GetScale() const
{
    return scale;
}

bool
TensorAttributes::GetScaleByMagnitude() const
{
    return scaleByMagnitude;
}

bool
TensorAttributes::GetAutoScale() const
{
    return autoScale;
}

bool
TensorAttributes::GetColorByEigenvalues() const
{
    return colorByEigenvalues;
}

bool
TensorAttributes::GetUseLegend() const
{
    return useLegend;
}

const ColorAttribute &
TensorAttributes::GetTensorColor() const
{
    return tensorColor;
}

ColorAttribute &
TensorAttributes::GetTensorColor()
{
    return tensorColor;
}

const std::string &
TensorAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
TensorAttributes::GetColorTableName()
{
    return colorTableName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
TensorAttributes::SelectTensorColor()
{
    Select(8, (void *)&tensorColor);
}

void
TensorAttributes::SelectColorTableName()
{
    Select(9, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TensorAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
TensorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Use stride";
        case 1:  return "Stride";
        case 2:  return "Num tensors";
        case 3:  return "Scale";
        case 4:  return "Scale by magnitude";
        case 5:  return "Auto scale";
        case 6:  return "color by eigenvalues";
        case 7:  return "Legend";
        case 8:  return "color";
        case 9:  return "Color table";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TensorAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TensorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_int;
        case 2:  return FieldType_int;
        case 3:  return FieldType_double;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_color;
        case 9:  return FieldType_colortable;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TensorAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
TensorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "int";
        case 2:  return "int";
        case 3:  return "double";
        case 4:  return "bool";
        case 5:  return "bool";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "color";
        case 9:  return "colortable";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TensorAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Nov 24 11:30:54 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TensorAttributes &obj = *((const TensorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (useStride == obj.useStride);
        }
        break;
    case 1:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case 2:
        {  // new scope
        retval = (nTensors == obj.nTensors);
        }
        break;
    case 3:
        {  // new scope
        retval = (scale == obj.scale);
        }
        break;
    case 4:
        {  // new scope
        retval = (scaleByMagnitude == obj.scaleByMagnitude);
        }
        break;
    case 5:
        {  // new scope
        retval = (autoScale == obj.autoScale);
        }
        break;
    case 6:
        {  // new scope
        retval = (colorByEigenvalues == obj.colorByEigenvalues);
        }
        break;
    case 7:
        {  // new scope
        retval = (useLegend == obj.useLegend);
        }
        break;
    case 8:
        {  // new scope
        retval = (tensorColor == obj.tensorColor);
        }
        break;
    case 9:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
TensorAttributes::ChangesRequireRecalculation(const TensorAttributes &obj)
{
    return ((useStride != obj.useStride) ||
            (stride != obj.stride) ||
            (nTensors != obj.nTensors));
}

