#include <PyTensorAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyTensorAttributes
//
// Purpose: 
//   Attributes for the tensor plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Nov 24 11:31:07 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a TensorAttributes.
//
struct TensorAttributesObject
{
    PyObject_HEAD
    TensorAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewTensorAttributes();

static PyObject *
TensorAttributes_Notify(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_SetUseStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useStride in the object.
    obj->data->SetUseStride(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetUseStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseStride()?1L:0L);
    return retval;
}

static PyObject *
TensorAttributes_SetStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetStride(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

static PyObject *
TensorAttributes_SetNTensors(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nTensors in the object.
    obj->data->SetNTensors(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetNTensors(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNTensors()));
    return retval;
}

static PyObject *
TensorAttributes_SetScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scale in the object.
    obj->data->SetScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScale());
    return retval;
}

static PyObject *
TensorAttributes_SetScaleByMagnitude(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleByMagnitude in the object.
    obj->data->SetScaleByMagnitude(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetScaleByMagnitude(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleByMagnitude()?1L:0L);
    return retval;
}

static PyObject *
TensorAttributes_SetAutoScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoScale in the object.
    obj->data->SetAutoScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetAutoScale(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoScale()?1L:0L);
    return retval;
}

static PyObject *
TensorAttributes_SetColorByEigenvalues(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorByEigenvalues in the object.
    obj->data->SetColorByEigenvalues(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetColorByEigenvalues(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetColorByEigenvalues()?1L:0L);
    return retval;
}

static PyObject *
TensorAttributes_SetUseLegend(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useLegend in the object.
    obj->data->SetUseLegend(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetUseLegend(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseLegend()?1L:0L);
    return retval;
}

static PyObject *
TensorAttributes_SetTensorColor(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the tensorColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetTensorColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetTensorColor(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the tensorColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *tensorColor = obj->data->GetTensorColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(tensorColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(tensorColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(tensorColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(tensorColor[3])));
    return retval;
}

static PyObject *
TensorAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
TensorAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}



static struct PyMethodDef TensorAttributes_methods[] = {
    {"Notify", TensorAttributes_Notify, METH_VARARGS},
    {"SetUseStride", TensorAttributes_SetUseStride, METH_VARARGS},
    {"GetUseStride", TensorAttributes_GetUseStride, METH_VARARGS},
    {"SetStride", TensorAttributes_SetStride, METH_VARARGS},
    {"GetStride", TensorAttributes_GetStride, METH_VARARGS},
    {"SetNTensors", TensorAttributes_SetNTensors, METH_VARARGS},
    {"GetNTensors", TensorAttributes_GetNTensors, METH_VARARGS},
    {"SetScale", TensorAttributes_SetScale, METH_VARARGS},
    {"GetScale", TensorAttributes_GetScale, METH_VARARGS},
    {"SetScaleByMagnitude", TensorAttributes_SetScaleByMagnitude, METH_VARARGS},
    {"GetScaleByMagnitude", TensorAttributes_GetScaleByMagnitude, METH_VARARGS},
    {"SetAutoScale", TensorAttributes_SetAutoScale, METH_VARARGS},
    {"GetAutoScale", TensorAttributes_GetAutoScale, METH_VARARGS},
    {"SetColorByEigenvalues", TensorAttributes_SetColorByEigenvalues, METH_VARARGS},
    {"GetColorByEigenvalues", TensorAttributes_GetColorByEigenvalues, METH_VARARGS},
    {"SetUseLegend", TensorAttributes_SetUseLegend, METH_VARARGS},
    {"GetUseLegend", TensorAttributes_GetUseLegend, METH_VARARGS},
    {"SetTensorColor", TensorAttributes_SetTensorColor, METH_VARARGS},
    {"GetTensorColor", TensorAttributes_GetTensorColor, METH_VARARGS},
    {"SetColorTableName", TensorAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", TensorAttributes_GetColorTableName, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TensorAttributes_dealloc(PyObject *v)
{
   TensorAttributesObject *obj = (TensorAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
TensorAttributes_compare(PyObject *v, PyObject *w)
{
    TensorAttributes *a = ((TensorAttributesObject *)v)->data;
    TensorAttributes *b = ((TensorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
TensorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "useStride") == 0)
        return TensorAttributes_GetUseStride(self, NULL);
    if(strcmp(name, "stride") == 0)
        return TensorAttributes_GetStride(self, NULL);
    if(strcmp(name, "nTensors") == 0)
        return TensorAttributes_GetNTensors(self, NULL);
    if(strcmp(name, "scale") == 0)
        return TensorAttributes_GetScale(self, NULL);
    if(strcmp(name, "scaleByMagnitude") == 0)
        return TensorAttributes_GetScaleByMagnitude(self, NULL);
    if(strcmp(name, "autoScale") == 0)
        return TensorAttributes_GetAutoScale(self, NULL);
    if(strcmp(name, "colorByEigenvalues") == 0)
        return TensorAttributes_GetColorByEigenvalues(self, NULL);
    if(strcmp(name, "useLegend") == 0)
        return TensorAttributes_GetUseLegend(self, NULL);
    if(strcmp(name, "tensorColor") == 0)
        return TensorAttributes_GetTensorColor(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return TensorAttributes_GetColorTableName(self, NULL);

    return Py_FindMethod(TensorAttributes_methods, self, name);
}

static int
TensorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "useStride") == 0)
        retval = (TensorAttributes_SetUseStride(self, tuple) != NULL);
    else if(strcmp(name, "stride") == 0)
        retval = (TensorAttributes_SetStride(self, tuple) != NULL);
    else if(strcmp(name, "nTensors") == 0)
        retval = (TensorAttributes_SetNTensors(self, tuple) != NULL);
    else if(strcmp(name, "scale") == 0)
        retval = (TensorAttributes_SetScale(self, tuple) != NULL);
    else if(strcmp(name, "scaleByMagnitude") == 0)
        retval = (TensorAttributes_SetScaleByMagnitude(self, tuple) != NULL);
    else if(strcmp(name, "autoScale") == 0)
        retval = (TensorAttributes_SetAutoScale(self, tuple) != NULL);
    else if(strcmp(name, "colorByEigenvalues") == 0)
        retval = (TensorAttributes_SetColorByEigenvalues(self, tuple) != NULL);
    else if(strcmp(name, "useLegend") == 0)
        retval = (TensorAttributes_SetUseLegend(self, tuple) != NULL);
    else if(strcmp(name, "tensorColor") == 0)
        retval = (TensorAttributes_SetTensorColor(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (TensorAttributes_SetColorTableName(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
TensorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)v;

    if(obj->data->GetUseStride())
        fprintf(fp, "useStride = 1\n");
    else
        fprintf(fp, "useStride = 0\n");
    fprintf(fp, "stride = %d\n", obj->data->GetStride());
    fprintf(fp, "nTensors = %d\n", obj->data->GetNTensors());
    fprintf(fp, "scale = %g\n", obj->data->GetScale());
    if(obj->data->GetScaleByMagnitude())
        fprintf(fp, "scaleByMagnitude = 1\n");
    else
        fprintf(fp, "scaleByMagnitude = 0\n");
    if(obj->data->GetAutoScale())
        fprintf(fp, "autoScale = 1\n");
    else
        fprintf(fp, "autoScale = 0\n");
    if(obj->data->GetColorByEigenvalues())
        fprintf(fp, "colorByEigenvalues = 1\n");
    else
        fprintf(fp, "colorByEigenvalues = 0\n");
    if(obj->data->GetUseLegend())
        fprintf(fp, "useLegend = 1\n");
    else
        fprintf(fp, "useLegend = 0\n");
    const unsigned char *tensorColor = obj->data->GetTensorColor().GetColor();
    fprintf(fp, "tensorColor = (%d, %d, %d, %d)\n", int(tensorColor[0]), int(tensorColor[1]), int(tensorColor[2]), int(tensorColor[3]));
    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PyTensorAttributes_StringRepresentation(const TensorAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetUseStride())
        SNPRINTF(tmpStr, 1000, "useStride = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useStride = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "stride = %d\n", atts->GetStride());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "nTensors = %d\n", atts->GetNTensors());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "scale = %g\n", atts->GetScale());
    str += tmpStr;
    if(atts->GetScaleByMagnitude())
        SNPRINTF(tmpStr, 1000, "scaleByMagnitude = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "scaleByMagnitude = 0\n");
    str += tmpStr;
    if(atts->GetAutoScale())
        SNPRINTF(tmpStr, 1000, "autoScale = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "autoScale = 0\n");
    str += tmpStr;
    if(atts->GetColorByEigenvalues())
        SNPRINTF(tmpStr, 1000, "colorByEigenvalues = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "colorByEigenvalues = 0\n");
    str += tmpStr;
    if(atts->GetUseLegend())
        SNPRINTF(tmpStr, 1000, "useLegend = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useLegend = 0\n");
    str += tmpStr;
    const unsigned char *tensorColor = atts->GetTensorColor().GetColor();
    SNPRINTF(tmpStr, 1000, "tensorColor = (%d, %d, %d, %d)\n", int(tensorColor[0]), int(tensorColor[1]), int(tensorColor[2]), int(tensorColor[3]));
    str += tmpStr;
   SNPRINTF(tmpStr, 1000, "colorTableName = %s\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
TensorAttributes_str(PyObject *v)
{
    TensorAttributesObject *obj = (TensorAttributesObject *)v;
    return PyTensorAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *TensorAttributes_Purpose = "Attributes for the tensor plot";

//
// The type description structure
//
static PyTypeObject TensorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TensorAttributes",                    // tp_name
    sizeof(TensorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TensorAttributes_dealloc,  // tp_dealloc
    (printfunc)TensorAttributes_print,     // tp_print
    (getattrfunc)TensorAttributes_getattr, // tp_getattr
    (setattrfunc)TensorAttributes_setattr, // tp_setattr
    (cmpfunc)TensorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TensorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TensorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TensorAttributes *defaultAtts = 0;

static PyObject *
NewTensorAttributes()
{
    TensorAttributesObject *newObject;
    newObject = PyObject_NEW(TensorAttributesObject, &TensorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new TensorAttributes(*defaultAtts);
    else
        newObject->data = new TensorAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapTensorAttributes(const TensorAttributes *attr)
{
    TensorAttributesObject *newObject;
    newObject = PyObject_NEW(TensorAttributesObject, &TensorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TensorAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TensorAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewTensorAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TensorAttributesMethods[] = {
    {"TensorAttributes", TensorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TensorAttributesObserver = 0;
static bool TensorAttributesEnableLogging = true;

static void
PyTensorAttributes_WriteLog(Subject *subj, void *data)
{
    TensorAttributes *atts = (TensorAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!TensorAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# TensorAttributes_WriteLog()\n");
}

void
PyTensorAttributes_StartUp(TensorAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyTensorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TensorAttributesObserver == 0)
    {
        TensorAttributesObserver = new ObserverToCallback(subj,
            PyTensorAttributes_WriteLog, (void *)logFile);
    }

    TensorAttributesEnableLogging = true;
}

void
PyTensorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TensorAttributesObserver;
    TensorAttributesObserver = 0;
}

PyMethodDef *
PyTensorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TensorAttributesMethods;
}

bool
PyTensorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TensorAttributesType);
}

TensorAttributes *
PyTensorAttributes_FromPyObject(PyObject *obj)
{
    TensorAttributesObject *obj2 = (TensorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTensorAttributes_NewPyObject()
{
    return NewTensorAttributes();
}

PyObject *
PyTensorAttributes_WrapPyObject(const TensorAttributes *attr)
{
    return WrapTensorAttributes(attr);
}

void
PyTensorAttributes_SetLogging(bool val)
{
    TensorAttributesEnableLogging = val;
}

void
PyTensorAttributes_SetDefaults(const TensorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TensorAttributes(*atts);
}

