// ************************************************************************* //
//  File: SurfaceViewerPluginInfo.C
// ************************************************************************* //

#include <SurfacePluginInfo.h>
#include <avtSurfacePlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Surface_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Surface plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    SurfaceViewerPluginInfo::InitializeGlobalObjects();
    return new SurfaceViewerPluginInfo;
}

//
// Storage for static data elements.
//
SurfaceAttributes *SurfaceViewerPluginInfo::clientAtts = NULL;
SurfaceAttributes *SurfaceViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SurfaceViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************
void
SurfaceViewerPluginInfo::InitializeGlobalObjects()
{
    SurfaceViewerPluginInfo::clientAtts  = new SurfaceAttributes;
    SurfaceViewerPluginInfo::defaultAtts = new SurfaceAttributes;
}

// ****************************************************************************
//  Method: SurfaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************

AttributeSubject *
SurfaceViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SurfaceViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************

AttributeSubject *
SurfaceViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SurfaceViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************

void
SurfaceViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SurfaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SurfaceViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************

void
SurfaceViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SurfaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SurfaceViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************

avtPlot *
SurfaceViewerPluginInfo::AllocAvtPlot()
{
    return new avtSurfacePlot;
}

// ****************************************************************************
//  Method: SurfaceViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************

void
SurfaceViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(SurfaceAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: SurfaceViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
SurfaceViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}


// ****************************************************************************
//  Method: SurfaceViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:53 PST 2004
//
// ****************************************************************************

#include <Surface.xpm>
const char **
SurfaceViewerPluginInfo::XPMIconData() const
{
    return Surface_xpm;
}
