// ************************************************************************* //
//                        SurfaceScriptingPluginInfo.C
// ************************************************************************* //
#include <SurfacePluginInfo.h>
#include <PySurfaceAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Surface_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Surface plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:08 PST 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new SurfaceScriptingPluginInfo;
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PySurfaceAttributes_StartUp((SurfaceAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
SurfaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySurfaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Surface plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySurfaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceScriptingPluginInfo::SetLogging(bool val)
{
    PySurfaceAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:08 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySurfaceAttributes_SetDefaults((const SurfaceAttributes *)atts);
}
