#include <SurfaceAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for SurfaceAttributes::ColorByType
//

static const char *ColorByType_strings[] = {
"Constant", "ZValue"};

std::string
SurfaceAttributes::ColorByType_ToString(SurfaceAttributes::ColorByType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ColorByType_strings[index];
}

std::string
SurfaceAttributes::ColorByType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ColorByType_strings[index];
}

bool
SurfaceAttributes::ColorByType_FromString(const std::string &s, SurfaceAttributes::ColorByType &val)
{
    val = SurfaceAttributes::Constant;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ColorByType_strings[i])
        {
            val = (ColorByType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SurfaceAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log", "Skew"
};

std::string
SurfaceAttributes::Scaling_ToString(SurfaceAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Scaling_strings[index];
}

std::string
SurfaceAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Scaling_strings[index];
}

bool
SurfaceAttributes::Scaling_FromString(const std::string &s, SurfaceAttributes::Scaling &val)
{
    val = SurfaceAttributes::Linear;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SurfaceAttributes::LimitsMode
//

static const char *LimitsMode_strings[] = {
"OriginalData", "CurrentPlot"};

std::string
SurfaceAttributes::LimitsMode_ToString(SurfaceAttributes::LimitsMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LimitsMode_strings[index];
}

std::string
SurfaceAttributes::LimitsMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LimitsMode_strings[index];
}

bool
SurfaceAttributes::LimitsMode_FromString(const std::string &s, SurfaceAttributes::LimitsMode &val)
{
    val = SurfaceAttributes::OriginalData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LimitsMode_strings[i])
        {
            val = (LimitsMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SurfaceAttributes::SurfaceAttributes
//
// Purpose: 
//   Constructor for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SurfaceAttributes::SurfaceAttributes() : AttributeSubject("bbbbibbbiiiaaddds"),
    surfaceColor(0, 0, 0), wireframeColor(0, 0, 0), 
    colorTableName("hot")
{
    legendFlag = true;
    lightingFlag = true;
    surfaceFlag = true;
    wireframeFlag = false;
    limitsMode = OriginalData;
    minFlag = false;
    maxFlag = false;
    colorByZFlag = true;
    scaling = Linear;
    lineStyle = 0;
    lineWidth = 0;
    skewFactor = 1;
    min = 0;
    max = 1;
}

// ****************************************************************************
// Method: SurfaceAttributes::SurfaceAttributes
//
// Purpose: 
//   Copy constructor for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SurfaceAttributes::SurfaceAttributes(const SurfaceAttributes &obj) : AttributeSubject("bbbbibbbiiiaaddds")
{
    legendFlag = obj.legendFlag;
    lightingFlag = obj.lightingFlag;
    surfaceFlag = obj.surfaceFlag;
    wireframeFlag = obj.wireframeFlag;
    limitsMode = obj.limitsMode;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    colorByZFlag = obj.colorByZFlag;
    scaling = obj.scaling;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    surfaceColor = obj.surfaceColor;
    wireframeColor = obj.wireframeColor;
    skewFactor = obj.skewFactor;
    min = obj.min;
    max = obj.max;
    colorTableName = obj.colorTableName;

    SelectAll();
}

// ****************************************************************************
// Method: SurfaceAttributes::~SurfaceAttributes
//
// Purpose: 
//   Destructor for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

SurfaceAttributes::~SurfaceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SurfaceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceAttributes::operator = (const SurfaceAttributes &obj)
{
    legendFlag = obj.legendFlag;
    lightingFlag = obj.lightingFlag;
    surfaceFlag = obj.surfaceFlag;
    wireframeFlag = obj.wireframeFlag;
    limitsMode = obj.limitsMode;
    minFlag = obj.minFlag;
    maxFlag = obj.maxFlag;
    colorByZFlag = obj.colorByZFlag;
    scaling = obj.scaling;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    surfaceColor = obj.surfaceColor;
    wireframeColor = obj.wireframeColor;
    skewFactor = obj.skewFactor;
    min = obj.min;
    max = obj.max;
    colorTableName = obj.colorTableName;

    SelectAll();
}

// ****************************************************************************
// Method: SurfaceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceAttributes::operator == (const SurfaceAttributes &obj) const
{
    // Create the return value
    return ((legendFlag == obj.legendFlag) &&
            (lightingFlag == obj.lightingFlag) &&
            (surfaceFlag == obj.surfaceFlag) &&
            (wireframeFlag == obj.wireframeFlag) &&
            (limitsMode == obj.limitsMode) &&
            (minFlag == obj.minFlag) &&
            (maxFlag == obj.maxFlag) &&
            (colorByZFlag == obj.colorByZFlag) &&
            (scaling == obj.scaling) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (surfaceColor == obj.surfaceColor) &&
            (wireframeColor == obj.wireframeColor) &&
            (skewFactor == obj.skewFactor) &&
            (min == obj.min) &&
            (max == obj.max) &&
            (colorTableName == obj.colorTableName));
}

// ****************************************************************************
// Method: SurfaceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceAttributes::operator != (const SurfaceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SurfaceAttributes::TypeName
//
// Purpose: 
//   Type name method for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
SurfaceAttributes::TypeName() const
{
    return "SurfaceAttributes";
}

// ****************************************************************************
// Method: SurfaceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SurfaceAttributes *tmp = (const SurfaceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SurfaceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfaceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SurfaceAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SurfaceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfaceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SurfaceAttributes(*this);
    else
        retval = new SurfaceAttributes;

    return retval;
}

// ****************************************************************************
// Method: SurfaceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceAttributes::SelectAll()
{
    Select(0, (void *)&legendFlag);
    Select(1, (void *)&lightingFlag);
    Select(2, (void *)&surfaceFlag);
    Select(3, (void *)&wireframeFlag);
    Select(4, (void *)&limitsMode);
    Select(5, (void *)&minFlag);
    Select(6, (void *)&maxFlag);
    Select(7, (void *)&colorByZFlag);
    Select(8, (void *)&scaling);
    Select(9, (void *)&lineStyle);
    Select(10, (void *)&lineWidth);
    Select(11, (void *)&surfaceColor);
    Select(12, (void *)&wireframeColor);
    Select(13, (void *)&skewFactor);
    Select(14, (void *)&min);
    Select(15, (void *)&max);
    Select(16, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfaceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SurfaceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SurfaceAttributes.
    DataNode *node = new DataNode("SurfaceAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lightingFlag", lightingFlag));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("surfaceFlag", surfaceFlag));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wireframeFlag", wireframeFlag));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("limitsMode", LimitsMode_ToString(limitsMode)));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorByZFlag", colorByZFlag));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaling", Scaling_ToString(scaling)));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

        DataNode *surfaceColorNode = new DataNode("surfaceColor");
        if(surfaceColor.CreateNode(surfaceColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(surfaceColorNode);
        }
        else
            delete surfaceColorNode;
        DataNode *wireframeColorNode = new DataNode("wireframeColor");
        if(wireframeColor.CreateNode(wireframeColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(wireframeColorNode);
        }
        else
            delete wireframeColorNode;
    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("skewFactor", skewFactor));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SurfaceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
SurfaceAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SurfaceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
    if((node = searchNode->GetNode("lightingFlag")) != 0)
        SetLightingFlag(node->AsBool());
    if((node = searchNode->GetNode("surfaceFlag")) != 0)
        SetSurfaceFlag(node->AsBool());
    if((node = searchNode->GetNode("wireframeFlag")) != 0)
        SetWireframeFlag(node->AsBool());
    if((node = searchNode->GetNode("limitsMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLimitsMode(LimitsMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LimitsMode value;
            if(LimitsMode_FromString(node->AsString(), value))
                SetLimitsMode(value);
        }
    }
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("colorByZFlag")) != 0)
        SetColorByZFlag(node->AsBool());
    if((node = searchNode->GetNode("scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetScaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetScaling(value);
        }
    }
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("surfaceColor")) != 0)
        surfaceColor.SetFromNode(node);
    if((node = searchNode->GetNode("wireframeColor")) != 0)
        wireframeColor.SetFromNode(node);
    if((node = searchNode->GetNode("skewFactor")) != 0)
        SetSkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfaceAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(0, (void *)&legendFlag);
}

void
SurfaceAttributes::SetLightingFlag(bool lightingFlag_)
{
    lightingFlag = lightingFlag_;
    Select(1, (void *)&lightingFlag);
}

void
SurfaceAttributes::SetSurfaceFlag(bool surfaceFlag_)
{
    surfaceFlag = surfaceFlag_;
    Select(2, (void *)&surfaceFlag);
}

void
SurfaceAttributes::SetWireframeFlag(bool wireframeFlag_)
{
    wireframeFlag = wireframeFlag_;
    Select(3, (void *)&wireframeFlag);
}

void
SurfaceAttributes::SetLimitsMode(SurfaceAttributes::LimitsMode limitsMode_)
{
    limitsMode = limitsMode_;
    Select(4, (void *)&limitsMode);
}

void
SurfaceAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(5, (void *)&minFlag);
}

void
SurfaceAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(6, (void *)&maxFlag);
}

void
SurfaceAttributes::SetColorByZFlag(bool colorByZFlag_)
{
    colorByZFlag = colorByZFlag_;
    Select(7, (void *)&colorByZFlag);
}

void
SurfaceAttributes::SetScaling(SurfaceAttributes::Scaling scaling_)
{
    scaling = scaling_;
    Select(8, (void *)&scaling);
}

void
SurfaceAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(9, (void *)&lineStyle);
}

void
SurfaceAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(10, (void *)&lineWidth);
}

void
SurfaceAttributes::SetSurfaceColor(const ColorAttribute &surfaceColor_)
{
    surfaceColor = surfaceColor_;
    Select(11, (void *)&surfaceColor);
}

void
SurfaceAttributes::SetWireframeColor(const ColorAttribute &wireframeColor_)
{
    wireframeColor = wireframeColor_;
    Select(12, (void *)&wireframeColor);
}

void
SurfaceAttributes::SetSkewFactor(double skewFactor_)
{
    skewFactor = skewFactor_;
    Select(13, (void *)&skewFactor);
}

void
SurfaceAttributes::SetMin(double min_)
{
    min = min_;
    Select(14, (void *)&min);
}

void
SurfaceAttributes::SetMax(double max_)
{
    max = max_;
    Select(15, (void *)&max);
}

void
SurfaceAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(16, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
SurfaceAttributes::GetLegendFlag() const
{
    return legendFlag;
}

bool
SurfaceAttributes::GetLightingFlag() const
{
    return lightingFlag;
}

bool
SurfaceAttributes::GetSurfaceFlag() const
{
    return surfaceFlag;
}

bool
SurfaceAttributes::GetWireframeFlag() const
{
    return wireframeFlag;
}

SurfaceAttributes::LimitsMode
SurfaceAttributes::GetLimitsMode() const
{
    return LimitsMode(limitsMode);
}

bool
SurfaceAttributes::GetMinFlag() const
{
    return minFlag;
}

bool
SurfaceAttributes::GetMaxFlag() const
{
    return maxFlag;
}

bool
SurfaceAttributes::GetColorByZFlag() const
{
    return colorByZFlag;
}

SurfaceAttributes::Scaling
SurfaceAttributes::GetScaling() const
{
    return Scaling(scaling);
}

int
SurfaceAttributes::GetLineStyle() const
{
    return lineStyle;
}

int
SurfaceAttributes::GetLineWidth() const
{
    return lineWidth;
}

const ColorAttribute &
SurfaceAttributes::GetSurfaceColor() const
{
    return surfaceColor;
}

ColorAttribute &
SurfaceAttributes::GetSurfaceColor()
{
    return surfaceColor;
}

const ColorAttribute &
SurfaceAttributes::GetWireframeColor() const
{
    return wireframeColor;
}

ColorAttribute &
SurfaceAttributes::GetWireframeColor()
{
    return wireframeColor;
}

double
SurfaceAttributes::GetSkewFactor() const
{
    return skewFactor;
}

double
SurfaceAttributes::GetMin() const
{
    return min;
}

double
SurfaceAttributes::GetMax() const
{
    return max;
}

const std::string &
SurfaceAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
SurfaceAttributes::GetColorTableName()
{
    return colorTableName;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfaceAttributes::SelectSurfaceColor()
{
    Select(11, (void *)&surfaceColor);
}

void
SurfaceAttributes::SelectWireframeColor()
{
    Select(12, (void *)&wireframeColor);
}

void
SurfaceAttributes::SelectColorTableName()
{
    Select(16, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfaceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfaceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Legend";
        case 1:  return "Lighting";
        case 2:  return "Surface";
        case 3:  return "Wireframe";
        case 4:  return "LimitsMode";
        case 5:  return "Use min";
        case 6:  return "Use max";
        case 7:  return "Color by Z Value";
        case 8:  return "Scale";
        case 9:  return "Line style";
        case 10:  return "Line width";
        case 11:  return "Surface color";
        case 12:  return "Wireframe color";
        case 13:  return "Skew factor";
        case 14:  return "Min";
        case 15:  return "Max";
        case 16:  return "Color table";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SurfaceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_enum;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_enum;
        case 9:  return FieldType_linestyle;
        case 10:  return FieldType_linewidth;
        case 11:  return FieldType_color;
        case 12:  return FieldType_color;
        case 13:  return FieldType_double;
        case 14:  return FieldType_double;
        case 15:  return FieldType_double;
        case 16:  return FieldType_colortable;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SurfaceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfaceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "enum";
        case 5:  return "bool";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "enum";
        case 9:  return "linestyle";
        case 10:  return "linewidth";
        case 11:  return "color";
        case 12:  return "color";
        case 13:  return "double";
        case 14:  return "double";
        case 15:  return "double";
        case 16:  return "colortable";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfaceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:22 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
SurfaceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SurfaceAttributes &obj = *((const SurfaceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    case 1:
        {  // new scope
        retval = (lightingFlag == obj.lightingFlag);
        }
        break;
    case 2:
        {  // new scope
        retval = (surfaceFlag == obj.surfaceFlag);
        }
        break;
    case 3:
        {  // new scope
        retval = (wireframeFlag == obj.wireframeFlag);
        }
        break;
    case 4:
        {  // new scope
        retval = (limitsMode == obj.limitsMode);
        }
        break;
    case 5:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case 6:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case 7:
        {  // new scope
        retval = (colorByZFlag == obj.colorByZFlag);
        }
        break;
    case 8:
        {  // new scope
        retval = (scaling == obj.scaling);
        }
        break;
    case 9:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 10:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 11:
        {  // new scope
        retval = (surfaceColor == obj.surfaceColor);
        }
        break;
    case 12:
        {  // new scope
        retval = (wireframeColor == obj.wireframeColor);
        }
        break;
    case 13:
        {  // new scope
        retval = (skewFactor == obj.skewFactor);
        }
        break;
    case 14:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case 15:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case 16:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Modifications:
//   Kathleen Bonnell, Thu Mar 28 14:03:19 PST 2002
//   Removed 'scaling' modifier from min/max and min/maxFlag.
//
// ****************************************************************************
bool
SurfaceAttributes::ChangesRequireRecalculation(const SurfaceAttributes &obj) const
{
    return ((minFlag != obj.minFlag) ||
            (maxFlag != obj.maxFlag) ||
            (scaling != obj.scaling) ||
            (skewFactor != obj.skewFactor) ||
            (min != obj.min) ||
            (max != obj.max) );
}

