#include <PySurfaceAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PySurfaceAttributes
//
// Purpose: 
//   Attributes for the surface plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Sep 11 11:50:27 PDT 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a SurfaceAttributes.
//
struct SurfaceAttributesObject
{
    PyObject_HEAD
    SurfaceAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewSurfaceAttributes();

static PyObject *
SurfaceAttributes_Notify(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
SurfaceAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

static PyObject *
SurfaceAttributes_SetSurfaceFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the surfaceFlag in the object.
    obj->data->SetSurfaceFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetSurfaceFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSurfaceFlag()?1L:0L);
    return retval;
}

static PyObject *
SurfaceAttributes_SetWireframeFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframeFlag in the object.
    obj->data->SetWireframeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetWireframeFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframeFlag()?1L:0L);
    return retval;
}

static PyObject *
SurfaceAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(SurfaceAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

static PyObject *
SurfaceAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

static PyObject *
SurfaceAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

static PyObject *
SurfaceAttributes_SetColorByZFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorByZFlag in the object.
    obj->data->SetColorByZFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetColorByZFlag(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetColorByZFlag()?1L:0L);
    return retval;
}

static PyObject *
SurfaceAttributes_SetScaling(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(SurfaceAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetScaling(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

static PyObject *
SurfaceAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
SurfaceAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
SurfaceAttributes_SetSurfaceColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the surfaceColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSurfaceColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetSurfaceColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the surfaceColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *surfaceColor = obj->data->GetSurfaceColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(surfaceColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(surfaceColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(surfaceColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(surfaceColor[3])));
    return retval;
}

static PyObject *
SurfaceAttributes_SetWireframeColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the wireframeColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetWireframeColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetWireframeColor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the wireframeColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *wireframeColor = obj->data->GetWireframeColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(wireframeColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(wireframeColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(wireframeColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(wireframeColor[3])));
    return retval;
}

static PyObject *
SurfaceAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

static PyObject *
SurfaceAttributes_SetMin(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetMin(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

static PyObject *
SurfaceAttributes_SetMax(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetMax(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

static PyObject *
SurfaceAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SurfaceAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}



static struct PyMethodDef SurfaceAttributes_methods[] = {
    {"Notify", SurfaceAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", SurfaceAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", SurfaceAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", SurfaceAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", SurfaceAttributes_GetLightingFlag, METH_VARARGS},
    {"SetSurfaceFlag", SurfaceAttributes_SetSurfaceFlag, METH_VARARGS},
    {"GetSurfaceFlag", SurfaceAttributes_GetSurfaceFlag, METH_VARARGS},
    {"SetWireframeFlag", SurfaceAttributes_SetWireframeFlag, METH_VARARGS},
    {"GetWireframeFlag", SurfaceAttributes_GetWireframeFlag, METH_VARARGS},
    {"SetLimitsMode", SurfaceAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", SurfaceAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMinFlag", SurfaceAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", SurfaceAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", SurfaceAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", SurfaceAttributes_GetMaxFlag, METH_VARARGS},
    {"SetColorByZFlag", SurfaceAttributes_SetColorByZFlag, METH_VARARGS},
    {"GetColorByZFlag", SurfaceAttributes_GetColorByZFlag, METH_VARARGS},
    {"SetScaling", SurfaceAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", SurfaceAttributes_GetScaling, METH_VARARGS},
    {"SetLineStyle", SurfaceAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", SurfaceAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", SurfaceAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", SurfaceAttributes_GetLineWidth, METH_VARARGS},
    {"SetSurfaceColor", SurfaceAttributes_SetSurfaceColor, METH_VARARGS},
    {"GetSurfaceColor", SurfaceAttributes_GetSurfaceColor, METH_VARARGS},
    {"SetWireframeColor", SurfaceAttributes_SetWireframeColor, METH_VARARGS},
    {"GetWireframeColor", SurfaceAttributes_GetWireframeColor, METH_VARARGS},
    {"SetSkewFactor", SurfaceAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", SurfaceAttributes_GetSkewFactor, METH_VARARGS},
    {"SetMin", SurfaceAttributes_SetMin, METH_VARARGS},
    {"GetMin", SurfaceAttributes_GetMin, METH_VARARGS},
    {"SetMax", SurfaceAttributes_SetMax, METH_VARARGS},
    {"GetMax", SurfaceAttributes_GetMax, METH_VARARGS},
    {"SetColorTableName", SurfaceAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", SurfaceAttributes_GetColorTableName, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SurfaceAttributes_dealloc(PyObject *v)
{
   SurfaceAttributesObject *obj = (SurfaceAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
SurfaceAttributes_compare(PyObject *v, PyObject *w)
{
    SurfaceAttributes *a = ((SurfaceAttributesObject *)v)->data;
    SurfaceAttributes *b = ((SurfaceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
SurfaceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return SurfaceAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return SurfaceAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "surfaceFlag") == 0)
        return SurfaceAttributes_GetSurfaceFlag(self, NULL);
    if(strcmp(name, "wireframeFlag") == 0)
        return SurfaceAttributes_GetWireframeFlag(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return SurfaceAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::OriginalData));
    else if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::CurrentPlot));

    if(strcmp(name, "minFlag") == 0)
        return SurfaceAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return SurfaceAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "colorByZFlag") == 0)
        return SurfaceAttributes_GetColorByZFlag(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return SurfaceAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::Log));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(SurfaceAttributes::Skew));

    if(strcmp(name, "lineStyle") == 0)
        return SurfaceAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return SurfaceAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "surfaceColor") == 0)
        return SurfaceAttributes_GetSurfaceColor(self, NULL);
    if(strcmp(name, "wireframeColor") == 0)
        return SurfaceAttributes_GetWireframeColor(self, NULL);
    if(strcmp(name, "skewFactor") == 0)
        return SurfaceAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "min") == 0)
        return SurfaceAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return SurfaceAttributes_GetMax(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return SurfaceAttributes_GetColorTableName(self, NULL);

    return Py_FindMethod(SurfaceAttributes_methods, self, name);
}

static int
SurfaceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "legendFlag") == 0)
        retval = (SurfaceAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lightingFlag") == 0)
        retval = (SurfaceAttributes_SetLightingFlag(self, tuple) != NULL);
    else if(strcmp(name, "surfaceFlag") == 0)
        retval = (SurfaceAttributes_SetSurfaceFlag(self, tuple) != NULL);
    else if(strcmp(name, "wireframeFlag") == 0)
        retval = (SurfaceAttributes_SetWireframeFlag(self, tuple) != NULL);
    else if(strcmp(name, "limitsMode") == 0)
        retval = (SurfaceAttributes_SetLimitsMode(self, tuple) != NULL);
    else if(strcmp(name, "minFlag") == 0)
        retval = (SurfaceAttributes_SetMinFlag(self, tuple) != NULL);
    else if(strcmp(name, "maxFlag") == 0)
        retval = (SurfaceAttributes_SetMaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "colorByZFlag") == 0)
        retval = (SurfaceAttributes_SetColorByZFlag(self, tuple) != NULL);
    else if(strcmp(name, "scaling") == 0)
        retval = (SurfaceAttributes_SetScaling(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (SurfaceAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (SurfaceAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "surfaceColor") == 0)
        retval = (SurfaceAttributes_SetSurfaceColor(self, tuple) != NULL);
    else if(strcmp(name, "wireframeColor") == 0)
        retval = (SurfaceAttributes_SetWireframeColor(self, tuple) != NULL);
    else if(strcmp(name, "skewFactor") == 0)
        retval = (SurfaceAttributes_SetSkewFactor(self, tuple) != NULL);
    else if(strcmp(name, "min") == 0)
        retval = (SurfaceAttributes_SetMin(self, tuple) != NULL);
    else if(strcmp(name, "max") == 0)
        retval = (SurfaceAttributes_SetMax(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (SurfaceAttributes_SetColorTableName(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
SurfaceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SurfaceAttributesObject *obj = (SurfaceAttributesObject *)v;

    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    if(obj->data->GetLightingFlag())
        fprintf(fp, "lightingFlag = 1\n");
    else
        fprintf(fp, "lightingFlag = 0\n");
    if(obj->data->GetSurfaceFlag())
        fprintf(fp, "surfaceFlag = 1\n");
    else
        fprintf(fp, "surfaceFlag = 0\n");
    if(obj->data->GetWireframeFlag())
        fprintf(fp, "wireframeFlag = 1\n");
    else
        fprintf(fp, "wireframeFlag = 0\n");
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    if(obj->data->GetLimitsMode() == SurfaceAttributes::OriginalData)
        fprintf(fp, "limitsMode = OriginalData  # %s\n", limitsMode_names);
    else
        fprintf(fp, "limitsMode = CurrentPlot  # %s\n", limitsMode_names);

    if(obj->data->GetMinFlag())
        fprintf(fp, "minFlag = 1\n");
    else
        fprintf(fp, "minFlag = 0\n");
    if(obj->data->GetMaxFlag())
        fprintf(fp, "maxFlag = 1\n");
    else
        fprintf(fp, "maxFlag = 0\n");
    if(obj->data->GetColorByZFlag())
        fprintf(fp, "colorByZFlag = 1\n");
    else
        fprintf(fp, "colorByZFlag = 0\n");
    const char *scaling_names = "Linear, Log, Skew";
    if(obj->data->GetScaling() == SurfaceAttributes::Linear)
        fprintf(fp, "scaling = Linear  # %s\n", scaling_names);
    else if(obj->data->GetScaling() == SurfaceAttributes::Log)
        fprintf(fp, "scaling = Log  # %s\n", scaling_names);
    else
        fprintf(fp, "scaling = Skew  # %s\n", scaling_names);

    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *surfaceColor = obj->data->GetSurfaceColor().GetColor();
    fprintf(fp, "surfaceColor = (%d, %d, %d, %d)\n", int(surfaceColor[0]), int(surfaceColor[1]), int(surfaceColor[2]), int(surfaceColor[3]));
    const unsigned char *wireframeColor = obj->data->GetWireframeColor().GetColor();
    fprintf(fp, "wireframeColor = (%d, %d, %d, %d)\n", int(wireframeColor[0]), int(wireframeColor[1]), int(wireframeColor[2]), int(wireframeColor[3]));
    fprintf(fp, "skewFactor = %g\n", obj->data->GetSkewFactor());
    fprintf(fp, "min = %g\n", obj->data->GetMin());
    fprintf(fp, "max = %g\n", obj->data->GetMax());
    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());

    return 0;
}

//
// The doc string for the class.
//
static char *SurfaceAttributes_Purpose = "Attributes for the surface plot";

//
// The type description structure
//
static PyTypeObject SurfaceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SurfaceAttributes",                    // tp_name
    sizeof(SurfaceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SurfaceAttributes_dealloc,  // tp_dealloc
    (printfunc)SurfaceAttributes_print,     // tp_print
    (getattrfunc)SurfaceAttributes_getattr, // tp_getattr
    (setattrfunc)SurfaceAttributes_setattr, // tp_setattr
    (cmpfunc)SurfaceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SurfaceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SurfaceAttributes *defaultAtts = 0;

static PyObject *
NewSurfaceAttributes()
{
    SurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(SurfaceAttributesObject, &SurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new SurfaceAttributes(*defaultAtts);
    else
        newObject->data = new SurfaceAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapSurfaceAttributes(const SurfaceAttributes *attr)
{
    SurfaceAttributesObject *newObject;
    newObject = PyObject_NEW(SurfaceAttributesObject, &SurfaceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SurfaceAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SurfaceAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewSurfaceAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SurfaceAttributesMethods[] = {
    {"SurfaceAttributes", SurfaceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SurfaceAttributesObserver = 0;
static bool SurfaceAttributesEnableLogging = true;

static void
PySurfaceAttributes_WriteLog(Subject *subj, void *data)
{
    SurfaceAttributes *atts = (SurfaceAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!SurfaceAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# SurfaceAttributes_WriteLog()\n");
}

void
PySurfaceAttributes_StartUp(SurfaceAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PySurfaceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SurfaceAttributesObserver == 0)
    {
        SurfaceAttributesObserver = new ObserverToCallback(subj,
            PySurfaceAttributes_WriteLog, (void *)logFile);
    }

    SurfaceAttributesEnableLogging = true;
}

void
PySurfaceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SurfaceAttributesObserver;
    SurfaceAttributesObserver = 0;
}

PyMethodDef *
PySurfaceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SurfaceAttributesMethods;
}

bool
PySurfaceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SurfaceAttributesType);
}

SurfaceAttributes *
PySurfaceAttributes_FromPyObject(PyObject *obj)
{
    SurfaceAttributesObject *obj2 = (SurfaceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySurfaceAttributes_NewPyObject()
{
    return NewSurfaceAttributes();
}

PyObject *
PySurfaceAttributes_WrapPyObject(const SurfaceAttributes *attr)
{
    return WrapSurfaceAttributes(attr);
}

void
PySurfaceAttributes_SetLogging(bool val)
{
    SurfaceAttributesEnableLogging = val;
}

void
PySurfaceAttributes_SetDefaults(const SurfaceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SurfaceAttributes(*atts);
}

