// ************************************************************************* //
//  File: SubsetViewerPluginInfo.C
// ************************************************************************* //

#include <SubsetPluginInfo.h>

#if defined(__APPLE__)
#define GetViewerInfo Subset_GetViewerInfo
#endif

#include <stdio.h>

#include <avtColorTables.h>
#include <avtDatabaseMetaData.h>
#include <avtSubsetPlot.h>
#include <avtTypes.h>
#include <set>

#include <DebugStream.h>
#include <InvalidVariableException.h>

using std::string;
using std::set;

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Subset plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    SubsetViewerPluginInfo::InitializeGlobalObjects();
    return new SubsetViewerPluginInfo;
}

//
// Storage for static data elements.
//
SubsetAttributes *SubsetViewerPluginInfo::clientAtts = NULL;
SubsetAttributes *SubsetViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SubsetViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************
void
SubsetViewerPluginInfo::InitializeGlobalObjects()
{
    SubsetViewerPluginInfo::clientAtts  = new SubsetAttributes;
    SubsetViewerPluginInfo::defaultAtts = new SubsetAttributes;
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************

AttributeSubject *
SubsetViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************

AttributeSubject *
SubsetViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************

void
SubsetViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SubsetAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************

void
SubsetViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SubsetAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************

avtPlot *
SubsetViewerPluginInfo::AllocAvtPlot()
{
    return new avtSubsetPlot;
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
//  Modifications:
//    Kathleen Bonnell, Tue Nov  6 08:19:45 PST 2001
//    Create labels only from mesh related to varName, not from all
//    meshes.
//
//    Hank Childs, Wed Aug 14 11:30:18 PDT 2002
//    Only use the labels from the material we actually have.
//
//    Kathleen Bonnell, Thu Sep  5 10:55:47 PDT 2002  
//    Moved bulk of code to PrivateSetPlotAtts to aid in maintenance, as it is
//    shared with ResetPlotAtts. 
//
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
SubsetViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *md, const char *varName)
{
    *(SubsetAttributes*)atts = *defaultAtts;

    PrivateSetPlotAtts(atts, md, varName);
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::ResetPlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri Sep 7 10:53:06 PDT 2001
//
//  Modifications:
//    Kathleen Bonnell, Mon Apr 29 13:37:14 PDT 2002  
//    Create labels only from mesh related to varName, not from all
//    meshes.
//
//    Hank Childs, Wed Aug 14 11:30:18 PDT 2002
//    Only use the labels from the material we actually have.
//
//    Kathleen Bonnell, Thu Sep  5 10:55:47 PDT 2002  
//    Moved code to PrivateSetPlotAtts to aid in maintenance, as the code is
//    shared with InitializePlotAtts. 
//
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
SubsetViewerPluginInfo::ResetPlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *md, const char *varName)

{
    PrivateSetPlotAtts(atts, md, varName);
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::PrivateSetPlotAtts
//
//  Purpose:
//    Initialize the plot attributes. 
//
//  Arguments:
//    atts          The attribute subject to initialize.
//    hostName      The host name of the plot. 
//    databaseName  The database name of the plot.
//    varName       The variable name of the plot.
//
//  Notes:  
//    This code was pulled from ResetPlotAtts and InitializePlotAtts to
//    aid in maintenance, and reworkd to support groups.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   September 5, 2002 
//
//  Modifications:
//    Kathleen Bonnell, Thu Dec  5 16:53:22 PST 2002 
//    Changed exception from ImproperUse to InvalidVariable.
//
//    Brad Whitlock, Wed Nov 20 14:12:03 PST 2002
//    I added support for discrete color tables.
//
//    Kathleen Bonnell, Thu Sep  4 16:08:46 PDT 2003 
//    Set colors, subsetNames for defaultAtts so that "Reset" won't zero
//    out the colors in the gui.
//
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
SubsetViewerPluginInfo::PrivateSetPlotAtts(AttributeSubject *atts, 
    const avtDatabaseMetaData *md, const char *varName)
{
    SubsetAttributes *subsetAtts = (SubsetAttributes *)atts;

    //
    // Get the meta-data and initialize the subset names and colors in the
    // new SubsetAttributes object.
    //
    if (md == NULL)
    {
        return;
    }

    avtDatabaseMetaData *nonConstmd = const_cast <avtDatabaseMetaData *>(md);

    string vn(varName);

    const avtMaterialMetaData *mat = NULL;

    string meshName = nonConstmd->MeshForVar(varName);
    avtMeshMetaData *mesh = 
        const_cast <avtMeshMetaData *> (md->GetMesh(meshName));


    stringVector       sv;
    stringVector::const_iterator pos;
    set<int> groupSet;
    vector<int> gIDS;
    int i;
    char temp[512];

    // 
    // Create subset names, based on Subset Type 
    // 
    avtSubsetType subT = nonConstmd->DetermineSubsetType(vn);
    switch (subT)
    {
      case AVT_DOMAIN_SUBSET : 
          debug5 << "Variable for subset plot is a domain Mesh." << endl; 
          subsetAtts->SetSubsetType(SubsetAttributes::Domain);
          defaultAtts->SetSubsetType(SubsetAttributes::Domain);
          if (mesh->blockNames.empty())
          {
              for (i = 0; i < mesh->numBlocks; i++)
              { 
                  sprintf(temp, "%d", i+mesh->blockOrigin);
                  sv.push_back(temp);
              }
          }
          else
          {
              for(pos = mesh->blockNames.begin();
                  pos != mesh->blockNames.end(); ++pos)
              {
                  sv.push_back(*pos);
              }
          }
          break;

      case AVT_GROUP_SUBSET :
          debug5 << "Variable for subset plot is a group Mesh." << endl; 
          subsetAtts->SetSubsetType(SubsetAttributes::Group);
          defaultAtts->SetSubsetType(SubsetAttributes::Group);
          for (i = 0; i < mesh->groupIds.size(); i++)
          {
              if (groupSet.count(mesh->groupIds[i]) == 0)
              {
                  groupSet.insert(mesh->groupIds[i]);
                  gIDS.push_back(mesh->groupIds[i]);
              }
          }
          for (i = 0; i < gIDS.size(); i++)
          {
              sprintf(temp, "%d", gIDS[i]);
              sv.push_back(temp);
          }
          break;

      case AVT_MATERIAL_SUBSET :
          debug5 << "Variable for subset plot is a Material." << endl; 
          subsetAtts->SetSubsetType(SubsetAttributes::Material);
          defaultAtts->SetSubsetType(SubsetAttributes::Material);
          mat = md->GetMaterial(vn);
          if (mat != NULL)
          {
              for(pos = mat->materialNames.begin();
                  pos != mat->materialNames.end(); ++pos)
              {
                  sv.push_back(*pos);
              }
          }
          break;

      default:
          EXCEPTION1(InvalidVariableException, varName);
          break;
    }
    
    // 
    // Add a color for each subset name.
    //
    ColorAttribute *ca = new ColorAttribute[sv.size() + 1];
    avtColorTables *ct = avtColorTables::Instance();
    if(ct->IsDiscrete(ct->GetDefaultDiscreteColorTable()))
    {
        // The CT is discrete, get its color color control points.
        for(int i = 0; i < sv.size(); ++i)
        {
            unsigned char rgb[3] = {0,0,0};
            ct->GetControlPointColor(ct->GetDefaultDiscreteColorTable(), i, rgb);
            ca[i].SetRed(int(rgb[0]));
            ca[i].SetGreen(int(rgb[1]));
            ca[i].SetBlue(int(rgb[2]));
        }
    }
    else
    {
        // The CT is continuous, sample the CT so we have a unique color
        // for each element in sv.
        unsigned char *rgb = ct->GetSampledColors(
            ct->GetDefaultDiscreteColorTable(), sv.size());
        if(rgb)
        {
            for(int i = 0; i < sv.size(); ++i)
            {
                ca[i].SetRed(int(rgb[i*3]));
                ca[i].SetGreen(int(rgb[i*3+1]));
                ca[i].SetBlue(int(rgb[i*3+2]));
            }
            delete [] rgb;
        }
    }

    ColorAttributeList cal;
    int idx = 0;
    for(pos = sv.begin(); pos != sv.end(); ++pos)
    {
        if (idx < subsetAtts->GetMultiColor().GetNumColorAttributes())
        {
            // The meshIndex is within the defaultAtts' color
            // vector size.
            cal.AddColorAttribute(subsetAtts->GetMultiColor()[idx]);
        }
        else
        {
            // The meshIndex is greater than the size of the
            // defaultAtts' color vector. Use colors from the
            // default discrete color table.
            cal.AddColorAttribute(ca[idx]);
        }
        ++idx;
    }

    delete [] ca;

    // Set the subset names and colors in the subsetAtts.
    subsetAtts->SetSubsetNames(sv);
    subsetAtts->SetMultiColor(cal);
    defaultAtts->SetSubsetNames(sv);
    defaultAtts->SetMultiColor(cal);
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::ReInitializePlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   December 5, 2002 
//
//  Modifications:
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
// ****************************************************************************

void
SubsetViewerPluginInfo::ReInitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *md, const char *varName)
{
    PrivateSetPlotAtts(atts, md, varName);
}

// ****************************************************************************
// Method: SubsetViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
SubsetViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SUBSET;
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
// ****************************************************************************

#include <Subset.xpm>
const char **
SubsetViewerPluginInfo::XPMIconData() const
{
    return Subset_xpm;
}
