// ************************************************************************* //
//                        SubsetScriptingPluginInfo.C
// ************************************************************************* //
#include <SubsetPluginInfo.h>
#include <PySubsetAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Subset_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Subset plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new SubsetScriptingPluginInfo;
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SubsetScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PySubsetAttributes_StartUp((SubsetAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
SubsetScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySubsetAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Subset plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
SubsetScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySubsetAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SubsetScriptingPluginInfo::SetLogging(bool val)
{
    PySubsetAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: SubsetScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
SubsetScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySubsetAttributes_SetDefaults((const SubsetAttributes *)atts);
}
