// ************************************************************************* //
//                               SubsetPluginInfo.h                            //
// ************************************************************************* //

#ifndef SUBSET_PLUGIN_INFO_H
#define SUBSET_PLUGIN_INFO_H
#include <PlotPluginInfo.h>
#include <plot_plugin_exports.h>

class SubsetAttributes;

// ****************************************************************************
//  Class: SubsetPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about a Subset
//    plot plugin.  The information is broken up into five classes since
//    portions of it are only relevant to particular components within
//    visit.  There is the general information which all the components
//    are interested in, the gui information which the gui is interested in,
//    the viewer information which the viewer is interested in, the
//    engine information which the engine is interested in, and finally a.
//    scripting portion that enables the Python VisIt extension to use the
//    plugin.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Mar 18 09:01:21 PDT 2003
//
//  Modifications:
//    Kathleen Bonnell, Thu Sep  5 10:55:47 PDT 2002 
//    Added private method PrivateSetPlotAtts to ViewerPluginInfo.
//
//    Kathleen Bonnell, Thu Dec  5 16:53:22 PST 2002    
//    Added virtual method ReIntializePlotAtts to ViewerPluginInfo.
//
//    Brad Whitlock, Fri Mar 26 15:23:17 PST 2004
//    I changed the viewer plugin info interface.
//
// ****************************************************************************

class SubsetGeneralPluginInfo: public virtual GeneralPlotPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class SubsetCommonPluginInfo : public virtual CommonPlotPluginInfo, public virtual SubsetGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class SubsetGUIPluginInfo: public virtual GUIPlotPluginInfo, public virtual SubsetCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual int GetVariableTypes() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class SubsetViewerPluginInfo: public virtual ViewerPlotPluginInfo, public virtual SubsetCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual avtPlot *AllocAvtPlot();

    virtual void InitializePlotAtts(AttributeSubject *atts,
        const avtDatabaseMetaData *md,
        const char *variableName);

    virtual void ReInitializePlotAtts(AttributeSubject *atts,
        const avtDatabaseMetaData *md,
        const char *variableName);

    virtual void ResetPlotAtts(AttributeSubject *atts,
        const avtDatabaseMetaData *md,
        const char *variableName);

    virtual const char **XPMIconData() const;
    virtual int GetVariableTypes() const;

    static void InitializeGlobalObjects();
  private:
    static SubsetAttributes *defaultAtts;
    static SubsetAttributes *clientAtts;

    void   PrivateSetPlotAtts(AttributeSubject *atts,
        const avtDatabaseMetaData *md,
        const char *variableName);
};

class SubsetEnginePluginInfo: public virtual EnginePlotPluginInfo, public virtual SubsetCommonPluginInfo
{
  public:
    virtual avtPlot *AllocAvtPlot();
};

class SubsetScriptingPluginInfo : public virtual ScriptingPlotPluginInfo, public virtual SubsetCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
